/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class JavaScriptParserBase<T extends JavaScriptParser> {
    public static final Key<DialectOptionHolder> JS_DIALECT_KEY = Key.create((String)"JS_DIALECT");
    public static final Key<ForceContext> FORCE_CONTEXT_KEY = Key.create((String)"FORCE_CONTEXT");
    public static int MAX_TREE_DEPTH = 100;
    protected final PsiBuilder builder;
    protected final T myJavaScriptParser;
    protected static final WhitespacesAndCommentsBinder INCLUDE_DOC_COMMENT_AT_LEFT = new JSDocBinder(true);
    protected static final WhitespacesAndCommentsBinder INCLUDE_DOC_COMMENT_AT_LEFT_NO_EXTRA_LINEBREAK = new JSDocBinder(false);

    protected JavaScriptParserBase(T parser2) {
        this.builder = ((JavaScriptParser)parser2).builder;
        this.myJavaScriptParser = parser2;
    }

    public static boolean hasLineTerminatorBefore(PsiBuilder builder2) {
        IElementType tokenType = builder2.getTokenType();
        if (tokenType == null || tokenType == JSTokenTypes.RBRACE || tokenType == JSTokenTypes.OR_RBRACE) {
            return true;
        }
        return JavaScriptParserBase.hasLineTerminator(builder2, -1);
    }

    public static boolean hasLineTerminatorAfter(PsiBuilder builder2) {
        return JavaScriptParserBase.hasLineTerminator(builder2, 1);
    }

    static boolean hasLineTerminator(PsiBuilder builder2, int at) {
        IElementType boundElementType = builder2.rawLookup(at);
        while (boundElementType == JSTokenTypes.WHITE_SPACE || boundElementType == JSTokenTypes.HEREDOC_BOUND || JSTokenTypes.COMMENTS.contains(boundElementType)) {
            int end = builder2.rawTokenTypeStart(at + 1);
            CharSequence sequence = builder2.getOriginalText();
            for (int start = builder2.rawTokenTypeStart(at); start < end; ++start) {
                char ch = sequence.charAt(start);
                if (ch != '\n' && ch != '\u2028' && ch != '\u2029' && ch != '\r') continue;
                return true;
            }
            at = at < 0 ? --at : ++at;
            boundElementType = builder2.rawLookup(at);
        }
        return false;
    }

    public static boolean checkMatches(PsiBuilder builder2, IElementType token, @NonNls @PropertyKey(resourceBundle="messages.JavaScriptBundle") @NonNls @PropertyKey(resourceBundle="messages.JavaScriptBundle") String errorMessageKey) {
        if (builder2.getTokenType() == token) {
            builder2.advanceLexer();
            return true;
        }
        builder2.error(JavaScriptBundle.message(errorMessageKey, new Object[0]));
        return false;
    }

    protected boolean isECMAL4() {
        DialectOptionHolder dialect = (DialectOptionHolder)this.builder.getUserData(JS_DIALECT_KEY);
        return dialect != null && dialect.isECMA4;
    }

    protected boolean isECMA6() {
        DialectOptionHolder dialect = (DialectOptionHolder)this.builder.getUserData(JS_DIALECT_KEY);
        return dialect != null && dialect.isECMA6;
    }

    protected boolean isJavaScript() {
        DialectOptionHolder dialect = (DialectOptionHolder)this.builder.getUserData(JS_DIALECT_KEY);
        return dialect == null || dialect.isJavaScript();
    }

    protected boolean isJSorTS() {
        DialectOptionHolder dialect = (DialectOptionHolder)this.builder.getUserData(JS_DIALECT_KEY);
        return dialect == null || dialect.isJavaScript() || dialect.isTypeScript;
    }

    @NotNull
    protected DialectOptionHolder getOptionHolder(@NotNull DialectOptionHolder defaultValue) {
        DialectOptionHolder dialect;
        if (defaultValue == null) {
            JavaScriptParserBase.$$$reportNull$$$0(0);
        }
        DialectOptionHolder dialectOptionHolder = (dialect = (DialectOptionHolder)this.builder.getUserData(JS_DIALECT_KEY)) != null ? dialect : defaultValue;
        if (dialectOptionHolder == null) {
            JavaScriptParserBase.$$$reportNull$$$0(1);
        }
        return dialectOptionHolder;
    }

    protected boolean isIdentifierToken(IElementType tokenType) {
        if (tokenType == JSTokenTypes.IDENTIFIER || tokenType == JSTokenTypes.PRIVATE_IDENTIFIER) {
            return true;
        }
        return ((JavaScriptParser)this.myJavaScriptParser).isIdentifierToken(tokenType);
    }

    protected CharSequence getTokenCharSequence() {
        return this.builder.eof() ? null : PsiBuilderUtil.rawTokenText((PsiBuilder)this.builder, (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/parsing/JavaScriptParserBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/parsing/JavaScriptParserBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOptionHolder";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class JSDocBinder
    implements WhitespacesAndCommentsBinder {
        private final boolean myAllowExtraLineBreak;

        private JSDocBinder(boolean allowExtraLineBreak) {
            this.myAllowExtraLineBreak = allowExtraLineBreak;
        }

        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            CharSequence tokenText;
            IElementType type2;
            int i = tokens.size() - 1;
            IElementType iElementType = type2 = i >= 0 ? tokens.get(i) : null;
            while (!(type2 != JSTokenTypes.WHITE_SPACE && type2 != JSTokenTypes.END_OF_LINE_COMMENT || !this.myAllowExtraLineBreak && type2 == JSTokenTypes.WHITE_SPACE && (tokenText = getter.get(i)).chars().filter(c2 -> c2 == 10).count() > 1L)) {
                type2 = --i >= 0 ? tokens.get(i) : null;
            }
            if (type2 == JSTokenTypes.DOC_COMMENT) {
                return i;
            }
            return tokens.size();
        }
    }

    public static enum ForceContext {
        Type,
        TypeAllowEmpty,
        Parameter;

    }
}

