/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JSXmlParser;
import com.intellij.lang.javascript.parsing.JSXmlTokensParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptParser<E extends ExpressionParser, S extends StatementParser, F extends FunctionParser, T extends JSPsiTypeParser> {
    @Nullable
    private final DialectOptionHolder myDialect;
    protected final PsiBuilder builder;
    protected E myExpressionParser;
    protected S myStatementParser;
    protected F myFunctionParser;
    protected T myTypeParser;
    protected JSXmlParser myXmlParser;

    public JavaScriptParser(@Nullable JSLanguageDialect dialect, PsiBuilder builder2) {
        this(dialect != null ? dialect.getOptionHolder() : null, builder2);
    }

    public JavaScriptParser(@Nullable DialectOptionHolder dialect, PsiBuilder builder2) {
        this.builder = builder2;
        this.myDialect = dialect;
        this.myExpressionParser = new ExpressionParser<JavaScriptParser>(this);
        this.myStatementParser = new StatementParser<JavaScriptParser>(this);
        this.myFunctionParser = new FunctionParser<JavaScriptParser>(this);
        this.myTypeParser = new JSPsiTypeParser<JavaScriptParser>(this);
        this.myXmlParser = dialect != null && !dialect.hasFeature(JSLanguageFeature.E4X) ? JSXmlParser.DUMMY : new JSXmlTokensParser(this);
    }

    public void parseJS(IElementType root) {
        PsiBuilder.Marker rootMarker = this.builder.mark();
        this.builder.putUserData(JavaScriptParserBase.JS_DIALECT_KEY, (Object)this.myDialect);
        JavaScriptParserBase.ForceContext forceContext = (JavaScriptParserBase.ForceContext)((Object)this.builder.getUserData(JavaScriptParserBase.FORCE_CONTEXT_KEY));
        if (forceContext != null) {
            if (forceContext == JavaScriptParserBase.ForceContext.Parameter && this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            } else {
                if (forceContext == JavaScriptParserBase.ForceContext.TypeAllowEmpty && this.builder.eof()) {
                    rootMarker.done(root);
                    return;
                }
                ((JSPsiTypeParser)this.myTypeParser).parseType();
            }
            while (!this.builder.eof()) {
                ((StatementParser)this.getStatementParser()).parseStatement();
            }
        } else {
            this.builder.putUserData(JSParsingContextUtil.ASYNC_METHOD_KEY, (Object)true);
            while (!this.builder.eof()) {
                ((StatementParser)this.getStatementParser()).parseSourceElement();
            }
        }
        rootMarker.done(root);
    }

    public void fillBuilderDataFromContext(@NotNull PsiElement context2) {
        if (context2 == null) {
            JavaScriptParser.$$$reportNull$$$0(0);
        }
        JSParsingContextUtil.fillBuilderData(context2, this.builder, this.getDialect(), this.getFunctionParser());
    }

    public E getExpressionParser() {
        return this.myExpressionParser;
    }

    public S getStatementParser() {
        return this.myStatementParser;
    }

    public F getFunctionParser() {
        return this.myFunctionParser;
    }

    public T getTypeParser() {
        return this.myTypeParser;
    }

    public JSXmlParser getXmlParser() {
        return this.myXmlParser;
    }

    public boolean isIdentifierToken(IElementType tokenType) {
        return JSKeywordSets.JS_IDENTIFIER_TOKENS_SET.contains(tokenType);
    }

    public boolean isIdentifierName(IElementType firstToken) {
        return JSKeywordSets.IDENTIFIER_NAMES.contains(firstToken);
    }

    @Nullable
    public DialectOptionHolder getDialect() {
        return this.myDialect;
    }

    public void buildTokenElement(@NotNull IElementType type2) {
        if (type2 == null) {
            JavaScriptParser.$$$reportNull$$$0(1);
        }
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        marker.done(type2);
    }

    @NotNull
    public EnumSet<JSModifiersStructure.JSModifiersParseResult> parseModifiers(@NotNull JSModifiersStructure structure, boolean dropIfEmpty, @NotNull Predicate<? super PsiBuilder> isPossibleStateAfterModifiers) {
        boolean lexerAdvanced;
        if (structure == null) {
            JavaScriptParser.$$$reportNull$$$0(2);
        }
        if (isPossibleStateAfterModifiers == null) {
            JavaScriptParser.$$$reportNull$$$0(3);
        }
        int offsetBefore = this.builder.getCurrentOffset();
        PsiBuilder.Marker attrList = this.builder.mark();
        ((FunctionParser)this.getFunctionParser()).tryParseES7Decorators();
        EnumSet<JSModifiersStructure.JSModifiersParseResult> parseResults = structure.parseOptimistically(this.builder);
        if (parseResults.contains((Object)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED) && !isPossibleStateAfterModifiers.test((PsiBuilder)this.builder)) {
            attrList.rollbackTo();
            attrList = this.builder.mark();
            ((FunctionParser)this.getFunctionParser()).tryParseES7Decorators();
            parseResults = structure.parse(this.builder, isPossibleStateAfterModifiers);
        }
        this.builder.putUserData(ES6FunctionParser.HAD_ASYNC_MODIFIER_KEY, (Object)parseResults.contains((Object)JSModifiersStructure.JSModifiersParseResult.ASYNC_FOUND));
        ((FunctionParser)this.myFunctionParser).setIsGenerator(parseResults.contains((Object)JSModifiersStructure.JSModifiersParseResult.MULT_FOUND));
        boolean bl = lexerAdvanced = this.builder.getCurrentOffset() > offsetBefore;
        if (lexerAdvanced) {
            parseResults.add(JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED);
        } else {
            parseResults.remove((Object)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED);
        }
        if (dropIfEmpty && !lexerAdvanced) {
            attrList.drop();
        } else {
            attrList.done(((FunctionParser)this.myFunctionParser).getAttributeListElementType());
        }
        EnumSet<JSModifiersStructure.JSModifiersParseResult> enumSet = parseResults;
        if (enumSet == null) {
            JavaScriptParser.$$$reportNull$$$0(4);
        }
        return enumSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isPossibleStateAfterModifiers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/parsing/JavaScriptParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/parsing/JavaScriptParser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillBuilderDataFromContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildTokenElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseModifiers";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

