/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public final class JSParsingContextUtil {
    public static final Key<Boolean> ASYNC_METHOD_KEY = Key.create((String)"js.asyncMethod");
    private static final Key<Boolean> IS_GENERATOR_FUNCTION_KEY = Key.create((String)"js.generator.Function");
    static final boolean IS_TOP_LEVEL_ASYNC = true;

    static void fillBuilderData(@NotNull PsiElement context2, PsiBuilder builder2, DialectOptionHolder dialect, FunctionParser functionParser) {
        if (context2 == null) {
            JSParsingContextUtil.$$$reportNull$$$0(0);
        }
        builder2.putUserData(JavaScriptParserBase.JS_DIALECT_KEY, (Object)dialect);
        JSFunction parent = (JSFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context2, (Class[])new Class[]{JSFunction.class});
        builder2.putUserData(ASYNC_METHOD_KEY, (Object)(parent != null ? parent.isAsync() : true));
        functionParser.setIsGenerator(parent != null && parent.isGenerator());
    }

    static boolean isAsyncContext(PsiBuilder builder2) {
        Boolean asyncValue = (Boolean)builder2.getUserData(ASYNC_METHOD_KEY);
        if (asyncValue == null) {
            return true;
        }
        return asyncValue;
    }

    static boolean isGeneratorContext(PsiBuilder builder2, DialectOptionHolder dialect) {
        if (Boolean.TRUE.equals(builder2.getUserData(IS_GENERATOR_FUNCTION_KEY))) {
            return true;
        }
        return dialect != null && dialect.hasFeature(JSLanguageFeature.ALWAYS_GENERATOR_CONTEXT);
    }

    public static void setIsGenerator(boolean isGenerator, PsiBuilder builder2) {
        builder2.putUserData(IS_GENERATOR_FUNCTION_KEY, (Object)isGenerator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/parsing/JSParsingContextUtil", "fillBuilderData"));
    }
}

