/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JSArrowFunctionDetector;
import com.intellij.lang.javascript.parsing.JSParseResult;
import com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionParser<T extends JavaScriptParser>
extends JavaScriptParserBase<T> {
    public static final Key<MethodEmptiness> methodsEmptinessKey = Key.create((String)"methodsEmptinessKey");

    protected FunctionParser(T parser2) {
        super(parser2);
    }

    public boolean parseFunctionExpression() {
        PsiBuilder.Marker mark = this.builder.mark();
        this.parseFunctionExpressionAttributeList();
        return this.parseFunctionNoMarker(Context.EXPRESSION, mark);
    }

    public boolean isFunctionDeclarationStart() {
        return this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD;
    }

    public void parseFunctionDeclaration() {
        @Nullable MethodEmptiness prevMethodEmptiness = (MethodEmptiness)((Object)this.builder.getUserData(methodsEmptinessKey));
        try {
            PsiBuilder.Marker mark = this.builder.mark();
            this.parseAttributesList();
            this.parseFunctionNoMarker(Context.SOURCE_ELEMENT, mark);
        }
        finally {
            this.builder.putUserData(methodsEmptinessKey, (Object)prevMethodEmptiness);
        }
    }

    public void parseFunctionExpressionAttributeList() {
        this.parseAttributesList();
    }

    public boolean parseFunctionNoMarker(Context context2, @NotNull PsiBuilder.Marker functionMarker) {
        if (functionMarker == null) {
            FunctionParser.$$$reportNull$$$0(0);
        }
        boolean functionKeywordWasOmitted = true;
        boolean parsedWithoutErrors = true;
        boolean isGeneratorContext = false;
        if (this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD && context2 != Context.PROPERTY) {
            this.builder.advanceLexer();
            functionKeywordWasOmitted = false;
            if (this.builder.getTokenType() == JSTokenTypes.MULT && this.isJSorTS()) {
                this.builder.advanceLexer();
                isGeneratorContext = true;
            }
        }
        boolean wasGenerator = this.isGeneratorContext();
        this.setIsGenerator(isGeneratorContext);
        if (!this.parseFunctionName(functionKeywordWasOmitted, context2)) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.function.name", new Object[0]));
            parsedWithoutErrors = false;
        }
        parsedWithoutErrors &= !this.parseParameterList((boolean)(context2 == Context.EXPRESSION || context2 == Context.PROPERTY ? true : false)).hasErrors;
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseFunctionReturnType();
        @Nullable MethodEmptiness methodEmptiness = (MethodEmptiness)((Object)this.builder.getUserData(methodsEmptinessKey));
        if (methodEmptiness == null) {
            if (functionKeywordWasOmitted && JSTokenTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
            }
            parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
        } else if (methodEmptiness == MethodEmptiness.ALWAYS) {
            if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                String key2 = this.builder.getUserData(StatementParser.withinInterfaceKey) == null ? "javascript.ambient.declaration.should.have.no.body" : "interface.function.declaration.should.have.no.body";
                parsedWithoutErrors = false;
                this.builder.error(JavaScriptBundle.message(key2, new Object[0]));
            }
        } else if (methodEmptiness == MethodEmptiness.POSSIBLY) {
            if (functionKeywordWasOmitted && JSTokenTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
                parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
            } else if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                parsedWithoutErrors &= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
            }
        }
        functionMarker.done(context2 == Context.SOURCE_ELEMENT ? this.getFunctionDeclarationElementType() : this.getFunctionExpressionElementType());
        functionMarker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        this.setIsGenerator(wasGenerator);
        return parsedWithoutErrors;
    }

    public boolean parseFunctionName(boolean functionKeywordWasOmitted, Context context2) {
        DialectOptionHolder dialect = (DialectOptionHolder)this.builder.getUserData(JS_DIALECT_KEY);
        if ((dialect == null || dialect.hasFeature(JSLanguageFeature.E4X)) && this.parseGetSetAndNameAfterFunctionKeyword(context2)) {
            return true;
        }
        IElementType tokenType = this.builder.getTokenType();
        if (!(this.isIdentifierToken(tokenType) || functionKeywordWasOmitted && JSKeywordSets.PROPERTY_NAMES.contains(tokenType))) {
            return context2 == Context.EXPRESSION;
        }
        this.parseFunctionIdentifier();
        return true;
    }

    protected boolean parseGetSetAndNameAfterFunctionKeyword(Context context2) {
        IElementType firstToken = this.builder.getTokenType();
        if (JSTokenTypes.GET_SET.contains(firstToken) && context2 != Context.EXPRESSION) {
            IElementType lookAhead = this.builder.lookAhead(1);
            if (JSKeywordSets.PROPERTY_NAMES.contains(lookAhead)) {
                this.builder.advanceLexer();
            } else if (context2 == Context.PROPERTY && ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).isPropertyNameStart(lookAhead)) {
                this.builder.advanceLexer();
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parsePropertyName();
                return true;
            }
        }
        return false;
    }

    public void parseFunctionIdentifier() {
        IElementType tokenType = this.builder.getTokenType();
        if (JSKeywordSets.PROPERTY_NAMES.contains(tokenType)) {
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).advancePropertyName(tokenType);
        } else {
            this.builder.advanceLexer();
        }
    }

    public IElementType getFunctionDeclarationElementType() {
        return JSStubElementTypes.FUNCTION_DECLARATION;
    }

    public boolean parseAttributesList() {
        PsiBuilder.Marker mark = this.builder.mark();
        IElementType type2 = this.builder.getTokenType();
        if (type2 == JSTokenTypes.EXPORT_KEYWORD || type2 == JSTokenTypes.GET_KEYWORD || type2 == JSTokenTypes.SET_KEYWORD) {
            this.builder.advanceLexer();
        }
        mark.done(this.getAttributeListElementType());
        return true;
    }

    public IElementType getAttributeListElementType() {
        return JSStubElementTypes.ATTRIBUTE_LIST;
    }

    public void parseES7Decorators() {
        StatementParser.LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.AT);
        while (this.builder.getTokenType() == JSTokenTypes.AT) {
            PsiBuilder.Marker attribute = this.builder.mark();
            this.builder.advanceLexer();
            Object expressionParser = this.myJavaScriptParser.getExpressionParser();
            ((ExpressionParser)expressionParser).parseLeftHandSideExpression(EnumSet.of(ExpressionParser.ParseLeftHandSideExpressionOptions.DISALLOW_INDEXER));
            attribute.done(JSStubElementTypes.ES6_DECORATOR);
        }
    }

    public boolean tryParseES7Decorators() {
        boolean hadAnnotation;
        boolean bl = hadAnnotation = this.builder.getTokenType() == JSTokenTypes.AT;
        if (hadAnnotation && this.hasSupportDecorators()) {
            this.parseES7Decorators();
        }
        return hadAnnotation;
    }

    public boolean hasSupportDecorators() {
        return false;
    }

    public JSParseResult parseParameterList(boolean funExpr) {
        if (!((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseTypeParameterList()) {
            return JSParseResult.UNACCEPTABLE;
        }
        if (this.builder.getTokenType() != JSTokenTypes.LPAR) {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.lparen", new Object[0]));
            if (!funExpr) {
                PsiBuilder.Marker parameterList = this.builder.mark();
                parameterList.done(this.getParameterListElementType());
            }
            return JSParseResult.UNACCEPTABLE;
        }
        PsiBuilder.Marker parameterList = this.builder.mark();
        this.builder.advanceLexer();
        boolean hasErrors2 = false;
        boolean first = true;
        while (this.builder.getTokenType() != JSTokenTypes.RPAR) {
            if (first) {
                first = false;
            } else if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR && this.allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.comma.or.rparen", new Object[0]));
                hasErrors2 = true;
                break;
            }
            PsiBuilder.Marker parameter = this.builder.mark();
            this.parseParameterAttributeList();
            if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.DOT || this.builder.getTokenType() == JSTokenTypes.DOT_DOT) {
                this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.parameter.name", new Object[0]));
                while (this.builder.getTokenType() == JSTokenTypes.DOT || this.builder.getTokenType() == JSTokenTypes.DOT_DOT) {
                    this.builder.advanceLexer();
                }
                hasErrors2 = true;
            }
            hasErrors2 |= !this.parseSingleParameter(parameter);
        }
        if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
            this.builder.advanceLexer();
        }
        parameterList.done(this.getParameterListElementType());
        return JSParseResult.acceptable(hasErrors2, null);
    }

    public boolean parseSingleParameter(PsiBuilder.Marker parameter) {
        JSParseResult result2 = this.doParseSingleParameter();
        IElementType elementType = result2.elementType;
        if (elementType != null) {
            parameter.done(elementType);
        } else {
            parameter.drop();
        }
        return !result2.hasErrors;
    }

    @NotNull
    protected JSParseResult doParseSingleParameter() {
        boolean acceptResult;
        boolean hasErrors2 = false;
        IElementType elementType = this.getParameterType();
        IElementType tokenType = this.builder.getTokenType();
        if (this.isParameterName(false, tokenType)) {
            this.builder.advanceLexer();
            this.parseParameterOptionalMark();
            ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
            if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                this.builder.advanceLexer();
                if (!((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true)) {
                    this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                }
            }
            acceptResult = true;
        } else if (this.willParseDestructuringAssignment()) {
            elementType = ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseDestructuringElementNoMarker(this.getParameterType(), true, true);
            acceptResult = true;
        } else {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.formal.parameter.name", new Object[0]));
            hasErrors2 = true;
            if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                this.builder.advanceLexer();
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true);
            } else {
                ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
            }
            acceptResult = false;
        }
        JSParseResult jSParseResult = acceptResult && elementType != null ? JSParseResult.acceptable(hasErrors2, elementType) : JSParseResult.UNACCEPTABLE;
        if (jSParseResult == null) {
            FunctionParser.$$$reportNull$$$0(1);
        }
        return jSParseResult;
    }

    protected boolean isParameterName(boolean allowPropertyNameAsIdentifier, IElementType tokenType) {
        return this.isIdentifierToken(tokenType) || allowPropertyNameAsIdentifier && JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType);
    }

    protected boolean allowLastCommaInParameterAndArgumentList() {
        return false;
    }

    public IElementType getParameterType() {
        return JSStubElementTypes.FORMAL_PARAMETER;
    }

    public void parseParameterOptionalMark() {
    }

    public boolean willParseDestructuringAssignment() {
        return !this.isECMAL4() && FunctionParser.willParseDestructuringAssignment(this.builder.getTokenType());
    }

    public static boolean willParseDestructuringAssignment(IElementType tokenType) {
        return tokenType == JSTokenTypes.LBRACKET || tokenType == JSTokenTypes.LBRACE;
    }

    protected void parseParameterAttributeList() {
        if (this.hasSupportDecorators() && this.builder.getTokenType() == JSTokenTypes.AT) {
            PsiBuilder.Marker mark = this.builder.mark();
            this.tryParseES7Decorators();
            mark.done(this.getAttributeListElementType());
        }
    }

    public boolean parseArrowFunction() {
        return this.parseArrowFunctionWithoutModifiers(this.builder.mark());
    }

    protected boolean parseArrowFunctionWithoutModifiers(@NotNull PsiBuilder.Marker arrowFunction) {
        IElementType firstToken;
        if (arrowFunction == null) {
            FunctionParser.$$$reportNull$$$0(2);
        }
        if (this.isIdentifierToken(firstToken = this.builder.getTokenType()) && JSTokenTypes.ARROWS.contains(this.builder.lookAhead(1))) {
            PsiBuilder.Marker parameterList = this.builder.mark();
            PsiBuilder.Marker parameter = this.builder.mark();
            this.builder.advanceLexer();
            parameter.done(this.getParameterType());
            parameterList.done(this.getParameterListElementType());
            parameterList.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        } else {
            if (!JSArrowFunctionDetector.INSTANCE.isArrowFunctionExpression(this.builder, this)) {
                arrowFunction.rollbackTo();
                return false;
            }
            this.parseParameterList(true);
            ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseArrowFunctionReturnType();
        }
        IElementType arrow = this.builder.getTokenType();
        if (JSTokenTypes.ARROWS.contains(arrow)) {
            this.builder.advanceLexer();
            ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseBlockOrFunctionBody(StatementParser.BlockType.ARROW_FUNCTION_BODY);
        } else {
            this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.eqgt", new Object[0]));
        }
        arrowFunction.done(this.getFunctionExpressionElementType());
        arrowFunction.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return true;
    }

    protected boolean isValidFirstParameterStart(IElementType next) {
        if (next == JSTokenTypes.RPAR || next == JSTokenTypes.DOT_DOT_DOT || !this.isECMAL4() && FunctionParser.willParseDestructuringAssignment(next)) {
            return true;
        }
        boolean isParameterName = this.isParameterName(true, next);
        if (!isParameterName) {
            return false;
        }
        int lookaheadSteps = 2;
        if (next == JSTokenTypes.CLASS_KEYWORD || next == JSTokenTypes.FUNCTION_KEYWORD || next == JSTokenTypes.ASYNC_KEYWORD && (next = this.builder.lookAhead(lookaheadSteps++)) == JSTokenTypes.FUNCTION_KEYWORD) {
            IElementType lookAhead = this.builder.lookAhead(lookaheadSteps);
            if (this.isIdentifierToken(lookAhead)) {
                return false;
            }
            if (next == JSTokenTypes.FUNCTION_KEYWORD) {
                return lookAhead != JSTokenTypes.LPAR && lookAhead != JSTokenTypes.MULT;
            }
            return lookAhead != JSTokenTypes.LBRACE;
        }
        return true;
    }

    protected boolean supportsColonTypeCast() {
        return false;
    }

    public IElementType getParameterListElementType() {
        return JSStubElementTypes.PARAMETER_LIST;
    }

    protected IElementType getFunctionExpressionElementType() {
        return JSStubElementTypes.FUNCTION_EXPRESSION;
    }

    public boolean isAsyncContext() {
        return JSParsingContextUtil.isAsyncContext(this.builder);
    }

    public void setIsGenerator(boolean isGenerator) {
        JSParsingContextUtil.setIsGenerator(isGenerator, this.builder);
    }

    public boolean isGeneratorContext() {
        return JSParsingContextUtil.isGeneratorContext(this.builder, this.myJavaScriptParser.getDialect());
    }

    protected boolean parseParameterListAndBody(PsiBuilder.Marker marker, IElementType elementType) {
        boolean lexerAdvanced = !((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseParameterList((boolean)false).hasErrors;
        lexerAdvanced |= ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseFunctionReturnType();
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return lexerAdvanced |= ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseFunctionBody();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionMarker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/parsing/FunctionParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrowFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/parsing/FunctionParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doParseSingleParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFunctionNoMarker";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseArrowFunctionWithoutModifiers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum Context {
        EXPRESSION,
        SOURCE_ELEMENT,
        PROPERTY;

    }

    public static enum MethodEmptiness {
        ALWAYS,
        POSSIBLY;

    }
}

