/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.remote;

import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.lang.javascript.modules.remote.JSRemoteModule;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesChangeEvent;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesChangeListener;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesEventType;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesRegistry;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesSyntheticLibrary;
import com.intellij.lang.javascript.modules.remote.JSRemoteModulesUsagesDetector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.webcore.libraries.ScriptingLibraryUtil;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
public final class JSRemoteModulesLibraryManager
implements JSRemoteModulesChangeListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(JSRemoteModulesLibraryManager.class);
    public static final String LIBRARY_DEBUG_NAME = "Remote modules";
    private static final int UPDATE_TIMEOUT = 300;
    private final Project myProject;
    private final JSRemoteModulesRegistry myModulesRegistry;
    private final Alarm myAlarm;
    private volatile JSRemoteLibrariesSnapshot myLibrariesSnapshot;

    public static JSRemoteModulesLibraryManager getInstance(@NotNull Project project) {
        if (project == null) {
            JSRemoteModulesLibraryManager.$$$reportNull$$$0(0);
        }
        return (JSRemoteModulesLibraryManager)project.getService(JSRemoteModulesLibraryManager.class);
    }

    public JSRemoteModulesLibraryManager(@NotNull Project project) {
        if (project == null) {
            JSRemoteModulesLibraryManager.$$$reportNull$$$0(1);
        }
        this.myLibrariesSnapshot = new JSRemoteLibrariesSnapshot(Map.of());
        this.myProject = project;
        this.myModulesRegistry = JSRemoteModulesRegistry.getInstance();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        appConnection.subscribe(JSRemoteModulesRegistry.TOPIC, (Object)this);
    }

    @NotNull
    public Map<String, JSRemoteModulesSyntheticLibrary> getLibraries() {
        JSRemoteLibrariesSnapshot snapshot = this.myLibrariesSnapshot;
        Map<String, JSRemoteModulesSyntheticLibrary> map = snapshot.getLibraries();
        if (map == null) {
            JSRemoteModulesLibraryManager.$$$reportNull$$$0(2);
        }
        return map;
    }

    @Nullable
    public JSRemoteModulesSyntheticLibrary getLibrary(@NotNull String url) {
        if (url == null) {
            JSRemoteModulesLibraryManager.$$$reportNull$$$0(3);
        }
        JSRemoteLibrariesSnapshot snapshot = this.myLibrariesSnapshot;
        Map<String, JSRemoteModulesSyntheticLibrary> libraries = snapshot.getLibraries();
        return libraries.get(url);
    }

    @NotNull
    public GlobalSearchScope getLibraryScope() {
        JSRemoteLibrariesSnapshot snapshot = this.myLibrariesSnapshot;
        GlobalSearchScope globalSearchScope = snapshot.getLibraryScope();
        if (globalSearchScope == null) {
            JSRemoteModulesLibraryManager.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @Nullable
    public JSRemoteModule getLibraryModule(@NotNull String url) {
        JSRemoteModulesSyntheticLibrary library;
        if (url == null) {
            JSRemoteModulesLibraryManager.$$$reportNull$$$0(5);
        }
        if ((library = this.getLibrary(url)) != null) {
            return this.myModulesRegistry.getModule(url);
        }
        return null;
    }

    @NotNull
    public Map<String, JSRemoteModule> resolveRemoteModules(@NotNull VirtualFile file) {
        if (file == null) {
            JSRemoteModulesLibraryManager.$$$reportNull$$$0(6);
        }
        if (!file.isValid()) {
            Map<String, JSRemoteModule> map = Collections.emptyMap();
            if (map == null) {
                JSRemoteModulesLibraryManager.$$$reportNull$$$0(7);
            }
            return map;
        }
        VirtualFile stopAt = JSUrlImportsUtil.getRemoteModulesDir();
        if (stopAt == null || !stopAt.isValid()) {
            Map<String, JSRemoteModule> map = Collections.emptyMap();
            if (map == null) {
                JSRemoteModulesLibraryManager.$$$reportNull$$$0(8);
            }
            return map;
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)stopAt, (VirtualFile)file, (boolean)true)) {
            Map<String, JSRemoteModule> map = Collections.emptyMap();
            if (map == null) {
                JSRemoteModulesLibraryManager.$$$reportNull$$$0(9);
            }
            return map;
        }
        JSRemoteLibrariesSnapshot snapshot = this.myLibrariesSnapshot;
        Map<VirtualFile, Collection<String>> rootsToModuleNames = snapshot.getRootsToModuleNames();
        HashMap<String, JSRemoteModule> modules = new HashMap<String, JSRemoteModule>();
        for (VirtualFile current = file; current != null && !current.equals(stopAt); current = current.getParent()) {
            Collection moduleNames = rootsToModuleNames.getOrDefault(current, Collections.emptyList());
            for (String name : moduleNames) {
                JSRemoteModule module = this.myModulesRegistry.getModule(name);
                if (module == null || !module.isValid()) continue;
                modules.put(name, module);
            }
        }
        HashMap<String, JSRemoteModule> hashMap = modules;
        if (hashMap == null) {
            JSRemoteModulesLibraryManager.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    public void scheduleUpdate() {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater(this::updateLibraries, ModalityState.nonModal(), this.myProject.getDisposed());
        } else {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this, this::updateLibraries), 300);
        }
    }

    private void updateLibraries() {
        if (this.myProject.isDisposed()) {
            return;
        }
        JSRemoteLibrariesSnapshot previousSnapshot = this.myLibrariesSnapshot;
        Map<String, JSRemoteModulesSyntheticLibrary> previousLibraries = previousSnapshot.getLibraries();
        HashMap<String, JSRemoteModulesSyntheticLibrary> newLibraries = new HashMap<String, JSRemoteModulesSyntheticLibrary>();
        HashSet<JSRemoteModulesSyntheticLibrary> changedLibraries = new HashSet<JSRemoteModulesSyntheticLibrary>();
        ArrayDeque<String> modulesToProcess = new ArrayDeque<String>(this.getUsedModules());
        HashSet<String> visited = new HashSet<String>();
        while (!modulesToProcess.isEmpty()) {
            JSRemoteModule remoteModule;
            ProgressManager.checkCanceled();
            String url = (String)modulesToProcess.pop();
            if (!visited.add(url) || (remoteModule = this.myModulesRegistry.getModule(url)) == null || !remoteModule.isValid()) continue;
            JSRemoteModulesSyntheticLibrary previousLibrary = previousLibraries.get(url);
            JSRemoteModulesSyntheticLibrary newLibrary = JSRemoteModulesSyntheticLibrary.fromModule(remoteModule);
            newLibraries.put(url, newLibrary);
            if (!Objects.equals((Object)previousLibrary, (Object)newLibrary)) {
                changedLibraries.add(newLibrary);
            }
            for (String dependency : remoteModule.getDependencies()) {
                modulesToProcess.push(dependency);
            }
        }
        HashMap<String, JSRemoteModulesSyntheticLibrary> removedLibrariesMap = new HashMap<String, JSRemoteModulesSyntheticLibrary>(previousLibraries);
        removedLibrariesMap.keySet().removeAll(newLibraries.keySet());
        HashSet<JSRemoteModulesSyntheticLibrary> removedLibraries = new HashSet<JSRemoteModulesSyntheticLibrary>(removedLibrariesMap.values());
        if (!changedLibraries.isEmpty() || !removedLibraries.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Previous libraries: " + previousLibraries);
                LOG.debug("New libraries: " + newLibraries);
                LOG.debug("Changed libraries: " + changedLibraries);
                LOG.debug("Removed libraries: " + removedLibraries);
            }
            this.myLibrariesSnapshot = new JSRemoteLibrariesSnapshot(newLibraries);
            this.fireAdditionalLibrariesChanged(changedLibraries, removedLibraries);
        }
    }

    @NotNull
    private Set<String> getUsedModules() {
        Set<String> set = JSRemoteModulesUsagesDetector.getInstance(this.myProject).getCachedReferencedModules();
        if (set == null) {
            JSRemoteModulesLibraryManager.$$$reportNull$$$0(11);
        }
        return set;
    }

    private void fireAdditionalLibrariesChanged(@NotNull Set<JSRemoteModulesSyntheticLibrary> changedLibraries, @NotNull Set<JSRemoteModulesSyntheticLibrary> removedLibraries) {
        if (changedLibraries == null) {
            JSRemoteModulesLibraryManager.$$$reportNull$$$0(12);
        }
        if (removedLibraries == null) {
            JSRemoteModulesLibraryManager.$$$reportNull$$$0(13);
        }
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> WriteAction.run(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                for (JSRemoteModulesSyntheticLibrary library : changedLibraries) {
                    AdditionalLibraryRootsListener.fireAdditionalLibraryChanged((Project)this.myProject, (String)library.getPresentableText(), Collections.emptySet(), library.getSourceRoots(), (String)JSRemoteModulesLibraryManager.getLibraryDebugName(library));
                }
                for (JSRemoteModulesSyntheticLibrary library : removedLibraries) {
                    AdditionalLibraryRootsListener.fireAdditionalLibraryChanged((Project)this.myProject, (String)library.getPresentableText(), library.getSourceRoots(), Collections.emptySet(), (String)JSRemoteModulesLibraryManager.getLibraryDebugName(library));
                }
            }));
        });
    }

    @NotNull
    private static String getLibraryDebugName(@NotNull JSRemoteModulesSyntheticLibrary library) {
        if (library == null) {
            JSRemoteModulesLibraryManager.$$$reportNull$$$0(14);
        }
        String string = (String)ObjectUtils.coalesce((Object)library.getPresentableText(), (Object)LIBRARY_DEBUG_NAME);
        if (string == null) {
            JSRemoteModulesLibraryManager.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public void onRemoteModuleChanged(@NotNull JSRemoteModulesChangeEvent event) {
        if (event == null) {
            JSRemoteModulesLibraryManager.$$$reportNull$$$0(16);
        }
        JSRemoteModulesEventType type2 = event.getType();
        JSRemoteModule module = event.getModule();
        if (LOG.isDebugEnabled()) {
            LOG.debug(event.toString());
        }
        if (type2 == JSRemoteModulesEventType.MODIFIED) {
            String url = module.getUrl();
            JSRemoteLibrariesSnapshot snapshot = this.myLibrariesSnapshot;
            Map<String, JSRemoteModulesSyntheticLibrary> previousLibraries = snapshot.getLibraries();
            JSRemoteModulesSyntheticLibrary previousLibrary = previousLibraries.get(url);
            JSRemoteModulesSyntheticLibrary newLibrary = JSRemoteModulesSyntheticLibrary.fromModule(module);
            if (previousLibrary != null && previousLibrary.equals((Object)newLibrary)) {
                this.fireAdditionalLibrariesChanged(Collections.singleton(newLibrary), Collections.emptySet());
                return;
            }
        }
        this.scheduleUpdate();
    }

    @TestOnly
    public void clear() {
        this.myLibrariesSnapshot = new JSRemoteLibrariesSnapshot(Map.of());
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 7, 8, 9, 10, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesLibraryManager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedLibraries";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedLibraries";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesLibraryManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryScope";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveRemoteModules";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedModules";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryDebugName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLibrary";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryModule";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveRemoteModules";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fireAdditionalLibrariesChanged";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryDebugName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onRemoteModuleChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 7, 8, 9, 10, 11, 15 -> new IllegalStateException(string);
        };
    }

    private final class JSRemoteLibrariesSnapshot {
        private final Map<String, JSRemoteModulesSyntheticLibrary> myLibraries;
        private final NotNullLazyValue<Map<VirtualFile, Collection<String>>> myRootsToModuleNames;
        private final NotNullLazyValue<GlobalSearchScope> myLibraryScope;

        private JSRemoteLibrariesSnapshot(Map<String, JSRemoteModulesSyntheticLibrary> libraries) {
            if (libraries == null) {
                JSRemoteLibrariesSnapshot.$$$reportNull$$$0(0);
            }
            this.myLibraries = Collections.unmodifiableMap(libraries);
            this.myRootsToModuleNames = NotNullLazyValue.atomicLazy(() -> {
                if (this.myLibraries.isEmpty()) {
                    return Collections.emptyMap();
                }
                MultiMap rootsToModuleNames = MultiMap.createSet();
                for (Map.Entry<String, JSRemoteModulesSyntheticLibrary> entry : this.myLibraries.entrySet()) {
                    String url = entry.getKey();
                    JSRemoteModulesSyntheticLibrary library = entry.getValue();
                    Collection<VirtualFile> roots = library.getSourceRoots();
                    for (VirtualFile root : roots) {
                        rootsToModuleNames.putValue((Object)root, (Object)url);
                    }
                }
                return rootsToModuleNames.freezeValues();
            });
            this.myLibraryScope = NotNullLazyValue.atomicLazy(() -> {
                Set roots = this.myLibraries.values().stream().flatMap(library -> library.getSourceRoots().stream()).filter(VirtualFile::isValid).collect(Collectors.toSet());
                return ScriptingLibraryUtil.getFilesAndDirectoriesScope((Project)JSRemoteModulesLibraryManager.this.myProject, roots);
            });
        }

        @NotNull
        private Map<String, JSRemoteModulesSyntheticLibrary> getLibraries() {
            Map<String, JSRemoteModulesSyntheticLibrary> map = this.myLibraries;
            if (map == null) {
                JSRemoteLibrariesSnapshot.$$$reportNull$$$0(1);
            }
            return map;
        }

        @NotNull
        private GlobalSearchScope getLibraryScope() {
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)this.myLibraryScope.getValue();
            if (globalSearchScope == null) {
                JSRemoteLibrariesSnapshot.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }

        @NotNull
        private Map<VirtualFile, Collection<String>> getRootsToModuleNames() {
            Map map = (Map)this.myRootsToModuleNames.getValue();
            if (map == null) {
                JSRemoteLibrariesSnapshot.$$$reportNull$$$0(3);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraries";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesLibraryManager$JSRemoteLibrariesSnapshot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/modules/remote/JSRemoteModulesLibraryManager$JSRemoteLibrariesSnapshot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraries";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootsToModuleNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static final class JSRemoteModulesLibraryManagerStartupActivity
    implements StartupActivity.DumbAware {
        JSRemoteModulesLibraryManagerStartupActivity() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw ExtensionNotApplicableException.create();
            }
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                JSRemoteModulesLibraryManagerStartupActivity.$$$reportNull$$$0(0);
            }
            JSRemoteModulesLibraryManager.getInstance(project).scheduleUpdate();
            JSRemoteModulesUsagesDetector.getInstance(project).detect();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/remote/JSRemoteModulesLibraryManager$JSRemoteModulesLibraryManagerStartupActivity", "runActivity"));
        }
    }
}

