/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.providers;

import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSNodeModulesHandlerScope;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.JSNodeModuleStructure;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.ES6FixedImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidatesBase;
import com.intellij.lang.javascript.modules.imports.providers.ES6ExportedCandidatesProvider;
import com.intellij.lang.javascript.modules.imports.providers.JSCandidatesProcessor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.stubs.JSLazyIndexedPackagesIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExportedTopLevelCandidatesProvider
extends JSImportCandidatesBase {
    @NotNull
    private final Set<String> myPackageJsonModules;
    @Nullable
    private MultiMap<String, Pair<JSElement, String>> myElementsFromResolvedPackages;

    public ES6ExportedTopLevelCandidatesProvider(@NotNull JSImportPlaceInfo placeInfo) {
        if (placeInfo == null) {
            ES6ExportedTopLevelCandidatesProvider.$$$reportNull$$$0(0);
        }
        super(placeInfo);
        this.myPackageJsonModules = JSNodeModulesHandlerScope.getAcceptableModules(placeInfo.getProject(), placeInfo.getFile());
    }

    @NotNull
    private MultiMap<String, Pair<JSElement, String>> getElementsFromResolvedPackages() {
        if (this.myElementsFromResolvedPackages != null) {
            MultiMap<String, Pair<JSElement, String>> multiMap = this.myElementsFromResolvedPackages;
            if (multiMap == null) {
                ES6ExportedTopLevelCandidatesProvider.$$$reportNull$$$0(1);
            }
            return multiMap;
        }
        PsiElement place = this.myPlaceInfo.getPlace();
        MultiMap result2 = MultiMap.createSet();
        List toProcess = ContainerUtil.filter(this.myPackageJsonModules, el -> !JSLazyIndexedPackagesIndex.LAZY_PACKAGES.contains(el));
        for (String module : toProcess) {
            CompletionResultSink sink = new CompletionResultSink(place, null);
            List elements = ContainerUtil.filter(JSFileReferencesUtil.resolveModuleReference(place, module), el -> TypeScriptUtil.isDefinitionFile(el.getContainingFile()));
            List tsElements = ((StreamEx)StreamEx.of(ES6PsiUtil.convertWithExportAssignments(elements)).select(JSElement.class).filter(el -> TypeScriptUtil.isDefinitionFile(el.getContainingFile()))).toList();
            if (tsElements.isEmpty()) continue;
            ES6PsiUtil.processExportedSymbols(place, tsElements, sink);
            List<PsiElement> results = sink.getResults();
            if (results == null) continue;
            for (PsiElement candidate : results) {
                JSElement jsElement2;
                String name;
                if (!(candidate instanceof JSElement) || StringUtil.isEmpty((String)(name = (jsElement2 = (JSElement)candidate).getName())) || !this.myPlaceInfo.isAcceptable((PsiElement)jsElement2)) continue;
                result2.putValue((Object)name, (Object)Pair.create((Object)jsElement2, (Object)module));
            }
        }
        this.myElementsFromResolvedPackages = result2;
        MultiMap multiMap = result2;
        if (multiMap == null) {
            ES6ExportedTopLevelCandidatesProvider.$$$reportNull$$$0(2);
        }
        return multiMap;
    }

    @NotNull
    private List<JSImportCandidate> getDirectExportedFromPackages(@NotNull String name) {
        if (name == null) {
            ES6ExportedTopLevelCandidatesProvider.$$$reportNull$$$0(3);
        }
        if (this.myPlaceInfo.getImportContext() == JSImportPlaceInfo.ImportContext.BINDING) {
            List<JSImportCandidate> list2 = Collections.emptyList();
            if (list2 == null) {
                ES6ExportedTopLevelCandidatesProvider.$$$reportNull$$$0(4);
            }
            return list2;
        }
        MultiMap<String, Pair<JSElement, String>> packages = this.getElementsFromResolvedPackages();
        Collection pairs = packages.get((Object)name);
        if (pairs.isEmpty()) {
            List<JSImportCandidate> list3 = Collections.emptyList();
            if (list3 == null) {
                ES6ExportedTopLevelCandidatesProvider.$$$reportNull$$$0(5);
            }
            return list3;
        }
        ArrayList<JSImportCandidate> result2 = new ArrayList<JSImportCandidate>();
        PsiElement place = this.myPlaceInfo.getPlace();
        for (Pair pair : pairs) {
            JSNodeModuleStructure structure;
            String moduleName = (String)pair.second;
            JSElement element = ES6ExportedCandidatesProvider.expandElementAndFilter((PsiElement)pair.first, this.myPlaceInfo);
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (file == null || (structure = JSNodeModuleStructure.getStructure(this.myPlaceInfo.getProject(), file)) == null || !this.isFromIndirectPackage(element, file, structure) && element instanceof JSPsiElementBase && ((JSPsiElementBase)element).isExported()) continue;
            if (moduleName.startsWith("@types/")) {
                moduleName = ES6CreateImportUtil.convertScopedTypesName(moduleName.substring("@types/".length()));
            }
            result2.add(new ES6FixedImportCandidate(name, element, place, ES6ImportPsiUtil.ImportExportType.SPECIFIER, moduleName));
        }
        ArrayList<JSImportCandidate> arrayList = result2;
        if (arrayList == null) {
            ES6ExportedTopLevelCandidatesProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private boolean isFromIndirectPackage(JSElement element, VirtualFile file, JSNodeModuleStructure structure) {
        return NodeModuleUtil.hasNodeModulesInPath((PsiElement)element) && !NodeCoreLibraryManager.getInstance(this.getProject()).isCoreLibraryFile(file) && !this.myPackageJsonModules.isEmpty() && !this.myPackageJsonModules.contains(structure.getPackageName()) && !this.myPackageJsonModules.contains(structure.getOriginalPackageName());
    }

    @Override
    public void processCandidates(@NotNull String name, @NotNull JSCandidatesProcessor processor) {
        if (name == null) {
            ES6ExportedTopLevelCandidatesProvider.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            ES6ExportedTopLevelCandidatesProvider.$$$reportNull$$$0(8);
        }
        List<JSImportCandidate> directElements = this.getDirectExportedFromPackages(name);
        directElements.forEach(processor::processCandidate);
    }

    @Override
    public void collectNames(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            ES6ExportedTopLevelCandidatesProvider.$$$reportNull$$$0(9);
        }
        this.getElementsFromResolvedPackages().keySet().forEach(consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedTopLevelCandidatesProvider";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedTopLevelCandidatesProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsFromResolvedPackages";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectExportedFromPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDirectExportedFromPackages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    public static class MyFactory
    implements JSImportCandidatesProvider.CandidatesFactory {
        @Override
        @Nullable
        public JSImportCandidatesProvider createProvider(@NotNull JSImportPlaceInfo placeInfo) {
            if (placeInfo == null) {
                MyFactory.$$$reportNull$$$0(0);
            }
            return new ES6ExportedTopLevelCandidatesProvider(placeInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedTopLevelCandidatesProvider$MyFactory", "createProvider"));
        }
    }
}

