/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigManager;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerDefinition;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerDefinitionsProvider;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerResolveAlias;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.InstallNodeModuleAddToDevDependenciesQuickFix;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.JSModuleVisitor;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.RunNpmUpdateQuickFix;
import com.intellij.lang.javascript.modules.TypeScriptInstallGlobalTypesFix;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmUsedModulesInstalledInspection
extends JSInspection {
    public static final String[] NODE_MODULES = new String[]{"node_modules"};

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, final @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(1);
        }
        return new JSModuleVisitor(){

            @Override
            protected void processRequire(@NotNull JSCallExpression call, @NotNull JSLiteralExpression argument, @NotNull JSModuleVisitor.ImportResolver importResolver, @NotNull JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (argument == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (importResolver == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pointerBuilder == null) {
                    1.$$$reportNull$$$0(3);
                }
                Project project = session.getFile().getProject();
                String referenceText = StringUtil.unquoteString((String)argument.getText());
                Convertor<VirtualFile, VirtualFile> resolver = this.getRequireImportResolver(project, argument, referenceText);
                NpmUsedModulesInstalledInspection.check((PsiElement)argument, referenceText, holder, importResolver, resolver, pointerBuilder);
            }

            @Override
            protected void processImport(@NotNull PsiElement literalElement, @NotNull String quotedLiteralValue, PsiReference @NotNull [] references, @NotNull JSModuleVisitor.ImportResolver importResolver, @NotNull JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                if (literalElement == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (quotedLiteralValue == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (importResolver == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (pointerBuilder == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (references == null) {
                    1.$$$reportNull$$$0(8);
                }
                Convertor<VirtualFile, VirtualFile> resolver = NpmUsedModulesInstalledInspection.getES6Resolver(importResolver);
                NpmUsedModulesInstalledInspection.check(literalElement, quotedLiteralValue, holder, importResolver, resolver, pointerBuilder);
            }

            @Override
            protected boolean isAvailable(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(9);
                }
                return DialectDetector.isJavaScript(element);
            }

            @NotNull
            private Convertor<VirtualFile, VirtualFile> getRequireImportResolver(@NotNull Project project, @NotNull JSExpression argument, @NotNull String referenceText) {
                if (project == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (argument == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (referenceText == null) {
                    1.$$$reportNull$$$0(12);
                }
                Convertor convertor = moduleRoot -> {
                    String[] split;
                    ResolveResult[] resolve;
                    JSModuleBaseReference reference = 1.getNodeModuleReference(argument);
                    if (reference == null) {
                        return null;
                    }
                    Object list2 = reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false) : ((resolve = ((PsiReference)reference).resolve()) != null ? new ResolveResult[]{new PsiElementResolveResult((PsiElement)resolve)} : null);
                    if (list2 != null) {
                        for (ResolveResult result2 : list2) {
                            PsiFileSystemItem psiFile;
                            if (result2 == null || !result2.isValidResult() || result2.getElement() == null || !result2.getElement().isValid()) continue;
                            PsiElement resolve2 = result2.getElement();
                            Object object = psiFile = resolve2 instanceof PsiFileSystemItem ? (PsiFileSystemItem)resolve2 : resolve2.getContainingFile();
                            if (psiFile.isDirectory() || !DialectDetector.JAVASCRIPT_FILE_TYPES.contains(psiFile.getVirtualFile().getFileType()) && !TypeScriptUtil.isDefinitionFile(psiFile.getVirtualFile()) || !(psiFile instanceof PsiFile) || NodeModuleUtil.getRequireModuleInfo(project, moduleRoot, psiFile.getVirtualFile()) == null) continue;
                            return psiFile.getVirtualFile();
                        }
                    }
                    String name = (split = referenceText.replace("\\", "/").split("/")).length == 0 ? referenceText : split[0];
                    VirtualFile nm = moduleRoot.findChild("node_modules");
                    if (nm != null) {
                        return nm.findChild(name);
                    }
                    return null;
                };
                if (convertor == null) {
                    1.$$$reportNull$$$0(13);
                }
                return convertor;
            }

            private static JSModuleBaseReference getNodeModuleReference(JSExpression argument) {
                PsiReference[] references;
                for (PsiReference reference : references = argument.getReferences()) {
                    if (!(reference instanceof JSModuleBaseReference)) continue;
                    return (JSModuleBaseReference)reference;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 13 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "argument";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "importResolver";
                        break;
                    }
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pointerBuilder";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "literalElement";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "quotedLiteralValue";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "references";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceText";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection$1";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRequireImportResolver";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processRequire";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "processImport";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "getRequireImportResolver";
                        break;
                    }
                    case 13: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 13 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static Convertor<VirtualFile, VirtualFile> getES6Resolver(@NotNull JSModuleVisitor.ImportResolver resolver) {
        if (resolver == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(2);
        }
        Convertor convertor = moduleRoot -> {
            for (PsiElement element : resolver.resolveImportModules()) {
                VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
                if (file == null) continue;
                return file;
            }
            return null;
        };
        if (convertor == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(3);
        }
        return convertor;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(4);
        }
        return highlightDisplayLevel;
    }

    private static void check(@Nullable PsiElement element, @Nullable String quotedLiteralValue, ProblemsHolder holder, @NotNull JSModuleVisitor.ImportResolver importResolver, @NotNull Convertor<VirtualFile, VirtualFile> resolver, @NotNull JSModuleVisitor.ModulePointerBuilder pointerCreator) {
        VirtualFile projectDir;
        if (importResolver == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(5);
        }
        if (resolver == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(6);
        }
        if (pointerCreator == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(7);
        }
        if (quotedLiteralValue == null || element == null) {
            return;
        }
        String moduleName = JSFileReferencesUtil.getNodeModuleName(quotedLiteralValue = quotedLiteralValue.trim());
        if (!JSFileReferencesUtil.isAcceptableNodeModulesPackageName(moduleName)) {
            return;
        }
        Project project = element.getProject();
        if (NpmUsedModulesInstalledInspection.isAliasedModule(element, moduleName, project)) {
            return;
        }
        if (NodeCoreLibraryManager.isCoreModuleName(moduleName)) {
            return;
        }
        VirtualFile coreModule = NodeCoreLibraryManager.getInstance(project).findCoreModuleFileByName(moduleName);
        if (coreModule != null) {
            return;
        }
        if (PackageJsonDependenciesExternalUpdateManager.getInstance(project).isExternalUpdateRunning(moduleName)) {
            return;
        }
        if (NpmUsedModulesInstalledInspection.isDependencyInstalledWithYarnPnp(project, PsiUtilCore.getVirtualFile((PsiElement)element), moduleName)) {
            return;
        }
        if (NpmUsedModulesInstalledInspection.isResolveOutOfNodeModules(importResolver)) {
            return;
        }
        Collection<Object> packageJsonFiles = PackageJsonFileManager.getInstance(project).getValidPackageJsonFiles();
        packageJsonFiles = ContainerUtil.filter(packageJsonFiles, file -> !JSLibraryUtil.isProbableLibraryFile(file));
        boolean inPackageJson = false;
        InstallationDetector installationDetector = new InstallationDetector(project, resolver);
        if (!packageJsonFiles.isEmpty()) {
            for (VirtualFile virtualFile : packageJsonFiles) {
                VirtualFile moduleRoot = virtualFile.getParent();
                if (moduleRoot == null || !virtualFile.isValid()) continue;
                boolean notInPackageJson = NodeModuleUtil.moduleNotInPackageJson(moduleName, virtualFile);
                if (!notInPackageJson) {
                    inPackageJson = true;
                }
                installationDetector.accept(moduleRoot);
                if (!inPackageJson || !installationDetector.isInstalledMaybeMultiple()) continue;
                if (holder.isOnTheFly()) {
                    NpmUsedModulesInstalledInspection.checkTypings(element, moduleName, importResolver, installationDetector, holder);
                }
                return;
            }
        }
        if (!installationDetector.isInstalledMaybeMultiple() && packageJsonFiles.isEmpty() && (projectDir = ProjectUtil.guessProjectDir((Project)project)) != null) {
            installationDetector.accept(projectDir);
        }
        InstallNodeModuleQuickFix.ModuleElement moduleElement = pointerCreator.createPointer();
        if (!installationDetector.isLibraryResolveOnly() && installationDetector.isInstalledMaybeMultiple()) {
            return;
        }
        VirtualFile virtualFile = installationDetector.isInstalledMaybeMultiple() ? installationDetector.getNodeModules() : null;
        NpmUsedModulesInstalledInspection.reportModulesIsNotInstalledErrorWithFixes(moduleElement, packageJsonFiles, inPackageJson, virtualFile, (text2, fixes) -> holder.registerProblem(element, text2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes.toArray(LocalQuickFix.EMPTY_ARRAY)));
    }

    private static boolean isResolveOutOfNodeModules(@NotNull JSModuleVisitor.ImportResolver importResolver) {
        if (importResolver == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(8);
        }
        Collection<PsiElement> elements = importResolver.resolveImportModules();
        for (PsiElement element : elements) {
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (file != null && (JSLibraryUtil.isProbableLibraryFile(file) || TypeScriptUtil.isDefinitionFile(file))) continue;
            return true;
        }
        return false;
    }

    private static boolean isDependencyInstalledWithYarnPnp(@NotNull Project project, @Nullable VirtualFile contextFileUsingDependency, @NotNull String dependencyName) {
        if (project == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(9);
        }
        if (dependencyName == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(10);
        }
        YarnPnpManager yarnPnpManager = YarnPnpManager.getInstance(project);
        if (contextFileUsingDependency == null || !yarnPnpManager.isUnderPnp(contextFileUsingDependency)) {
            return false;
        }
        Ref installed = Ref.create((Object)false);
        PackageJsonUtil.processUpPackageJsonFiles(project, contextFileUsingDependency, (Processor<? super VirtualFile>)((Processor)packageJson -> {
            VirtualFile dependencyDir;
            if (PackageJsonData.getOrCreate(packageJson).isDependencyOfAnyType(dependencyName) && (dependencyDir = yarnPnpManager.findInstalledPackageDir((VirtualFile)packageJson, dependencyName)) != null && dependencyDir.isValid()) {
                installed.set((Object)true);
                return false;
            }
            return true;
        }));
        return (Boolean)installed.get();
    }

    private static void checkTypings(@NotNull PsiElement element, @NotNull String moduleName, @NotNull JSModuleVisitor.ImportResolver importResolver, @NotNull InstallationDetector installationDetector, @NotNull ProblemsHolder holder) {
        if (element == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(11);
        }
        if (moduleName == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(12);
        }
        if (importResolver == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(13);
        }
        if (installationDetector == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(14);
        }
        if (holder == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(15);
        }
        if (NpmUsedModulesInstalledInspection.modulePackageJsonHasTypings(moduleName, installationDetector.myNodeModules) == ModuleTypingsState.NO_TYPINGS && !moduleName.startsWith("@")) {
            Collection<PsiElement> elements = importResolver.resolveImportModules();
            for (PsiElement psiElement : elements) {
                if (!DialectDetector.isTypeScript(psiElement)) continue;
                return;
            }
            holder.registerProblem(element, JavaScriptBundle.message("npm.modules.install.global.types.fix.name", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new TypeScriptInstallGlobalTypesFix(element, moduleName)});
        }
    }

    public static void reportModulesIsNotInstalledErrorWithFixes(@NotNull InstallNodeModuleQuickFix.ModuleElement moduleElement, @NotNull Collection<VirtualFile> packageJsonFiles, boolean inPackageJson, @Nullable VirtualFile nodeModules, @NotNull Reporter reporter) {
        if (moduleElement == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(16);
        }
        if (packageJsonFiles == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(17);
        }
        if (reporter == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(18);
        }
        if (nodeModules != null) {
            if (!inPackageJson) {
                NpmUsedModulesInstalledInspection.reportModuleIsNotInDependencies(packageJsonFiles, moduleElement, reporter);
            }
        } else {
            ArrayList<InstallNodeModuleQuickFix> fixes = new ArrayList<InstallNodeModuleQuickFix>();
            if (inPackageJson) {
                if (!packageJsonFiles.isEmpty()) {
                    fixes.add(new RunNpmUpdateQuickFix(moduleElement, packageJsonFiles));
                }
            } else {
                fixes.add(new InstallNodeModuleQuickFix(moduleElement, packageJsonFiles));
                fixes.add(new InstallNodeModuleAddToDevDependenciesQuickFix(moduleElement, packageJsonFiles));
            }
            reporter.reportError(JavaScriptBundle.message("npm.modules.inspection.content.of.require.module.not.installed.warning", new Object[0]), fixes);
        }
    }

    private static void reportModuleIsNotInDependencies(@NotNull Collection<VirtualFile> packageJsonFiles, @NotNull InstallNodeModuleQuickFix.ModuleElement moduleElement, @NotNull Reporter reporter) {
        if (packageJsonFiles == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(19);
        }
        if (moduleElement == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(20);
        }
        if (reporter == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(21);
        }
        reporter.reportError(JavaScriptBundle.message("npm.modules.inspection.content.of.require.not.in.dependencies.warning", new Object[0]), List.of(new InstallNodeModuleQuickFix(moduleElement, packageJsonFiles), new InstallNodeModuleAddToDevDependenciesQuickFix(moduleElement, packageJsonFiles)));
    }

    private static boolean isAliasedModule(PsiElement context2, String moduleName, Project project) {
        Collection<WebBundlerDefinition> bundlerDefinitions = WebBundlerDefinitionsProvider.getInstance(project).getAllDefinitions();
        for (WebBundlerDefinition definition2 : bundlerDefinitions) {
            WebBundlerConfigManager manager = definition2.getConfigManager(project);
            Map<String, WebBundlerResolveAlias> alias = manager.resolveConfig(context2).getResolve().getAlias();
            if (!alias.containsKey(moduleName) && !alias.containsKey(moduleName + "$")) continue;
            return true;
        }
        return false;
    }

    public static ModuleTypingsState modulePackageJsonHasTypings(@NotNull String moduleName, @Nullable VirtualFile nodeModulesDirectory) {
        if (moduleName == null) {
            NpmUsedModulesInstalledInspection.$$$reportNull$$$0(22);
        }
        if (nodeModulesDirectory == null) {
            return ModuleTypingsState.MODULE_DIRECTORY_NOT_EXIST;
        }
        List names = ContainerUtil.append((List)ContainerUtil.filter((Object[])moduleName.split("/"), el -> !StringUtil.isEmpty((String)el)), (Object[])new String[]{"package.json"});
        VirtualFile packageJsonForModule = VfsUtil.findRelativeFile((VirtualFile)nodeModulesDirectory, (String[])ArrayUtilRt.toStringArray((Collection)names));
        if (packageJsonForModule != null) {
            PackageJsonData moduleData = PackageJsonData.getOrCreate(packageJsonForModule);
            return moduleData.hasTypings() ? ModuleTypingsState.HAS_TYPINGS : ModuleTypingsState.NO_TYPINGS;
        }
        return ModuleTypingsState.MODULE_DIRECTORY_NOT_EXIST;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importResolver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointerCreator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installationDetector";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleElement";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getES6Resolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getES6Resolver";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isResolveOutOfNodeModules";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyInstalledWithYarnPnp";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkTypings";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reportModulesIsNotInstalledErrorWithFixes";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "reportModuleIsNotInDependencies";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "modulePackageJsonHasTypings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class InstallationDetector {
        private boolean myIsLibraryResolveOnly;
        private boolean myMultipleInstallations;
        private VirtualFile myNodeModules;
        @NotNull
        private final Project myProject;
        @NotNull
        private final Convertor<? super VirtualFile, ? extends VirtualFile> myResolver;

        InstallationDetector(@NotNull Project project, @NotNull Convertor<? super VirtualFile, ? extends VirtualFile> resolver) {
            if (project == null) {
                InstallationDetector.$$$reportNull$$$0(0);
            }
            if (resolver == null) {
                InstallationDetector.$$$reportNull$$$0(1);
            }
            this.myIsLibraryResolveOnly = true;
            this.myProject = project;
            this.myResolver = resolver;
        }

        public void accept(@NotNull VirtualFile packageJsonParent) {
            VirtualFile resolveFile;
            if (packageJsonParent == null) {
                InstallationDetector.$$$reportNull$$$0(2);
            }
            if ((resolveFile = (VirtualFile)this.myResolver.convert((Object)packageJsonParent)) != null) {
                this.myIsLibraryResolveOnly &= JSLibraryUtil.hasDirectoryInPath(resolveFile, NODE_MODULES, NodeModuleUtil.findParentContentRoot(this.myProject, resolveFile));
                VirtualFile folder = JSLibraryUtil.getTopLibraryFolder(resolveFile, NODE_MODULES[0], null);
                if (folder != null) {
                    if (!this.myMultipleInstallations && this.myNodeModules == null) {
                        this.myNodeModules = folder.getParent();
                    } else {
                        this.myMultipleInstallations = true;
                        this.myNodeModules = null;
                    }
                }
            }
        }

        public boolean isLibraryResolveOnly() {
            return this.myIsLibraryResolveOnly;
        }

        public boolean isInstalledMaybeMultiple() {
            return this.myNodeModules != null || this.myMultipleInstallations;
        }

        public VirtualFile getNodeModules() {
            return this.myNodeModules;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJsonParent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection$InstallationDetector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface Reporter {
        public void reportError(@NotNull @InspectionMessage String var1, @NotNull @NotNull List<? extends @NotNull LocalQuickFix> var2);
    }

    public static enum ModuleTypingsState {
        HAS_TYPINGS,
        NO_TYPINGS,
        MODULE_DIRECTORY_NOT_EXIST;

    }
}

