/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.JSImportModuleFix;
import com.intellij.lang.javascript.modules.JSPlaceTail;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.modules.NodeJSModulesSearcher;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidateWithExecutor;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.modules.imports.JSReplaceReferenceExecutor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportModulesSuggester
implements JsModulesSuggester {
    @NotNull
    protected final Set<VirtualFile> myPredefinedFiles;
    @NotNull
    protected final ModuleReferenceInfo myModuleReferenceInfo;
    @NotNull
    protected final PsiElement myNode;

    public JSImportModulesSuggester(@NotNull ModuleReferenceInfo moduleReferenceInfo, @NotNull PsiElement node) {
        if (moduleReferenceInfo == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(0);
        }
        if (node == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(1);
        }
        this.myPredefinedFiles = JsModulesSuggester.getPredefinedLibraries(node);
        this.myModuleReferenceInfo = moduleReferenceInfo;
        this.myNode = node;
    }

    @Override
    public boolean isResolvedGlobally(@NotNull ResolveResult result2) {
        if (result2 == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(2);
        }
        return NodeModuleUtil.isResolvedGloballyCommonJS(result2, this.myPredefinedFiles);
    }

    @NotNull
    protected List<JSImportCandidateWithExecutor> find(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(3);
        }
        List<JSImportCandidateWithExecutor> list2 = new NodeJSModulesSearcher(this.myModuleReferenceInfo, this.myNode, resolveResults, this.myPredefinedFiles).find();
        if (list2 == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<LocalQuickFix> findFixes(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(5);
        }
        if (NodeModuleUtil.isWrappedInAmdDefinition(this.myNode)) {
            List<LocalQuickFix> list2 = Collections.emptyList();
            if (list2 == null) {
                JSImportModulesSuggester.$$$reportNull$$$0(6);
            }
            return list2;
        }
        return this.createFixes(this.find(resolveResults));
    }

    @Override
    @Nullable
    public String getMessage(@NotNull Collection<LocalQuickFix> fixes) {
        if (fixes == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(7);
        }
        if (fixes.isEmpty()) {
            return null;
        }
        return JSHandlersFactory.isES6ImportAvailable(this.myNode) ? JavaScriptBundle.message("js.inspection.missing.import", new Object[0]) : JavaScriptBundle.message("node.js.missing.require", new Object[0]);
    }

    @NotNull
    private List<LocalQuickFix> createFixes(@NotNull List<JSImportCandidateWithExecutor> candidates) {
        if (candidates == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(8);
        }
        ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
        boolean hint2 = this.myModuleReferenceInfo.needHint();
        JSImportModuleFix.HintMode mode = candidates.size() > 1 ? JSImportModuleFix.HintMode.MULTI : JSImportModuleFix.HintMode.SINGLE;
        for (int i = 0; i < candidates.size(); ++i) {
            JSImportCandidateWithExecutor candidate = candidates.get(i);
            JSImportModuleFix.HintMode usedMode = i == 0 && hint2 ? mode : JSImportModuleFix.HintMode.NO_HINT;
            result2.add(new JSImportModuleFix(this.myNode, candidate, usedMode));
        }
        PsiElement parent = this.myModuleReferenceInfo.getParentRef();
        String name = this.myModuleReferenceInfo.getParentName();
        if (parent != null && name != null) {
            this.addTailCandidates(candidates, result2, parent, name);
        }
        ArrayList<LocalQuickFix> arrayList = result2;
        if (arrayList == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private void addTailCandidates(@NotNull List<JSImportCandidateWithExecutor> descriptors, @NotNull List<LocalQuickFix> result2, @NotNull PsiElement parent, @NotNull String name) {
        if (descriptors == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(12);
        }
        if (name == null) {
            JSImportModulesSuggester.$$$reportNull$$$0(13);
        }
        Project project = this.myNode.getProject();
        for (JSImportCandidateWithExecutor candidateWithExecutor : descriptors) {
            JSImportExportType type2;
            JSImportCandidate candidate = candidateWithExecutor.getCandidate();
            JSImportDescriptor descriptor = candidate.getDescriptor();
            if (descriptor == null || (type2 = descriptor.getImportType()).isSpecifier() || this.myModuleReferenceInfo.getContext() == JSContext.INSTANCE) continue;
            JSPlaceTail tail = new JSPlaceTail((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(parent), new String[]{name});
            VirtualFile file = candidate.getElementFile();
            if (file == null) continue;
            JSModuleDescriptor moduleDescriptor = descriptor.getModuleDescriptor();
            JSImportCandidateDescriptor newDescriptor = new JSImportCandidateDescriptor(moduleDescriptor, name, name, descriptor.getImportExportPrefixKind(), (JSImportExportType)ES6ImportPsiUtil.ImportExportType.SPECIFIER);
            JSReplaceReferenceExecutor executor = new JSReplaceReferenceExecutor(candidateWithExecutor.getExecutor(), tail);
            JSImportCandidateWithExecutor newCandidate = new JSImportCandidateWithExecutor(newDescriptor, executor);
            ContainerUtil.addIfNotNull(result2, (Object)new JSImportModuleFix(parent, newCandidate, JSImportModuleFix.HintMode.NO_HINT));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReferenceInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSImportModulesSuggester";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSImportModulesSuggester";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findFixes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedGlobally";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFixes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFixes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addTailCandidates";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 9 -> new IllegalStateException(string);
        };
    }
}

