/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.inspections.TypeScriptFixesReferenceErrorUpdater;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.lang.javascript.modules.imports.JSImportCandidateWithExecutor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportAllQuickFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final String myParentName;

    public JSImportAllQuickFix(@NotNull String parentName, @NotNull PsiElement element) {
        if (parentName == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(1);
        }
        super(element);
        this.myParentName = parentName;
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        return JSImportAllQuickFix.getImportAllActionName();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(3);
        }
        if (file == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(6);
        }
        return JSImportAction.isValidImportPlace(startElement);
    }

    private static boolean isAcceptableUnresolvedJSXLiteral(@NotNull JSLiteralExpression node) {
        if (node == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(7);
        }
        return node instanceof JSXXmlLiteralExpressionImpl && StringUtil.isCapitalized((String)node.getName()) && !JSXResolveUtil.areReferencesResolvedOrEmpty((JSXmlLiteralExpression)node);
    }

    private static boolean isAcceptableUnresolvedReference(@NotNull JSReferenceExpression node) {
        JSExpression qualifier;
        if (node == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(8);
        }
        if ((qualifier = node.getQualifier()) != null) {
            return false;
        }
        Object[] results = node.multiResolve(false);
        if (results.length == 0) {
            return true;
        }
        if (results.length != 1 || ContainerUtil.exists((Object[])results, ResolveResult::isValidResult)) {
            return false;
        }
        JSResolveResult result2 = (JSResolveResult)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])results), JSResolveResult.class);
        if (result2 == null) {
            return false;
        }
        return TypeScriptFixesReferenceErrorUpdater.isAcceptableResolveKey(node, result2.getResolveProblemKind(), result2.getElement());
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSElement scope2;
        if (project == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(9);
        }
        if (file == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(10);
        }
        if (startElement == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(11);
        }
        if (endElement == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(12);
        }
        if ((scope2 = ES6PsiUtil.getExportScope(startElement)) == null) {
            return;
        }
        final LinkedHashMap<String, PsiElement> nameToElement = new LinkedHashMap<String, PsiElement>();
        nameToElement.put(this.myParentName, startElement);
        scope2.accept(new JSRecursiveWalkingElementVisitor(){

            @Override
            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (JSImportAllQuickFix.isAcceptableUnresolvedReference(node)) {
                    nameToElement.putIfAbsent(node.getReferenceName(), node);
                }
                super.visitJSReferenceExpression(node);
            }

            @Override
            public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (JSImportAllQuickFix.isAcceptableUnresolvedJSXLiteral(node)) {
                    PsiElement psiName;
                    ASTNode nameNode = node.getNode().findChildByType(JSTokenTypes.XML_TAG_NAME);
                    PsiElement psiElement = psiName = nameNode == null ? null : nameNode.getPsi();
                    if (psiName != null) {
                        nameToElement.putIfAbsent(node.getName(), psiName);
                    }
                }
                super.visitJSLiteralExpression(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSImportAllQuickFix$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSLiteralExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (nameToElement.isEmpty()) {
            return;
        }
        List<String> strings = nameToElement.keySet().stream().toList();
        Editor editor = PsiEditorUtil.findEditor((PsiElement)startElement);
        JSImportAllQuickFix.executeForAll(0, editor, strings, nameToElement);
    }

    private static void executeForAll(int index, @Nullable Editor editor, @NotNull List<String> strings, @NotNull Map<String, PsiElement> nameToElement) {
        if (strings == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(13);
        }
        if (nameToElement == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(14);
        }
        String key2 = strings.get(index);
        PsiElement element = nameToElement.get(key2);
        JSImportAction action = new JSImportAction(editor, element, key2);
        action.executeForAllVariants((Consumer<JSImportCandidateWithExecutor>)((Consumer)__ -> {
            int next = index + 1;
            if (next < strings.size()) {
                JSImportAllQuickFix.executeForAll(next, editor, strings, nameToElement);
            }
        }));
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    @IntentionFamilyName
    public static String getImportAllActionName() {
        String string = JavaScriptBundle.message("ts.add.import.all.family.name", new Object[0]);
        if (string == null) {
            JSImportAllQuickFix.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSImportAllQuickFix";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSImportAllQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportAllActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 15: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableUnresolvedJSXLiteral";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableUnresolvedReference";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeForAll";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 15 -> new IllegalStateException(string);
        };
    }
}

