/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.service;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.GlobPatternUtil;
import com.intellij.lang.javascript.linter.MultiRootJSLinterLanguageServiceManager;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.service.ESLintLanguageService;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class EslintLanguageServiceManager
extends MultiRootJSLinterLanguageServiceManager<ESLintLanguageService> {
    public EslintLanguageServiceManager(@NotNull Project project) {
        if (project == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(0);
        }
        super(project, "eslint");
    }

    @NotNull
    public static EslintLanguageServiceManager getInstance(@NotNull Project project) {
        if (project == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(1);
        }
        EslintLanguageServiceManager eslintLanguageServiceManager = (EslintLanguageServiceManager)project.getService(EslintLanguageServiceManager.class);
        if (eslintLanguageServiceManager == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(2);
        }
        return eslintLanguageServiceManager;
    }

    @Override
    @NotNull
    protected ESLintLanguageService createServiceInstance(@NotNull NodePackage resolvedPackage, @NotNull VirtualFile workingDirectory) {
        if (resolvedPackage == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(3);
        }
        if (workingDirectory == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(4);
        }
        return new ESLintLanguageService(this.myProject, resolvedPackage, workingDirectory);
    }

    @Override
    protected boolean hasLinterSpecificConfiguration(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(5);
        }
        for (VirtualFile child : packageJson.getParent().getChildren()) {
            if (child.isDirectory() || !EslintUtil.isFlatOrLegacyConfigFile(child)) continue;
            return true;
        }
        Set<String> properties = PackageJsonData.getOrCreate(packageJson).getTopLevelProperties();
        return properties.contains("eslintConfig");
    }

    @Override
    @NotNull
    protected VirtualFile getWorkingDirectory(@NotNull NodePackage resolvedPackage, @NotNull Project project, @NotNull VirtualFile file) {
        boolean customFlatConfigFileSpecified;
        VirtualFile wd;
        if (resolvedPackage == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(6);
        }
        if (project == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(7);
        }
        if (file == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(8);
        }
        if ((wd = EslintLanguageServiceManager.getConfiguredWorkingDirectoryForFile(project, file)) != null) {
            VirtualFile virtualFile = wd;
            if (virtualFile == null) {
                EslintLanguageServiceManager.$$$reportNull$$$0(9);
            }
            return virtualFile;
        }
        SemVer eslintVersion = resolvedPackage.getVersion(project);
        String customConfigFilePath = ((EslintState)EslintConfiguration.getInstance(project).getExtendedState().getState()).getCustomConfigFilePath();
        boolean usingCustomConfig = !customConfigFilePath.isEmpty();
        boolean bl = customFlatConfigFileSpecified = usingCustomConfig && EslintUtil.isFlatConfigFileName(PathUtil.getFileName((String)customConfigFilePath));
        if (usingCustomConfig && EslintUtil.isUseFlatConfigMode(eslintVersion, customFlatConfigFileSpecified)) {
            VirtualFile dir2;
            VirtualFile customConfigFile = LocalFileSystem.getInstance().findFileByPath(customConfigFilePath);
            if (customConfigFile != null && VfsUtilCore.isAncestor((VirtualFile)(dir2 = customConfigFile.getParent()), (VirtualFile)file, (boolean)false)) {
                VirtualFile virtualFile = dir2;
                if (virtualFile == null) {
                    EslintLanguageServiceManager.$$$reportNull$$$0(10);
                }
                return virtualFile;
            }
            VirtualFile virtualFile = super.getWorkingDirectory(resolvedPackage, project, file);
            if (virtualFile == null) {
                EslintLanguageServiceManager.$$$reportNull$$$0(11);
            }
            return virtualFile;
        }
        Ref flatConfigFile = new Ref();
        Ref workingDirIfNotFlatConfig = new Ref();
        JSProjectUtil.processDirectoriesUpToContentRoot(project, file, (Processor<? super VirtualFile>)((Processor)dir -> {
            Set<String> properties;
            for (VirtualFile child : dir.getChildren()) {
                if (child.isDirectory()) continue;
                if (EslintUtil.isFlatConfigFileName(child.getName()) && flatConfigFile.isNull()) {
                    flatConfigFile.set((Object)child);
                }
                if (!child.getName().equals(".eslintignore") && !EslintUtil.isLegacyConfigFileName(child.getName()) || !workingDirIfNotFlatConfig.isNull()) continue;
                workingDirIfNotFlatConfig.set(dir);
            }
            VirtualFile packageJson = dir.findChild("package.json");
            if (packageJson != null && ((properties = PackageJsonData.getOrCreate(packageJson).getTopLevelProperties()).contains("eslintIgnore") || properties.contains("eslintConfig")) && workingDirIfNotFlatConfig.isNull()) {
                workingDirIfNotFlatConfig.set(dir);
            }
            return true;
        }));
        if (!usingCustomConfig && EslintUtil.isUseFlatConfigMode(eslintVersion, !flatConfigFile.isNull())) {
            VirtualFile virtualFile = !flatConfigFile.isNull() ? ((VirtualFile)flatConfigFile.get()).getParent() : super.getWorkingDirectory(resolvedPackage, project, file);
            if (virtualFile == null) {
                EslintLanguageServiceManager.$$$reportNull$$$0(12);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = !workingDirIfNotFlatConfig.isNull() ? (VirtualFile)workingDirIfNotFlatConfig.get() : super.getWorkingDirectory(resolvedPackage, project, file);
        if (virtualFile == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(13);
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile getConfiguredWorkingDirectoryForFile(@NotNull Project project, @NotNull VirtualFile file) {
        String patternsString;
        if (project == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(14);
        }
        if (file == null) {
            EslintLanguageServiceManager.$$$reportNull$$$0(15);
        }
        if ((patternsString = ((EslintState)EslintConfiguration.getInstance(project).getExtendedState().getState()).getWorkDirPatterns()).isEmpty()) {
            return null;
        }
        List patterns = ContainerUtil.mapNotNull((Collection)StringUtil.split((String)patternsString, (String)";"), s -> StringUtil.nullize((String)StringUtil.trimStart((String)Strings.trimEnd((String)s.trim(), (char)'/'), (String)"./")));
        VirtualFile dir = file.getParent();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        while (fileIndex.isInContent(dir)) {
            for (String pattern : patterns) {
                if (pattern.equals(".") && dir.getPath().equals(project.getBasePath())) {
                    return dir;
                }
                if (pattern.equals(dir.getPath())) {
                    return dir;
                }
                if (!GlobPatternUtil.isFileMatchingGlobPattern(project, pattern, dir)) continue;
                return dir;
            }
            dir = dir.getParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/service/EslintLanguageServiceManager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedPackage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/service/EslintLanguageServiceManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createServiceInstance";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasLinterSpecificConfiguration";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredWorkingDirectoryForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

