/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.eslint.ESLintJsonProblemsParser;
import com.intellij.lang.javascript.linter.eslint.EslintError;
import com.intellij.lang.javascript.linter.eslint.EslintRequestData;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceClient;
import com.intellij.lang.javascript.linter.eslint.service.protocol.ESLintLanguageServiceInitialState;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ESLintBasedLanguageService<TStoredState extends JSNpmLinterState<TStoredState>>
extends JSLanguageServiceBase
implements EslintLanguageServiceClient {
    @NotNull
    private final NodePackage myNodePackage;
    @NotNull
    private final VirtualFile myWorkingDirectory;

    public ESLintBasedLanguageService(@NotNull Project project, @NotNull NodePackage nodePackage, @NotNull VirtualFile workingDirectory) {
        if (project == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(0);
        }
        if (nodePackage == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(1);
        }
        if (workingDirectory == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(2);
        }
        super(project);
        this.myNodePackage = nodePackage;
        this.myWorkingDirectory = workingDirectory;
    }

    @Override
    @NotNull
    public NodePackage getNodePackage() {
        NodePackage nodePackage = this.myNodePackage;
        if (nodePackage == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(3);
        }
        return nodePackage;
    }

    @Override
    @NotNull
    public VirtualFile getWorkingDirectory() {
        VirtualFile virtualFile = this.myWorkingDirectory;
        if (virtualFile == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public CompletableFuture<EslintLanguageServiceClient.Response<List<EslintError>>> highlight(@NotNull EslintRequestData requestData, String extraOptions) {
        if (requestData == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmptyOrSpaces((String)requestData.getFileToLintContent())) {
            return null;
        }
        VirtualFile virtualFile = requestData.getFileToLint();
        String configPath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(requestData.getSpecifiedConfigFile());
        String path2 = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(virtualFile);
        String eslintIgnoreFilePath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(requestData.getEslintIgnoreFile());
        if (path2 == null) {
            return null;
        }
        JSLanguageServiceQueue process2 = this.getProcess();
        if (process2 == null) {
            String error = JSLanguageServiceUtil.getLanguageServiceCreationError(this);
            return CompletableFuture.completedFuture(EslintLanguageServiceClient.Response.error(error, false));
        }
        GetErrorsCommand command = new GetErrorsCommand(path2, configPath, requestData.getFileToLintContent(), extraOptions, eslintIgnoreFilePath, requestData.getFileKind().getStringValue(), requestData.isFlatConfigMode());
        return process2.execute(command, ESLintBasedLanguageService.createHighlightProcessor());
    }

    @Override
    @Nullable
    public CompletableFuture<EslintLanguageServiceClient.Response<String>> fixFile(@NotNull EslintRequestData requestData, String extraOptions) {
        if (requestData == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(6);
        }
        VirtualFile virtualFile = requestData.getFileToLint();
        String configPath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(requestData.getSpecifiedConfigFile());
        String path2 = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(virtualFile);
        String ignoreFilePath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(requestData.getEslintIgnoreFile());
        if (path2 == null) {
            return null;
        }
        JSLanguageServiceQueue process2 = this.getProcess();
        if (process2 == null) {
            return CompletableFuture.completedFuture(EslintLanguageServiceClient.Response.error(JSLanguageServiceUtil.getLanguageServiceCreationError(this), false));
        }
        FixErrorsCommand command = new FixErrorsCommand(path2, configPath, requestData.getFileToLintContent(), extraOptions, ignoreFilePath, requestData.getFileKind().getStringValue(), requestData.isFlatConfigMode());
        return process2.execute(command, (serviceObject, answer) -> ESLintBasedLanguageService.processFixFileResponse(answer));
    }

    @NotNull
    protected abstract Class<? extends JSLinterConfiguration<TStoredState>> getConfigurationClass();

    protected void fillInitialProtocolState(@NotNull ESLintLanguageServiceInitialState protocolState, @NotNull TStoredState storedState) {
        String packagePath;
        NodePackage nodePackage;
        if (protocolState == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(7);
        }
        if (storedState == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(8);
        }
        if ((nodePackage = this.myNodePackage) instanceof YarnPnpNodePackage) {
            YarnPnpNodePackage pnpNodePackage = (YarnPnpNodePackage)nodePackage;
            packagePath = pnpNodePackage.getName();
            String packageJsonPath = pnpNodePackage.getPackageJsonPath(this.myProject);
            if (packageJsonPath == null) {
                throw new IllegalStateException("Cannot find package.json path for " + this.myNodePackage);
            }
            protocolState.packageJsonPath = LocalFilePath.create(FileUtil.toSystemDependentName((String)packageJsonPath));
        } else {
            packagePath = this.myNodePackage.getSystemDependentPath();
        }
        LocalFilePath localFilePackagePath = LocalFilePath.create(packagePath);
        if (this.myNodePackage.getName().equals("standard")) {
            protocolState.standardPackagePath = localFilePackagePath;
        } else {
            protocolState.eslintPackagePath = localFilePackagePath;
        }
        SemVer version2 = this.myNodePackage.getVersion(this.myProject);
        protocolState.linterPackageVersion = version2 != null ? version2.getRawVersion() : "";
    }

    @NotNull
    private static JSLanguageServiceCommandProcessor<EslintLanguageServiceClient.Response<List<EslintError>>> createHighlightProcessor() {
        JSLanguageServiceCommandProcessor<EslintLanguageServiceClient.Response<List<EslintError>>> jSLanguageServiceCommandProcessor = (serviceObject, answer) -> {
            @NlsSafe String languageServiceError = JsonUtil.getChildAsString((JsonObject)answer.getElement(), (String)"error");
            if (languageServiceError != null) {
                boolean isNoConfigFile = JsonUtil.getChildAsBoolean((JsonObject)answer.getElement(), (String)"isNoConfigFile", (boolean)false);
                return EslintLanguageServiceClient.Response.error(languageServiceError, isNoConfigFile);
            }
            ESLintJsonProblemsParser parser2 = ESLintJsonProblemsParser.parse(answer.getElement());
            return new EslintLanguageServiceClient.Response<List<EslintError>>(parser2.getFileLevelError(), parser2.getErrors(), false);
        };
        if (jSLanguageServiceCommandProcessor == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(9);
        }
        return jSLanguageServiceCommandProcessor;
    }

    @NotNull
    private static EslintLanguageServiceClient.Response<String> processFixFileResponse(@NotNull JSLanguageServiceAnswer answer) {
        JsonObject element;
        JsonObject responseObject;
        String languageServiceError;
        if (answer == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(10);
        }
        if ((languageServiceError = JsonUtil.getChildAsString((JsonObject)(responseObject = answer.getElement()), (String)"error")) != null) {
            EslintLanguageServiceClient.Response<String> response = EslintLanguageServiceClient.Response.error(languageServiceError, false);
            if (response == null) {
                ESLintBasedLanguageService.$$$reportNull$$$0(11);
            }
            return response;
        }
        JsonObject body2 = JsonUtil.getChildAsObject((JsonObject)responseObject, (String)"body");
        JsonArray response = JsonUtil.getChildAsArray((JsonObject)body2, (String)"results");
        if (response == null || response.size() == 0) {
            EslintLanguageServiceClient.Response<Object> response2 = EslintLanguageServiceClient.Response.ok(null);
            if (response2 == null) {
                ESLintBasedLanguageService.$$$reportNull$$$0(12);
            }
            return response2;
        }
        JsonObject jsonObject = element = response.get(0).isJsonObject() ? response.get(0).getAsJsonObject() : null;
        if (element == null) {
            EslintLanguageServiceClient.Response<String> response3 = EslintLanguageServiceClient.Response.error(JavaScriptBundle.message("eslint.inspections.error.unexpected.language.service.response", responseObject.toString()), false);
            if (response3 == null) {
                ESLintBasedLanguageService.$$$reportNull$$$0(13);
            }
            return response3;
        }
        EslintLanguageServiceClient.Response<String> response4 = EslintLanguageServiceClient.Response.ok(JsonUtil.getChildAsString((JsonObject)element, (String)"output"));
        if (response4 == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(14);
        }
        return response4;
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        JSLanguageServiceQueue.ProcessConnector processConnector = this.myProcessConnector;
        if (processConnector == null && NodeTargetRun.shouldEnableRemoteDevelopmentUsingTargetsApi()) {
            processConnector = new JSLanguageServiceQueue.ProcessConnector(){

                @Override
                public void connectToProcessHandler(@NotNull ProcessHandler handler) {
                    if (handler == null) {
                        1.$$$reportNull$$$0(0);
                    }
                }

                @Override
                public void disconnectFromProcessHandler(boolean closeAssociatedConsoleView) {
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$1", "connectToProcessHandler"));
                }
            };
        }
        return new JSLanguageServiceQueueImpl(this.myProject, new Protocol(StringUtil.toLowerCase((String)this.getDebugName()), this.myProject, o -> {}), processConnector, this.myDefaultReporter, new JSLanguageServiceDefaultCacheData());
    }

    @Override
    protected boolean needInitToolWindow() {
        return false;
    }

    @NotNull
    private ExtendedLinterState<TStoredState> getExtendedState() {
        ExtendedLinterState<TStoredState> extendedLinterState = JSLinterConfiguration.getInstance(this.myProject, this.getConfigurationClass()).getExtendedState();
        if (extendedLinterState == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(15);
        }
        return extendedLinterState;
    }

    @Nullable
    private String findUploadRoot(@NotNull String path2) {
        if (path2 == null) {
            ESLintBasedLanguageService.$$$reportNull$$$0(16);
        }
        return (String)ReadAction.compute(() -> {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path2);
            if (file == null) {
                JSLanguageServiceQueue.Holder.LOGGER.info("Cannot find virtual file by " + path2);
                return null;
            }
            if (!file.isDirectory() && (file = file.getParent()) == null) {
                JSLanguageServiceQueue.Holder.LOGGER.error("file.getParent() is null for " + path2);
                return null;
            }
            VirtualFile root = ProjectFileIndex.getInstance((Project)this.myProject).getContentRootForFile(file, false);
            if (root == null) {
                JSLanguageServiceQueue.Holder.LOGGER.info("Cannot find content root for " + file);
                return file.getPath();
            }
            return root.getPath();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 9, 11, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocolState";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storedState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodePackage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightProcessor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processFixFileResponse";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fixFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillInitialProtocolState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processFixFileResponse";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findUploadRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 9, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    private static final class GetErrorsCommand
    extends BaseCommand {
        private GetErrorsCommand(String fileName, String configPath, String content, String extraOptions, String ignoreFilePath, String fileKind, boolean flatConfig) {
            super(fileName, configPath, content, extraOptions, ignoreFilePath, fileKind, flatConfig);
        }

        @Override
        @NotNull
        public String getCommand() {
            return "GetErrors";
        }
    }

    private static class FixErrorsCommand
    extends BaseCommand {
        FixErrorsCommand(String fileName, String configPath, String content, String extraOptions, String ignoreFilePath, String fileKind, boolean flatConfig) {
            super(fileName, configPath, content, extraOptions, ignoreFilePath, fileKind, flatConfig);
        }

        @Override
        @NotNull
        public String getCommand() {
            return "FixErrors";
        }
    }

    public class Protocol
    extends JSLanguageServiceNodeStdProtocolBase {
        public Protocol(@NotNull String serviceName, @NotNull Project project, Consumer<?> readyConsumer) {
            if (project == null) {
                Protocol.$$$reportNull$$$0(0);
            }
            if (readyConsumer == null) {
                Protocol.$$$reportNull$$$0(1);
            }
            super(serviceName, project, readyConsumer);
        }

        @Override
        protected String getWorkingDirectory() {
            return JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(ESLintBasedLanguageService.this.myWorkingDirectory);
        }

        public void dispose() {
        }

        @Override
        protected void addNodeProcessAdditionalArguments(@NotNull NodeTargetRun targetRun) {
            Path additionalRootDirectory;
            if (targetRun == null) {
                Protocol.$$$reportNull$$$0(2);
            }
            super.addNodeProcessAdditionalArguments(targetRun);
            if (this.myServiceName != null) {
                JSLanguageServiceUtil.addNodeProcessArgumentsFromRegistry(targetRun.getCommandLineBuilder(), this.myServiceName, () -> Registry.stringValue((String)"eslint.service.node.arguments"));
            }
            JSLanguageServiceUtil.addNodePathFromRegistry(targetRun.getCommandLineBuilder(), () -> Registry.stringValue((String)"eslint.service.node.path"));
            ESLintLanguageServiceInitialState initialState = this.createState();
            targetRun.path(PathUtil.getParentPath((String)initialState.pluginPath.getPath()));
            String uploadRootPath = ESLintBasedLanguageService.this.myNodePackage instanceof YarnPnpNodePackage ? ESLintBasedLanguageService.this.findUploadRoot(Objects.requireNonNull(initialState.packageJsonPath).getPath()) : ESLintBasedLanguageService.this.findUploadRoot(ESLintBasedLanguageService.this.myNodePackage.getSystemIndependentPath());
            if (uploadRootPath != null) {
                targetRun.path(uploadRootPath);
            }
            if ((additionalRootDirectory = LocalFilePath.getNioPath(initialState.additionalRootDirectory)) != null && additionalRootDirectory.isAbsolute() && Files.isDirectory(additionalRootDirectory, new LinkOption[0])) {
                targetRun.path(additionalRootDirectory.toString());
            }
        }

        @NotNull
        private File getEslintPluginDir() {
            return new File(JSLanguageServiceUtil.getPluginDirectory(this.getClass(), "languageService"), "eslint");
        }

        @Override
        protected ESLintLanguageServiceInitialState createState() {
            ESLintLanguageServiceInitialState protocolState = new ESLintLanguageServiceInitialState();
            ESLintBasedLanguageService.this.fillInitialProtocolState(protocolState, (JSNpmLinterState)ESLintBasedLanguageService.this.getExtendedState().getState());
            protocolState.pluginName = "ESLint";
            File service2 = new File(this.getEslintPluginDir(), "bin/eslint-plugin-provider.js");
            if (!service2.exists()) {
                JSLanguageServiceQueue.Holder.LOGGER.info("ESLint plugin not found");
            }
            protocolState.pluginPath = LocalFilePath.create(service2.getAbsolutePath());
            return protocolState;
        }

        @Override
        @NotNull
        protected NodeCommandLineConfigurator.Options getNodeCommandLineConfiguratorOptions(@NotNull Project project) {
            if (project == null) {
                Protocol.$$$reportNull$$$0(3);
            }
            NodeCommandLineConfigurator.Options options = NodeCommandLineConfigurator.defaultOptions(project).withRequiredNodePackage(ESLintBasedLanguageService.this.myNodePackage);
            if (options == null) {
                Protocol.$$$reportNull$$$0(4);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readyConsumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRun";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$Protocol";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$Protocol";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeCommandLineConfiguratorOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addNodeProcessAdditionalArguments";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getNodeCommandLineConfiguratorOptions";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class BaseCommand
    implements JSLanguageServiceCommand,
    JSLanguageServiceSimpleCommand,
    JSLanguageServiceObject {
        public String fileKind;
        public LocalFilePath fileName;
        public LocalFilePath configPath;
        public String content;
        public String extraOptions;
        public LocalFilePath ignoreFilePath;
        public boolean flatConfig;

        BaseCommand(String fileName, String configPath, String content, String extraOptions, String ignoreFilePath, String fileKind, boolean flatConfig) {
            this.fileName = LocalFilePath.create(fileName);
            this.configPath = LocalFilePath.create(configPath);
            this.content = content;
            this.extraOptions = extraOptions;
            this.ignoreFilePath = LocalFilePath.create(ignoreFilePath);
            this.fileKind = fileKind;
            this.flatConfig = flatConfig;
        }

        @Override
        @NotNull
        public JSLanguageServiceObject toSerializableObject() {
            BaseCommand baseCommand = this;
            if (baseCommand == null) {
                BaseCommand.$$$reportNull$$$0(0);
            }
            return baseCommand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$BaseCommand", "toSerializableObject"));
        }
    }
}

