/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.importer;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.importer.EslintConfigWrapper;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintImportCodeStyleEditorNotificationProvider
implements EditorNotificationProvider {
    private static final String NOTIFICATION_DISMISSED_PROPERTY = "eslint.code.style.apply.dismiss";
    @NotNull
    private final Project myProject;

    public EslintImportCodeStyleEditorNotificationProvider(@NotNull Project project) {
        if (project == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    private boolean isNotificationDismissed(@NotNull VirtualFile file) {
        if (file == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(NOTIFICATION_DISMISSED_PROPERTY) || !EslintUtil.isFlatOrLegacyConfigFile(file) && !PackageJsonUtil.isPackageJsonFile(file);
    }

    private void dismissNotification() {
        PropertiesComponent.getInstance((Project)this.myProject).setValue(NOTIFICATION_DISMISSED_PROPERTY, true);
        EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        PsiFile psiFile;
        if (project == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            EslintImportCodeStyleEditorNotificationProvider.$$$reportNull$$$0(3);
        }
        if (!((psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof JsonFile)) {
            return null;
        }
        if (!psiFile.isWritable() || JSProjectUtil.isInLibrary(psiFile) || JSLibraryUtil.isProbableLibraryFile(file)) {
            return null;
        }
        if (this.isNotificationDismissed(file)) {
            return null;
        }
        EslintConfigWrapper rulesWrapper = EslintConfigWrapper.getForFile(psiFile);
        if (rulesWrapper == null || !rulesWrapper.hasDataToImport(project)) {
            return null;
        }
        return fileEditor -> {
            if (!(fileEditor instanceof TextEditor)) {
                return null;
            }
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, null, EditorColors.GUTTER_BACKGROUND, EditorNotificationPanel.Status.Info);
            panel2.setText(JavaScriptBundle.message("eslint.code.style.apply.message", new Object[0]));
            panel2.createActionLabel(JavaScriptBundle.message("eslint.code.style.apply.text", new Object[0]), "EslintImportCodeStyle", false);
            panel2.createActionLabel(JavaScriptBundle.message("eslint.code.style.dismiss.text", new Object[0]), () -> this.dismissNotification(), false);
            return panel2;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintImportCodeStyleEditorNotificationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotificationDismissed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNotificationData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

