/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.importer;

import com.intellij.application.options.CodeStyle;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.formatter.JSCodeStyleUtil;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.importer.EslintRuleMapper;
import com.intellij.lang.javascript.linter.eslint.importer.EslintRuleMappersFactory;
import com.intellij.lang.javascript.linter.eslint.importer.EslintSettingsConverter;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EslintConfigWrapper {
    @NotNull
    private static final ClearableLazyValue<Map<String, EslintRuleMapper>> RULES = ExtensionPointUtil.dropLazyValueOnChange((ClearableLazyValue)ClearableLazyValue.create(() -> EslintConfigWrapper.createRules()), EslintRuleMappersFactory.EP_NAME, null);
    private static final Key<ParameterizedCachedValue<EslintConfigWrapper, PsiFile>> CACHE_KEY = Key.create((String)"Eslint.Import.Code.Style.cache.key");
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull EslintSettingsConverter> myConfigRules;

    private EslintConfigWrapper(@NotNull JsonObject config) {
        if (config == null) {
            EslintConfigWrapper.$$$reportNull$$$0(0);
        }
        this.myConfigRules = EslintConfigWrapper.parseConfig(config);
    }

    @Nullable
    public static EslintConfigWrapper getForFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            EslintConfigWrapper.$$$reportNull$$$0(1);
        }
        if (!psiFile.isPhysical()) {
            return EslintConfigWrapper.createImporter(psiFile);
        }
        return (EslintConfigWrapper)CachedValuesManager.getManager((Project)psiFile.getProject()).getParameterizedCachedValue((UserDataHolder)psiFile, CACHE_KEY, param -> CachedValueProvider.Result.create((Object)EslintConfigWrapper.createImporter(param), (Object[])new Object[]{param}), false, (Object)psiFile);
    }

    @Nullable
    private static EslintConfigWrapper createImporter(@NotNull PsiFile psiFile) {
        JsonObject rootObject;
        if (psiFile == null) {
            EslintConfigWrapper.$$$reportNull$$$0(2);
        }
        return (rootObject = EslintUtil.getConfigRootObject(psiFile)) != null ? new EslintConfigWrapper(rootObject) : null;
    }

    public boolean hasDataToImport(@NotNull Project project) {
        if (project == null) {
            EslintConfigWrapper.$$$reportNull$$$0(3);
        }
        CodeStyleSettings settings2 = CodeStyle.getSettings((Project)project);
        if (this.myConfigRules.isEmpty()) {
            return false;
        }
        return this.myConfigRules.values().stream().anyMatch(convertor -> !convertor.inSync(settings2));
    }

    @NotNull
    public Set<String> modifySettings(@NotNull Project project) {
        if (project == null) {
            EslintConfigWrapper.$$$reportNull$$$0(4);
        }
        HashSet<String> modifiedRules = new HashSet<String>();
        JSCodeStyleUtil.updateProjectCodeStyle(project, (Consumer<? super CodeStyleSettings>)((Consumer)settings2 -> WriteAction.run(() -> {
            for (Map.Entry<String, EslintSettingsConverter> entry : this.myConfigRules.entrySet()) {
                EslintSettingsConverter convertor = entry.getValue();
                if (convertor.inSync((CodeStyleSettings)settings2)) continue;
                convertor.apply((CodeStyleSettings)settings2);
                modifiedRules.add(entry.getKey());
            }
        })));
        HashSet<String> hashSet = modifiedRules;
        if (hashSet == null) {
            EslintConfigWrapper.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    private static @NotNull Map<@NotNull String, @NotNull EslintSettingsConverter> parseConfig(final @NotNull JsonObject config) {
        JsonProperty property;
        if (config == null) {
            EslintConfigWrapper.$$$reportNull$$$0(6);
        }
        if ((property = config.findProperty("rules")) == null) {
            Map<String, EslintSettingsConverter> map = Collections.emptyMap();
            if (map == null) {
                EslintConfigWrapper.$$$reportNull$$$0(7);
            }
            return map;
        }
        JsonObject rulesObject = (JsonObject)ObjectUtils.tryCast((Object)property.getValue(), JsonObject.class);
        if (rulesObject == null) {
            Map<String, EslintSettingsConverter> map = Collections.emptyMap();
            if (map == null) {
                EslintConfigWrapper.$$$reportNull$$$0(8);
            }
            return map;
        }
        final Set plugins = StreamEx.ofNullable((Object)config.findProperty("plugins")).map(JsonProperty::getValue).select(JsonArray.class).flatCollection(JsonArray::getValueList).select(JsonStringLiteral.class).map(JsonStringLiteral::getValue).toSet();
        EslintRuleMapper.EslintConfig configWrapper = new EslintRuleMapper.EslintConfig(){

            @Override
            @NotNull
            public JsonObject getConfigRoot() {
                JsonObject jsonObject = config;
                if (jsonObject == null) {
                    1.$$$reportNull$$$0(0);
                }
                return jsonObject;
            }

            @Override
            @NotNull
            public Set<String> getPlugins() {
                Set set = plugins;
                if (set == null) {
                    1.$$$reportNull$$$0(1);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintConfigWrapper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getConfigRoot";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPlugins";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        HashMap<String, EslintSettingsConverter> result2 = new HashMap<String, EslintSettingsConverter>();
        List list2 = rulesObject.getPropertyList();
        for (JsonProperty rule : list2) {
            String name = StringUtil.unquoteString((String)rule.getName());
            if (StringUtil.isEmptyOrSpaces((String)name) || rule.getValue() == null) continue;
            result2.put(name, EslintConfigWrapper.getSettingsConvertor(name, rule, configWrapper));
        }
        HashMap<String, EslintSettingsConverter> hashMap = result2;
        if (hashMap == null) {
            EslintConfigWrapper.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    @NotNull
    private static EslintSettingsConverter getSettingsConvertor(@NotNull String name, @NotNull JsonProperty rule, @NotNull EslintRuleMapper.EslintConfig configWrapper) {
        if (name == null) {
            EslintConfigWrapper.$$$reportNull$$$0(10);
        }
        if (rule == null) {
            EslintConfigWrapper.$$$reportNull$$$0(11);
        }
        if (configWrapper == null) {
            EslintConfigWrapper.$$$reportNull$$$0(12);
        }
        EslintRuleMapper mapper = (EslintRuleMapper)((Map)RULES.getValue()).get(name);
        JsonValue value = rule.getValue();
        assert (value != null);
        if (mapper == null) {
            EslintSettingsConverter eslintSettingsConverter = EslintSettingsConverter.SKIPPED;
            if (eslintSettingsConverter == null) {
                EslintConfigWrapper.$$$reportNull$$$0(13);
            }
            return eslintSettingsConverter;
        }
        EslintSettingsConverter eslintSettingsConverter = mapper.parseSettings(value, configWrapper);
        if (eslintSettingsConverter == null) {
            EslintConfigWrapper.$$$reportNull$$$0(14);
        }
        return eslintSettingsConverter;
    }

    private static Map<String, EslintRuleMapper> createRules() {
        return EslintRuleMappersFactory.EP_NAME.getExtensionList().stream().flatMap(factory -> factory.createMappers().stream()).collect(Collectors.toMap(EslintRuleMapper::getName, Function.identity()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8, 9, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintConfigWrapper";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintConfigWrapper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "modifySettings";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseConfig";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsConvertor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getForFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createImporter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasDataToImport";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "modifySettings";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseConfig";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsConvertor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8, 9, 13, 14 -> new IllegalStateException(string);
        };
    }
}

