/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.typings;

import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.typings.TypeScriptDefinitionsUtils;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsContributor;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsServiceKt;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsServiceState;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.SemVer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TypeScriptExternalDefinitions", storages={@Storage(value="$CACHE_FILE$", roamingType=RoamingType.DISABLED)})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001$B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\rH\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018J\b\u0010\u0019\u001a\u00020\u0002H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0002H\u0016J\u0010\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020\rJ\u0006\u0010#\u001a\u00020\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsServiceState;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "alarm", "Lcom/intellij/util/Alarm;", "pendingRootsChanged", "Ljava/util/concurrent/atomic/AtomicBoolean;", "usedExternalDefinitions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/util/text/SemVer;", "cacheInstalledDefinition", "", "typingsPackage", "Lcom/intellij/lang/javascript/library/typings/TypeScriptPackageName;", "dispose", "evictInstalledDefinitionFromCache", "packageName", "fireRootsChanged", "getCachedExternalDefinitions", "", "getState", "installForProject", "installTypeDefinitionsPackage", "", "registry", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry;", "loadState", "state", "resolveCachedExternalDefinitionForPackage", "sourcePackage", "scheduleUpdate", "Companion", "intellij.javascript.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nTypeScriptExternalDefinitionsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptExternalDefinitionsService.kt\ncom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,224:1\n152#2,3:225\n1#3:228\n1855#4,2:229\n1238#4,4:232\n403#5:231\n*S KotlinDebug\n*F\n+ 1 TypeScriptExternalDefinitionsService.kt\ncom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService\n*L\n80#1:225,3\n149#1:229,2\n200#1:232,4\n200#1:231\n*E\n"})
public final class TypeScriptExternalDefinitionsService
implements PersistentStateComponent<TypeScriptExternalDefinitionsServiceState>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Alarm alarm;
    @NotNull
    private final ConcurrentHashMap<String, SemVer> usedExternalDefinitions;
    @NotNull
    private final AtomicBoolean pendingRootsChanged;

    public TypeScriptExternalDefinitionsService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.usedExternalDefinitions = new ConcurrentHashMap();
        this.pendingRootsChanged = new AtomicBoolean();
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        Topic<PackageJsonFileManager.PackageJsonChangesListener> topic = PackageJsonFileManager.CHANGES_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"CHANGES_TOPIC");
        connection.subscribe(topic, arg_0 -> TypeScriptExternalDefinitionsService._init_$lambda$0(this, arg_0));
        Topic<JSLibraryManager.JSLibraryManagerChangeListener> topic2 = JSLibraryManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        connection.subscribe(topic2, () -> TypeScriptExternalDefinitionsService._init_$lambda$1(this));
        Registry.get((String)"typescript.external.type.definitions").addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.fireRootsChanged();
            }
        }, (Disposable)this);
    }

    public final void scheduleUpdate() {
        if (!TypeScriptExternalDefinitionsRegistry.Companion.isEnabled()) {
            return;
        }
        if (TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().isDebugEnabled()) {
            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().debug("Scheduling update. Used definitions: " + this.getCachedExternalDefinitions(), new Throwable());
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.installForProject();
        } else {
            this.alarm.cancelAllRequests();
            this.alarm.addRequest(() -> TypeScriptExternalDefinitionsService.scheduleUpdate$lambda$3(this), 3000L);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<TypeScriptPackageName> getCachedExternalDefinitions() {
        Set set;
        if (TypeScriptExternalDefinitionsRegistry.Companion.isEnabled()) {
            void var2_2;
            void $this$mapTo$iv;
            Map map = this.usedExternalDefinitions;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv;
                Map.Entry entry = item$iv = iterator.next();
                Collection collection = destination$iv;
                boolean bl = false;
                collection.add(new TypeScriptPackageName((String)it.getKey(), (SemVer)it.getValue()));
            }
            set = (Set)var2_2;
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @Nullable
    public final TypeScriptPackageName resolveCachedExternalDefinitionForPackage(@NotNull String sourcePackage) {
        TypeScriptPackageName typeScriptPackageName;
        Intrinsics.checkNotNullParameter((Object)sourcePackage, (String)"sourcePackage");
        if (!TypeScriptExternalDefinitionsRegistry.Companion.isEnabled()) {
            return null;
        }
        String packageName = TypeScriptDefinitionsUtils.getTypingsPackageName(sourcePackage);
        SemVer semVer = this.usedExternalDefinitions.get(packageName);
        if (semVer != null) {
            SemVer it = semVer;
            boolean bl = false;
            typeScriptPackageName = new TypeScriptPackageName(packageName, it);
        } else {
            typeScriptPackageName = null;
        }
        return typeScriptPackageName;
    }

    private final void evictInstalledDefinitionFromCache(String packageName) {
        this.usedExternalDefinitions.remove(packageName);
    }

    private final void cacheInstalledDefinition(TypeScriptPackageName typingsPackage) {
        if (!TypeScriptDefinitionsUtils.isTypingsPackage(typingsPackage.getName())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        String string = typingsPackage.getName();
        SemVer semVer = typingsPackage.getVersion();
        Intrinsics.checkNotNull((Object)semVer);
        this.usedExternalDefinitions.put(string, semVer);
    }

    private final void installForProject() {
        if (this.project.isDisposed() || !TypeScriptExternalDefinitionsRegistry.Companion.isEnabled()) {
            return;
        }
        if (TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().isDebugEnabled()) {
            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().debug("Install type definitions for project [" + this.project.getName() + "] started");
        }
        HashSet<String> definitions = new HashSet<String>();
        HashSet<String> changedDefinitions = new HashSet<String>();
        TypeScriptExternalDefinitionsRegistry registry = TypeScriptExternalDefinitionsRegistry.Companion.getInstance();
        for (TypeScriptExternalDefinitionsContributor contributor : TypeScriptExternalDefinitionsContributor.Companion.getEP_NAME().getExtensionList()) {
            for (TypeScriptPackageName typeDefinition : contributor.getTypeDefinitions(this.project)) {
                if (!TypeScriptDefinitionsUtils.isTypingsPackage(typeDefinition.getName()) || typeDefinition.getVersion() == null) {
                    TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().warn("Invalid type definition package contributed: " + typeDefinition);
                    continue;
                }
                if (!definitions.add(typeDefinition.getName())) continue;
                if (registry.ensureExternalDefinitionsInstalled$intellij_javascript_impl(typeDefinition)) {
                    if (this.usedExternalDefinitions.containsKey(typeDefinition.getName())) continue;
                    changedDefinitions.add(typeDefinition.getName());
                    this.cacheInstalledDefinition(typeDefinition);
                    continue;
                }
                if (!this.installTypeDefinitionsPackage(typeDefinition, registry)) continue;
                if (registry.ensureExternalDefinitionsInstalled$intellij_javascript_impl(typeDefinition)) {
                    changedDefinitions.add(typeDefinition.getName());
                    this.cacheInstalledDefinition(typeDefinition);
                    continue;
                }
                TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().warn("Installation completed but not succeeded: " + typeDefinition);
            }
        }
        Set set = this.usedExternalDefinitions.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Set removedDefinitions = SetsKt.minus((Set)set, (Iterable)definitions);
        Iterable $this$forEach$iv = removedDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            this.evictInstalledDefinitionFromCache(p0);
        }
        if (!((Collection)changedDefinitions).isEmpty() || !((Collection)removedDefinitions).isEmpty()) {
            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().info("Type definition roots changed: project [" + this.project.getName() + "], added/updated " + changedDefinitions + ", removed: " + removedDefinitions);
            this.fireRootsChanged();
        }
        if (TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().isDebugEnabled()) {
            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().debug("Install type definitions for project [" + this.project.getName() + "] completed");
        }
    }

    private final void fireRootsChanged() {
        if (this.pendingRootsChanged.compareAndSet(false, true)) {
            ReadAction.run(() -> TypeScriptExternalDefinitionsService.fireRootsChanged$lambda$7(this));
        }
    }

    private final boolean installTypeDefinitionsPackage(TypeScriptPackageName typingsPackage, TypeScriptExternalDefinitionsRegistry registry) {
        try {
            boolean installed;
            if (TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().isDebugEnabled()) {
                TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().debug("Begin typings package installation: " + typingsPackage);
            }
            boolean bl = installed = registry.installPackage(typingsPackage, this.project, null).get(2L, TimeUnit.MINUTES) != null;
            if (!installed) {
                TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().warn("Package " + typingsPackage + " is not installed");
            }
            return installed;
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().warn("Unable to install package " + typingsPackage, (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TypeScriptExternalDefinitionsServiceState getState() {
        void $this$mapValuesTo$iv;
        Map map = this.usedExternalDefinitions;
        Map destination$iv = new HashMap();
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            void it$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map2 = destination$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            Object k = it$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            String string = ((SemVer)it.getValue()).getParsedVersion();
            map3.put(k, string);
        }
        HashMap packages = (HashMap)destination$iv;
        return packages.isEmpty() ? TypeScriptExternalDefinitionsServiceKt.access$getEMPTY_STATE$p() : new TypeScriptExternalDefinitionsServiceState(packages);
    }

    public void loadState(@NotNull TypeScriptExternalDefinitionsServiceState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        for (Map.Entry<String, String> entry : state.getPackages().entrySet()) {
            if (!(((CharSequence)entry.getValue()).length() > 0)) continue;
            this.cacheInstalledDefinition(TypeScriptPackageName.Companion.from(entry.getKey(), entry.getValue()));
        }
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(TypeScriptExternalDefinitionsService this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.scheduleUpdate();
    }

    private static final void _init_$lambda$1(TypeScriptExternalDefinitionsService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scheduleUpdate();
    }

    private static final void scheduleUpdate$lambda$3$lambda$2(TypeScriptExternalDefinitionsService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.installForProject();
    }

    private static final void scheduleUpdate$lambda$3(TypeScriptExternalDefinitionsService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this$0, () -> TypeScriptExternalDefinitionsService.scheduleUpdate$lambda$3$lambda$2(this$0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void fireRootsChanged$lambda$7$lambda$6(TypeScriptExternalDefinitionsService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this$0){
                final /* synthetic */ TypeScriptExternalDefinitionsService this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ProjectRootManagerEx.getInstanceEx((Project)TypeScriptExternalDefinitionsService.access$getProject$p(this.this$0)).makeRootsChange(EmptyRunnable.getInstance(), RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
                }
            }));
        }
        finally {
            this$0.pendingRootsChanged.set(false);
        }
    }

    private static final void fireRootsChanged$lambda$7(TypeScriptExternalDefinitionsService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.project.isDisposed()) {
            return;
        }
        DumbService.Companion.getInstance(this$0.project).runWhenSmart(() -> TypeScriptExternalDefinitionsService.fireRootsChanged$lambda$7$lambda$6(this$0));
    }

    @JvmStatic
    @NotNull
    public static final TypeScriptExternalDefinitionsService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Project access$getProject$p(TypeScriptExternalDefinitionsService $this) {
        return $this.project;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService$Companion;", "", "()V", "getInstance", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nTypeScriptExternalDefinitionsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptExternalDefinitionsService.kt\ncom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,224:1\n31#2,2:225\n*S KotlinDebug\n*F\n+ 1 TypeScriptExternalDefinitionsService.kt\ncom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService$Companion\n*L\n214#1:225,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TypeScriptExternalDefinitionsService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<TypeScriptExternalDefinitionsService> serviceClass$iv = TypeScriptExternalDefinitionsService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (TypeScriptExternalDefinitionsService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

