/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.typings;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.library.download.TypeScriptRelatedPackagesCollector;
import com.intellij.lang.javascript.library.typings.TypeScriptDefinitionsUtils;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.lang.javascript.modules.PackageInstaller;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@com.intellij.openapi.components.State(name="TypeScriptExternalDefinitionsRegistry", storages={@Storage(value="$CACHE_FILE$", roamingType=RoamingType.DISABLED)})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 12\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003123B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\u0015\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020\nJ\u001a\u0010!\u001a\u0004\u0018\u00010\u00122\b\u0010#\u001a\u0004\u0018\u00010\u00122\u0006\u0010$\u001a\u00020\u000fJ\u001d\u0010%\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010&\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b'J\b\u0010(\u001a\u00020\u0002H\u0016J(\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0*2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010+\u001a\u0004\u0018\u00010,J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0002H\u0016J\u0018\u0010/\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\n2\u0006\u00100\u001a\u00020\u0012H\u0007R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry$State;", "Lcom/intellij/openapi/Disposable;", "()V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "installingPackages", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/lang/javascript/library/typings/TypeScriptPackageName;", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleDependencies", "", "", "resolveDefinitionsVersionCache", "Ljava/util/Optional;", "Lcom/intellij/util/text/SemVer;", "areExternalDefinitionsInstalling", "", "typingsPackage", "collectModuleDependencies", "", "createInstallationDirectory", "Ljava/io/File;", "createInterpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "project", "Lcom/intellij/openapi/project/Project;", "dispose", "ensureExternalDefinitionsInstalled", "ensureExternalDefinitionsInstalled$intellij_javascript_impl", "findMatchedTypingsVersion", "sourcePackage", "sourcePackageVersion", "typingsPackageName", "getCachedModuleDependencies", "packageName", "getCachedModuleDependencies$intellij_javascript_impl", "getState", "installPackage", "Ljava/util/concurrent/Future;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadState", "state", "setTypingsVersionForPackage", "version", "Companion", "ModuleDependenciesState", "State", "intellij.javascript.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nTypeScriptExternalDefinitionsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptExternalDefinitionsRegistry.kt\ncom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n46#2,5:330\n46#2,5:336\n46#2,5:341\n46#2,5:346\n46#2,5:351\n46#2,5:356\n11#2:367\n1#3:335\n125#4:361\n152#4,3:362\n1855#5,2:365\n*S KotlinDebug\n*F\n+ 1 TypeScriptExternalDefinitionsRegistry.kt\ncom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry\n*L\n79#1:330,5\n89#1:336,5\n126#1:341,5\n214#1:346,5\n216#1:351,5\n218#1:356,5\n259#1:367\n238#1:361\n238#1:362,3\n244#1:365,2\n*E\n"})
public final class TypeScriptExternalDefinitionsRegistry
implements PersistentStateComponent<State>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<TypeScriptPackageName, CompletableFuture<VirtualFile>> installingPackages = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<TypeScriptPackageName, Set<String>> moduleDependencies = new ConcurrentHashMap();
    @NotNull
    private ConcurrentHashMap<TypeScriptPackageName, Optional<SemVer>> resolveDefinitionsVersionCache = new ConcurrentHashMap();
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String REGISTRY_KEY = "typescript.external.type.definitions";
    @TestOnly
    @Nullable
    private static String testTypingsRootPath;

    public TypeScriptExternalDefinitionsRegistry() {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"TypeScript External Definitions Registry", (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executor = executorService;
    }

    @Nullable
    public final Set<String> getCachedModuleDependencies$intellij_javascript_impl(@NotNull TypeScriptPackageName packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.moduleDependencies.get(packageName);
    }

    private final void collectModuleDependencies(TypeScriptPackageName typingsPackage) {
        Object object;
        VirtualFile nodeModulesDir;
        Logger logger;
        block13: {
            block12: {
                VirtualFile it;
                Object object2;
                block11: {
                    block10: {
                        VirtualFile virtualFile;
                        if (this.getCachedModuleDependencies$intellij_javascript_impl(typingsPackage) != null) {
                            return;
                        }
                        Logger $this$debug_u24default$iv = LOG;
                        Throwable e$iv = null;
                        boolean $i$f$debug = false;
                        if ($this$debug_u24default$iv.isDebugEnabled()) {
                            logger = $this$debug_u24default$iv;
                            boolean bl = false;
                            logger.debug("Collecting dependencies for " + typingsPackage, e$iv);
                        }
                        String string = Companion.getTypingsVersionPath(typingsPackage);
                        if (string == null) {
                            return;
                        }
                        String path2 = string;
                        String[] stringArray = new String[]{path2, "node_modules"};
                        object2 = LocalFileSystem.getInstance().findFileByPath(FileUtil.join((String[])stringArray));
                        if (object2 == null) break block10;
                        it = virtualFile = object2;
                        boolean bl = false;
                        object2 = it.isValid() ? virtualFile : null;
                        if (object2 != null) break block11;
                    }
                    return;
                }
                nodeModulesDir = object2;
                object = nodeModulesDir.findFileByRelativePath(typingsPackage.getName());
                if (object == null) break block12;
                VirtualFile it2 = it = object;
                boolean bl = false;
                object = it2.isValid() ? it : null;
                if (object != null) break block13;
            }
            return;
        }
        VirtualFile moduleDir = object;
        Set<String> packages = new TypeScriptRelatedPackagesCollector(moduleDir, nodeModulesDir).collectFullPackageNames();
        ((Map)this.moduleDependencies).put(typingsPackage, packages);
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Collected dependencies for " + typingsPackage + ": " + packages, e$iv);
        }
    }

    @Nullable
    public final SemVer findMatchedTypingsVersion(@NotNull TypeScriptPackageName sourcePackage) {
        Intrinsics.checkNotNullParameter((Object)sourcePackage, (String)"sourcePackage");
        Optional<SemVer> optional = this.resolveDefinitionsVersionCache.get(sourcePackage);
        if (optional != null) {
            Optional<SemVer> it = optional;
            boolean bl = false;
            return it.orElse(null);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        try {
            String typingsPackageName = TypeScriptDefinitionsUtils.getTypingsPackageName(sourcePackage.getName());
            AvailablePackageVersions availablePackageVersions = NpmRegistryService.getInstance().getCachedOrFetchPackageVersionsFuture(typingsPackageName).get();
            if (availablePackageVersions == null) {
                return null;
            }
            AvailablePackageVersions packageVersions = availablePackageVersions;
            SemVer semVer = sourcePackage.getVersion();
            List<SemVer> list2 = packageVersions.getVersions();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getVersions(...)");
            SemVer semVer2 = TypeScriptDefinitionsUtils.getMatchedVersion(semVer, (Collection<SemVer>)list2);
            if (semVer2 == null) {
                List<SemVer> list3 = packageVersions.getVersions();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"getVersions(...)");
                semVer2 = (SemVer)CollectionsKt.firstOrNull(list3);
            }
            SemVer matchedVersion = semVer2;
            Map map = this.resolveDefinitionsVersionCache;
            Optional<SemVer> optional2 = Optional.ofNullable(matchedVersion);
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"ofNullable(...)");
            Optional<SemVer> optional3 = optional2;
            map.put(sourcePackage, optional3);
            return matchedVersion;
        }
        catch (Exception e) {
            LOG.warn("An error occurred during resolving typings version for " + sourcePackage, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final SemVer findMatchedTypingsVersion(@Nullable SemVer sourcePackageVersion, @NotNull String typingsPackageName) {
        Intrinsics.checkNotNullParameter((Object)typingsPackageName, (String)"typingsPackageName");
        return this.findMatchedTypingsVersion(new TypeScriptPackageName(TypeScriptDefinitionsUtils.getSourcePackageName(typingsPackageName), sourcePackageVersion));
    }

    @NotNull
    public final Future<VirtualFile> installPackage(@NotNull TypeScriptPackageName typingsPackage, @NotNull Project project, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)typingsPackage, (String)"typingsPackage");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        Future failedFuture = completableFuture;
        NodeJsInterpreter interpreter = this.createInterpreter(project);
        if (interpreter == null) {
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Unable to create interpreter for package installation: " + typingsPackage, e$iv);
            }
            return failedFuture;
        }
        File file = this.createInstallationDirectory(typingsPackage);
        if (file == null) {
            return failedFuture;
        }
        File installationDir = file;
        CompletableFuture<VirtualFile> future = new CompletableFuture<VirtualFile>();
        Runnable installRunnable2 = () -> TypeScriptExternalDefinitionsRegistry.installPackage$lambda$6(typingsPackage, installationDir, project, interpreter, indicator, future, this);
        CompletableFuture completableFuture2 = this.installingPackages.computeIfAbsent(typingsPackage, arg_0 -> TypeScriptExternalDefinitionsRegistry.installPackage$lambda$7((Function1)new Function1<TypeScriptPackageName, CompletableFuture<VirtualFile>>(this, installRunnable2, future, typingsPackage){
            final /* synthetic */ TypeScriptExternalDefinitionsRegistry this$0;
            final /* synthetic */ Runnable $installRunnable;
            final /* synthetic */ CompletableFuture<VirtualFile> $future;
            final /* synthetic */ TypeScriptPackageName $typingsPackage;
            {
                this.this$0 = $receiver;
                this.$installRunnable = $installRunnable;
                this.$future = $future;
                this.$typingsPackage = $typingsPackage;
                super(1);
            }

            @NotNull
            public final CompletableFuture<VirtualFile> invoke(@NotNull TypeScriptPackageName it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TypeScriptExternalDefinitionsRegistry.access$getExecutor$p(this.this$0).execute(this.$installRunnable);
                return this.$future.whenComplete((arg_0, arg_1) -> installPackage.2.invoke$lambda$0((Function2)new Function2<VirtualFile, Throwable, Unit>(this.this$0, this.$typingsPackage){
                    final /* synthetic */ TypeScriptExternalDefinitionsRegistry this$0;
                    final /* synthetic */ TypeScriptPackageName $typingsPackage;
                    {
                        this.this$0 = $receiver;
                        this.$typingsPackage = $typingsPackage;
                        super(2);
                    }

                    public final void invoke(@Nullable VirtualFile virtualFile, Throwable throwable) {
                        TypeScriptExternalDefinitionsRegistry.access$getInstallingPackages$p(this.this$0).remove(this.$typingsPackage);
                    }
                }, arg_0, arg_1));
            }

            private static final void invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0, p1);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture2, (String)"computeIfAbsent(...)");
        return completableFuture2;
    }

    public final boolean areExternalDefinitionsInstalling(@NotNull TypeScriptPackageName typingsPackage) {
        Intrinsics.checkNotNullParameter((Object)typingsPackage, (String)"typingsPackage");
        return this.installingPackages.contains(typingsPackage);
    }

    private final File createInstallationDirectory(TypeScriptPackageName typingsPackage) {
        File file;
        String installationPath = Companion.getTypingsVersionPath(typingsPackage);
        if (installationPath == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No path provided: " + typingsPackage);
            }
            return null;
        }
        String[] stringArray = new String[]{installationPath, "node_modules"};
        String string = FileUtil.join((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        String nodeModulesPath = string;
        if (!FileUtil.createDirectory((File)new File(nodeModulesPath))) {
            LOG.warn("Unable to create a node_modules directory for " + typingsPackage + ": " + installationPath);
            return null;
        }
        File it = file = new File(installationPath);
        boolean bl = false;
        return it.exists() ? file : null;
    }

    public final boolean ensureExternalDefinitionsInstalled$intellij_javascript_impl(@NotNull TypeScriptPackageName typingsPackage) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)typingsPackage, (String)"typingsPackage");
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Ensure external definitions installed: " + typingsPackage, e$iv);
        }
        String string = Companion.getExactModuleTypingsPath(typingsPackage);
        if (string == null) {
            return false;
        }
        String path2 = string;
        Logger $this$debug_u24default$iv2 = LOG;
        Throwable e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("Module path: " + path2, e$iv2);
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path2);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile dir = virtualFile;
        Logger $this$debug_u24default$iv3 = LOG;
        Throwable e$iv3 = null;
        boolean $i$f$debug3 = false;
        if ($this$debug_u24default$iv3.isDebugEnabled()) {
            logger = $this$debug_u24default$iv3;
            boolean bl = false;
            logger.debug("Directory exists: " + path2, e$iv3);
        }
        return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(dir, this, typingsPackage){
            final /* synthetic */ VirtualFile $dir;
            final /* synthetic */ TypeScriptExternalDefinitionsRegistry this$0;
            final /* synthetic */ TypeScriptPackageName $typingsPackage;
            {
                this.$dir = $dir;
                this.this$0 = $receiver;
                this.$typingsPackage = $typingsPackage;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                void $this$debug_u24default$iv;
                if (PackageJsonUtil.findChildPackageJsonFile(this.$dir) == null) {
                    return false;
                }
                Logger logger = TypeScriptExternalDefinitionsRegistry.access$getLOG$cp();
                TypeScriptPackageName typeScriptPackageName = this.$typingsPackage;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    void var6_5 = $this$debug_u24default$iv;
                    boolean bl = false;
                    var6_5.debug("Existing module was found: " + typeScriptPackageName, e$iv);
                }
                TypeScriptExternalDefinitionsRegistry.access$collectModuleDependencies(this.this$0, this.$typingsPackage);
                return true;
            }
        }));
    }

    private final NodeJsInterpreter createInterpreter(Project project) {
        return NodeJsInterpreterManager.getInstance(project).getInterpreter();
    }

    @TestOnly
    public final void setTypingsVersionForPackage(@NotNull TypeScriptPackageName sourcePackage, @NotNull SemVer version2) {
        Intrinsics.checkNotNullParameter((Object)sourcePackage, (String)"sourcePackage");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Map map = this.resolveDefinitionsVersionCache;
        Optional<SemVer> optional = Optional.of(version2);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        Optional<SemVer> optional2 = optional;
        map.put(sourcePackage, optional2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public State getState() {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = this.moduleDependencies;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = ((TypeScriptPackageName)it.getKey()).getName();
            Object object = ((TypeScriptPackageName)it.getKey()).getVersion();
            if (object == null || (object = object.getParsedVersion()) == null) {
                object = "";
            }
            Object object2 = object;
            Intrinsics.checkNotNull((Object)object2);
            collection.add(new ModuleDependenciesState(string, (String)object2, (Collection)it.getValue()));
        }
        Collection collection = (List)destination$iv$iv;
        return new State(collection);
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Iterable $this$forEach$iv = state.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleDependenciesState it = (ModuleDependenciesState)element$iv;
            boolean bl = false;
            if (((CharSequence)it.getVersion()).length() == 0) continue;
            this.moduleDependencies.putIfAbsent(TypeScriptPackageName.Companion.from(it.getName(), it.getVersion()), CollectionsKt.toSet((Iterable)it.getDependencies()));
        }
    }

    public void dispose() {
        this.executor.shutdownNow();
    }

    private static final void installPackage$lambda$6(TypeScriptPackageName $typingsPackage, File $installationDir, Project $project, NodeJsInterpreter $interpreter, ProgressIndicator $indicator, CompletableFuture $future, TypeScriptExternalDefinitionsRegistry this$0) {
        Intrinsics.checkNotNullParameter((Object)$typingsPackage, (String)"$typingsPackage");
        Intrinsics.checkNotNullParameter((Object)$installationDir, (String)"$installationDir");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LOG.info("Installing typings package: " + $typingsPackage + "; path=" + $installationDir.getPath());
        try {
            PackageManagementService.Listener listener2 = new PackageManagementService.Listener($typingsPackage, $future, $indicator, $installationDir, this$0){
                final /* synthetic */ TypeScriptPackageName $typingsPackage;
                final /* synthetic */ CompletableFuture<VirtualFile> $future;
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ File $installationDir;
                final /* synthetic */ TypeScriptExternalDefinitionsRegistry this$0;
                {
                    this.$typingsPackage = $typingsPackage;
                    this.$future = $future;
                    this.$indicator = $indicator;
                    this.$installationDir = $installationDir;
                    this.this$0 = $receiver;
                }

                public void operationStarted(@Nullable String packageName) {
                    Logger $this$debug_u24default$iv = TypeScriptExternalDefinitionsRegistry.access$getLOG$cp();
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("Install operation started: " + packageName, e$iv);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationFinished(@Nullable String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                    if (errorDescription != null) {
                        TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().warn("Install operation failed " + this.$typingsPackage + ": " + errorDescription.getMessage());
                        this.$future.complete(null);
                    } else {
                        void $this$debug_u24default$iv;
                        Logger logger = TypeScriptExternalDefinitionsRegistry.access$getLOG$cp();
                        TypeScriptPackageName typeScriptPackageName = this.$typingsPackage;
                        Throwable e$iv = null;
                        boolean $i$f$debug = false;
                        if ($this$debug_u24default$iv.isDebugEnabled()) {
                            void var8_7 = $this$debug_u24default$iv;
                            boolean bl = false;
                            var8_7.debug("Install operation finished: " + typeScriptPackageName, e$iv);
                        }
                        ApplicationManager.getApplication().executeOnPooledThread(() -> installPackage.installRunnable.1.listener.1.operationFinished$lambda$3(this.$indicator, this.$installationDir, this.this$0, this.$typingsPackage, this.$future));
                    }
                }

                private static final void operationFinished$lambda$3(ProgressIndicator $indicator, File $installationDir, TypeScriptExternalDefinitionsRegistry this$0, TypeScriptPackageName $typingsPackage, CompletableFuture $future) {
                    Intrinsics.checkNotNullParameter((Object)$installationDir, (String)"$installationDir");
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$typingsPackage, (String)"$typingsPackage");
                    Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
                    File[] fileArray = $indicator;
                    if ($indicator == null || (fileArray = fileArray.getModalityState()) == null) {
                        fileArray = ModalityState.defaultModalityState();
                    }
                    File[] fileArray2 = fileArray;
                    Intrinsics.checkNotNull((Object)fileArray2);
                    File[] modalityState = fileArray2;
                    fileArray2 = new File[]{$installationDir};
                    JSLibraryUtil.markDirtyAndRefresh(false, true, true, (ModalityState)modalityState, null, fileArray2);
                    Logger $this$debug_u24default$iv = TypeScriptExternalDefinitionsRegistry.access$getLOG$cp();
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("VFS update successful: " + $typingsPackage, e$iv);
                    }
                    if (this$0.ensureExternalDefinitionsInstalled$intellij_javascript_impl($typingsPackage)) {
                        TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().info("Package was installed successfully: " + $typingsPackage);
                        $future.complete(ActionsKt.runReadAction((Function0)((Function0)new Function0<VirtualFile>($installationDir){
                            final /* synthetic */ File $installationDir;
                            {
                                this.$installationDir = $installationDir;
                                super(0);
                            }

                            @Nullable
                            public final VirtualFile invoke() {
                                return LocalFileSystem.getInstance().findFileByIoFile(this.$installationDir);
                            }
                        })));
                    } else {
                        TypeScriptExternalDefinitionsRegistry.access$getLOG$cp().warn("Package was installed but not found in FS: " + $typingsPackage);
                        $future.complete(null);
                    }
                }
            };
            SemVer semVer = $typingsPackage.getVersion();
            new PackageInstaller($project, $interpreter, NodePackageRef.create("npm"), $typingsPackage.getName(), semVer != null ? semVer.getParsedVersion() : null, $installationDir, listener2, "--ignore-scripts").run($indicator);
        }
        catch (Exception e) {
            LOG.warn("Error during installation of " + $typingsPackage, (Throwable)e);
            $future.complete(null);
        }
    }

    private static final CompletableFuture installPackage$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletableFuture)$tmp0.invoke(p0);
    }

    @NotNull
    public static final TypeScriptExternalDefinitionsRegistry getInstance() {
        return Companion.getInstance();
    }

    public static final boolean isEnabled() {
        return Companion.isEnabled();
    }

    @JvmStatic
    @NotNull
    public static final String getTypingsContainerPath(@NotNull TypeScriptPackageName typingsPackage) {
        return Companion.getTypingsContainerPath(typingsPackage);
    }

    @JvmStatic
    @Nullable
    public static final String getTypingsVersionPath(@NotNull TypeScriptPackageName typingsPackage) {
        return Companion.getTypingsVersionPath(typingsPackage);
    }

    @JvmStatic
    @Nullable
    public static final String getExactModuleTypingsPath(@NotNull TypeScriptPackageName typingsPackage) {
        return Companion.getExactModuleTypingsPath(typingsPackage);
    }

    @Nullable
    public static final String getTestTypingsRootPath() {
        return Companion.getTestTypingsRootPath();
    }

    public static final void setTestTypingsRootPath(@Nullable String string) {
        Companion.setTestTypingsRootPath(string);
    }

    public static final /* synthetic */ ExecutorService access$getExecutor$p(TypeScriptExternalDefinitionsRegistry $this) {
        return $this.executor;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getInstallingPackages$p(TypeScriptExternalDefinitionsRegistry $this) {
        return $this.installingPackages;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$collectModuleDependencies(TypeScriptExternalDefinitionsRegistry $this, TypeScriptPackageName typingsPackage) {
        $this.collectModuleDependencies(typingsPackage);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TypeScriptExternalDefinitionsRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\f\u0010\u000fR&\u0010\u0010\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "REGISTRY_KEY", "", "instance", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry;", "getInstance$annotations", "getInstance", "()Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry;", "isEnabled", "", "isEnabled$annotations", "()Z", "testTypingsRootPath", "getTestTypingsRootPath$annotations", "getTestTypingsRootPath", "()Ljava/lang/String;", "setTestTypingsRootPath", "(Ljava/lang/String;)V", "getExactModuleTypingsPath", "typingsPackage", "Lcom/intellij/lang/javascript/library/typings/TypeScriptPackageName;", "getRootDefinitionsDir", "getTypingsContainerPath", "getTypingsScope", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfigService$IntPredicate;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTypingsVersionPath", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nTypeScriptExternalDefinitionsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptExternalDefinitionsRegistry.kt\ncom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,329:1\n1#2:330\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TypeScriptExternalDefinitionsRegistry getInstance() {
            Object object = ApplicationManager.getApplication().getService(TypeScriptExternalDefinitionsRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (TypeScriptExternalDefinitionsRegistry)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public final boolean isEnabled() {
            return Registry.is((String)TypeScriptExternalDefinitionsRegistry.REGISTRY_KEY, (boolean)true);
        }

        @JvmStatic
        public static /* synthetic */ void isEnabled$annotations() {
        }

        @Nullable
        public final String getRootDefinitionsDir() {
            return ApplicationManager.getApplication().isUnitTestMode() ? this.getTestTypingsRootPath() : TypeScriptDefinitionFilesDirectory.getGlobalAutoDownloadTypesDirectoryPath();
        }

        @Nullable
        public final TypeScriptConfigService.IntPredicate getTypingsScope(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (ApplicationManager.getApplication().isUnitTestMode() && this.getTestTypingsRootPath() == null) {
                return null;
            }
            String startWith = FileUtil.toCanonicalPath((String)this.getRootDefinitionsDir());
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            CharSequence charSequence = string;
            Intrinsics.checkNotNull((Object)startWith);
            if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)startWith, (boolean)false, (int)2, null)) {
                return Companion::getTypingsScope$lambda$0;
            }
            return null;
        }

        @JvmStatic
        @NotNull
        public final String getTypingsContainerPath(@NotNull TypeScriptPackageName typingsPackage) {
            Intrinsics.checkNotNullParameter((Object)typingsPackage, (String)"typingsPackage");
            String root = this.getRootDefinitionsDir();
            if (root != null) {
                String[] stringArray = new String[]{root, TypeScriptDefinitionsUtils.getSourcePackageName(typingsPackage.getName())};
                String string = FileUtil.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
                return string;
            }
            throw new RuntimeException("Missing root path");
        }

        @JvmStatic
        @Nullable
        public final String getTypingsVersionPath(@NotNull TypeScriptPackageName typingsPackage) {
            Intrinsics.checkNotNullParameter((Object)typingsPackage, (String)"typingsPackage");
            SemVer semVer = typingsPackage.getVersion();
            if (semVer == null) {
                return null;
            }
            SemVer version2 = semVer;
            String[] stringArray = new String[]{this.getTypingsContainerPath(typingsPackage), version2.getParsedVersion()};
            return FileUtil.join((String[])stringArray);
        }

        @JvmStatic
        @Nullable
        public final String getExactModuleTypingsPath(@NotNull TypeScriptPackageName typingsPackage) {
            String string;
            Intrinsics.checkNotNullParameter((Object)typingsPackage, (String)"typingsPackage");
            String string2 = this.getTypingsVersionPath(typingsPackage);
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                String[] stringArray = new String[]{it, "node_modules", typingsPackage.getName()};
                string = FileUtil.join((String[])stringArray);
            } else {
                string = null;
            }
            return string;
        }

        @Nullable
        public final String getTestTypingsRootPath() {
            return testTypingsRootPath;
        }

        public final void setTestTypingsRootPath(@Nullable String string) {
            testTypingsRootPath = string;
        }

        @JvmStatic
        public static /* synthetic */ void getTestTypingsRootPath$annotations() {
        }

        private static final boolean getTypingsScope$lambda$0(int it) {
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Tag(value="module")
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B)\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J-\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry$ModuleDependenciesState;", "", "name", "", "version", "dependencies", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Collection;)V", "getDependencies", "()Ljava/util/Collection;", "setDependencies", "(Ljava/util/Collection;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getVersion", "setVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.javascript.impl"})
    public static final class ModuleDependenciesState {
        @Tag(value="name")
        @NotNull
        private String name;
        @Tag(value="version")
        @NotNull
        private String version;
        @XCollection(propertyElementName="dependencies", elementName="dependency")
        @NotNull
        private Collection<String> dependencies;

        public ModuleDependenciesState(@NotNull String name, @NotNull String version2, @NotNull Collection<String> dependencies) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            this.name = name;
            this.version = version2;
            this.dependencies = dependencies;
        }

        public /* synthetic */ ModuleDependenciesState(String string, String string2, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                collection = new LinkedHashSet();
            }
            this(string, string2, collection);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.version = string;
        }

        @NotNull
        public final Collection<String> getDependencies() {
            return this.dependencies;
        }

        public final void setDependencies(@NotNull Collection<String> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
            this.dependencies = collection;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.version;
        }

        @NotNull
        public final Collection<String> component3() {
            return this.dependencies;
        }

        @NotNull
        public final ModuleDependenciesState copy(@NotNull String name, @NotNull String version2, @NotNull Collection<String> dependencies) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            return new ModuleDependenciesState(name, version2, dependencies);
        }

        public static /* synthetic */ ModuleDependenciesState copy$default(ModuleDependenciesState moduleDependenciesState, String string, String string2, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                string = moduleDependenciesState.name;
            }
            if ((n & 2) != 0) {
                string2 = moduleDependenciesState.version;
            }
            if ((n & 4) != 0) {
                collection = moduleDependenciesState.dependencies;
            }
            return moduleDependenciesState.copy(string, string2, collection);
        }

        @NotNull
        public String toString() {
            return "ModuleDependenciesState(name=" + this.name + ", version=" + this.version + ", dependencies=" + this.dependencies + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.version.hashCode();
            result2 = result2 * 31 + ((Object)this.dependencies).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleDependenciesState)) {
                return false;
            }
            ModuleDependenciesState moduleDependenciesState = (ModuleDependenciesState)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)moduleDependenciesState.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)moduleDependenciesState.version)) {
                return false;
            }
            return Intrinsics.areEqual(this.dependencies, moduleDependenciesState.dependencies);
        }

        public ModuleDependenciesState() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R$\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry$State;", "", "dependencies", "", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry$ModuleDependenciesState;", "(Ljava/util/Collection;)V", "getDependencies", "()Ljava/util/Collection;", "setDependencies", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.javascript.impl"})
    public static final class State {
        @XCollection(propertyElementName="modules")
        @NotNull
        private Collection<ModuleDependenciesState> dependencies;

        public State(@NotNull Collection<ModuleDependenciesState> dependencies) {
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            this.dependencies = dependencies;
        }

        public /* synthetic */ State(Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                collection = new ArrayList();
            }
            this(collection);
        }

        @NotNull
        public final Collection<ModuleDependenciesState> getDependencies() {
            return this.dependencies;
        }

        public final void setDependencies(@NotNull Collection<ModuleDependenciesState> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
            this.dependencies = collection;
        }

        @NotNull
        public final Collection<ModuleDependenciesState> component1() {
            return this.dependencies;
        }

        @NotNull
        public final State copy(@NotNull Collection<ModuleDependenciesState> dependencies) {
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            return new State(dependencies);
        }

        public static /* synthetic */ State copy$default(State state, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                collection = state.dependencies;
            }
            return state.copy(collection);
        }

        @NotNull
        public String toString() {
            return "State(dependencies=" + this.dependencies + ")";
        }

        public int hashCode() {
            return ((Object)this.dependencies).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            return Intrinsics.areEqual(this.dependencies, state.dependencies);
        }

        public State() {
            this(null, 1, null);
        }
    }
}

