/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSFileNameMismatchIntentionBase
extends JavaScriptIntention {
    @Nullable
    protected String myName = null;
    @Nullable
    protected String myFileName = null;
    @Nullable
    protected String myEntityDesc = null;
    @Nullable
    protected String myEntityName = null;

    @Nullable
    static JSQualifiedNamedElement findNamedElement(@NotNull PsiElement element) {
        if (element == null) {
            JSFileNameMismatchIntentionBase.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (PsiUtilCore.getElementType((PsiElement)element) != JSTokenTypes.IDENTIFIER) {
            return null;
        }
        PsiElement parent = element.getParent();
        return (parent instanceof JSClass || parent instanceof JSFunctionDeclaration || parent instanceof JSVariable) && ((JSQualifiedNamedElement)parent).getNameIdentifier() == element ? (JSQualifiedNamedElement)parent : null;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        JSQualifiedNamedElement jsElement2;
        if (project == null) {
            JSFileNameMismatchIntentionBase.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSFileNameMismatchIntentionBase.$$$reportNull$$$0(2);
        }
        if (!JSFileNameMismatchIntentionBase.isTopLevelDeclaration((PsiElement)(jsElement2 = JSFileNameMismatchIntentionBase.findNamedElement(element))) || JSNameSuggestionsUtil.matchesFileNameByCodeStyle(jsElement2)) {
            return false;
        }
        this.myName = jsElement2.getName();
        if (this.myName == null) {
            return false;
        }
        PsiFile file = jsElement2.getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        String withoutExtension = JSNameSuggestionsUtil.fileNameFromElementName(jsElement2, this.myName);
        if (withoutExtension == null) {
            return false;
        }
        this.myFileName = withoutExtension + "." + virtualFile.getExtension();
        JSNamedElementPresenter presenter = new JSNamedElementPresenter((PsiElement)jsElement2);
        this.myEntityDesc = presenter.describeWithShortName();
        this.myEntityName = presenter.describeElementKind();
        return true;
    }

    @Contract(value="null -> false")
    private static boolean isTopLevelDeclaration(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSVarStatement) {
            parent = parent.getParent();
        }
        if (parent instanceof JSFile) {
            return true;
        }
        return parent instanceof ES6ExportDefaultAssignment && parent.getParent() instanceof JSFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/intentions/JSFileNameMismatchIntentionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findNamedElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

