/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSConvertLoopsUtils;
import com.intellij.lang.javascript.inspections.JSReplaceForEachWithForOfIntention;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSVariableDeclaringScope;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertMapToForOfIntention
extends JavaScriptIntention {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ES6ConvertMapToForOfIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ES6ConvertMapToForOfIntention.$$$reportNull$$$0(1);
        }
        return super.isAvailable(project, editor, element) && DialectDetector.hasFeature(element, JSLanguageFeature.FOR_OF) && ES6ConvertMapToForOfIntention.isAvailable(element);
    }

    private static boolean isAvailable(@NotNull PsiElement element) {
        JSCallExpression callExpression;
        if (element == null) {
            ES6ConvertMapToForOfIntention.$$$reportNull$$$0(2);
        }
        if (!JSConvertLoopsUtils.isMapCall(callExpression = JSReplaceForEachWithForOfIntention.findCallExpression(element))) {
            return false;
        }
        JSFunction function2 = JSConvertLoopsUtils.getFunction(callExpression);
        if (function2 == null) {
            return false;
        }
        if (!ES6ConvertMapToForOfIntention.hasOnlySupportedParameters(function2, callExpression, 1)) {
            return false;
        }
        JSVarStatement varStatement = ES6ConvertMapToForOfIntention.findVarDeclarationStatement(callExpression);
        if (varStatement == null) {
            return false;
        }
        JSBlockStatement functionBody = function2.getBlock();
        return functionBody == null || JSConvertLoopsUtils.getReturnStatements(functionBody).size() <= 1;
    }

    public static boolean hasOnlySupportedParameters(@NotNull JSFunction function2, @NotNull JSCallExpression callExpression, int maxArgs) {
        JSParameterListElement[] parameters;
        if (function2 == null) {
            ES6ConvertMapToForOfIntention.$$$reportNull$$$0(3);
        }
        if (callExpression == null) {
            ES6ConvertMapToForOfIntention.$$$reportNull$$$0(4);
        }
        if ((parameters = function2.getParameters()).length > maxArgs) {
            return false;
        }
        for (JSParameterListElement parameter : parameters) {
            boolean calledWithReference = JSConvertLoopsUtils.isCalledWithFunctionReference(callExpression);
            if (parameter.isRest()) {
                return false;
            }
            if (parameter.getInitializerOrStub() != null && !calledWithReference) {
                return false;
            }
            if (!(parameter instanceof JSDestructuringParameter) || !calledWithReference) continue;
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSCallExpression callExpression;
        if (project == null) {
            ES6ConvertMapToForOfIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            ES6ConvertMapToForOfIntention.$$$reportNull$$$0(6);
        }
        if ((callExpression = JSReplaceForEachWithForOfIntention.findCallExpression(element)) == null) {
            return;
        }
        JSVarStatement varStatement = ES6ConvertMapToForOfIntention.findVarDeclarationStatement(callExpression);
        if (varStatement == null) {
            return;
        }
        JSFunction function2 = JSConvertLoopsUtils.getFunction(callExpression);
        if (function2 == null) {
            return;
        }
        JSConvertLoopsUtils.replaceMapCallWithForInStatement(varStatement, callExpression, function2, JSConvertLoopsUtils.LoopType.FOR_OF);
    }

    @Nullable
    private static JSVarStatement findVarDeclarationStatement(@Nullable JSCallExpression callExpression) {
        PsiElement parent = JSUtils.getParentSkipParentheses((PsiElement)callExpression);
        if (!(parent instanceof JSVariable)) {
            return null;
        }
        if (!((parent = parent.getParent()) instanceof JSVarStatement)) {
            return null;
        }
        JSVarStatement varStatement = (JSVarStatement)parent;
        if (varStatement.getParent() instanceof JSVariableDeclaringScope) {
            return null;
        }
        return varStatement.getVariables().length != 1 ? null : varStatement;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.convert.map.to.for.of.intention.family", new Object[0]);
        if (string == null) {
            ES6ConvertMapToForOfIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    @IntentionName
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ES6ConvertMapToForOfIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/ES6ConvertMapToForOfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/ES6ConvertMapToForOfIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlySupportedParameters";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

