/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.modules.JSImportAllQuickFix;
import com.intellij.lang.javascript.modules.JSImportModuleFix;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.JSImportReferenceQuickFixProviderBase;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.lang.javascript.modules.imports.JSImportCandidateWithExecutor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.javascript.validation.JSUnresolvedReferenceErrorUpdater;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptFixesReferenceErrorUpdater
implements JSUnresolvedReferenceErrorUpdater {
    @Override
    public void updateError(@NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info2, @NotNull JSReferenceExpression node, ResolveResult @NotNull [] results, boolean inTypeContext) {
        if (info2 == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(0);
        }
        if (node == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(1);
        }
        if (results == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(2);
        }
        if (!DialectDetector.isTypeScript((PsiElement)node)) {
            return;
        }
        if (TypeScriptFixesReferenceErrorUpdater.fixNullabilityError(info2, node, results, inTypeContext)) {
            return;
        }
        if (this.fixDistinctError(info2, node, results)) {
            return;
        }
        if (node.getQualifier() == null && results.length == 0 && this.isAcceptableImportContext((PsiElement)node)) {
            info2.addAll(TypeScriptFixesReferenceErrorUpdater.createFixes(node.getReferenceName(), (PsiElement)node, true));
        }
    }

    @Override
    public void updateError(@NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info2, @NotNull JSXmlLiteralExpression node) {
        if (info2 == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(3);
        }
        if (node == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(4);
        }
        if (!DialectDetector.isTypeScript((PsiElement)node) || !this.isAcceptableImportContext((PsiElement)node)) {
            return;
        }
        info2.addAll(TypeScriptFixesReferenceErrorUpdater.createFixes(node.getName(), (PsiElement)node, true));
    }

    protected boolean isAcceptableImportContext(@NotNull PsiElement node) {
        if (node == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(5);
        }
        if (node.getContainingFile() instanceof JSFile) {
            return true;
        }
        JSElement scope2 = ES6PsiUtil.getExportScope(node);
        return scope2 != null;
    }

    private boolean fixDistinctError(@NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info2, @NotNull JSReferenceExpression node, ResolveResult @NotNull [] results) {
        if (info2 == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(6);
        }
        if (node == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(7);
        }
        if (results == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(8);
        }
        if (results.length != 1) {
            return false;
        }
        JSResolveResult result2 = (JSResolveResult)ObjectUtils.tryCast((Object)results[0], JSResolveResult.class);
        if (result2 == null) {
            return false;
        }
        JSResolveResult.ProblemKind problemKind = result2.getResolveProblemKind();
        PsiElement element = result2.getElement();
        if (problemKind == JSResolveResult.ProblemKind.TS_NEED_TO_BE_INCLUDED_TO_CONFIG && element != null) {
            info2.addAll(JSFixFactory.getInstance().typeScriptConfigFixes(node, element));
            return true;
        }
        if (TypeScriptFixesReferenceErrorUpdater.isAcceptableResolveKey(node, problemKind, element) && this.isAcceptableImportContext((PsiElement)node)) {
            info2.addAll(TypeScriptFixesReferenceErrorUpdater.createFixes(node.getReferenceName(), (PsiElement)node, true));
            return true;
        }
        return false;
    }

    public static boolean isAcceptableResolveKey(@NotNull JSReferenceExpression node, JSResolveResult.ProblemKind resolveProblemKind, @Nullable PsiElement element) {
        if (node == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(9);
        }
        return (resolveProblemKind == JSResolveResult.ProblemKind.ELEMENT_IS_NOT_ACCESSIBLE || resolveProblemKind == JSResolveResult.ProblemKind.JS_NEED_TO_BE_EXPORTED) && element instanceof TypeScriptImportStatement && node.getQualifier() == null;
    }

    @NotNull
    public static Collection<LocalQuickFix> createFixes(String name, @NotNull PsiElement context2, boolean showHint2) {
        if (context2 == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(10);
        }
        if (name == null) {
            List<LocalQuickFix> list2 = Collections.emptyList();
            if (list2 == null) {
                TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(11);
            }
            return list2;
        }
        JSImportPlaceInfo placeInfo = JSHandlersFactory.forElement(context2).createImportPlaceInfo(context2);
        List<JSImportCandidateWithExecutor> candidates = new JSImportAction(null, name, placeInfo).getFilteredCandidates();
        ArrayList<LocalQuickFix> objects = new ArrayList<LocalQuickFix>();
        JSImportModuleFix.HintMode firstMode = candidates.size() > 1 ? JSImportModuleFix.HintMode.MULTI : JSImportModuleFix.HintMode.SINGLE;
        for (int i = 0; i < candidates.size(); ++i) {
            JSImportCandidateWithExecutor candidate = candidates.get(i);
            boolean hint2 = showHint2 && i == 0 && JSApplicationSettings.getInstance().showTSImportPopupEffective(context2.getProject());
            JSImportModuleFix.HintMode mode = hint2 ? firstMode : JSImportModuleFix.HintMode.NO_HINT;
            objects.add(new JSImportModuleFix(context2, candidate, mode));
        }
        if (objects.size() > 0 && showHint2) {
            objects.add((LocalQuickFix)new JSImportAllQuickFix(name, context2));
        }
        Collection<LocalQuickFix> collection = JSImportReferenceQuickFixProviderBase.sortAndFilter(objects);
        if (collection == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(12);
        }
        return collection;
    }

    private static boolean fixNullabilityError(@NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info2, @NotNull JSReferenceExpression node, ResolveResult @NotNull [] results, boolean inTypeContext) {
        if (info2 == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(13);
        }
        if (node == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(14);
        }
        if (results == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(15);
        }
        if (results.length != 0 || inTypeContext || node.getQualifier() == null) {
            return false;
        }
        JSType type2 = JSResolveUtil.getExpressionJSType(node.getQualifier());
        JSTypeCastUtil.NullableState nullableState = JSTypeCastUtil.getNullableState(type2);
        if (nullableState == JSTypeCastUtil.NullableState.NOT_NULLABLE) {
            return false;
        }
        JSType typeWithoutNull = JSTypeUtils.removeNullableComponents(type2);
        String refName = node.getReferenceName();
        if (typeWithoutNull != null && refName != null && typeWithoutNull != type2 && typeWithoutNull.asRecordType().hasProperty(refName)) {
            if (nullableState == JSTypeCastUtil.NullableState.HAS_NULL_AND_UNDEFINED) {
                info2.updateMessage(JavaScriptBundle.message("javascript.unresolved.variable.null.or.undefined.qualifier.message", refName));
            } else if (nullableState == JSTypeCastUtil.NullableState.HAS_NULL) {
                info2.updateMessage(JavaScriptBundle.message("javascript.unresolved.variable.null.qualifier.message", refName));
            } else {
                info2.updateMessage(JavaScriptBundle.message("javascript.unresolved.variable.undefined.qualifier.message", refName));
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/TypeScriptFixesReferenceErrorUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/TypeScriptFixesReferenceErrorUpdater";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateError";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableImportContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fixDistinctError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableResolveKey";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFixes";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fixNullabilityError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12 -> new IllegalStateException(string);
        };
    }
}

