/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.frameworks.jsx.JSXEmptyImplementation;
import com.intellij.lang.javascript.frameworks.jsx.JSXImplementation;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXTagOrComponentReference;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.validation.JSBundleMessageHighlighter;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceInspectionVisitor;
import com.intellij.lang.javascript.validation.JSReferenceProblemReporter;
import com.intellij.lang.javascript.validation.JSUnresolvedReferenceErrorUpdater;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSXUnresolvedComponentInspection
extends JSInspection {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            JSXUnresolvedComponentInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    protected JSElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSXUnresolvedComponentInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSXUnresolvedComponentInspection.$$$reportNull$$$0(2);
        }
        return new JSUnresolvedReactComponentInspectionVisitor(new JSReferenceProblemReporter(holder));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSXUnresolvedComponentInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSXUnresolvedComponentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static class JSUnresolvedReactComponentInspectionVisitor
    extends JSReferenceInspectionVisitor {
        public JSUnresolvedReactComponentInspectionVisitor(@NotNull JSProblemReporter<?> reporter) {
            if (reporter == null) {
                JSUnresolvedReactComponentInspectionVisitor.$$$reportNull$$$0(0);
            }
            super(reporter);
        }

        @Override
        public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
            if (node == null) {
                JSUnresolvedReactComponentInspectionVisitor.$$$reportNull$$$0(1);
            }
            if (!this.isAcceptable((PsiElement)node)) {
                return;
            }
            if (node instanceof JSXXmlLiteralExpressionImpl) {
                this.processXmlLiteralExpression((JSXXmlLiteralExpressionImpl)node);
            }
            super.visitJSLiteralExpression(node);
        }

        private void processXmlLiteralExpression(JSXmlLiteralExpression expression) {
            int startRef;
            if (!JSXResolveUtil.isComponentName(expression.getName()) || JSXImplementation.getImplementation((PsiElement)expression) instanceof JSXEmptyImplementation) {
                return;
            }
            PsiReference[] references = expression.getReferences();
            for (int i = startRef = Math.max(references.length / 2 - 1, 0); i >= 0; --i) {
                PsiElement resolve;
                PsiReference reference = references[i];
                if (!(reference instanceof JSXTagOrComponentReference) || (resolve = reference.resolve()) != null && resolve != expression) continue;
                LocalQuickFix[] fixes = JSUnresolvedReactComponentInspectionVisitor.getUnresolvedXmlLiteralFixes(expression);
                String message = ((JSBundleMessageHighlighter)expression.getProject().getService(JSBundleMessageHighlighter.class)).message("javascript.validation.message.unresolved.component", new JSBundleMessageHighlighter.TextWithAttributes(reference.getCanonicalText(), XmlHighlighterColors.HTML_CUSTOM_TAG_NAME));
                this.myReporter.registerProblem((PsiElement)expression, reference.getRangeInElement(), message, null, fixes);
                return;
            }
        }

        private static LocalQuickFix @NotNull [] getUnresolvedXmlLiteralFixes(@NotNull JSXmlLiteralExpression expression) {
            if (expression == null) {
                JSUnresolvedReactComponentInspectionVisitor.$$$reportNull$$$0(2);
            }
            ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
            JSUnresolvedReferenceErrorUpdater.ErrorInfoImpl info2 = new JSUnresolvedReferenceErrorUpdater.ErrorInfoImpl(quickFixes);
            for (JSUnresolvedReferenceErrorUpdater provider : JSUnresolvedReferenceErrorUpdater.EP_NAME.getExtensionList()) {
                provider.updateError(info2, expression);
            }
            LocalQuickFix[] localQuickFixArray = quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY);
            if (localQuickFixArray == null) {
                JSUnresolvedReactComponentInspectionVisitor.$$$reportNull$$$0(3);
            }
            return localQuickFixArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reporter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSXUnresolvedComponentInspection$JSUnresolvedReactComponentInspectionVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSXUnresolvedComponentInspection$JSUnresolvedReactComponentInspectionVisitor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedXmlLiteralFixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitJSLiteralExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getUnresolvedXmlLiteralFixes";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

