/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSAccessibilityCheckInspection;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.modules.ES6CheckImportVisitor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.JSReferenceInspectionVisitor;
import com.intellij.lang.javascript.validation.JSReferenceProblemReporter;
import com.intellij.lang.javascript.validation.JavaScriptReferenceProblemReporter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUnresolvedReferenceInspection
extends JSInspection {
    public boolean myStrictlyCheckGlobalDefinitions;
    public boolean myStrictlyCheckProperties = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myStrictlyCheckGlobalDefinitions", (String)JavaScriptBundle.message("javascript.strictly.check.global.vars", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myStrictlyCheckProperties", (String)JavaScriptBundle.message("javascript.strictly.check.object.properties", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JSUnresolvedReferenceInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected JSElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnresolvedReferenceInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSUnresolvedReferenceInspection.$$$reportNull$$$0(2);
        }
        return new JSUnresolvedReferenceInspectionVisitor(new JavaScriptReferenceProblemReporter(holder){

            @Override
            @Nullable
            public Void registerProblem(PsiElement referenceNameElement, @Nullable TextRange rangeWithinElement, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
                PsiElement parent;
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fixes == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!JSUnresolvedReferenceInspection.this.myStrictlyCheckProperties && !(parent = referenceNameElement.getParent()).getFirstChild().equals(referenceNameElement)) {
                    return null;
                }
                if (JSUnresolvedReferenceInspection.this.myStrictlyCheckGlobalDefinitions && (parent = referenceNameElement.getParent()) instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == null) {
                    highlightType = ProblemHighlightType.ERROR;
                }
                return super.registerProblem(referenceNameElement, rangeWithinElement, message, highlightType, fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fixes";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/inspections/JSUnresolvedReferenceInspection$1";
                objectArray[2] = "registerProblem";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnresolvedReferenceInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnresolvedReferenceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static class JSUnresolvedReferenceInspectionVisitor
    extends JSReferenceInspectionVisitor {
        @NotNull
        private final ES6CheckImportVisitor myImportVisitor;

        protected JSUnresolvedReferenceInspectionVisitor(@NotNull JSReferenceProblemReporter reporter) {
            if (reporter == null) {
                JSUnresolvedReferenceInspectionVisitor.$$$reportNull$$$0(0);
            }
            super(reporter);
            this.myImportVisitor = new ES6CheckImportVisitor();
        }

        @Override
        public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
            if (node == null) {
                JSUnresolvedReferenceInspectionVisitor.$$$reportNull$$$0(1);
            }
            if (!this.isAcceptable((PsiElement)node)) {
                return;
            }
            ResolveResult[] results = node.multiResolve(false);
            if (JSAccessibilityCheckInspection.isSymbolNotAccessible(results)) {
                return;
            }
            JSCallLikeExpression callExpression = JSReferenceChecker.getCallIfMethodExpression(node);
            JSReferenceChecker referenceChecker = JSAnalysisHandlersFactory.forElement((PsiElement)node).getReferenceChecker(this.myReporter);
            if (callExpression != null) {
                referenceChecker.checkCallReferences(node, callExpression instanceof JSNewExpression);
            } else {
                referenceChecker.checkRefExpression(node);
            }
        }

        @Override
        public void visitES6ExportSpecifier(@NotNull ES6ExportSpecifier node) {
            if (node == null) {
                JSUnresolvedReferenceInspectionVisitor.$$$reportNull$$$0(2);
            }
            if (!this.isAcceptable((PsiElement)node)) {
                return;
            }
            ES6ExportDeclaration declaration = node.getDeclaration();
            if (declaration != null && declaration.getFromClause() == null) {
                ResolveResult result2;
                ResolveResult[] results = node.multiResolve(false);
                if (results.length == 0) {
                    this.myReporter.registerProblem((PsiElement)node, null, XmlHighlightVisitor.getErrorDescription((PsiReference)node), null, JSReferenceChecker.getCreateFixesForUnresolvedRef(node));
                } else if (results.length == 1 && !(result2 = results[0]).isValidResult()) {
                    JSResolveResult.ProblemKind problemKind;
                    String message = null;
                    if (result2 instanceof JSResolveResult && (problemKind = ((JSResolveResult)result2).getResolveProblemKind()) != null) {
                        message = JavaScriptBundle.message(problemKind.getMessageKey(), new Object[0]);
                    }
                    String s = message != null ? message : XmlHighlightVisitor.getErrorDescription((PsiReference)node);
                    this.myReporter.registerProblem((PsiElement)node, null, s, null, new LocalQuickFix[0]);
                }
            }
            super.visitES6ExportSpecifier(node);
        }

        @Override
        public void visitJSCallExpression(@NotNull JSCallExpression node) {
            if (node == null) {
                JSUnresolvedReferenceInspectionVisitor.$$$reportNull$$$0(3);
            }
            if (!this.isAcceptable((PsiElement)node)) {
                return;
            }
            JSExpression methodExpression = node.getMethodExpression();
            if (methodExpression instanceof JSNewExpression) {
                JSAnalysisHandlersFactory.forElement((PsiElement)methodExpression).getReferenceChecker(this.myReporter).checkNewExpressionInsideCallReferences((JSNewExpression)methodExpression);
            }
        }

        @Override
        public void visitES6ImportedBinding(@NotNull ES6ImportedBinding importedBinding) {
            if (importedBinding == null) {
                JSUnresolvedReferenceInspectionVisitor.$$$reportNull$$$0(4);
            }
            if (!this.isAcceptable((PsiElement)importedBinding)) {
                return;
            }
            this.myImportVisitor.visitES6ImportedBindingImpl(importedBinding, ((JSReferenceProblemReporter)this.myReporter).getProblemsHolder());
        }

        @Override
        public void visitES6ImportExportSpecifier(@NotNull ES6ImportExportSpecifier specifier) {
            if (specifier == null) {
                JSUnresolvedReferenceInspectionVisitor.$$$reportNull$$$0(5);
            }
            if (!this.isAcceptable((PsiElement)specifier)) {
                return;
            }
            this.myImportVisitor.visitSpecifierImpl(((JSReferenceProblemReporter)this.myReporter).getProblemsHolder(), specifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reporter";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importedBinding";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "specifier";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnresolvedReferenceInspection$JSUnresolvedReferenceInspectionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSReferenceExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitES6ExportSpecifier";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSCallExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitES6ImportedBinding";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitES6ImportExportSpecifier";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

