/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSPotentiallyInvalidUsageOfThisInspection;
import com.intellij.lang.javascript.inspections.JSRecursiveWalkingElementSkippingNestedFunctionsVisitor;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public class JSPotentiallyInvalidUsageOfClassThisInspection
extends JSInspection {
    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSPotentiallyInvalidUsageOfClassThisInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSPotentiallyInvalidUsageOfClassThisInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node.isArrowFunction()) {
                    return;
                }
                this.process(node);
            }

            @Override
            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                JSClass parent;
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((parent = JSUtils.getMemberContainingClass(node)) != null || node.isArrowFunction()) {
                    return;
                }
                this.process(node);
            }

            private void process(@NotNull JSFunction function2) {
                JSClass clazz;
                if (function2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((clazz = (JSClass)PsiTreeUtil.getContextOfType((PsiElement)function2, (Class[])new Class[]{JSClass.class})) == null) {
                    return;
                }
                if (JSDocumentationUtils.findContextType(function2) != null) {
                    return;
                }
                if (DialectDetector.isTypeScript(function2) && TypeScriptPsiUtil.getThisParameter(function2) != null) {
                    return;
                }
                final Set fieldNames = StreamSupport.stream(clazz.getMembers().spliterator(), false).filter(m -> m instanceof JSNamedElement).map(m -> m.getName()).collect(Collectors.toSet());
                if (JSPotentiallyInvalidUsageOfThisInspection.isSameThisAsBefore(function2)) {
                    return;
                }
                function2.acceptChildren(new JSRecursiveWalkingElementSkippingNestedFunctionsVisitor(){

                    @Override
                    public void visitJSThisExpression(@NotNull JSThisExpression node) {
                        PsiElement parent;
                        if (node == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!((parent = node.getParent()) instanceof JSReferenceExpression) || ((JSReferenceExpression)parent).getQualifier() != node) {
                            return;
                        }
                        String name = ((JSReferenceExpression)parent).getReferenceName();
                        if (name == null || !fieldNames.contains(name)) {
                            return;
                        }
                        holder.registerProblem(parent, JavaScriptBundle.message("javascript.potentially.invalid.usage.of.class.this", new Object[0]), new LocalQuickFix[0]);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfClassThisInspection$1$1", "visitJSThisExpression"));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfClassThisInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfClassThisInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

