/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSOctalIntegerInspection
extends JSInspection {
    public boolean myReportNonStrictEs5;

    public JSOctalIntegerInspection() {
    }

    public JSOctalIntegerInspection(boolean reportNonStrictEs5) {
        this.myReportNonStrictEs5 = reportNonStrictEs5;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSOctalIntegerInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSOctalIntegerInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                JSLiteralExpressionKind expressionKind;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((expressionKind = node.getExpressionKind(true)) == JSLiteralExpressionKind.OBSOLETE_OCT) {
                    this.reportObsoleteOct(node.getFirstChild());
                }
            }

            private void reportObsoleteOct(@NotNull PsiElement leafElement) {
                if (leafElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (DialectDetector.isES6(leafElement) || DialectDetector.isTypeScript(leafElement)) {
                    holder.registerProblem(leafElement, JavaScriptBundle.message("javascript.octal.literals.are.not.allowed.es6.message", new Object[0]), new LocalQuickFix[]{new ReplaceWithEs6OctLiteralFix(leafElement)});
                } else if (JSResolveUtil.isEcmaScript5(leafElement)) {
                    holder.registerProblem(leafElement, JavaScriptBundle.message("javascript.octal.literals.are.not.allowed.in.strict.mode", new Object[0]), new LocalQuickFix[0]);
                } else if (JSOctalIntegerInspection.this.myReportNonStrictEs5) {
                    holder.registerProblem(leafElement, JavaScriptBundle.message("javascript.octal.literals.are.not.allowed.es5.message", new Object[0]), new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitJSProperty(@NotNull JSProperty node) {
                PsiElement nameIdentifier;
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((nameIdentifier = node.getNameIdentifier()) != null && nameIdentifier.getNode().getElementType() == JSTokenTypes.NUMERIC_LITERAL && JSLiteralExpressionImpl.getNumericExpressionKind(nameIdentifier.getText()) == JSLiteralExpressionKind.OBSOLETE_OCT) {
                    this.reportObsoleteOct(nameIdentifier);
                }
                super.visitJSProperty(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "leafElement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSOctalIntegerInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSLiteralExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reportObsoleteOct";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSProperty";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myReportNonStrictEs5", (String)JavaScriptBundle.message("javascript.octal.literals.warn.always", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JSOctalIntegerInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSOctalIntegerInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSOctalIntegerInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class ReplaceWithEs6OctLiteralFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final String myNewText;

        private ReplaceWithEs6OctLiteralFix(PsiElement leafElement) {
            super(leafElement);
            String newText = StringUtil.trimStart((String)leafElement.getText(), (String)"0");
            this.myNewText = "0o" + (newText.isEmpty() ? "0" : newText);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.replace.with.literal", "0o");
            if (string == null) {
                ReplaceWithEs6OctLiteralFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message("js.replace.with.literal", this.myNewText);
            if (string == null) {
                ReplaceWithEs6OctLiteralFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ReplaceWithEs6OctLiteralFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                ReplaceWithEs6OctLiteralFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                ReplaceWithEs6OctLiteralFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                ReplaceWithEs6OctLiteralFix.$$$reportNull$$$0(5);
            }
            startElement.replace(JSPsiElementFactory.createJSExpression(this.myNewText, startElement).getFirstChild());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSOctalIntegerInspection$ReplaceWithEs6OctLiteralFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSOctalIntegerInspection$ReplaceWithEs6OctLiteralFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

