/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.lang.javascript.highlighting.JavaScriptHighlightDescriptor;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSBundleMessageHighlighter;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.IndexingBundle;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileReferencesInspection
extends JSInspection {
    public boolean myIgnoreComplexCases = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myIgnoreComplexCases", (String)JavaScriptBundle.message("js.file.references.inspection.ignore.complex.cases", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    public static boolean hasImportReferences(@NotNull PsiElement element) {
        if (element == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(1);
        }
        if (element instanceof JSLiteralExpression) {
            PsiElement parent = element.getContext();
            if (parent instanceof JSArgumentList) {
                PsiElement callCandidate = parent.getContext();
                if (callCandidate instanceof JSCallExpression && (((JSCallExpression)callCandidate).isRequireCall() || ((JSCallExpression)callCandidate).isDefineCall())) {
                    return true;
                }
            } else {
                if (parent instanceof ES6ImportCall) {
                    return true;
                }
                if (parent instanceof TypeScriptModule) {
                    return ((TypeScriptModule)parent).getIdentifyingElement() == element;
                }
            }
        }
        return ContainerUtil.exists((Object[])element.getReferences(), el -> el instanceof JSModuleBaseReference) || element instanceof ES6ImportExportDeclaration && ((ES6ImportExportDeclaration)element).getFromClause() == null || element instanceof ES6FromClause;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(3);
        }
        return new JSElementVisitor(){

            public void visitComment(@NotNull PsiComment comment) {
                if (comment == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (TypeScriptPsiUtil.isTopLevelThreeSlashComment(comment) && JSFileReferencesInspection.hasImportReferences((PsiElement)comment)) {
                    JSFileReferencesInspection.checkReferences((PsiElement)comment, holder, JSFileReferencesInspection.this.myIgnoreComplexCases);
                }
                super.visitComment(comment);
            }

            @Override
            public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!node.isQuotedLiteral()) {
                    return;
                }
                if (JSFileReferencesInspection.hasImportReferences((PsiElement)node)) {
                    if (TypeScriptPsiUtil.isLiteralModuleAugmentationName((PsiElement)node)) {
                        return;
                    }
                    JSFileReferencesInspection.checkImportReferences((PsiElement)node, holder, JSFileReferencesInspection.this.myIgnoreComplexCases);
                    return;
                }
                JSFileReferencesInspection.checkReferences((PsiElement)node, holder, JSFileReferencesInspection.this.myIgnoreComplexCases);
            }

            @Override
            public void visitES6FromClause(@NotNull ES6FromClause fromClause) {
                if (fromClause == null) {
                    1.$$$reportNull$$$0(2);
                }
                JSFileReferencesInspection.checkImportReferences((PsiElement)fromClause, holder, JSFileReferencesInspection.this.myIgnoreComplexCases);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "comment";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fromClause";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSFileReferencesInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitComment";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSLiteralExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6FromClause";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void checkImportReferences(@NotNull PsiElement element, @NotNull ProblemsHolder holder, boolean ignoreComplexCases) {
        if (element == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(5);
        }
        if (DialectDetector.isTypeScript(element)) {
            return;
        }
        if (!JSFileReferencesUtil.resolveModuleReferences(element).isEmpty()) {
            return;
        }
        String text2 = JSFileReferencesUtil.getReferenceModuleText(element);
        if (text2 == null) {
            return;
        }
        if (!JSFileReferencesInspection.isStrict(element, JSStringUtil.unquoteStringLiteralValue(text2))) {
            return;
        }
        JSFileReferencesInspection.checkReferences(element, holder, ignoreComplexCases);
    }

    private static boolean isStrict(@NotNull PsiElement element, @Nullable String text2) {
        if (element == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(6);
        }
        if (text2 == null || JSUrlImportsUtil.isSupportedRemoteModuleUrl(text2) && element instanceof XmlAttributeValue) {
            return false;
        }
        return JSFileReferencesUtil.isRelative(text2) || text2.endsWith(".js") || text2.startsWith("file://") || text2.startsWith("/");
    }

    public static void checkReferences(@NotNull PsiElement node, @NotNull ProblemsHolder holder, boolean ignoreComplexCases) {
        if (node == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(8);
        }
        HashMap<TextRange, PsiFileReference> hardRefs = new HashMap<TextRange, PsiFileReference>();
        MultiMap softRefs = MultiMap.create();
        for (PsiReference ref : node.getReferences()) {
            if (!(ref instanceof PsiFileReference)) continue;
            PsiFileReference fileRef = (PsiFileReference)ref;
            TextRange range = ref.getRangeInElement();
            if (ref.isSoft() && ignoreComplexCases) {
                softRefs.putValue((Object)range, (Object)fileRef);
                continue;
            }
            if (hardRefs.containsKey(range) && hardRefs.get(range) == null) continue;
            ResolveResult[] results = fileRef.multiResolve(false);
            if (results.length != 0) {
                hardRefs.put(range, null);
                continue;
            }
            hardRefs.put(range, fileRef);
        }
        block1: for (Map.Entry entry : hardRefs.entrySet()) {
            PsiFileReference ref = (PsiFileReference)entry.getValue();
            if (ref == null) continue;
            for (PsiFileReference softRef : softRefs.get((Object)((TextRange)entry.getKey()))) {
                if (softRef.multiResolve(false).length <= 0) continue;
                continue block1;
            }
            String message = JSFileReferencesInspection.getErrorDescription((PsiReference)ref, holder.getProject());
            LocalQuickFix[] fixes = ref instanceof LocalQuickFixProvider ? ((LocalQuickFixProvider)ref).getQuickFixes() : LocalQuickFix.EMPTY_ARRAY;
            holder.registerProblem(node, ref.getRangeInElement(), message, fixes);
        }
    }

    @InspectionMessage
    @NotNull
    public static String getErrorDescription(@NotNull PsiReference ref, @NotNull Project project) {
        if (ref == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(9);
        }
        if (project == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(10);
        }
        if (ref instanceof JSFileReference) {
            JSFileReference fileReference = (JSFileReference)ref;
            JSBundleMessageHighlighter service2 = (JSBundleMessageHighlighter)project.getService(JSBundleMessageHighlighter.class);
            TextAttributesKey stringKey = JavaScriptHighlightDescriptor.STRING.getAttributesKey(JSAnnotatingVisitor.getHighlighter(ref.getElement()));
            String string = service2.message("javascript.unresolved.file.or.dir", IndexingBundle.message((String)(fileReference.isLast() ? "terms.file" : "terms.directory"), (Object[])new Object[0]), new JSBundleMessageHighlighter.TextWithAttributes(fileReference.decode(ref.getCanonicalText()), stringKey));
            if (string == null) {
                JSFileReferencesInspection.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = XmlHighlightVisitor.getErrorDescription((PsiReference)ref);
        if (string == null) {
            JSFileReferencesInspection.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSFileReferencesInspection";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSFileReferencesInspection";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDescription";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasImportReferences";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkImportReferences";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isStrict";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkReferences";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getErrorDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

