/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.impl.JSBinaryExpressionImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSEqualityComparisonWithCoercionInspection
extends JSInspection {
    private static final Map<String, Severity> LEGACY_SERIALIZED_VALUES = Map.of("All", Severity.Always, "All except when comparing with null", Severity.AlwaysExceptNull, "All except when comparing with null or typeof", Severity.AlwaysExceptNull, "Only suspicious expressions", Severity.OnlySuspicious);
    @NotNull
    public Severity mySeverity;
    private final Condition<? super DialectOptionHolder> myAcceptsDialect;

    public JSEqualityComparisonWithCoercionInspection(@NotNull Severity severity, Condition<? super DialectOptionHolder> acceptsDialect) {
        if (severity == null) {
            JSEqualityComparisonWithCoercionInspection.$$$reportNull$$$0(0);
        }
        this.mySeverity = severity;
        this.myAcceptsDialect = acceptsDialect;
    }

    public JSEqualityComparisonWithCoercionInspection() {
        this(Severity.AlwaysExceptNull, (Condition<? super DialectOptionHolder>)((Condition)holder -> holder.isJavaScript()));
    }

    @NotNull
    public String getID() {
        return "EqualityComparisonWithCoercionJS";
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSEqualityComparisonWithCoercionInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSEqualityComparisonWithCoercionInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitJSBinaryExpression(expression);
                IElementType signTokenType = expression.getOperationSign();
                DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)expression);
                if (!JSTokenTypes.EQEQ.equals(signTokenType) && !JSTokenTypes.NE.equals(signTokenType) || dialectOptionHolder == null || !JSEqualityComparisonWithCoercionInspection.this.myAcceptsDialect.value((Object)dialectOptionHolder)) {
                    return;
                }
                if (JSEqualityComparisonWithCoercionInspection.this.needToHighlight(expression)) {
                    boolean equalityOp = signTokenType == JSTokenTypes.EQEQ;
                    holder.registerProblem((PsiElement)expression, JavaScriptBundle.message("javascript.equality.comparison.with.coercion.error.string", new Object[0]), new LocalQuickFix[]{new MyQuickfix(equalityOp)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/inspections/JSEqualityComparisonWithCoercionInspection$1", "visitJSBinaryExpression"));
            }
        };
    }

    private boolean needToHighlight(@NotNull JSBinaryExpression expression) {
        JSExpression rhs;
        JSExpression lhs;
        if (expression == null) {
            JSEqualityComparisonWithCoercionInspection.$$$reportNull$$$0(3);
        }
        if (JSEqualityComparisonWithCoercionInspection.isTypeOfAndStringLiteral(lhs = JSUtils.unparenthesize(expression.getLOperand()), rhs = JSUtils.unparenthesize(expression.getROperand())) || JSEqualityComparisonWithCoercionInspection.isTypeOfAndStringLiteral(rhs, lhs)) {
            return false;
        }
        return switch (this.mySeverity) {
            default -> throw new IncompatibleClassChangeError();
            case Severity.Always -> true;
            case Severity.AlwaysExceptNull -> {
                if (!(JSEqualityComparisonWithCoercionInspection.isTypeOfAndStringLiteral(lhs, rhs) || JSEqualityComparisonWithCoercionInspection.isTypeOfAndStringLiteral(rhs, lhs) || JSEqualityComparisonWithCoercionInspection.isNull(lhs) || JSEqualityComparisonWithCoercionInspection.isNull(rhs))) {
                    yield true;
                }
                yield false;
            }
            case Severity.OnlySuspicious -> JSEqualityComparisonWithCoercionInspection.mayCauseCoercion(rhs) || JSEqualityComparisonWithCoercionInspection.mayCauseCoercion(lhs);
        };
    }

    private static boolean isTypeOfAndStringLiteral(@Nullable JSExpression lExpression, @Nullable JSExpression rExpression) {
        if (lExpression instanceof JSPrefixExpression) {
            IElementType sign = ((JSPrefixExpression)lExpression).getOperationSign();
            return sign == JSTokenTypes.TYPEOF_KEYWORD && rExpression instanceof JSLiteralExpression && ((JSLiteralExpression)rExpression).isStringLiteral();
        }
        return false;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.dropdown((String)"mySeverity", (String)JavaScriptBundle.message("javascript.equality.comparison.with.coercion.options.label", new Object[0]), Severity.class, Severity::getPresentableText)});
        if (optPane == null) {
            JSEqualityComparisonWithCoercionInspection.$$$reportNull$$$0(4);
        }
        return optPane;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            JSEqualityComparisonWithCoercionInspection.$$$reportNull$$$0(5);
        }
        super.readSettings(node);
        for (Element child : node.getChildren("option")) {
            if (!StringUtil.equals((CharSequence)child.getAttributeValue("name"), (CharSequence)"mySeverity")) continue;
            String value = child.getAttributeValue("value");
            this.mySeverity = value == null ? this.mySeverity : LEGACY_SERIALIZED_VALUES.getOrDefault(value, this.mySeverity);
        }
    }

    private static boolean isNull(@Nullable JSExpression expression) {
        return expression instanceof JSLiteralExpression && "null".equals(expression.getText());
    }

    private static boolean mayCauseCoercion(@Nullable JSExpression expression) {
        if (!(expression instanceof JSLiteralExpression)) {
            return false;
        }
        if (JSEqualityComparisonWithCoercionInspection.isNull(expression)) {
            return true;
        }
        String text2 = expression.getText();
        return "0".equals(text2) || "0x0".equals(text2) || "0X0".equals(text2) || "0.0".equals(text2) || "0L".equals(text2) || "0l".equals(text2) || "true".equals(text2) || "false".equals(text2) || "undefined".equals(text2) || "''".equals(text2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSEqualityComparisonWithCoercionInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSEqualityComparisonWithCoercionInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "needToHighlight";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    public static enum Severity {
        Always("javascript.equality.comparison.with.coercion.option.always", "Always"),
        AlwaysExceptNull("javascript.equality.comparison.with.coercion.option.always.except.null", "AlwaysExceptNull"),
        OnlySuspicious("javascript.equality.comparison.with.coercion.option.only.suspicious", "OnlySuspicious");

        @PropertyKey(resourceBundle="messages.JavaScriptBundle")
        private final @PropertyKey(resourceBundle="messages.JavaScriptBundle") String myPresentableTextKey;
        private final String mySerializedName;

        private Severity(String presentableTextKey, String mySerialized) {
            this.myPresentableTextKey = presentableTextKey;
            this.mySerializedName = mySerialized;
        }

        @NotNull
        String getPresentableText() {
            String string = JavaScriptBundle.message(this.myPresentableTextKey, new Object[0]);
            if (string == null) {
                Severity.$$$reportNull$$$0(0);
            }
            return string;
        }

        public String toString() {
            return this.mySerializedName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSEqualityComparisonWithCoercionInspection$Severity", "getPresentableText"));
        }
    }

    public static class TSInspection
    extends JSEqualityComparisonWithCoercionInspection {
        public TSInspection() {
            super(Severity.AlwaysExceptNull, (Condition<? super DialectOptionHolder>)((Condition)holder -> holder.isTypeScript));
        }

        @Override
        @NotNull
        public String getShortName() {
            return "JSEqualityComparisonWithCoercion.TS";
        }
    }

    private static class MyQuickfix
    implements LocalQuickFix {
        private final boolean equalityOp;

        MyQuickfix(boolean equalityOp) {
            this.equalityOp = equalityOp;
        }

        @NotNull
        public String getName() {
            String string = JavaScriptBundle.message("javascript.equality.comparison.with.coercion.fix", this.getOperatorStr());
            if (string == null) {
                MyQuickfix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private String getOperatorStr() {
            return this.equalityOp ? "===" : "!==";
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("javascript.equality.comparison.with.coercion.family.name", new Object[0]);
            if (string == null) {
                MyQuickfix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyQuickfix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MyQuickfix.$$$reportNull$$$0(3);
            }
            ASTNode expressionNode = descriptor.getPsiElement().getNode();
            ASTNode operatorNode = JSBinaryExpressionImpl.getOperationSignNode(expressionNode);
            IElementType operatorTokenType = this.equalityOp ? JSTokenTypes.EQEQEQ : JSTokenTypes.NEQEQ;
            LeafElement newChild = ASTFactory.leaf((IElementType)operatorTokenType, (CharSequence)this.getOperatorStr());
            CodeEditUtil.setNodeGenerated((ASTNode)newChild, (boolean)true);
            expressionNode.replaceChild(operatorNode, (ASTNode)newChild);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSEqualityComparisonWithCoercionInspection$MyQuickfix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSEqualityComparisonWithCoercionInspection$MyQuickfix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

