/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.JSReferenceInspectionVisitor;
import com.intellij.lang.javascript.validation.JSReferenceProblemReporter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAccessibilityCheckInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSAccessibilityCheckInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSAccessibilityCheckInspection.$$$reportNull$$$0(1);
        }
        return new JSReferenceInspectionVisitor(new JSProblemReporter<Void>(){

            @Override
            @Nullable
            public Void registerProblem(PsiElement referenceNameElement, @Nullable TextRange rangeWithinElement, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fixes == null) {
                    1.$$$reportNull$$$0(1);
                }
                JSReferenceProblemReporter.registerFixes(referenceNameElement, fixes);
                if (highlightType == null) {
                    highlightType = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
                }
                holder.registerProblem(referenceNameElement, message, highlightType, rangeWithinElement, fixes);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fixes";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$1";
                objectArray[2] = "registerProblem";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }){

            @Override
            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!this.isAcceptable((PsiElement)node)) {
                    return;
                }
                ResolveResult[] results = node.multiResolve(false);
                if (!JSAccessibilityCheckInspection.isSymbolNotAccessible(results)) {
                    return;
                }
                JSReferenceChecker checker = JSAnalysisHandlersFactory.forElement((PsiElement)node).getReferenceChecker(this.myReporter);
                JSCallLikeExpression callExpression = JSReferenceChecker.getCallIfMethodExpression(node);
                if (callExpression != null) {
                    checker.checkCallReferences(node, callExpression instanceof JSNewExpression);
                } else {
                    checker.checkRefExpression(node);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$2", "visitJSReferenceExpression"));
            }
        };
    }

    public static boolean isSymbolNotAccessible(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            JSAccessibilityCheckInspection.$$$reportNull$$$0(2);
        }
        if (resolveResults.length == 0) {
            return false;
        }
        ResolveResult result2 = resolveResults[0];
        if (!(result2 instanceof JSResolveResult)) {
            return false;
        }
        JSResolveResult.ProblemKind resolveProblemKey = ((JSResolveResult)result2).getResolveProblemKind();
        return resolveProblemKey == JSResolveResult.ProblemKind.JS_PRIVATE_MEMBER_IS_NOT_ACCESSIBLE || resolveProblemKey == JSResolveResult.ProblemKind.JS_PROTECTED_MEMBER_IS_NOT_ACCESSIBLE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSymbolNotAccessible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SetJSDocElementVisibilityFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final JSAttributeList.AccessType myNewVisibility;

        public SetJSDocElementVisibilityFix(@NotNull PsiElement element, JSAttributeList.AccessType newVisibility) {
            if (element == null) {
                SetJSDocElementVisibilityFix.$$$reportNull$$$0(0);
            }
            super(element);
            this.myNewVisibility = newVisibility;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            JSDocTag[] tags;
            PsiComment comment;
            if (project == null) {
                SetJSDocElementVisibilityFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                SetJSDocElementVisibilityFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                SetJSDocElementVisibilityFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                SetJSDocElementVisibilityFix.$$$reportNull$$$0(4);
            }
            if (!((comment = JSDocumentationUtils.findDocComment(startElement)) instanceof JSDocComment)) {
                return;
            }
            for (JSDocTag tag : tags = ((JSDocComment)comment).getTags()) {
                String tagName = tag.getName();
                if (!"private".equals(tagName) && !"protected".equals(tagName) && !"public".equals(tagName)) continue;
                Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(comment.getContainingFile());
                if (document2 != null) {
                    String visibilityTag = JSVisibilityUtil.getJSDocVisibilityKeyword(this.myNewVisibility);
                    if (visibilityTag != null) {
                        document2.replaceString(tag.getTextRange().getStartOffset(), tag.getTextRange().getEndOffset(), (CharSequence)("@" + visibilityTag));
                    } else {
                        document2.deleteString(tag.getTextRange().getStartOffset(), tag.getTextRange().getEndOffset());
                    }
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
                }
                return;
            }
        }

        @NotNull
        public String getText() {
            PsiElement element = this.getStartElement();
            String name = element instanceof JSNamedElement ? ((JSNamedElement)element).getName() : "element";
            String visibility = JSVisibilityUtil.getJSDocVisibilityKeyword(this.myNewVisibility);
            if (visibility == null) {
                visibility = "default";
            }
            String string = JavaScriptBundle.message("javascript.fix.set.element.visibility", name, visibility);
            if (string == null) {
                SetJSDocElementVisibilityFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("javascript.fix.visibility.family", new Object[0]);
            if (string == null) {
                SetJSDocElementVisibilityFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$SetJSDocElementVisibilityFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$SetJSDocElementVisibilityFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

