/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.injections;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSInjectionUtil {
    private static final String EXTERNAL_FRAGMENT = "EXTERNAL_FRAGMENT";
    public static final Key<Boolean> EVALUATED_INJECTION = Key.create((String)"js.evaluated.injection");

    private JSInjectionUtil() {
    }

    @NotNull
    public static PsiElement getTopElement(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            JSInjectionUtil.$$$reportNull$$$0(0);
        }
        PsiLanguageInjectionHost parent = host;
        while (parent.getParent() instanceof JSBinaryExpression && ((JSBinaryExpression)parent.getParent()).getOperationSign() == JSTokenTypes.PLUS || parent.getParent() instanceof JSParenthesizedExpression) {
            parent = parent.getParent();
        }
        PsiLanguageInjectionHost psiLanguageInjectionHost = parent;
        if (psiLanguageInjectionHost == null) {
            JSInjectionUtil.$$$reportNull$$$0(1);
        }
        return psiLanguageInjectionHost;
    }

    @NotNull
    public static List<JSLiteralExpression> getConcatenationParts(@NotNull PsiElement topElement) {
        if (topElement == null) {
            JSInjectionUtil.$$$reportNull$$$0(2);
        }
        if (topElement instanceof JSLiteralExpression) {
            List<JSLiteralExpression> list2 = Collections.singletonList((JSLiteralExpression)topElement);
            if (list2 == null) {
                JSInjectionUtil.$$$reportNull$$$0(3);
            }
            return list2;
        }
        final ArrayList<JSLiteralExpression> results = new ArrayList<JSLiteralExpression>();
        topElement.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof JSBinaryExpression && ((JSBinaryExpression)element).getOperationSign() == JSTokenTypes.PLUS || element instanceof JSParenthesizedExpression) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (node.isQuotedLiteral()) {
                    results.add(node);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/injections/JSInjectionUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSLiteralExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList<JSLiteralExpression> arrayList = results;
        if (arrayList == null) {
            JSInjectionUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public static String getConcatenationText(@NotNull List<? extends JSLiteralExpression> parts) {
        if (parts == null) {
            JSInjectionUtil.$$$reportNull$$$0(5);
        }
        String string = StringUtil.join(parts, JSInjectionUtil::getQuotedLiteralText, (String)"");
        if (string == null) {
            JSInjectionUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getConcatenationText(@NotNull PsiElement topElement) {
        if (topElement == null) {
            JSInjectionUtil.$$$reportNull$$$0(7);
        }
        return JSInjectionUtil.getConcatenationText(JSInjectionUtil.getConcatenationParts(topElement));
    }

    @NotNull
    private static List<PlaceInfo> getConcatenationPlaces(@NotNull List<JSLiteralExpression> parts, @Nullable Language language, @Nullable String prefix, @Nullable String suffix) {
        if (parts == null) {
            JSInjectionUtil.$$$reportNull$$$0(8);
        }
        ArrayList<PlaceInfo> result2 = new ArrayList<PlaceInfo>(parts.size());
        for (int i = 0; i < parts.size(); ++i) {
            JSLiteralExpression literalExpression = parts.get(i);
            result2.addAll(JSInjectionUtil.getQuotedLiteralPlaces(literalExpression, language, i == 0 ? prefix : null, i == parts.size() - 1 ? suffix : null));
        }
        ArrayList<PlaceInfo> arrayList = result2;
        if (arrayList == null) {
            JSInjectionUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public static List<PlaceInfo> injectInQuotedLiteral(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull JSLiteralExpression literalExpression, @Nullable String prefix, @Nullable String suffix) {
        if (registrar == null) {
            JSInjectionUtil.$$$reportNull$$$0(10);
        }
        if (language == null) {
            JSInjectionUtil.$$$reportNull$$$0(11);
        }
        if (literalExpression == null) {
            JSInjectionUtil.$$$reportNull$$$0(12);
        }
        return JSInjectionUtil.injectInQuotedLiteral(registrar, language, null, literalExpression, prefix, suffix);
    }

    @NotNull
    public static List<PlaceInfo> injectInQuotedLiteral(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @Nullable String extension, @NotNull JSLiteralExpression literalExpression, @Nullable String prefix, @Nullable String suffix) {
        List<PlaceInfo> places;
        if (registrar == null) {
            JSInjectionUtil.$$$reportNull$$$0(13);
        }
        if (language == null) {
            JSInjectionUtil.$$$reportNull$$$0(14);
        }
        if (literalExpression == null) {
            JSInjectionUtil.$$$reportNull$$$0(15);
        }
        if (!(places = JSInjectionUtil.getQuotedLiteralPlaces(literalExpression, language, prefix, suffix)).isEmpty()) {
            registrar.startInjecting(language, extension);
            JSInjectionUtil.injectForPlaces(registrar, places);
            registrar.doneInjecting();
        }
        List<PlaceInfo> list2 = places;
        if (list2 == null) {
            JSInjectionUtil.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    public static List<PlaceInfo> concatenationAwareInject(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull List<JSLiteralExpression> parts, @NotNull PsiElement contextElement, @Nullable String prefix, @Nullable String suffix) {
        List<PlaceInfo> places;
        if (registrar == null) {
            JSInjectionUtil.$$$reportNull$$$0(17);
        }
        if (language == null) {
            JSInjectionUtil.$$$reportNull$$$0(18);
        }
        if (parts == null) {
            JSInjectionUtil.$$$reportNull$$$0(19);
        }
        if (contextElement == null) {
            JSInjectionUtil.$$$reportNull$$$0(20);
        }
        if ((places = JSInjectionUtil.getConcatenationPlaces(parts, language, prefix, suffix)).isEmpty()) {
            List<PlaceInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                JSInjectionUtil.$$$reportNull$$$0(21);
            }
            return list2;
        }
        if (!ContainerUtil.exists(places, place -> PsiTreeUtil.isAncestor((PsiElement)contextElement, (PsiElement)place.getHost(), (boolean)false))) {
            List<PlaceInfo> list3 = Collections.emptyList();
            if (list3 == null) {
                JSInjectionUtil.$$$reportNull$$$0(22);
            }
            return list3;
        }
        registrar.startInjecting(language);
        JSInjectionUtil.injectForPlaces(registrar, places);
        registrar.doneInjecting();
        List<PlaceInfo> list4 = places;
        if (list4 == null) {
            JSInjectionUtil.$$$reportNull$$$0(23);
        }
        return list4;
    }

    private static void injectForPlaces(@NotNull MultiHostRegistrar registrar, @NotNull List<PlaceInfo> places) {
        if (registrar == null) {
            JSInjectionUtil.$$$reportNull$$$0(24);
        }
        if (places == null) {
            JSInjectionUtil.$$$reportNull$$$0(25);
        }
        for (PlaceInfo place : places) {
            registrar.addPlace(place.getPrefix(), place.getSuffix(), place.getHost(), place.getRange());
        }
    }

    @NotNull
    public static String getQuotedLiteralText(@NotNull JSLiteralExpression literalExpression) {
        if (literalExpression == null) {
            JSInjectionUtil.$$$reportNull$$$0(26);
        }
        String text2 = literalExpression.getText();
        StringBuilder result2 = new StringBuilder();
        for (PlaceInfo place : JSInjectionUtil.getQuotedLiteralPlaces(literalExpression, null, null, null)) {
            if (place.getPrefix() != null) {
                result2.append(place.getPrefix());
            }
            result2.append(text2, place.getRange().getStartOffset(), place.getRange().getEndOffset());
            if (place.getSuffix() == null) continue;
            result2.append(place.getSuffix());
        }
        String string = result2.toString();
        if (string == null) {
            JSInjectionUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static List<PlaceInfo> getQuotedLiteralPlaces(@NotNull JSLiteralExpression literalExpression, @Nullable Language language, @Nullable String injectionPrefix, @Nullable String injectionSuffix) {
        if (literalExpression == null) {
            JSInjectionUtil.$$$reportNull$$$0(28);
        }
        PsiLanguageInjectionHost injectionHost = (PsiLanguageInjectionHost)literalExpression;
        if (literalExpression instanceof JSStringTemplateExpression) {
            JSStringTemplateExpression templateExpression = (JSStringTemplateExpression)literalExpression;
            Object[] ranges = templateExpression.getStringRangesWithEmpty();
            JSExpression[] arguments = templateExpression.getArguments();
            if (arguments.length > 0 && ContainerUtil.and((Object[])ranges, TextRange::isEmpty)) {
                List list2 = ContainerUtil.emptyList();
                if (list2 == null) {
                    JSInjectionUtil.$$$reportNull$$$0(29);
                }
                return list2;
            }
            ArrayList<PlaceInfo> result2 = new ArrayList<PlaceInfo>(ranges.length);
            for (int i = 0; i < ranges.length; ++i) {
                Object range = ranges[i];
                JSExpression argument = i < arguments.length ? arguments[i] : null;
                String placeholder = JSInjectionUtil.getPlaceholder(argument, language, i);
                String prefix = i == 0 ? injectionPrefix : null;
                String suffix = i == ranges.length - 1 ? injectionSuffix : placeholder;
                result2.add(new PlaceInfo(prefix, (TextRange)range, suffix, injectionHost));
            }
            ArrayList<PlaceInfo> arrayList = result2;
            if (arrayList == null) {
                JSInjectionUtil.$$$reportNull$$$0(30);
            }
            return arrayList;
        }
        int endOffset = Math.max(literalExpression.getTextLength() - 1, 1);
        List<PlaceInfo> list3 = Collections.singletonList(new PlaceInfo(injectionPrefix, TextRange.create((int)1, (int)endOffset), injectionSuffix, injectionHost));
        if (list3 == null) {
            JSInjectionUtil.$$$reportNull$$$0(31);
        }
        return list3;
    }

    @NotNull
    private static String getPlaceholder(@Nullable JSExpression argument, @Nullable Language language, int index) {
        String referenceName;
        Object value;
        if (argument instanceof JSLiteralExpression && (value = ((JSLiteralExpression)argument).getValue()) != null) {
            String string = value.toString();
            if (string == null) {
                JSInjectionUtil.$$$reportNull$$$0(32);
            }
            return string;
        }
        if (language != null && StringUtil.containsIgnoreCase((String)language.getDisplayName(), (String)"SQL")) {
            referenceName = JSInjectionUtil.getPlaceholderForDynamicExpression(argument);
            if (referenceName != null) {
                String string = "${" + referenceName + "}";
                if (string == null) {
                    JSInjectionUtil.$$$reportNull$$$0(33);
                }
                return string;
            }
            String string = "${p" + index + "}";
            if (string == null) {
                JSInjectionUtil.$$$reportNull$$$0(34);
            }
            return string;
        }
        referenceName = JSInjectionUtil.getPlaceholderForDynamicExpression(argument);
        if (referenceName != null) {
            String string = referenceName;
            if (string == null) {
                JSInjectionUtil.$$$reportNull$$$0(35);
            }
            return string;
        }
        return EXTERNAL_FRAGMENT;
    }

    @Nullable
    private static String getPlaceholderForDynamicExpression(@Nullable JSExpression argument) {
        String referenceName;
        if (argument instanceof JSReferenceExpression && ((JSReferenceExpression)argument).getQualifier() == null && (referenceName = ((JSReferenceExpression)argument).getReferenceName()) != null) {
            return referenceName;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 6, 9, 16, 21, 22, 23, 27, 29, 30, 31, 32, 33, 34, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/injections/JSInjectionUtil";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topElement";
                break;
            }
            case 5: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 10: 
            case 13: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 12: 
            case 15: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/injections/JSInjectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenationParts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenationText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenationPlaces";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "injectInQuotedLiteral";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "concatenationAwareInject";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuotedLiteralText";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuotedLiteralPlaces";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTopElement";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenationParts";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenationText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenationPlaces";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "injectInQuotedLiteral";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "concatenationAwareInject";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "injectForPlaces";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getQuotedLiteralText";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getQuotedLiteralPlaces";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 6, 9, 16, 21, 22, 23, 27, 29, 30, 31, 32, 33, 34, 35 -> new IllegalStateException(string);
        };
    }

    public static class PlaceInfo {
        private final String myPrefix;
        private final TextRange myRange;
        private final String mySuffix;
        private final PsiLanguageInjectionHost myHost;

        public PlaceInfo(@Nullable String prefix, @NotNull TextRange range, @Nullable String suffix, @NotNull PsiLanguageInjectionHost host) {
            if (range == null) {
                PlaceInfo.$$$reportNull$$$0(0);
            }
            if (host == null) {
                PlaceInfo.$$$reportNull$$$0(1);
            }
            this.myPrefix = prefix;
            this.myRange = range;
            this.mySuffix = suffix;
            this.myHost = host;
        }

        @Nullable
        public String getPrefix() {
            return this.myPrefix;
        }

        @Nullable
        public String getSuffix() {
            return this.mySuffix;
        }

        @NotNull
        public TextRange getRange() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                PlaceInfo.$$$reportNull$$$0(2);
            }
            return textRange;
        }

        @NotNull
        public PsiLanguageInjectionHost getHost() {
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
            if (psiLanguageInjectionHost == null) {
                PlaceInfo.$$$reportNull$$$0(3);
            }
            return psiLanguageInjectionHost;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/injections/JSInjectionUtil$PlaceInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/injections/JSInjectionUtil$PlaceInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHost";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

