/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSInheritanceCallEvaluator;
import com.intellij.lang.javascript.index.JSLocalNamespaceEvaluator;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReferenceItem;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.types.JSLiteralExpressionElementType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSSymbolUtil {
    @NonNls
    public static final String J_QUERY_VAR_NAME = "jQuery";
    @NonNls
    static final String FN_FUN_NAME = "fn";
    @NonNls
    public static final String YAHOO_NAME = "YAHOO";
    public static final String WINDOW_OBJECT_NAME = "window";
    public static final String NODE_GLOBAL_OBJECT_NAME = "global";
    public static final String GLOBAL_OBJECT_NAME3 = "GLOBAL";
    public static final String SELF_OBJECT_NAME = "self";
    public static final String GLOBAL_THIS_NAME = "globalThis";
    public static final Collection<String> GLOBAL_TYPE_QUALIFIED_NAMES = List.of("Window", "NodeJS.Global");
    public static final Collection<JSQualifiedName> GLOBAL_TYPES = ContainerUtil.map(GLOBAL_TYPE_QUALIFIED_NAMES, JSQualifiedNameImpl::fromQualifiedName);
    public static final Set<String> GLOBAL_OBJECT_NAMES = Set.of("window", "global", "GLOBAL", "globalThis");
    public static final String EXPORTS = "exports";
    public static final String MODULE = "module";
    public static final String MODULE_EXPORTS = "module.exports";
    public static final String DEFINE_METHOD_NAME = "define";
    public static final String REQUIRE_METHOD_NAME = "require";
    public static final String DECLARE_METHOD_NAME = "declare";
    public static final String REGEXP_RESULT_GROUPS_PROPERTY_NAME = "groups";
    public static final String BIND_FUNCTION_NAME = "bind";
    public static final String WEBPACK_EXTEND_METHOD_NAME = "exportPlugins";

    public static JSExpression[] findClassesNames(JSExpression value) {
        JSExpression firstArg;
        JSExpression[] arguments;
        JSArgumentList list2;
        if (value instanceof JSReferenceExpression || value instanceof JSLiteralExpression) {
            return new JSExpression[]{value};
        }
        if (value instanceof JSArrayLiteralExpression) {
            return ((JSArrayLiteralExpression)value).getExpressions();
        }
        if (value instanceof JSCallExpression && (list2 = ((JSCallExpression)value).getArgumentList()) != null && (arguments = list2.getArguments()).length > 0 && (firstArg = arguments[0]) instanceof JSObjectLiteralExpression) {
            JSProperty[] properties = ((JSObjectLiteralExpression)firstArg).getProperties();
            JSExpression[] extendList = new JSExpression[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                extendList[i] = properties[i].getValue();
            }
            return extendList;
        }
        return JSExpression.EMPTY_ARRAY;
    }

    public static boolean isDefinitelyConstructor(@Nullable PsiElement resolve) {
        if (resolve == null) {
            return false;
        }
        JSFunctionItem functionItem = JSPsiImplUtils.calculatePossibleFunction(resolve, null, true);
        if (functionItem instanceof JSFunction) {
            return ((JSFunction)functionItem).isConstructor();
        }
        JSDocComment docComment = JSStubBasedPsiTreeUtil.findDocComment(resolve);
        if (docComment != null && docComment.isClassExplicitly()) {
            return true;
        }
        if (resolve instanceof JSInitializerOwner) {
            resolve = ((JSInitializerOwner)resolve).getInitializerOrStub();
        }
        return resolve instanceof JSClass;
    }

    public static boolean isConstructorName(String name) {
        if ("constructor".equals(name)) {
            return true;
        }
        return name != null && !name.isEmpty() && Character.isUpperCase(name.charAt(0));
    }

    public static boolean isConstructorSymbol(@NotNull JSPsiElementBase function2) {
        if (function2 == null) {
            JSSymbolUtil.$$$reportNull$$$0(0);
        }
        if (JSResolveUtil.isConstructorFunction((PsiElement)function2)) {
            return true;
        }
        if (JSClassUtils.isClassMember((PsiElement)function2)) {
            return false;
        }
        return JSSymbolUtil.isConstructorName(function2.getName());
    }

    public static void forEachIdentifierProperty(JSObjectLiteralExpression value, PropertyProcessor propertyProcessor) {
        for (JSProperty property : value.getProperties()) {
            String s = property.getName();
            if (s == null || s.length() <= 0 || !StringUtil.isJavaIdentifier((String)s)) continue;
            propertyProcessor.process(StringUtil.toTitleCase((String)s), property);
        }
    }

    @NonNls
    public static String suggestSetterName(String propertyName) {
        return "set" + StringUtil.capitalize((String)propertyName);
    }

    @NonNls
    public static String suggestGetterName(String propertyName) {
        return "get" + StringUtil.capitalize((String)propertyName);
    }

    static JSElement findNameComponent(JSElement expr) {
        if (expr instanceof JSReferenceExpression) {
            return expr;
        }
        JSElement current = expr;
        while (expr != null) {
            PsiElement parent;
            if (expr instanceof JSReferenceExpression) {
                return expr;
            }
            if (expr instanceof JSAssignmentExpression) {
                JSExpression lOperand;
                JSExpression _lOperand = ((JSAssignmentExpression)expr).getLOperand();
                if (!(_lOperand instanceof JSDefinitionExpression) || !((lOperand = ((JSDefinitionExpression)_lOperand).getExpression()) instanceof JSReferenceExpression)) break;
                expr = lOperand;
                continue;
            }
            if (expr instanceof JSVariable) {
                return expr;
            }
            if (expr instanceof JSCallExpression) {
                JSExpression method = ((JSCallExpression)expr).getMethodExpression();
                if (method instanceof JSReferenceExpression) {
                    return method;
                }
            } else {
                current = expr;
            }
            if (!((parent = current.getParent()) instanceof JSElement) || parent instanceof JSStatement) break;
            expr = (JSElement)parent;
        }
        return null;
    }

    @NotNull
    public static List<String> buildNameIndexArray(JSElement _expr) {
        final ArrayList<String> nameComponents = new ArrayList<String>();
        JSElement nameComponent = JSSymbolUtil.findNameComponent(_expr);
        JSReferenceExpression expr = null;
        if (nameComponent instanceof JSVariable) {
            String varName = nameComponent.getName();
            if (varName != null) {
                nameComponents.add(varName);
            }
        } else if (nameComponent instanceof JSReferenceExpression) {
            expr = (JSReferenceExpression)nameComponent;
        }
        if (expr != null) {
            final JSReferenceExpression expr1 = expr;
            JSSymbolUtil.visitReferenceExpressionComponentsInRootFirstOrder(expr, new ReferenceExpressionProcessor(){

                @Override
                public void processExpression(JSReferenceExpression expr) {
                    JSNamespace predefinedType = JSSymbolUtil.getPredefinedNamespace(expr);
                    String name = predefinedType != null ? predefinedType.getTypeText(JSType.TypeTextFormat.SIMPLE) : expr.getReferenceName();
                    nameComponents.add(name);
                }

                @Override
                public void processUnresolvedThis() {
                    nameComponents.add("");
                }

                @Override
                public boolean isTopLevel(JSReferenceExpression expression) {
                    return expr1 == expression;
                }
            });
        }
        ArrayList<String> arrayList = nameComponents;
        if (arrayList == null) {
            JSSymbolUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static String quoteIfSpecialPropertyName(@NotNull String name, boolean isPrivateName, char quote) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(2);
        }
        if (isPrivateName) {
            String string = name;
            if (string == null) {
                JSSymbolUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (name.startsWith("[Symbol.")) {
            String string = name;
            if (string == null) {
                JSSymbolUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (!JSSymbolUtil.isValidPropertyName(name)) {
            StringBuilder builder2 = new StringBuilder();
            builder2.append(quote);
            JSStringUtil.escapeSimpleStringChars(name, quote, true, false, false, builder2);
            builder2.append(quote);
            String string = builder2.toString();
            if (string == null) {
                JSSymbolUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            JSSymbolUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static boolean isUndefinedExpression(@Nullable JSExpression operand) {
        if (!(operand instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)operand;
        if (referenceExpression.getQualifier() != null) {
            return false;
        }
        return "undefined".equals(referenceExpression.getText());
    }

    public static boolean isNullLiteral(@Nullable JSExpression initializer) {
        return initializer instanceof JSLiteralExpression && initializer.getNode().findChildByType(JSTokenTypes.NULL_KEYWORD) != null;
    }

    public static boolean canElementBeFromAnyNamespace(@NotNull JSPsiElementBase element) {
        JSNamespace namespace;
        if (element == null) {
            JSSymbolUtil.$$$reportNull$$$0(7);
        }
        return !(namespace = element.getJSNamespace()).isSourceStrict() || namespace instanceof JSAnyType;
    }

    public static boolean canElementsBeFromSameNamespace(@NotNull JSPsiElementBase element1, @NotNull JSPsiElementBase element2) {
        if (element1 == null) {
            JSSymbolUtil.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            JSSymbolUtil.$$$reportNull$$$0(9);
        }
        return JSSymbolUtil.canElementBeFromAnyNamespace(element1) || JSSymbolUtil.canElementBeFromAnyNamespace(element2) || JSSymbolUtil.areElementsFromSameNamespace(element1, element2);
    }

    public static boolean areElementsFromSameNamespace(@NotNull JSPsiElementBase element1, @NotNull JSPsiElementBase element2) {
        if (element1 == null) {
            JSSymbolUtil.$$$reportNull$$$0(10);
        }
        if (element2 == null) {
            JSSymbolUtil.$$$reportNull$$$0(11);
        }
        JSNamespace ns1 = element1.getJSNamespace();
        JSNamespace ns2 = element2.getJSNamespace();
        if (!ComparatorUtil.equalsNullable((Object)ns1.getQualifiedName(), (Object)ns2.getQualifiedName())) {
            return false;
        }
        if (!ns1.getJSContext().isCompatibleWith(ns2.getJSContext())) {
            return false;
        }
        if (ns1.isLocal()) {
            if (!ns2.isLocal()) {
                return false;
            }
            PsiElement localScope1 = ns1.getLocalScope();
            if (localScope1 == null || !localScope1.isEquivalentTo(ns2.getLocalScope())) {
                return false;
            }
        }
        return true;
    }

    private static int findParameterIndex(@NotNull JSFunction function2, @Nullable JSParameter parameter) {
        if (function2 == null) {
            JSSymbolUtil.$$$reportNull$$$0(12);
        }
        JSParameter[] parameters = function2.getParameterVariables();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] != parameter) continue;
            return i;
        }
        return -1;
    }

    public static boolean isExportsOrGlobalNamespace(@Nullable JSQualifiedName namespace) {
        if (namespace == null) {
            return false;
        }
        String name = namespace.getQualifiedName();
        return EXPORTS.equals(name) || MODULE_EXPORTS.equals(name) || GLOBAL_OBJECT_NAMES.contains(name) || GLOBAL_TYPES.contains(namespace);
    }

    public static boolean isGlobalNamedType(@NotNull JSType type2) {
        if (type2 == null) {
            JSSymbolUtil.$$$reportNull$$$0(13);
        }
        if (type2 instanceof JSReferenceType) {
            return GLOBAL_OBJECT_NAMES.contains(((JSReferenceType)type2).getReferenceName());
        }
        if (type2 instanceof JSTypeImpl) {
            JSContext jsContext = ((JSTypeImpl)type2).getJSContext();
            return jsContext == JSContext.INSTANCE && GLOBAL_TYPE_QUALIFIED_NAMES.contains(type2.getTypeText(JSType.TypeTextFormat.SIMPLE)) || jsContext == JSContext.STATIC && GLOBAL_OBJECT_NAMES.contains(type2.getTypeText(JSType.TypeTextFormat.SIMPLE));
        }
        return false;
    }

    static void visitReferenceExpressionComponentsInRootFirstOrder(JSReferenceExpression expr, ReferenceExpressionProcessor processor) {
        String refName;
        JSExpression qualifier = expr.getQualifier();
        if (qualifier instanceof JSCallExpression) {
            qualifier = ((JSCallExpression)qualifier).getMethodExpression();
        }
        if (qualifier instanceof JSIndexedPropertyAccessExpression) {
            qualifier = ((JSIndexedPropertyAccessExpression)qualifier).getQualifier();
        }
        if (qualifier instanceof JSReferenceExpression) {
            JSSymbolUtil.visitReferenceExpressionComponentsInRootFirstOrder((JSReferenceExpression)qualifier, processor);
        }
        if (qualifier instanceof JSThisExpression) {
            processor.processUnresolvedThis();
        }
        if ((refName = expr.getReferenceName()) != null && (!refName.equals("prototype") || processor.isTopLevel(expr))) {
            processor.processExpression(expr);
        }
    }

    public static boolean binaryOpTypeToAvoidRecursions(IElementType sign) {
        return sign == JSTokenTypes.PLUS || sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.COMMA;
    }

    public static boolean isMeaningfulLocalVariableInitializer(JSExpression initializer) {
        return initializer instanceof JSFunction || initializer instanceof JSObjectLiteralExpression;
    }

    public static boolean referencesInterface(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            JSSymbolUtil.$$$reportNull$$$0(14);
        }
        return ContainerUtil.or(JSResolveResult.toElements(ref.multiResolve(false)), e -> e instanceof JSPsiElementBase && ((JSPsiElementBase)e).isClassOrInterface() == JSElementBase.ClassOrInterface.INTERFACE);
    }

    public static boolean isInterface(@NotNull String name, PsiElement context2) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(15);
        }
        return JSClassIndex.isInterface(name, context2, !DialectDetector.isTypeScript(context2));
    }

    @Nullable
    public static JSNamespace evaluateInitializedPrototype(JSExpression initializer, @NotNull Ref<JSReferenceExpression> outSourceReference) {
        JSNamespace ns;
        JSNamespace predefinedNamespace;
        if (outSourceReference == null) {
            JSSymbolUtil.$$$reportNull$$$0(16);
        }
        if (initializer instanceof JSParenthesizedExpression) {
            initializer = JSUtils.unparenthesize(initializer);
        }
        JSReferenceExpression initializedPrototype = null;
        JSTypeContext typeContext = JSTypeContext.UNKNOWN;
        if (initializer instanceof JSReferenceExpression && (predefinedNamespace = JSSymbolUtil.getPredefinedNamespace((JSReferenceExpression)initializer)) != null) {
            outSourceReference.set((Object)((JSReferenceExpression)initializer));
            return predefinedNamespace;
        }
        if (initializer instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)initializer).getReferenceName())) {
            JSExpression qualifier = ((JSReferenceExpression)initializer).getQualifier();
            if (qualifier instanceof JSReferenceExpression) {
                initializedPrototype = (JSReferenceExpression)qualifier;
                typeContext = JSTypeContext.PROTOTYPE;
            }
        } else if (initializer instanceof JSAssignmentExpression) {
            JSExpression initializerlOperand = ((JSAssignmentExpression)initializer).getLOperand();
            if (initializerlOperand instanceof JSDefinitionExpression) {
                JSExpression lOperand = ((JSDefinitionExpression)initializerlOperand).getExpression();
                typeContext = JSTypeContext.STATIC;
                JSSymbolUtil.evaluateInitializedPrototype(lOperand, outSourceReference);
                initializedPrototype = (JSReferenceExpression)outSourceReference.get();
                if (initializedPrototype == null && lOperand instanceof JSReferenceExpression && ((JSReferenceExpression)lOperand).getQualifier() instanceof JSReferenceExpression) {
                    initializedPrototype = (JSReferenceExpression)lOperand;
                }
            }
        } else if (initializer instanceof JSThisExpression && (ns = JSContextResolver.resolveContext((PsiElement)initializer)) != null) {
            return ns;
        }
        if (initializedPrototype == null) {
            return null;
        }
        outSourceReference.set(initializedPrototype);
        return JSSymbolUtil.createNamespaceFromReferenceExpression(initializedPrototype, typeContext.toJSContext(), true);
    }

    @Nullable
    public static JSNamespace getPredefinedNamespace(JSReferenceExpression expression) {
        if (JSSymbolUtil.isAccurateReferenceExpressionName(expression, WINDOW_OBJECT_NAME)) {
            return JSSymbolUtil.createPredefinedNamespace((PsiElement)expression, JSQualifiedNameImpl.create("Window", null));
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName(expression, NODE_GLOBAL_OBJECT_NAME)) {
            return JSSymbolUtil.createPredefinedNamespace((PsiElement)expression, JSQualifiedNameImpl.fromQualifiedName("NodeJS.Global"));
        }
        return null;
    }

    @Nullable
    public static JSNamespace getPredefinedNamespaceForUnresolvedReference(JSReferenceExpression expression) {
        if (JSSymbolUtil.isAccurateReferenceExpressionName(expression, SELF_OBJECT_NAME)) {
            return JSSymbolUtil.createPredefinedNamespace((PsiElement)expression, JSQualifiedNameImpl.create("Window", null));
        }
        return null;
    }

    @NotNull
    private static JSNamespace createPredefinedNamespace(@Nullable PsiElement source, @NotNull JSQualifiedName name) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(17);
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(name, JSTypeSourceFactory.createTypeSource(source, true), JSTypeContext.PROTOTYPE, false);
        if (jSNamespace == null) {
            JSSymbolUtil.$$$reportNull$$$0(18);
        }
        return jSNamespace;
    }

    @Nullable
    public static JSNamespace evaluateNamespaceLocally(@Nullable JSExpression expression) {
        return JSSymbolUtil.evaluateNamespaceLocally(expression, null);
    }

    @Nullable
    public static JSNamespace evaluateNamespaceLocally(@Nullable JSExpression expression, @Nullable Set<PsiElement> visited) {
        return new JSLocalNamespaceEvaluator(visited).evaluateNamespaceLocally(expression);
    }

    public static boolean isLiteralOrLiteralWithSign(@Nullable JSExpression expression) {
        IElementType sign;
        if (expression instanceof JSLiteralExpression) {
            return true;
        }
        if (expression instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)expression).getOperationSign()) == JSTokenTypes.PLUS || sign == JSTokenTypes.MINUS)) {
            return ((JSPrefixExpression)expression).getExpression() instanceof JSLiteralExpression;
        }
        return false;
    }

    public static boolean typeMayBeInlined(@NotNull ASTNode expression) {
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(19);
        }
        return expression.getElementType() instanceof JSLiteralExpressionElementType;
    }

    @Nullable
    public static JSPsiNamedElementBase resolveLocallyIncludingDefinitions(@NotNull String name, @NotNull JSElement context2) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(20);
        }
        if (context2 == null) {
            JSSymbolUtil.$$$reportNull$$$0(21);
        }
        PsiElement parent = context2.getParent();
        ASTNode node = context2.getNode();
        JSTreeUtil.JSScopeDeclarationsAndAssignments up = JSTreeUtil.getDeclarationsAndAssignmentsInScopeAndUp(name, node);
        if (up == null) {
            return null;
        }
        CompositeElement definition2 = up.findNearestDefinition(node);
        if (definition2 == null) {
            return null;
        }
        PsiElement jsElement2 = definition2.getPsi();
        if (jsElement2 == null && parent instanceof JSDefinitionExpression) {
            jsElement2 = parent;
        }
        return (JSPsiNamedElementBase)jsElement2;
    }

    @Nullable
    public static JSNamespace evalThis(JSThisExpression expressionToFollow, @NotNull Ref<JSReferenceExpression> outSourceReference) {
        JSNamespace ns;
        if (outSourceReference == null) {
            JSSymbolUtil.$$$reportNull$$$0(22);
        }
        if ((ns = JSContextResolver.resolveContext((PsiElement)expressionToFollow)) != null) {
            return ns;
        }
        ns = JSSymbolUtil.evaluateInitializedPrototype(expressionToFollow, outSourceReference);
        if (ns != null) {
            return (JSNamespace)ns.copyWithStrict(true);
        }
        boolean thisIsGlobal = false;
        JSFunction function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expressionToFollow, JSFunction.class);
        if (function2 == null || function2.isAnonymousFunctionCall()) {
            thisIsGlobal = true;
        } else if (function2 instanceof JSFunctionExpression) {
            PsiElement functionParent = function2.getParent();
            if (functionParent instanceof JSParenthesizedExpression) {
                functionParent = functionParent.getParent();
            }
            if (functionParent instanceof JSReferenceExpression && "call".equals(((JSReferenceExpression)functionParent).getReferenceName())) {
                PsiElement prevParent = functionParent;
                if ((functionParent = functionParent.getParent()) instanceof JSCallExpression && ((JSCallExpression)functionParent).getMethodExpression() == prevParent) {
                    JSExpression[] arguments = ((JSCallExpression)functionParent).getArguments();
                    if (arguments.length > 0) {
                        ns = JSSymbolUtil.evaluateInitializedPrototype(arguments[0], outSourceReference);
                        if (outSourceReference.isNull() && arguments[0] instanceof JSThisExpression && PsiTreeUtil.getParentOfType((PsiElement)arguments[0], (Class[])new Class[]{JSFunction.class, JSObjectLiteralExpression.class}) == null) {
                            thisIsGlobal = true;
                        }
                    } else {
                        thisIsGlobal = true;
                    }
                }
            }
        }
        if (thisIsGlobal) {
            return JSNamedTypeFactory.createNamespace(null, JSContext.STATIC, (PsiElement)expressionToFollow, true, true);
        }
        return ns;
    }

    @Contract(value="null -> false")
    public static boolean isAccurateReferenceExpression(@Nullable JSExpression initializer) {
        return initializer instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpression((JSReferenceExpression)initializer);
    }

    public static boolean isAccurateReferenceExpression(@NotNull JSReferenceExpression initializer) {
        if (initializer == null) {
            JSSymbolUtil.$$$reportNull$$$0(23);
        }
        JSExpression initializerQualifier = initializer.getQualifier();
        while (initializerQualifier instanceof JSReferenceExpression) {
            initializerQualifier = ((JSReferenceExpression)initializerQualifier).getQualifier();
        }
        return initializerQualifier == null;
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSExpression expression, String ... components) {
        return expression instanceof JSReferenceItem && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceItem)((Object)expression), components);
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSExpression expression, String name) {
        return expression instanceof JSReferenceItem && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceItem)((Object)expression), name);
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSReferenceExpression expression, String ... components) {
        return expression != null && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceItem)expression, components);
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSReferenceExpression expression, String name) {
        return expression != null && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceItem)expression, name);
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSReferenceItem referenceExpression, String name) {
        return referenceExpression != null && !referenceExpression.hasQualifier() && StringUtil.equals((CharSequence)referenceExpression.getReferenceName(), (CharSequence)name);
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSReferenceItem referenceExpression, String ... components) {
        JSReferenceItem ref = referenceExpression;
        int i = components.length - 1;
        while (ref != null) {
            if (i < 0) {
                return false;
            }
            if (!StringUtil.equals((CharSequence)ref.getReferenceName(), (CharSequence)components[i])) {
                return false;
            }
            ref = ref.getReferenceItemQualifier();
            --i;
        }
        return i == -1;
    }

    public static boolean isAccurateReferenceExpressionName(@NotNull ASTNode referenceExpression, String ... components) {
        if (referenceExpression == null) {
            JSSymbolUtil.$$$reportNull$$$0(24);
        }
        ASTNode ref = referenceExpression;
        int i = components.length - 1;
        while (ref != null) {
            if (i < 0) {
                return false;
            }
            if (ref.getElementType() != JSElementTypes.REFERENCE_EXPRESSION) {
                return false;
            }
            if (!StringUtil.equals((CharSequence)JSReferenceExpressionImpl.getReferenceName(ref), (CharSequence)components[i])) {
                return false;
            }
            ref = JSReferenceExpressionImpl.getQualifierNode(ref);
            --i;
        }
        return i == -1;
    }

    public static List<String> getReferenceParts(@NotNull JSExpression referenceOrIndexedAccessExpression) {
        if (referenceOrIndexedAccessExpression == null) {
            JSSymbolUtil.$$$reportNull$$$0(25);
        }
        SmartList nameParts = new SmartList();
        JSExpression ref = referenceOrIndexedAccessExpression;
        while (ref != null) {
            if (ref instanceof JSReferenceExpression) {
                JSReferenceExpression reference = (JSReferenceExpression)ref;
                String name = reference.getReferenceName();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return null;
                }
                nameParts.add(name);
                ref = reference.getQualifier();
                continue;
            }
            if (ref instanceof JSIndexedPropertyAccessExpression) {
                JSIndexedPropertyAccessExpression indexedAccessExpression = (JSIndexedPropertyAccessExpression)ref;
                JSExpression indexExpression = indexedAccessExpression.getIndexExpression();
                if (indexExpression == null) {
                    return null;
                }
                String indexText = indexExpression.getText();
                if (StringUtil.isEmptyOrSpaces((String)indexText)) {
                    return null;
                }
                nameParts.add("[" + indexText + "]");
                ref = indexedAccessExpression.getQualifier();
                continue;
            }
            return null;
        }
        assert (!nameParts.isEmpty());
        Collections.reverse(nameParts);
        return nameParts;
    }

    @Nullable
    public static JSQualifiedName getAccurateReferenceName(@NotNull PsiQualifiedReference reference) {
        String referenceName;
        if (reference == null) {
            JSSymbolUtil.$$$reportNull$$$0(26);
        }
        if ((referenceName = reference.getReferenceName()) == null) {
            return null;
        }
        PsiElement qualifier = reference.getQualifier();
        if (qualifier == null) {
            return JSQualifiedNameImpl.create(referenceName, null);
        }
        if (qualifier instanceof PsiQualifiedReference) {
            JSQualifiedName qualifierName = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)qualifier);
            return qualifierName != null ? JSQualifiedNameImpl.create(referenceName, qualifierName) : null;
        }
        return null;
    }

    @Nullable
    public static JSNamespace createNamespaceFromReferenceExpression(@NotNull JSReferenceExpression expression, JSContext jsContext, boolean isDeclaration) {
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(27);
        }
        return JSSymbolUtil.createNamespaceFromReferenceExpression(expression, jsContext, isDeclaration, false);
    }

    @Nullable
    public static JSNamespace createNamespaceFromReferenceExpression(@NotNull JSReferenceExpression expression, @NotNull JSContext jsContext, boolean isDeclaration, boolean explicitlyDeclared) {
        JSNamespace predefinedNs;
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(28);
        }
        if (jsContext == null) {
            JSSymbolUtil.$$$reportNull$$$0(29);
        }
        if ((predefinedNs = JSSymbolUtil.getPredefinedNamespace(expression)) != null) {
            return predefinedNs;
        }
        String name = expression.getReferenceName();
        if (JSSymbolUtil.isPrototype(name)) {
            JSExpression qualifier = expression.getQualifier();
            if (!(qualifier instanceof JSReferenceExpression)) {
                return null;
            }
            expression = (JSReferenceExpression)qualifier;
            jsContext = JSContext.INSTANCE;
            isDeclaration = true;
        }
        if (JSSymbolUtil.isExplicitExportReference(expression)) {
            return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(EXPORTS, null), jsContext, (PsiElement)expression, explicitlyDeclared, isDeclaration, true);
        }
        JSQualifiedName qualifiedName = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)expression);
        if (qualifiedName == null) {
            return null;
        }
        if (qualifiedName.getParent() != null && WINDOW_OBJECT_NAME.equals(JSQualifiedNameImpl.getTopmostParent(qualifiedName))) {
            List<String> components = qualifiedName.toComponents();
            components.set(0, "Window");
            qualifiedName = JSQualifiedNameImpl.fromComponents(components);
        }
        return JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, (PsiElement)expression, explicitlyDeclared, isDeclaration, false);
    }

    public static boolean isPrototype(String name) {
        return "prototype".equals(name) || FN_FUN_NAME.equals(name);
    }

    @Nullable
    public static JSQualifiedName evaluateReferencedNamespace(JSExpression expression) {
        JSNamespace namespace = JSSymbolUtil.evaluateReferencedNamespace(expression, false);
        return namespace == null ? null : namespace.getQualifiedName();
    }

    @Nullable
    public static JSNamespace evaluateReferencedNamespace(JSExpression expression, boolean evaluateThis) {
        SmartList components = new SmartList();
        boolean canBeEvaluated = true;
        JSContext context2 = JSContext.STATIC;
        while (canBeEvaluated) {
            JSNamespace result2;
            if (expression instanceof JSReferenceExpression) {
                JSNamespace ns = JSSymbolUtil.evaluateNamespaceLocally(expression);
                if (ns != null && ns.getQualifiedName() != null) {
                    JSSymbolUtil.addNamespaceComponents((List<String>)components, ns);
                    break;
                }
                String name = ((JSReferenceExpression)expression).getReferenceName();
                if (!"prototype".equals(name) && name != null) {
                    components.add(0, name);
                } else {
                    context2 = JSContext.INSTANCE;
                }
                expression = ((JSReferenceExpression)expression).getQualifier();
                continue;
            }
            if (expression instanceof JSIndexedPropertyAccessExpression) {
                String propertyName;
                JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression();
                if (indexExpression instanceof JSLiteralExpression && (propertyName = ((JSLiteralExpression)indexExpression).getValueAsPropertyName()) != null) {
                    components.add(0, propertyName);
                }
                expression = ((JSIndexedPropertyAccessExpression)expression).getQualifier();
                continue;
            }
            if (evaluateThis && expression instanceof JSThisExpression && (result2 = JSSymbolUtil.evaluateNamespaceLocally(expression)) != null) {
                JSSymbolUtil.addNamespaceComponents((List<String>)components, result2);
                JSContext jSContext = context2 = components.isEmpty() ? JSContext.INSTANCE : JSContext.STATIC;
            }
            if (expression == null || expression instanceof JSThisExpression) break;
            canBeEvaluated = false;
        }
        return canBeEvaluated ? JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromComponents((List<String>)components), context2, (PsiElement)expression, true) : null;
    }

    private static void addNamespaceComponents(@NotNull List<String> components, @NotNull JSNamespace ns) {
        JSQualifiedName name;
        if (components == null) {
            JSSymbolUtil.$$$reportNull$$$0(30);
        }
        if (ns == null) {
            JSSymbolUtil.$$$reportNull$$$0(31);
        }
        if ((name = ns.getQualifiedName()) == null) {
            return;
        }
        components.addAll(0, QualifiedName.fromDottedString((String)name.getQualifiedName()).getComponents());
    }

    @Nullable
    public static JSQualifiedName getReferencedNamespace(@NotNull JSExpression expression) {
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(32);
        }
        JSExpression qualifier = null;
        String name = null;
        if (expression instanceof JSReferenceExpression) {
            name = ((JSReferenceExpression)expression).getReferenceName();
            qualifier = ((JSReferenceExpression)expression).getQualifier();
        } else if (expression instanceof JSIndexedPropertyAccessExpression) {
            JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression();
            if (indexExpression instanceof JSLiteralExpression) {
                name = ((JSLiteralExpression)indexExpression).getValueAsPropertyName();
            }
            qualifier = ((JSIndexedPropertyAccessExpression)expression).getQualifier();
        }
        if (name == null) {
            return null;
        }
        if (qualifier == null) {
            return JSQualifiedNameImpl.create(name, null);
        }
        JSQualifiedName namespace = JSSymbolUtil.getReferencedNamespace(qualifier);
        return namespace != null && !"prototype".equals(name) ? JSQualifiedNameImpl.create(name, namespace) : namespace;
    }

    @Nullable
    public static JSQualifiedName getLiteralValueAsQualifiedName(@NotNull JSLiteralExpression literal) {
        if (literal == null) {
            JSSymbolUtil.$$$reportNull$$$0(33);
        }
        if (!literal.isQuotedLiteral() || literal.getTextLength() > 200) {
            return null;
        }
        String value = literal.getStringValue();
        if (value == null || StringUtil.containsWhitespaces((CharSequence)value)) {
            return null;
        }
        return JSQualifiedNameImpl.fromQualifiedName(value);
    }

    @Nullable
    public static JSExpression getFirstLiteralOrExprArg(@NotNull JSArgumentList parent) {
        if (parent == null) {
            JSSymbolUtil.$$$reportNull$$$0(34);
        }
        return JSSymbolUtil.getFirstLiteralOrExprArg(parent.getArguments());
    }

    @Nullable
    private static JSExpression getFirstLiteralOrExprArg(JSExpression @NotNull [] jsExpressions) {
        if (jsExpressions == null) {
            JSSymbolUtil.$$$reportNull$$$0(35);
        }
        for (JSExpression expr : jsExpressions) {
            if (expr instanceof JSReferenceExpression || expr instanceof JSLiteralExpression && !expr.textContains(' ') && expr.getTextLength() < 100) {
                return expr;
            }
            if (expr instanceof JSCallExpression) {
                JSArgumentList argumentList = ((JSCallExpression)expr).getArgumentList();
                if (argumentList == null) continue;
                return JSSymbolUtil.getFirstLiteralOrExprArg(argumentList.getArguments());
            }
            if (expr instanceof JSArrayLiteralExpression) {
                return JSSymbolUtil.getFirstLiteralOrExprArg(((JSArrayLiteralExpression)expr).getExpressions());
            }
            if (expr instanceof JSObjectLiteralExpression) break;
        }
        return null;
    }

    public static JSCallExpression getAnonymousFunCall(JSFunction function2) {
        PsiElement functionParent = function2.getParent();
        if (functionParent instanceof JSParenthesizedExpression) {
            functionParent = functionParent.getParent();
        }
        if (!(functionParent instanceof JSCallExpression)) {
            return null;
        }
        return (JSCallExpression)functionParent;
    }

    @Nullable
    public static JSLiteralExpression getParameterInitializationIfRequireArgument(@NotNull JSParameter jsParameter) {
        JSFunction function2;
        if (jsParameter == null) {
            JSSymbolUtil.$$$reportNull$$$0(36);
        }
        if ((function2 = jsParameter.getDeclaringFunction()) == null) {
            return null;
        }
        Pair<JSLiteralExpression, JSArrayLiteralExpression> requireArguments = JSAmdPsiUtil.getRequireArguments(function2);
        if (requireArguments != null) {
            int parameterIndex = JSSymbolUtil.findParameterIndex(function2, jsParameter);
            if (requireArguments.second != null) {
                JSExpression id = null;
                JSExpression[] expressions = ((JSArrayLiteralExpression)requireArguments.second).getExpressions();
                if (parameterIndex < expressions.length && parameterIndex >= 0) {
                    id = expressions[parameterIndex];
                }
                if (id instanceof JSLiteralExpression) {
                    return (JSLiteralExpression)id;
                }
            }
        }
        return null;
    }

    @Nullable
    public static JSExpression getParameterInitialization(@NotNull JSParameter jsParameter) {
        JSExpression expression;
        JSExpression actualParameter;
        JSFunction function2;
        if (jsParameter == null) {
            JSSymbolUtil.$$$reportNull$$$0(37);
        }
        if ((function2 = jsParameter.getDeclaringFunction()) == null) {
            return null;
        }
        JSExpression factoryArgument = JSSymbolUtil.getMatchedFactoryArgument(jsParameter);
        if (factoryArgument != null) {
            return factoryArgument;
        }
        JSCallExpression anonymousCallExpr = JSSymbolUtil.getAnonymousFunCall(function2);
        if (anonymousCallExpr == null) {
            return null;
        }
        int parameterIndex = JSSymbolUtil.findParameterIndex(function2, jsParameter);
        JSExpression[] expressions = anonymousCallExpr.getArguments();
        if (0 <= parameterIndex && parameterIndex < expressions.length) {
            actualParameter = expressions[parameterIndex];
        } else {
            if (parameterIndex == -1 && !TypeScriptPsiUtil.isThisParameter(jsParameter)) {
                Logger.getInstance(JSSymbolUtil.class).error("name = " + jsParameter.getName(), new Attachment[]{new Attachment("function.txt", function2.getText())});
            }
            actualParameter = null;
        }
        if (actualParameter instanceof JSThisExpression) {
            Ref ref = Ref.create();
            JSSymbolUtil.evalThis((JSThisExpression)actualParameter, (Ref<JSReferenceExpression>)ref);
            if (!ref.isNull()) {
                actualParameter = (JSExpression)ref.get();
            }
        }
        if (actualParameter instanceof JSCallExpression && 0 == ((JSCallExpression)actualParameter).getArguments().length && (expression = ((JSCallExpression)actualParameter).getMethodExpression()) instanceof JSReferenceExpression && "call".equals(((JSReferenceExpression)expression).getReferenceName())) {
            JSBlockStatement block;
            JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
            if (qualifier instanceof JSParenthesizedExpression) {
                qualifier = ((JSParenthesizedExpression)qualifier).getInnerExpression();
            }
            if (qualifier instanceof JSFunctionExpression && (block = ((JSFunctionExpression)qualifier).getBlock()) != null) {
                JSExpression returned;
                JSStatement secondStatement;
                JSStatement firstStatement = (JSStatement)PsiTreeUtil.getChildOfType((PsiElement)block, JSStatement.class);
                JSStatement jSStatement = secondStatement = firstStatement != null ? (JSStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)firstStatement, JSStatement.class) : null;
                if (secondStatement == null && firstStatement instanceof JSReturnStatement && (returned = ((JSReturnStatement)firstStatement).getExpression()) instanceof JSThisExpression) {
                    actualParameter = returned;
                }
            }
        }
        return actualParameter;
    }

    private static JSExpression getMatchedFactoryArgument(@NotNull JSParameter parameter) {
        JSFunction factoryFunction;
        if (parameter == null) {
            JSSymbolUtil.$$$reportNull$$$0(38);
        }
        if (!((factoryFunction = parameter.getDeclaringFunction()) instanceof JSExpression)) {
            return null;
        }
        PsiElement argumentList = factoryFunction.getParent();
        if (!(argumentList instanceof JSArgumentList)) {
            return null;
        }
        PsiElement anonymousFunctionCall = argumentList.getParent();
        if (!(anonymousFunctionCall instanceof JSCallExpression)) {
            return null;
        }
        JSExpression methodExpression = ((JSCallExpression)anonymousFunctionCall).getMethodExpression();
        if (!((methodExpression = JSUtils.unparenthesize(methodExpression)) instanceof JSFunctionExpression)) {
            return null;
        }
        JSParameterListElement[] callingFunctionParameters = ((JSFunctionExpression)methodExpression).getParameters();
        int factoryParameterIndex = ArrayUtil.indexOf((Object[])((JSArgumentList)argumentList).getArguments(), (Object)factoryFunction);
        if (factoryParameterIndex < 0 || factoryParameterIndex >= callingFunctionParameters.length) {
            return null;
        }
        JSParameterListElement factoryParameter = callingFunctionParameters[factoryParameterIndex];
        if (!(factoryParameter instanceof JSParameter)) {
            return null;
        }
        final String factoryParameterName = factoryParameter.getName();
        SmartList factoryCalls = new SmartList();
        methodExpression.acceptChildren(new JSRecursiveWalkingElementVisitor((List)factoryCalls){
            final /* synthetic */ List val$factoryCalls;
            {
                this.val$factoryCalls = list2;
            }

            @Override
            public void visitJSCallExpression(@NotNull JSCallExpression node) {
                JSExpression methodExpression;
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((methodExpression = node.getMethodExpression()) instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceItem)((Object)methodExpression), factoryParameterName)) {
                    this.val$factoryCalls.add(node);
                }
            }

            @Override
            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            @Override
            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    2.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/lang/javascript/index/JSSymbolUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        int namespaceParameterIndex = JSSymbolUtil.findParameterIndex(factoryFunction, parameter);
        if (namespaceParameterIndex == -1 || factoryCalls.isEmpty()) {
            return null;
        }
        for (JSCallExpression factoryCall : factoryCalls) {
            JSExpression argumentMatchingNs;
            JSExpression[] arguments = factoryCall.getArguments();
            if (arguments.length <= namespaceParameterIndex || !((argumentMatchingNs = arguments[namespaceParameterIndex]) instanceof JSReferenceExpression)) continue;
            return argumentMatchingNs;
        }
        return null;
    }

    public static boolean isExportReference(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            JSSymbolUtil.$$$reportNull$$$0(39);
        }
        if (!EXPORTS.equals(referenceExpression.getReferenceName())) {
            return false;
        }
        JSExpression qualifier = referenceExpression.getQualifier();
        if (qualifier == null) {
            return true;
        }
        if (!(qualifier instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression qualifierRef = (JSReferenceExpression)qualifier;
        if (qualifierRef.getQualifier() != null) {
            return false;
        }
        String qualifierName = qualifierRef.getReferenceName();
        if (qualifierName == null) {
            return false;
        }
        if (MODULE.equals(qualifierName)) {
            return true;
        }
        JSPsiNamedElementBase element = JSSymbolUtil.resolveLocallyIncludingDefinitions(qualifierName, qualifier);
        if (element instanceof JSInitializerOwner) {
            JSExpression initializer = ((JSInitializerOwner)((Object)element)).getInitializer();
            for (PsiElement expr : ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)initializer).filter(Conditions.or((Condition)Conditions.instanceOf(JSBinaryExpression.class), (Condition)Conditions.instanceOf(JSReferenceExpression.class)))).traverse()) {
                if (!(expr instanceof JSReferenceExpression) || !JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)expr, MODULE)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isExplicitExportReference(@Nullable JSReferenceExpression referenceExpression) {
        if (referenceExpression != null) {
            JSExpression qualifier = referenceExpression.getQualifier();
            String referencedName = referenceExpression.getReferenceName();
            return EXPORTS.equals(referencedName) && (qualifier == null || qualifier instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)qualifier, MODULE));
        }
        return false;
    }

    public static JSContext getContext(@NotNull JSElement element, boolean useJSDoc) {
        JSExpression qualifier;
        JSExpression expression;
        JSQualifiedNamedElement assignedTo;
        if (element == null) {
            JSSymbolUtil.$$$reportNull$$$0(40);
        }
        if (element instanceof JSAttributeListOwner) {
            if (element instanceof JSParameter) {
                return TypeScriptPsiUtil.isFieldParameter((JSParameter)element) ? JSContext.INSTANCE : JSContext.UNKNOWN;
            }
            JSAttributeList attributes = ((JSAttributeListOwner)element).getAttributeList();
            if (attributes != null && attributes.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                return JSContext.STATIC;
            }
            PsiElement parent = JSResolveUtil.findParent((PsiElement)element);
            if (parent instanceof TypeScriptEnum || parent instanceof TypeScriptModule) {
                return JSContext.STATIC;
            }
            if (parent instanceof JSClass) {
                return JSContext.INSTANCE;
            }
        }
        if (element instanceof JSFunctionExpression && (assignedTo = ((JSFunctionExpression)element).getElementAssignedTo()) != null) {
            return assignedTo.getJSContext();
        }
        if (element instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)element).getExpression()) instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)expression).getQualifier()) instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).getQualifier() != null && "prototype".equals(((JSReferenceExpression)qualifier).getReferenceName())) {
            return JSContext.INSTANCE;
        }
        if (element instanceof TypeScriptTypeMember) {
            if (JSUtils.getMemberContainingClass((PsiElement)element) instanceof TypeScriptInterface) {
                return JSContext.INSTANCE;
            }
            return JSContext.UNKNOWN;
        }
        if (!useJSDoc) {
            return JSContext.UNKNOWN;
        }
        JSContext context2 = JSDocumentationUtils.findJSContext((PsiElement)element);
        if (element instanceof JSProperty && context2 == JSContext.UNKNOWN) {
            return JSDocumentationUtils.findJSContext(element.getParent());
        }
        return context2;
    }

    @Nullable
    public static String getIndexedPropertyName(@NotNull JSIndexedPropertyAccessExpression expr) {
        PsiElement resolve;
        String name;
        JSExpression indexExpression;
        if (expr == null) {
            JSSymbolUtil.$$$reportNull$$$0(41);
        }
        if ((indexExpression = expr.getIndexExpression()) instanceof JSReferenceExpression && (name = ((JSReferenceExpression)indexExpression).getReferenceName()) != null && (resolve = JSStubBasedPsiTreeUtil.resolveLocally(name, (PsiElement)indexExpression, true)) instanceof JSInitializerOwner) {
            indexExpression = ((JSInitializerOwner)resolve).getInitializer();
        }
        if (indexExpression instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isQuotedLiteral()) {
            return ((JSLiteralExpression)indexExpression).getStringValue();
        }
        return null;
    }

    @Nullable
    public static JSNamespace findNamespace(@NotNull JSExpression expression) {
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(42);
        }
        return JSSymbolUtil.findNamespace(expression, null);
    }

    @Nullable
    public static JSNamespace findNamespace(@NotNull JSExpression expression, @Nullable Set<PsiElement> visited) {
        PsiElement grandParent;
        JSNamespace providedNs;
        JSPsiNamedElementBase initializedElement;
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(43);
        }
        for (FrameworkIndexingHandler indexingHandler : FrameworkIndexingHandler.getIndexingHandlers()) {
            JSNamespace ns = indexingHandler.findNamespace(expression, visited);
            if (ns == null) continue;
            return ns;
        }
        PsiElement parent = expression.getParent();
        JSExpression returnedExpression = JSDialectSpecificHandlersFactory.forElement((PsiElement)expression).getPsiHelper().isReturnedFromFunction(expression) ? expression : null;
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider((PsiElement)expression);
        if (docComment instanceof JSDocComment) {
            String lendsTagValue;
            JSDocComment comment = (JSDocComment)docComment;
            JSQualifiedName namespace = comment.getNamespace();
            String name = comment.getExplicitName();
            if (name != null) {
                JSContext context2 = comment.getJSContext();
                return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(name, namespace), context2, (PsiElement)docComment, true, true);
            }
            if (expression instanceof JSObjectLiteralExpression && (lendsTagValue = comment.getLendsTagValue()) != null) {
                return JSNamedTypeFactory.fromNamepath(lendsTagValue, true);
            }
        }
        JSPsiNamedElementBase jSPsiNamedElementBase = initializedElement = parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getROperand() == expression ? (JSPsiNamedElementBase)ObjectUtils.tryCast((Object)((JSAssignmentExpression)parent).getLOperand(), JSDefinitionExpression.class) : (JSPsiNamedElementBase)ObjectUtils.tryCast((Object)parent, JSPsiNamedElementBase.class);
        if (initializedElement != null && (providedNs = JSSymbolUtil.buildProvidedNamespace(initializedElement, visited)) != null) {
            return providedNs;
        }
        if (parent instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression) {
            JSNamespace nsResult;
            JSExpression[] arguments;
            JSExpression methodExpression = ((JSCallExpression)grandParent).getMethodExpression();
            if (methodExpression instanceof JSReferenceExpression && (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", "freeze") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", "seal"))) {
                return JSSymbolUtil.findNamespace((JSExpression)grandParent, visited);
            }
            if ((JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, "Object", "assign") || JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, "Object", "defineProperties") || JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, WEBPACK_EXTEND_METHOD_NAME)) && (arguments = ((JSArgumentList)parent).getArguments()).length >= 2 && arguments[1] == expression && (nsResult = JSSymbolUtil.evaluateNamespaceLocally(arguments[0], visited)) != null) {
                return nsResult;
            }
            JSInheritanceCallEvaluator.JSInheritanceCallResult inheritance = JSInheritanceCallEvaluator.findInheritance((JSCallExpression)grandParent);
            if (inheritance != null && inheritance.mixed == expression) {
                JSNamespace destinationNs = inheritance.evaluateOrFindDestinationNamespace((JSCallExpression)grandParent);
                if (destinationNs != null) {
                    return destinationNs;
                }
            } else if (grandParent.getParent() instanceof JSReturnStatement) {
                returnedExpression = (JSExpression)grandParent;
            } else {
                String name;
                PsiComment callExpressionDocComment = JSDocumentationUtils.findDocComment(grandParent);
                if (callExpressionDocComment instanceof JSDocComment && (name = ((JSDocComment)callExpressionDocComment).getExplicitName()) != null && ((JSDocComment)callExpressionDocComment).isClassExplicitly()) {
                    JSQualifiedNameImpl qName = JSQualifiedNameImpl.create(name, ((JSDocComment)callExpressionDocComment).getNamespace());
                    return JSNamedTypeFactory.createNamespace(qName, JSContext.UNKNOWN, (PsiElement)callExpressionDocComment, false, true);
                }
            }
        } else {
            if (parent instanceof JSParenthesizedExpression) {
                return JSSymbolUtil.findNamespace((JSParenthesizedExpression)parent, visited);
            }
            if (parent instanceof JSBinaryExpression) {
                IElementType sign = ((JSBinaryExpression)parent).getOperationSign();
                if (sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND) {
                    return JSSymbolUtil.findNamespace((JSBinaryExpression)parent, visited);
                }
            } else {
                if (parent instanceof JSConditionalExpression) {
                    return JSSymbolUtil.findNamespace((JSConditionalExpression)parent, visited);
                }
                if (parent instanceof ES6ExportDefaultAssignment) {
                    return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create("default", null), JSContext.STATIC, (PsiElement)expression, true, true, true);
                }
            }
        }
        JSFunction function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class);
        if (returnedExpression != null && function2 != null) {
            JSQualifiedName amdNamespace = JSAmdPsiUtil.getNamespaceForAmdModuleElements(function2);
            if (amdNamespace != null) {
                return JSNamedTypeFactory.createNamespace(amdNamespace, JSContext.UNKNOWN, function2, false, true);
            }
            PsiElement call = JSPsiImplUtils.getNonParenthesizeParent(function2);
            if (call instanceof JSCallExpression) {
                return JSSymbolUtil.findNamespace((JSExpression)call, visited);
            }
        }
        return null;
    }

    @Nullable
    public static JSNamespace buildProvidedNamespace(@NotNull JSPsiNamedElementBase element, @Nullable Set<PsiElement> visited) {
        if (element == null) {
            JSSymbolUtil.$$$reportNull$$$0(44);
        }
        if (element instanceof JSProperty) {
            JSObjectLiteralExpression parent;
            PsiElement psiElement;
            JSNamespace ns = JSNamedTypeFactory.buildProvidedNamespace((JSProperty)element, true, visited);
            if (ns != null && ns.getQualifiedName() != null && (psiElement = element.getParent()) instanceof JSObjectLiteralExpression && (parent = (JSObjectLiteralExpression)psiElement).getParent() instanceof JSArgumentList) {
                String name = ((JSProperty)element).getName();
                if ("members".equals(name) || "proto".equals(name)) {
                    return JSNamedTypeFactory.createNamespace(ns.getQualifiedName().getParent(), JSContext.INSTANCE, (PsiElement)element, ns.isSourceStrict(), ns.isDeclaration(), ns.isLocal());
                }
                if ("statics".equals(name) || "own".equals(name)) {
                    return JSNamedTypeFactory.createNamespace(ns.getQualifiedName().getParent(), JSContext.STATIC, (PsiElement)element, ns.isSourceStrict(), ns.isDeclaration(), ns.isLocal());
                }
            }
            return ns;
        }
        if (element instanceof JSElementBase) {
            return JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)((Object)element), true, visited);
        }
        return null;
    }

    @Nullable
    public static String getQualifierOfExprAsString(@NotNull JSElement expr) {
        JSExpression method;
        PsiElement jsExpressionParent;
        if (expr == null) {
            JSSymbolUtil.$$$reportNull$$$0(45);
        }
        if (expr instanceof JSNamedElement) {
            return expr.getName();
        }
        if (expr instanceof JSNewExpression && (jsExpressionParent = expr.getParent()) instanceof JSVariable && JSSymbolUtil.isAccurateReferenceExpressionName(method = ((JSNewExpression)expr).getMethodExpression(), "Class")) {
            return ((JSVariable)jsExpressionParent).getName();
        }
        if (expr instanceof JSReferenceExpression) {
            JSQualifiedName name;
            JSNamespace result2 = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)expr, JSContext.UNKNOWN, true);
            JSQualifiedName jSQualifiedName = name = result2 != null ? result2.getQualifiedName() : null;
            if (name != null) {
                return name.getQualifiedName();
            }
        }
        if (expr instanceof JSLiteralExpression) {
            return JSStringUtil.unquoteAndUnescapeStringLiteralValue(expr.getText());
        }
        return null;
    }

    public static boolean isValidPropertyName(@NotNull String name) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(46);
        }
        if (name.length() == 0) {
            return false;
        }
        char firstChar = (name = JSStringUtil.replaceUnicodeEscapeSequences(name)).charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar)) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSSymbolUtil";
                break;
            }
            case 2: 
            case 15: 
            case 17: 
            case 20: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outSourceReference";
                break;
            }
            case 19: 
            case 27: 
            case 28: 
            case 32: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 24: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceOrIndexedAccessExpression";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsExpressions";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsParameter";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSSymbolUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNameIndexArray";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "quoteIfSpecialPropertyName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createPredefinedNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isConstructorSymbol";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "quoteIfSpecialPropertyName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canElementBeFromAnyNamespace";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canElementsBeFromSameNamespace";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "areElementsFromSameNamespace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findParameterIndex";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalNamedType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "referencesInterface";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isInterface";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "evaluateInitializedPrototype";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPredefinedNamespace";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "typeMayBeInlined";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocallyIncludingDefinitions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "evalThis";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAccurateReferenceExpression";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAccurateReferenceExpressionName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceParts";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAccurateReferenceName";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createNamespaceFromReferenceExpression";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addNamespaceComponents";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedNamespace";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralValueAsQualifiedName";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLiteralOrExprArg";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getParameterInitializationIfRequireArgument";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getParameterInitialization";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getMatchedFactoryArgument";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isExportReference";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyName";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findNamespace";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "buildProvidedNamespace";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierOfExprAsString";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 18 -> new IllegalStateException(string);
        };
    }

    public static interface PropertyProcessor {
        public void process(String var1, JSProperty var2);
    }

    static interface ReferenceExpressionProcessor {
        public void processExpression(JSReferenceExpression var1);

        public void processUnresolvedThis();

        public boolean isTopLevel(JSReferenceExpression var1);
    }
}

