/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiFile;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/index/JSPragmaFlags;", "", "()V", "FLOW_PRAGMA", "", "JSX_FRAGMENT_PRAGMA_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "JSX_FRAG_PRAGMA", "JSX_IMPORT_SOURCE_PATTERN", "JSX_IMPORT_SOURCE_PRAGMA", "JSX_PRAGMA", "JSX_PRAGMA_PATTERN", "USE_ASM_DIRECTIVE", "USE_BABEL_DIRECTIVE", "USE_CLIENT_DIRECTIVE", "USE_SERVER_DIRECTIVE", "USE_STRICT_DIRECTIVE", "patterns", "", "parseFlags", "", "file", "Lcom/intellij/psi/PsiFile;", "comment", "Lcom/intellij/psi/PsiComment;", "cachedData", "Lcom/intellij/lang/javascript/psi/stubs/impl/JSFileCachedData;", "intellij.javascript.psi.impl"})
public final class JSPragmaFlags {
    @NotNull
    public static final JSPragmaFlags INSTANCE = new JSPragmaFlags();
    @NotNull
    public static final String JSX_PRAGMA = "@jsx";
    @NotNull
    public static final String JSX_FRAG_PRAGMA = "@jsxFrag";
    @NotNull
    public static final String JSX_IMPORT_SOURCE_PRAGMA = "@jsxImportSource";
    @NotNull
    public static final String FLOW_PRAGMA = "@flow";
    @NotNull
    public static final String USE_CLIENT_DIRECTIVE = "use client";
    @NotNull
    public static final String USE_SERVER_DIRECTIVE = "use server";
    @NotNull
    public static final String USE_STRICT_DIRECTIVE = "use strict";
    @NotNull
    public static final String USE_BABEL_DIRECTIVE = "use babel";
    @NotNull
    public static final String USE_ASM_DIRECTIVE = "use asm";
    private static final Pattern JSX_PRAGMA_PATTERN = Pattern.compile("^@jsx\\s+(\\S+)\\s*.*");
    private static final Pattern JSX_FRAGMENT_PRAGMA_PATTERN = Pattern.compile("^@jsxFrag\\s+(\\S+)\\s*.*");
    private static final Pattern JSX_IMPORT_SOURCE_PATTERN = Pattern.compile("^@jsxImportSource\\s+(\\S+)\\s*.*");
    @NotNull
    private static final Map<String, Pattern> patterns;

    private JSPragmaFlags() {
    }

    public final void parseFlags(@NotNull PsiFile file, @NotNull PsiComment comment, @NotNull JSFileCachedData cachedData) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)cachedData, (String)"cachedData");
        if (!comment.textContains('@')) {
            return;
        }
        if (FlowJSAnnotation.isFlowComment(comment)) {
            cachedData.addPragmaFlag(FLOW_PRAGMA, "");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String name = string;
            String string2 = FileUtilRt.getExtension((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExtension(...)");
            String extension = string2;
            if (Intrinsics.areEqual((Object)"mjs", (Object)extension)) {
                cachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.ES6);
            } else if (Intrinsics.areEqual((Object)"cjs", (Object)extension)) {
                cachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.COMMONJS);
            }
            return;
        }
        String string = comment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String rawText = string;
        for (Map.Entry<String, Pattern> entry : patterns.entrySet()) {
            String pragma = entry.getKey();
            Pattern pattern = entry.getValue();
            if (!StringsKt.contains$default((CharSequence)rawText, (CharSequence)(pragma + " "), (boolean)false, (int)2, null)) continue;
            String text2 = StringUtil.trim((String)JSDocumentationUtils.unwrapCommentDelimiters(rawText));
            Matcher matcher = pattern.matcher(text2);
            if (!matcher.matches()) {
                return;
            }
            String result2 = matcher.group(1);
            if (!StringUtil.isEmpty((String)result2)) {
                cachedData.addPragmaFlag(pragma, result2);
            }
            return;
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JSX_PRAGMA, (Object)JSX_PRAGMA_PATTERN), TuplesKt.to((Object)JSX_FRAG_PRAGMA, (Object)JSX_FRAGMENT_PRAGMA_PATTERN), TuplesKt.to((Object)JSX_IMPORT_SOURCE_PRAGMA, (Object)JSX_IMPORT_SOURCE_PATTERN)};
        patterns = MapsKt.mapOf((Pair[])pairArray);
    }
}

