/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hints;

import com.intellij.codeInsight.codeVision.CodeVisionRelativeOrdering;
import com.intellij.codeInsight.hints.codeVision.CodeVisionProviderBase;
import com.intellij.codeInsight.hints.codeVision.ReferencesCodeVisionProvider;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.hints.JSCodeVisionLocationKind;
import com.intellij.lang.javascript.hints.JSCodeVisionLocations;
import com.intellij.lang.javascript.hints.JSCodeVisionUsageCollector;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSSymbolReferenceCache;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.event.MouseEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0017\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/intellij/lang/javascript/hints/JSReferencesCodeVisionProvider;", "Lcom/intellij/codeInsight/hints/codeVision/ReferencesCodeVisionProvider;", "()V", "id", "", "getId", "()Ljava/lang/String;", "relativeOrderings", "", "Lcom/intellij/codeInsight/codeVision/CodeVisionRelativeOrdering;", "getRelativeOrderings", "()Ljava/util/List;", "acceptsElement", "", "element", "Lcom/intellij/psi/PsiElement;", "acceptsFile", "file", "Lcom/intellij/psi/PsiFile;", "calculateHint", "Lcom/intellij/codeInsight/hints/codeVision/CodeVisionProviderBase$CodeVisionInfo;", "Lorg/jetbrains/annotations/Nls;", "getHint", "getVisionInfo", "handleClick", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "event", "Ljava/awt/event/MouseEvent;", "logClickToFUS", "hint", "Companion", "intellij.javascript.impl"})
public final class JSReferencesCodeVisionProvider
extends ReferencesCodeVisionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "js.references";

    public boolean acceptsFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JSCodeVisionLocations.INSTANCE.acceptsFile(file);
    }

    public boolean acceptsElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return JSCodeVisionLocations.INSTANCE.isImportantLocation(element);
    }

    public void handleClick(@NotNull Editor editor, @NotNull PsiElement element, @Nullable MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.handleClick(editor, JSCodeVisionLocations.INSTANCE.getNamedElementForLocation(element), event);
    }

    public void logClickToFUS(@NotNull PsiElement element, @NotNull String hint2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hint2, (String)"hint");
        JSCodeVisionLocationKind jSCodeVisionLocationKind = JSCodeVisionLocations.INSTANCE.getLocationKind(element);
        if (jSCodeVisionLocationKind == null) {
            jSCodeVisionLocationKind = JSCodeVisionLocationKind.OTHER;
        }
        JSCodeVisionLocationKind location = jSCodeVisionLocationKind;
        JSCodeVisionUsageCollector.INSTANCE.getUSAGES_CLICKED_EVENT_ID().log(element.getProject(), (Object)location);
    }

    @Nullable
    public CodeVisionProviderBase.CodeVisionInfo getVisionInfo(@NotNull PsiElement element, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.calculateHint(element);
    }

    @Nullable
    public String getHint(@NotNull PsiElement element, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CodeVisionProviderBase.CodeVisionInfo codeVisionInfo = this.getVisionInfo(element, file);
        return codeVisionInfo != null ? codeVisionInfo.getText() : null;
    }

    private final CodeVisionProviderBase.CodeVisionInfo calculateHint(PsiElement element) {
        String string;
        PsiElement adjusted = JSCodeVisionLocations.INSTANCE.getNamedElementForLocation(element);
        if (!(adjusted instanceof JSNamedElement) && !(adjusted instanceof JSExportAssignment)) {
            return null;
        }
        int referenceLimit = Registry.intValue((String)"js.code.vision.reference.limit");
        int size = JSSymbolReferenceCache.getReferenceSearcher(adjusted).findReferences(referenceLimit, null).size();
        if (referenceLimit == 1) {
            var7_5 = new Object[]{size};
            string = JavaScriptBundle.message("inlay.hints.max.one.usage.text", var7_5);
        } else {
            var7_5 = new Object[]{size, size >= referenceLimit ? 1 : 0};
            string = JavaScriptBundle.message("inlay.hints.usages.text", var7_5);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String message = string2;
        return new CodeVisionProviderBase.CodeVisionInfo(message, Integer.valueOf(size), size < referenceLimit);
    }

    @NotNull
    public List<CodeVisionRelativeOrdering> getRelativeOrderings() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/lang/javascript/hints/JSReferencesCodeVisionProvider$Companion;", "", "()V", "ID", "", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

