/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRainbowVisitor
extends RainbowVisitor {
    public boolean suitableForFile(@NotNull PsiFile file) {
        if (file == null) {
            JSRainbowVisitor.$$$reportNull$$$0(0);
        }
        return file instanceof JSFile || file instanceof XmlFile;
    }

    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            JSRainbowVisitor.$$$reportNull$$$0(1);
        }
        PsiElement target = null;
        if (element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() == null) {
            String name = ((JSReferenceExpression)element).getReferenceName();
            if (name != null) {
                target = JSStubBasedPsiTreeUtil.resolveLocally(name, element, false);
            }
        } else if (element instanceof JSVariable) {
            target = element;
        }
        if (target instanceof JSVariable) {
            PsiElement highlight;
            PsiElement psiElement = highlight = element instanceof JSReferenceExpression ? ((JSReferenceExpression)element).getReferenceNameElement() : ((JSQualifiedNamedElement)element).getNameIdentifier();
            if (highlight == null) {
                return;
            }
            PsiElement scope2 = JSUseScopeProvider.getLexicalScopeOrFile(target);
            if (scope2 == null) {
                return;
            }
            HighlightInfo info2 = this.getInfo(scope2, highlight, JSRainbowVisitor.getName((JSVariable)target), this.getColorKey(target));
            this.addInfo(info2);
        }
    }

    @NotNull
    private static String getName(@NotNull JSQualifiedNamedElement var) {
        String name;
        if (var == null) {
            JSRainbowVisitor.$$$reportNull$$$0(2);
        }
        return (name = var.getName()) != null ? name : "";
    }

    @Nullable
    protected TextAttributesKey getColorKey(@NotNull PsiElement element) {
        if (element == null) {
            JSRainbowVisitor.$$$reportNull$$$0(3);
        }
        if (element instanceof JSParameter || JSSemanticHighlightingVisitor.isArgumentsVariable(element)) {
            return JSHighlighter.JS_PARAMETER;
        }
        if (element instanceof JSVariable) {
            return JSSemanticHighlightingVisitor.isLocalVariable((JSVariable)element, element) ? JSHighlighter.JS_LOCAL_VARIABLE : JSHighlighter.JS_GLOBAL_VARIABLE;
        }
        return null;
    }

    @NotNull
    public HighlightVisitor clone() {
        return new JSRainbowVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSRainbowVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "suitableForFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getColorKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

