/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.ide.highlighter.EmbeddedTokenHighlighter;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocElementType;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptHighlightingLexer;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.highlighting.JavaScriptHighlightDescriptor;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.MultiMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> keys1;
    private static final Map<IElementType, TextAttributesKey> keys2;
    @NotNull
    private final DialectOptionHolder myDialectOptionsHolder;
    public static final TextAttributesKey JS_KEYWORD;
    public static final TextAttributesKey JS_STRING;
    public static final TextAttributesKey JS_NUMBER;
    public static final TextAttributesKey JS_REGEXP;
    public static final TextAttributesKey JS_LINE_COMMENT;
    public static final TextAttributesKey JS_BLOCK_COMMENT;
    public static final TextAttributesKey JS_DOC_COMMENT;
    public static final TextAttributesKey JS_OPERATION_SIGN;
    public static final TextAttributesKey JS_PARENTHS;
    public static final TextAttributesKey JS_BRACKETS;
    public static final TextAttributesKey JS_BRACES;
    public static final TextAttributesKey JS_COMMA;
    public static final TextAttributesKey JS_DOT;
    public static final TextAttributesKey JS_SEMICOLON;
    public static final TextAttributesKey JS_BAD_CHARACTER;
    public static final TextAttributesKey JS_DOC_TAG;
    public static final TextAttributesKey JS_DOC_TAG_NAMEPATH;
    public static final TextAttributesKey JS_DOC_TYPE;
    public static final TextAttributesKey JS_VALID_STRING_ESCAPE;
    public static final TextAttributesKey JS_INVALID_STRING_ESCAPE;
    public static final TextAttributesKey JS_LOCAL_VARIABLE;
    public static final TextAttributesKey JS_PARAMETER;
    public static final TextAttributesKey JS_INSTANCE_MEMBER_VARIABLE;
    public static final TextAttributesKey JS_STATIC_MEMBER_VARIABLE;
    public static final TextAttributesKey JS_GLOBAL_VARIABLE;
    public static final TextAttributesKey JS_GLOBAL_FUNCTION;
    public static final TextAttributesKey JS_LOCAL_FUNCTION;
    public static final TextAttributesKey ES6_DECORATOR;
    public static final TextAttributesKey JS_STATIC_MEMBER_FUNCTION;
    public static final TextAttributesKey JS_INSTANCE_MEMBER_FUNCTION;
    public static final TextAttributesKey JS_CLASS;
    public static final TextAttributesKey JS_INTERFACE;
    public static final TextAttributesKey JS_TYPE_ALIAS;
    public static final TextAttributesKey JS_LABEL;
    public static final TextAttributesKey JS_MODULE_NAME;
    public static final TextAttributesKey FUNCTION_ARROW;
    public static final TextAttributesKey JS_PRIMITIVE_TYPE;
    public static final TextAttributesKey JS_EXPORTED_VARIABLE;
    public static final TextAttributesKey JS_EXPORTED_FUNCTION;
    public static final TextAttributesKey JS_EXPORTED_CLASS;
    public static final TextAttributesKey JSX_CLIENT_COMPONENT;
    public static final TextAttributesKey JS_INJECTED_LANGUAGE_FRAGMENT;
    protected static final TokenSet OPERATORS_LIKE;

    public JSHighlighter(@NotNull DialectOptionHolder dialectOptionsHolder) {
        if (dialectOptionsHolder == null) {
            JSHighlighter.$$$reportNull$$$0(0);
        }
        this(dialectOptionsHolder, false);
    }

    public JSHighlighter(@NotNull DialectOptionHolder dialectOptionsHolder, boolean skipKeywordHighlights) {
        if (dialectOptionsHolder == null) {
            JSHighlighter.$$$reportNull$$$0(1);
        }
        this.myDialectOptionsHolder = dialectOptionsHolder;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new JavaScriptHighlightingLexer(this.myDialectOptionsHolder);
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        if (this.getKeywords().contains(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = JSHighlighter.pack((TextAttributesKey)JS_KEYWORD);
            if (textAttributesKeyArray == null) {
                JSHighlighter.$$$reportNull$$$0(2);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = JSHighlighter.pack((TextAttributesKey)keys1.get(tokenType), (TextAttributesKey)keys2.get(tokenType));
        if (textAttributesKeyArray == null) {
            JSHighlighter.$$$reportNull$$$0(3);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public TextAttributesKey getMappedKey(@NotNull TextAttributesKey original) {
        if (original == null) {
            JSHighlighter.$$$reportNull$$$0(4);
        }
        TextAttributesKey textAttributesKey = original;
        if (textAttributesKey == null) {
            JSHighlighter.$$$reportNull$$$0(5);
        }
        return textAttributesKey;
    }

    @NotNull
    public DialectOptionHolder getDialectOptionsHolder() {
        DialectOptionHolder dialectOptionHolder = this.myDialectOptionsHolder;
        if (dialectOptionHolder == null) {
            JSHighlighter.$$$reportNull$$$0(6);
        }
        return dialectOptionHolder;
    }

    @NotNull
    public TokenSet getKeywords() {
        TokenSet tokenSet = JSKeywordSets.JS_RESERVED_WORDS;
        if (tokenSet == null) {
            JSHighlighter.$$$reportNull$$$0(7);
        }
        return tokenSet;
    }

    static {
        IElementType[] javadoc;
        JS_KEYWORD = JavaScriptHighlightDescriptor.KEYWORD.getOrCreateTextAttributesKey();
        JS_STRING = JavaScriptHighlightDescriptor.STRING.getOrCreateTextAttributesKey();
        JS_NUMBER = JavaScriptHighlightDescriptor.NUMBER.getOrCreateTextAttributesKey();
        JS_REGEXP = JavaScriptHighlightDescriptor.REGEXP.getOrCreateTextAttributesKey();
        JS_LINE_COMMENT = JavaScriptHighlightDescriptor.LINE_COMMENT.getOrCreateTextAttributesKey();
        JS_BLOCK_COMMENT = JavaScriptHighlightDescriptor.BLOCK_COMMENT.getOrCreateTextAttributesKey();
        JS_DOC_COMMENT = JavaScriptHighlightDescriptor.DOC_COMMENT.getOrCreateTextAttributesKey();
        JS_OPERATION_SIGN = JavaScriptHighlightDescriptor.OPERATION_SIGN.getOrCreateTextAttributesKey();
        JS_PARENTHS = JavaScriptHighlightDescriptor.PARENTHESES.getOrCreateTextAttributesKey();
        JS_BRACKETS = JavaScriptHighlightDescriptor.BRACKETS.getOrCreateTextAttributesKey();
        JS_BRACES = JavaScriptHighlightDescriptor.BRACES.getOrCreateTextAttributesKey();
        JS_COMMA = JavaScriptHighlightDescriptor.COMMA.getOrCreateTextAttributesKey();
        JS_DOT = JavaScriptHighlightDescriptor.DOT.getOrCreateTextAttributesKey();
        JS_SEMICOLON = JavaScriptHighlightDescriptor.SEMICOLON.getOrCreateTextAttributesKey();
        JS_BAD_CHARACTER = JavaScriptHighlightDescriptor.BAD_CHARACTER.getOrCreateTextAttributesKey();
        JS_DOC_TAG = JavaScriptHighlightDescriptor.DOC_TAG.getOrCreateTextAttributesKey();
        JS_DOC_TAG_NAMEPATH = JavaScriptHighlightDescriptor.DOC_TAG_NAMEPATH.getOrCreateTextAttributesKey();
        JS_DOC_TYPE = JavaScriptHighlightDescriptor.DOC_TYPE.getOrCreateTextAttributesKey();
        JS_VALID_STRING_ESCAPE = JavaScriptHighlightDescriptor.VALID_STRING_ESCAPE.getOrCreateTextAttributesKey();
        JS_INVALID_STRING_ESCAPE = JavaScriptHighlightDescriptor.INVALID_STRING_ESCAPE.getOrCreateTextAttributesKey();
        JS_LOCAL_VARIABLE = JavaScriptHighlightDescriptor.LOCAL_VARIABLE.getOrCreateTextAttributesKey();
        JS_PARAMETER = JavaScriptHighlightDescriptor.PARAMETER.getOrCreateTextAttributesKey();
        JS_INSTANCE_MEMBER_VARIABLE = JavaScriptHighlightDescriptor.INSTANCE_MEMBER_VARIABLE.getOrCreateTextAttributesKey();
        JS_STATIC_MEMBER_VARIABLE = JavaScriptHighlightDescriptor.STATIC_MEMBER_VARIABLE.getOrCreateTextAttributesKey();
        JS_GLOBAL_VARIABLE = JavaScriptHighlightDescriptor.GLOBAL_VARIABLE.getOrCreateTextAttributesKey();
        JS_GLOBAL_FUNCTION = JavaScriptHighlightDescriptor.GLOBAL_FUNCTION.getOrCreateTextAttributesKey();
        JS_LOCAL_FUNCTION = JavaScriptHighlightDescriptor.LOCAL_FUNCTION.getOrCreateTextAttributesKey();
        ES6_DECORATOR = JavaScriptHighlightDescriptor.DECORATOR.getOrCreateTextAttributesKey();
        JS_STATIC_MEMBER_FUNCTION = JavaScriptHighlightDescriptor.STATIC_MEMBER_FUNCTION.getOrCreateTextAttributesKey();
        JS_INSTANCE_MEMBER_FUNCTION = JavaScriptHighlightDescriptor.INSTANCE_MEMBER_FUNCTION.getOrCreateTextAttributesKey();
        JS_CLASS = JavaScriptHighlightDescriptor.CLASS.getOrCreateTextAttributesKey();
        JS_INTERFACE = JavaScriptHighlightDescriptor.INTERFACE.getOrCreateTextAttributesKey();
        JS_TYPE_ALIAS = JavaScriptHighlightDescriptor.TYPE_ALIAS.getOrCreateTextAttributesKey();
        JS_LABEL = JavaScriptHighlightDescriptor.LABEL.getOrCreateTextAttributesKey();
        JS_MODULE_NAME = JavaScriptHighlightDescriptor.MODULE_NAME.getOrCreateTextAttributesKey();
        FUNCTION_ARROW = JavaScriptHighlightDescriptor.FUNCTION_ARROW.getOrCreateTextAttributesKey();
        JS_PRIMITIVE_TYPE = JavaScriptHighlightDescriptor.PRIMITIVE_TYPE.getOrCreateTextAttributesKey();
        JS_EXPORTED_VARIABLE = JavaScriptHighlightDescriptor.EXPORTED_VARIABLE.getOrCreateTextAttributesKey();
        JS_EXPORTED_FUNCTION = JavaScriptHighlightDescriptor.EXPORTED_FUNCTION.getOrCreateTextAttributesKey();
        JS_EXPORTED_CLASS = JavaScriptHighlightDescriptor.EXPORTED_CLASS.getOrCreateTextAttributesKey();
        JSX_CLIENT_COMPONENT = JavaScriptHighlightDescriptor.JSX_CLIENT_COMPONENT.getOrCreateTextAttributesKey();
        JS_INJECTED_LANGUAGE_FRAGMENT = EditorColors.createInjectedLanguageFragmentKey((Language)JavascriptLanguage.INSTANCE);
        OPERATORS_LIKE = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.OPERATIONS, JSTokenTypes.ARROWS});
        keys1 = new HashMap<IElementType, TextAttributesKey>();
        keys2 = new HashMap<IElementType, TextAttributesKey>();
        JSHighlighter.fillMap(keys1, (TokenSet)OPERATORS_LIKE, (TextAttributesKey)JS_OPERATION_SIGN);
        JSHighlighter.fillMap(keys1, (TokenSet)JSKeywordSets.JS_RESERVED_WORDS, (TextAttributesKey)JS_KEYWORD);
        keys1.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, JS_VALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, JS_INVALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, JS_INVALID_STRING_ESCAPE);
        keys1.put(JSTokenTypes.NUMERIC_LITERAL, JS_NUMBER);
        keys1.put(JSTokenTypes.STRING_LITERAL, JS_STRING);
        keys1.put(JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL, JS_STRING);
        keys1.put(JSTokenTypes.STRING_TEMPLATE_PART, JS_STRING);
        keys1.put(JSTokenTypes.BACKQUOTE, JS_STRING);
        keys1.put(JSTokenTypes.REGEXP_LITERAL, JS_REGEXP);
        keys1.put(JSTokenTypes.LPAR, JS_PARENTHS);
        keys1.put(JSTokenTypes.RPAR, JS_PARENTHS);
        keys1.put(JSTokenTypes.LBRACE, JS_BRACES);
        keys1.put(JSTokenTypes.RBRACE, JS_BRACES);
        keys1.put(JSTokenTypes.LBRACKET, JS_BRACKETS);
        keys1.put(JSTokenTypes.RBRACKET, JS_BRACKETS);
        keys1.put(JSTokenTypes.COMMA, JS_COMMA);
        keys1.put(JSTokenTypes.DOT, JS_DOT);
        keys1.put(JSTokenTypes.ELVIS, JS_DOT);
        keys1.put(JSTokenTypes.SEMICOLON, JS_SEMICOLON);
        keys1.put(JSTokenTypes.C_STYLE_COMMENT, JS_BLOCK_COMMENT);
        keys1.put(JSTokenTypes.XML_STYLE_COMMENT, JS_BLOCK_COMMENT);
        keys1.put(JSTokenTypes.DOC_COMMENT, JS_DOC_COMMENT);
        keys1.put(JSTokenTypes.END_OF_LINE_COMMENT, JS_LINE_COMMENT);
        keys1.put(JSTokenTypes.BAD_CHARACTER, JS_BAD_CHARACTER);
        keys1.put(JSDocTokenTypes.DOC_TAG_NAME, JS_DOC_COMMENT);
        keys2.put(JSDocTokenTypes.DOC_TAG_NAME, JS_DOC_TAG);
        for (IElementType type3 : javadoc = IElementType.enumerate(type2 -> type2 instanceof JSDocElementType)) {
            keys1.put(type3, JS_DOC_COMMENT);
        }
        keys1.put(JSDocTokenTypes.DOC_DESCRIPTION, JS_DOC_COMMENT);
        keys1.put(JSDocTokenTypes.DOC_TAG_TYPE, JS_DOC_COMMENT);
        keys1.put(JSDocTokenTypes.DOC_TAG_NAMEPATH, JS_DOC_COMMENT);
        for (IElementType type3 : JSTokenTypes.XML_TOKENS.getTypes()) {
            keys1.put(type3, XmlHighlighterColors.XML_TAG);
        }
        keys1.put(JSTokenTypes.XML_LBRACE, JS_BRACES);
        keys1.put(JSTokenTypes.XML_RBRACE, JS_BRACES);
        keys2.put(JSTokenTypes.XML_TAG_NAME, XmlHighlighterColors.XML_TAG_NAME);
        keys2.put(JSTokenTypes.XML_NAME, XmlHighlighterColors.XML_ATTRIBUTE_NAME);
        keys2.put(JSTokenTypes.XML_ATTR_VALUE, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        keys2.put(JSTokenTypes.XML_ATTR_VALUE_END, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        keys2.put(JSTokenTypes.XML_ATTR_VALUE_START, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        keys2.put(JSTokenTypes.XML_ATTR_EQUAL, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        keys2.put(JSTokenTypes.XML_ENTITY_REF, XmlHighlighterColors.XML_ENTITY_REFERENCE);
        keys1.put(JSTokenTypes.XML_STYLE_COMMENT, XmlHighlighterColors.XML_COMMENT);
        keys1.put(JSTokenTypes.XML_TAG_CONTENT, XmlHighlighterColors.XML_TAG_DATA);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectOptionsHolder";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSHighlighter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSHighlighter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappedKey";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectOptionsHolder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMappedKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    static final class JSXmlTokenHighlighter
    implements EmbeddedTokenHighlighter {
        JSXmlTokenHighlighter() {
        }

        @NotNull
        public MultiMap<IElementType, TextAttributesKey> getEmbeddedTokenAttributes() {
            MultiMap map = new MultiMap(keys1.size() + keys2.size());
            map.putAllValues(keys1);
            map.putAllValues(keys2);
            MultiMap multiMap = map;
            if (multiMap == null) {
                JSXmlTokenHighlighter.$$$reportNull$$$0(0);
            }
            return multiMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSHighlighter$JSXmlTokenHighlighter", "getEmbeddedTokenAttributes"));
        }
    }
}

