/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules.resolver;

import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSDefaultFileReferenceRootsProvider;
import com.intellij.lang.javascript.modules.JSFileResolveRootsProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\u0013\u0010\u0017\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0016J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\tH\u0016J\b\u0010\"\u001a\u00020\rH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSImportConfigResolveContextImpl;", "Lcom/intellij/lang/javascript/config/JSImportResolveContext;", "config", "Lcom/intellij/lang/javascript/config/JSConfig;", "(Lcom/intellij/lang/javascript/config/JSConfig;)V", "myBaseUrl", "Lcom/intellij/openapi/vfs/VirtualFile;", "myContainingDirectory", "myMappingRoots", "", "myPathsMappings", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "myPreserveSymlinks", "", "myRootDirs", "myRootsProvider", "Lcom/intellij/lang/javascript/modules/JSFileResolveRootsProvider;", "getMyRootsProvider", "()Lcom/intellij/lang/javascript/modules/JSFileResolveRootsProvider;", "myRootsProvider$delegate", "Lkotlin/Lazy;", "baseUrl", "contextDirectory", "equals", "other", "", "getMappingRoots", "getNodeModuleSearchProcessor", "Lcom/intellij/lang/javascript/frameworks/modules/JSDirectorySearchProcessor;", "getRootDirs", "getRootsProvider", "hashCode", "", "pathsMappings", "preserveSymlinks", "intellij.javascript.impl"})
public class JSImportConfigResolveContextImpl
implements JSImportResolveContext {
    @NotNull
    private final Collection<VirtualFile> myRootDirs;
    private final boolean myPreserveSymlinks;
    @Nullable
    private final VirtualFile myBaseUrl;
    @NotNull
    private final VirtualFile myContainingDirectory;
    @NotNull
    private final Collection<JSModulePathSubstitution> myPathsMappings;
    @NotNull
    private final Collection<VirtualFile> myMappingRoots;
    @NotNull
    private final Lazy myRootsProvider$delegate;

    public JSImportConfigResolveContextImpl(@NotNull JSConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Collection<VirtualFile> collection = config.getRootDirsFiles();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRootDirsFiles(...)");
        this.myRootDirs = collection;
        this.myPreserveSymlinks = config.preserveSymlinks();
        this.myBaseUrl = config.getBaseUrl();
        VirtualFile virtualFile = config.getConfigDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getConfigDirectory(...)");
        this.myContainingDirectory = virtualFile;
        Collection<JSModulePathSubstitution> collection2 = config.getPaths();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"getPaths(...)");
        this.myPathsMappings = collection2;
        VirtualFile virtualFile2 = config.getMappingRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getMappingRoot(...)");
        this.myMappingRoots = CollectionsKt.listOf((Object)virtualFile2);
        this.myRootsProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JSDefaultFileReferenceRootsProvider>(this){
            final /* synthetic */ JSImportConfigResolveContextImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final JSDefaultFileReferenceRootsProvider invoke() {
                return new JSDefaultFileReferenceRootsProvider(this.this$0);
            }
        }));
    }

    private final JSFileResolveRootsProvider getMyRootsProvider() {
        Lazy lazy = this.myRootsProvider$delegate;
        return (JSFileResolveRootsProvider)lazy.getValue();
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getRootDirs() {
        return this.myRootDirs;
    }

    @Override
    public boolean preserveSymlinks() {
        return this.myPreserveSymlinks;
    }

    @Override
    @Nullable
    public VirtualFile baseUrl() {
        return this.myBaseUrl;
    }

    @Override
    @NotNull
    public Collection<JSModulePathSubstitution> pathsMappings() {
        return this.myPathsMappings;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getMappingRoots() {
        return this.myMappingRoots;
    }

    @Override
    @NotNull
    public JSFileResolveRootsProvider getRootsProvider() {
        return this.getMyRootsProvider();
    }

    @Override
    @NotNull
    public VirtualFile contextDirectory() {
        return this.myContainingDirectory;
    }

    @Override
    @NotNull
    public JSDirectorySearchProcessor getNodeModuleSearchProcessor() {
        NodeModuleDirectorySearchProcessor nodeModuleDirectorySearchProcessor = NodeModuleDirectorySearchProcessor.PROCESSOR;
        Intrinsics.checkNotNullExpressionValue((Object)nodeModuleDirectorySearchProcessor, (String)"PROCESSOR");
        return nodeModuleDirectorySearchProcessor;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.frameworks.modules.resolver.JSImportConfigResolveContextImpl");
        JSImportConfigResolveContextImpl cfr_ignored_0 = (JSImportConfigResolveContextImpl)other;
        if (!Intrinsics.areEqual(this.myRootDirs, ((JSImportConfigResolveContextImpl)other).myRootDirs)) {
            return false;
        }
        if (this.myPreserveSymlinks != ((JSImportConfigResolveContextImpl)other).myPreserveSymlinks) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.myBaseUrl, (Object)((JSImportConfigResolveContextImpl)other).myBaseUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.myContainingDirectory, (Object)((JSImportConfigResolveContextImpl)other).myContainingDirectory)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.myPathsMappings, ((JSImportConfigResolveContextImpl)other).myPathsMappings)) {
            return false;
        }
        return Intrinsics.areEqual(this.myMappingRoots, ((JSImportConfigResolveContextImpl)other).myMappingRoots);
    }

    public int hashCode() {
        int result2 = ((Object)this.myRootDirs).hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.myPreserveSymlinks);
        VirtualFile virtualFile = this.myBaseUrl;
        result2 = 31 * result2 + (virtualFile != null ? virtualFile.hashCode() : 0);
        result2 = 31 * result2 + this.myContainingDirectory.hashCode();
        result2 = 31 * result2 + ((Object)this.myPathsMappings).hashCode();
        result2 = 31 * result2 + ((Object)this.myMappingRoots).hashCode();
        return result2;
    }
}

