/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules.resolver;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptSymlinkLinkedProject;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.config.JSDirectFileReferenceResolver;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSFileModuleReference;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.frameworks.modules.JSPathResolution;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSParsedPathElement;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSSimpleFileReferenceRootsProviderKt;
import com.intellij.lang.javascript.modules.JSFileResolveRootsProvider;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolverImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.PathUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0014J\u001e\u0010\u001e\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001b2\u0006\u0010#\u001a\u00020\bH\u0002J\u0013\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0004\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u001b2\b\u0010'\u001a\u0004\u0018\u00010\u001bH\u0002J \u0010(\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u001bH\u0002J0\u0010+\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u001b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0 2\u0006\u0010.\u001a\u00020\u0013H\u0014J0\u0010/\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u00132\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0 H\u0004J(\u00100\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u001b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0 H\u0004J3\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\b2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00072\u0006\u00105\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u00106J\u0012\u00107\u001a\u0004\u0018\u00010\u001b2\u0006\u00108\u001a\u00020\u001bH\u0002J+\u00109\u001a\u00020\u00162\u0006\u00102\u001a\u00020\b2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00072\u0006\u00108\u001a\u00020\u001bH\u0004\u00a2\u0006\u0002\u0010:J+\u0010;\u001a\u00020\u00162\u0006\u00102\u001a\u00020\b2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00072\u0006\u00105\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010:J\u001b\u0010<\u001a\b\u0012\u0004\u0012\u0002040\u00072\u0006\u0010=\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010>J3\u0010?\u001a\u00020\u00162\u0006\u0010@\u001a\u00020\u00162\f\u0010A\u001a\b\u0012\u0004\u0012\u0002040\u00072\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010)\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010BJ\u0010\u0010C\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0016\u0010D\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001bJ\u0018\u0010E\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001bJ\u001a\u0010F\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\u0010\u0010G\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\bH\u0002J+\u0010H\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\b2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00072\u0006\u0010\u001d\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010:J\u001a\u0010I\u001a\u0004\u0018\u00010\u001b2\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010J\u001a\u00020\bH\u0002J\u0014\u0010K\u001a\u0004\u0018\u00010\u001b2\b\u0010'\u001a\u0004\u0018\u00010\u001bH\u0002J\u001a\u0010L\u001a\u0004\u0018\u00010\u001b2\u0006\u00108\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J+\u0010M\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\b2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00072\u0006\u00108\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010:R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006N"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSFileImportsResolverImpl;", "Lcom/intellij/lang/javascript/config/JSDirectFileReferenceResolver;", "project", "Lcom/intellij/openapi/project/Project;", "resolveContext", "Lcom/intellij/lang/javascript/config/JSImportResolveContext;", "defaultExtensions", "", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/config/JSImportResolveContext;[Ljava/lang/String;)V", "getDefaultExtensions", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getResolveContext", "()Lcom/intellij/lang/javascript/config/JSImportResolveContext;", "suffixWithExtensions", "allowDirectResolve", "", "name", "chooseBetterMatched", "Lcom/intellij/lang/javascript/frameworks/modules/JSPathResolution;", "oldCandidate", "newCandidate", "collectRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleName", "contextFile", "createResolved", "list", "", "target", "findRootDirWithLongestPrefix", "candidate", "getExtensionsWithSuffixes", "isReDirectCandidate", "canonicalFile", "file", "loadAndRemap", "ref", "currentRoot", "loadModuleForLastPart", "parent", "result", "resolveDirectory", "loadModuleForLastPartDirectly", "loadModuleForLastPartWithModification", "loadModuleFromFileOrDirectory", "relativePath", "elements", "Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;", "containingDirectory", "(Ljava/lang/String;[Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;Lcom/intellij/openapi/vfs/VirtualFile;Z)Lcom/intellij/lang/javascript/frameworks/modules/JSPathResolution;", "loadNodeModuleFromDirectory", "directory", "loader", "(Ljava/lang/String;[Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/lang/javascript/frameworks/modules/JSPathResolution;", "nodeLoadModuleByRelativeName", "parseTextElements", "suffix", "(Ljava/lang/String;)[Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;", "reMapElements", "pathResolution", "subElements", "(Lcom/intellij/lang/javascript/frameworks/modules/JSPathResolution;[Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSParsedPathElement;Ljava/lang/String;Ljava/lang/String;)Lcom/intellij/lang/javascript/frameworks/modules/JSPathResolution;", "remapToTypeScriptSourceDirectory", "resolveDirectFile", "resolveFileModule", "resolveFileModuleImpl", "resolveFromPathMappings", "resolveModuleWithElements", "resolvePathElement", "path", "toPreferredFileModule", "tryAddingExtensions", "tryLoadModuleUsingRootDirs", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSFileImportsResolverImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSFileImportsResolverImpl.kt\ncom/intellij/lang/javascript/frameworks/modules/resolver/JSFileImportsResolverImpl\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,484:1\n37#2,2:485\n13374#3,3:487\n13309#3,2:491\n1#4:490\n1864#5,3:493\n9#6:496\n*S KotlinDebug\n*F\n+ 1 JSFileImportsResolverImpl.kt\ncom/intellij/lang/javascript/frameworks/modules/resolver/JSFileImportsResolverImpl\n*L\n50#1:485,2\n141#1:487,3\n320#1:491,2\n410#1:493,3\n439#1:496\n*E\n"})
public class JSFileImportsResolverImpl
implements JSDirectFileReferenceResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final JSImportResolveContext resolveContext;
    @NotNull
    private final String[] defaultExtensions;
    @NotNull
    private final String[] suffixWithExtensions;

    public JSFileImportsResolverImpl(@NotNull Project project, @NotNull JSImportResolveContext resolveContext, @NotNull String[] defaultExtensions) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)resolveContext, (String)"resolveContext");
        Intrinsics.checkNotNullParameter((Object)defaultExtensions, (String)"defaultExtensions");
        this.project = project;
        this.resolveContext = resolveContext;
        this.defaultExtensions = defaultExtensions;
        JSFileImportsResolverImpl jSFileImportsResolverImpl = this;
        if (this.resolveContext.getModuleSuffixes().isEmpty()) {
            stringArray = this.defaultExtensions;
        } else {
            List mutableList = new ArrayList();
            String[] stringArray2 = this.defaultExtensions;
            int n = stringArray2.length;
            JSFileImportsResolverImpl jSFileImportsResolverImpl2 = jSFileImportsResolverImpl;
            for (int i = 0; i < n; ++i) {
                String extension = stringArray2[i];
                for (String moduleSuffix : this.resolveContext.getModuleSuffixes()) {
                    Intrinsics.checkNotNull((Object)moduleSuffix);
                    if (((CharSequence)moduleSuffix).length() == 0) continue;
                    mutableList.add(moduleSuffix + extension);
                }
                mutableList.add(extension);
            }
            jSFileImportsResolverImpl = jSFileImportsResolverImpl2;
            Collection $this$toTypedArray$iv = mutableList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        }
        jSFileImportsResolverImpl.suffixWithExtensions = stringArray;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final JSImportResolveContext getResolveContext() {
        return this.resolveContext;
    }

    @NotNull
    protected final String[] getDefaultExtensions() {
        return this.defaultExtensions;
    }

    @NotNull
    protected final String[] getExtensionsWithSuffixes() {
        return this.suffixWithExtensions;
    }

    @Nullable
    public final VirtualFile resolveFileModule(@NotNull String moduleName, @NotNull VirtualFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        return this.resolveFileModuleImpl(moduleName, contextFile);
    }

    private final VirtualFile resolveFileModuleImpl(String moduleName, VirtualFile contextFile) {
        ProgressManager.checkCanceled();
        return this.resolveModuleWithElements(moduleName, this.parseTextElements(moduleName), contextFile).resolvedTarget();
    }

    @Override
    @NotNull
    public final JSPathResolution resolveDirectFile(@NotNull String moduleName, @NotNull VirtualFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        ProgressManager.checkCanceled();
        return this.resolveModuleWithElements(moduleName, this.parseTextElements(moduleName), contextFile);
    }

    private final JSPathResolution resolveModuleWithElements(String moduleName, JSParsedPathElement[] elements, VirtualFile contextFile) {
        if (elements.length == 1 && StringsKt.startsWith$default((String)moduleName, (String)"lib.", (boolean)false, (int)2, null)) {
            String libShortName = StringsKt.removeSurrounding((String)moduleName, (CharSequence)"lib.", (CharSequence)".d.ts");
            VirtualFile libFile = TypeScriptLibraryProvider.getService(this.project).findLibraryByShortName(libShortName);
            if (libFile != null) {
                return new JSPathResolution(CollectionsKt.listOf((Object)libFile), true, false);
            }
        }
        JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution, (String)"EMPTY");
        JSPathResolution partialResolved = jSPathResolution;
        if (!JSFileReferencesUtil.isRelative(moduleName)) {
            JSPathResolution fromMapping = this.resolveFromPathMappings(moduleName);
            if (fromMapping.isFullChainResolved()) {
                return fromMapping;
            }
            partialResolved = fromMapping;
        }
        Collection<VirtualFile> roots = this.collectRoots(moduleName, contextFile);
        JSParsedPathElement[] parsedElements = this.parseTextElements(moduleName);
        for (VirtualFile root : roots) {
            ProgressManager.checkCanceled();
            JSPathResolution result2 = this.loader(moduleName, parsedElements, root);
            if (!result2.isFullChainResolved()) {
                partialResolved = this.chooseBetterMatched(partialResolved, result2);
                continue;
            }
            return result2;
        }
        if (JSSimpleFileReferenceRootsProviderKt.isExternalModuleNameRelative(moduleName)) {
            VirtualFile root;
            root = contextFile instanceof VirtualFileWindow ? ((VirtualFileWindow)contextFile).getDelegate() : contextFile;
            Intrinsics.checkNotNull((Object)root);
            VirtualFile effectiveFile = root;
            VirtualFile virtualFile = effectiveFile.getParent();
            if (virtualFile == null) {
                JSPathResolution jSPathResolution2 = JSPathResolution.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution2, (String)"EMPTY");
                return jSPathResolution2;
            }
            VirtualFile containingDirectory = virtualFile;
            JSPathResolution fromRootDirs = this.tryLoadModuleUsingRootDirs(moduleName, elements, containingDirectory);
            if (fromRootDirs.isFullChainResolved()) {
                return fromRootDirs;
            }
        }
        return partialResolved;
    }

    private final JSPathResolution chooseBetterMatched(JSPathResolution oldCandidate, JSPathResolution newCandidate) {
        int currentSize = oldCandidate.size();
        return newCandidate.size() > currentSize ? newCandidate : oldCandidate;
    }

    @NotNull
    protected Collection<VirtualFile> collectRoots(@NotNull String moduleName, @NotNull VirtualFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        JSFileResolveRootsProvider jSFileResolveRootsProvider = this.resolveContext.getRootsProvider();
        Intrinsics.checkNotNullExpressionValue((Object)jSFileResolveRootsProvider, (String)"getRootsProvider(...)");
        JSFileResolveRootsProvider rootsProvider = jSFileResolveRootsProvider;
        return rootsProvider.getDefaultRoots(this.project, moduleName, contextFile);
    }

    @NotNull
    protected final JSPathResolution loader(@NotNull String relativePath, @NotNull JSParsedPathElement[] elements, @NotNull VirtualFile directory) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        if (!this.resolveContext.isNodeLikeResolution()) {
            return this.loadModuleFromFileOrDirectory(relativePath, elements, directory, false);
        }
        return this.nodeLoadModuleByRelativeName(relativePath, elements, directory);
    }

    /*
     * WARNING - void declaration
     */
    private final JSPathResolution loadModuleFromFileOrDirectory(String relativePath, JSParsedPathElement[] elements, VirtualFile containingDirectory, boolean resolveDirectory) {
        if (StringsKt.endsWith$default((String)relativePath, (String)"/", (boolean)false, (int)2, null) && !resolveDirectory) {
            JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution, (String)"EMPTY");
            return jSPathResolution;
        }
        List result2 = new ArrayList();
        VirtualFile parent = null;
        parent = containingDirectory;
        JSParsedPathElement[] $this$forEachIndexed$iv = elements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (JSParsedPathElement item$iv : $this$forEachIndexed$iv) {
            JSPathResolution candidate;
            boolean isLast;
            void jsParsedPathElement;
            int n = index$iv++;
            JSParsedPathElement jSParsedPathElement = item$iv;
            int index = n;
            boolean bl = false;
            String name = jsParsedPathElement.getText();
            boolean bl2 = isLast = index == elements.length - 1;
            if (!isLast || StringsKt.endsWith$default((String)relativePath, (String)"/", (boolean)false, (int)2, null) && resolveDirectory) {
                VirtualFile resolved = this.resolvePathElement(parent, name);
                if (resolved == null) {
                    return new JSPathResolution(result2, false, false);
                }
                VirtualFile next = resolved;
                if (isLast && next.isDirectory()) {
                    next = this.loadNodeModuleFromDirectory(next);
                }
                if (next == null) {
                    if (resolved.isDirectory()) {
                        return this.createResolved(result2, resolved);
                    }
                    return new JSPathResolution(result2, false, false);
                }
                parent = next;
                result2.add(next);
                continue;
            }
            JSPathResolution jSPathResolution = candidate = this.loadModuleForLastPart(name, parent, result2, resolveDirectory);
            if (jSPathResolution == null) continue;
            return jSPathResolution;
        }
        return new JSPathResolution(result2, result2.size() == elements.length, false);
    }

    @Nullable
    protected JSPathResolution loadModuleForLastPart(@NotNull String name, @NotNull VirtualFile parent, @NotNull List<VirtualFile> result2, boolean resolveDirectory) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        JSPathResolution jSPathResolution = this.loadModuleForLastPartDirectly(name, parent, resolveDirectory, result2);
        if (jSPathResolution != null) {
            JSPathResolution it = jSPathResolution;
            boolean bl = false;
            return it;
        }
        JSPathResolution jSPathResolution2 = this.loadModuleForLastPartWithModification(name, parent, result2);
        if (jSPathResolution2 != null) {
            JSPathResolution it = jSPathResolution2;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @Nullable
    protected final JSPathResolution loadModuleForLastPartDirectly(@NotNull String name, @NotNull VirtualFile parent, boolean resolveDirectory, @NotNull List<VirtualFile> result2) {
        VirtualFile exactFile;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (this.allowDirectResolve(name) && (exactFile = this.resolvePathElement(parent, name)) != null) {
            VirtualFile loaded;
            if (resolveDirectory && exactFile.isDirectory() && (loaded = this.loadNodeModuleFromDirectory(exactFile)) != null) {
                return this.createResolved(result2, loaded);
            }
            if (!exactFile.isDirectory() || this.resolveContext.isAllowFolders()) {
                return this.createResolved(result2, exactFile);
            }
        }
        return null;
    }

    @Nullable
    protected final JSPathResolution loadModuleForLastPartWithModification(@NotNull String name, @NotNull VirtualFile parent, @NotNull List<VirtualFile> result2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        VirtualFile candidateWithExtension = this.tryAddingExtensions(parent, name);
        if (candidateWithExtension != null) {
            return this.createResolved(result2, candidateWithExtension);
        }
        if (TypeScriptUtil.isJavaScriptFile(name)) {
            String string = FileUtil.getNameWithoutExtension((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
            String nameWithoutExtension = string;
            VirtualFile tsCandidateForJSFile = this.tryAddingExtensions(parent, nameWithoutExtension);
            if (tsCandidateForJSFile != null && !tsCandidateForJSFile.isDirectory()) {
                return this.createResolved(result2, tsCandidateForJSFile);
            }
        }
        Collection<JSImportResolveContext.PrefixPostfix> collection = this.resolveContext.getPrefixPostfix();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getPrefixPostfix(...)");
        Collection<JSImportResolveContext.PrefixPostfix> prefixPostfixes = collection;
        for (JSImportResolveContext.PrefixPostfix prefixPostfix : prefixPostfixes) {
            String postfix;
            String effectivePostfix;
            VirtualFile candidate;
            String prefix;
            Intrinsics.checkNotNullExpressionValue((Object)prefixPostfix.prefix, (String)"prefix");
            Intrinsics.checkNotNullExpressionValue((Object)prefixPostfix.postfix, (String)"postfix");
            if (StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null) || (candidate = parent.findChild(prefix + name + (effectivePostfix = StringsKt.endsWith$default((String)name, (String)postfix, (boolean)false, (int)2, null) ? "" : postfix))) == null) continue;
            return this.createResolved(result2, candidate);
        }
        return null;
    }

    private final JSPathResolution tryLoadModuleUsingRootDirs(String moduleName, JSParsedPathElement[] elements, VirtualFile directory) {
        Collection<VirtualFile> collection = this.resolveContext.getRootDirs();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRootDirs(...)");
        Collection<VirtualFile> rootDirs = collection;
        if (rootDirs.isEmpty()) {
            JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution, (String)"EMPTY");
            return jSPathResolution;
        }
        String candidatePath = JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(directory, moduleName);
        Intrinsics.checkNotNull((Object)candidatePath);
        VirtualFile rootDir = this.findRootDirWithLongestPrefix(candidatePath);
        if (rootDir != null) {
            String string = candidatePath.substring(rootDir.getPath().length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String suffix = string;
            JSParsedPathElement[] restElements = this.parseTextElements(suffix);
            List result2 = new ArrayList();
            VirtualFile curr = directory;
            int n = elements.length - restElements.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile resolved = this.resolvePathElement(curr, elements[i].getText());
                if (resolved == null) {
                    JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution, (String)"EMPTY");
                    return jSPathResolution;
                }
                result2.add(resolved);
                curr = resolved;
            }
            for (VirtualFile currentRoot : rootDirs) {
                if (Intrinsics.areEqual((Object)currentRoot, (Object)rootDir)) continue;
                Intrinsics.checkNotNull((Object)currentRoot);
                JSPathResolution resolvedFromRoot = this.loader(suffix, restElements, currentRoot);
                if (!resolvedFromRoot.isFullChainResolved()) continue;
                List<VirtualFile> list2 = resolvedFromRoot.getChain();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getChain(...)");
                result2.addAll((Collection)list2);
                return new JSPathResolution(result2, true, false);
            }
        }
        JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution, (String)"EMPTY");
        return jSPathResolution;
    }

    private final JSPathResolution createResolved(List<VirtualFile> list2, VirtualFile target) {
        VirtualFile virtualFile = this.toPreferredFileModule(target);
        Intrinsics.checkNotNull((Object)virtualFile);
        list2.add(virtualFile);
        return new JSPathResolution(list2, true, false);
    }

    private final VirtualFile resolvePathElement(VirtualFile parent, String path2) {
        if (Intrinsics.areEqual((Object)path2, (Object)".") || ((CharSequence)path2).length() == 0) {
            return parent;
        }
        if (Intrinsics.areEqual((Object)path2, (Object)"..")) {
            return parent.getParent();
        }
        if (!PathUtilRt.isValidFileName((String)path2, (boolean)true)) {
            return null;
        }
        return parent.findChild(path2);
    }

    protected boolean allowDirectResolve(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return true;
    }

    private final JSPathResolution nodeLoadModuleByRelativeName(String relativePath, JSParsedPathElement[] elements, VirtualFile containingDirectory) {
        boolean isTypesRemapped;
        JSParsedPathElement[] toProcessParts;
        JSPathResolution resolved;
        String moduleNameForProcessing = relativePath;
        if (NodeModuleUtil.isTypesDir(containingDirectory) && StringsKt.startsWith$default((String)relativePath, (String)"@", (boolean)false, (int)2, null)) {
            moduleNameForProcessing = TypeScriptFileImportsResolverImpl.Companion.convertToTypesDirectory(moduleNameForProcessing);
        }
        if ((resolved = this.loadModuleFromFileOrDirectory(moduleNameForProcessing, toProcessParts = (isTypesRemapped = !Intrinsics.areEqual((Object)moduleNameForProcessing, (Object)relativePath)) ? this.parseTextElements(moduleNameForProcessing) : elements, containingDirectory, true)).size() == 0 || !isTypesRemapped) {
            return resolved;
        }
        List result2 = new ArrayList();
        for (VirtualFile virtualFile : resolved.getChain()) {
            if (result2.size() == 0) {
                Intrinsics.checkNotNull((Object)virtualFile);
                result2.add(virtualFile);
            }
            Intrinsics.checkNotNull((Object)virtualFile);
            result2.add(virtualFile);
        }
        return new JSPathResolution(result2, resolved.isFullChainResolved(), false);
    }

    private final JSParsedPathElement[] parseTextElements(String suffix) {
        return JSParsedPathElement.Parser.parseReferenceText(suffix, this.resolveContext.isUrlEncoded());
    }

    private final VirtualFile tryAddingExtensions(VirtualFile directory, String name) {
        String[] $this$forEach$iv = this.getExtensionsWithSuffixes();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            VirtualFile candidate;
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (!PathUtilRt.isValidFileName((String)(name + it), (boolean)true) || (candidate = directory.findChild(name + it)) == null) continue;
            return candidate;
        }
        return null;
    }

    private final VirtualFile findRootDirWithLongestPrefix(String candidate) {
        VirtualFile matchedRootDir = null;
        Object matchedNormalizedPrefix = null;
        for (VirtualFile rootDir : this.resolveContext.getRootDirs()) {
            String rootDirPath = rootDir.getPath() + "/";
            boolean isLongestMatchingPrefix = StringsKt.startsWith$default((String)candidate, (String)rootDirPath, (boolean)false, (int)2, null) && (matchedNormalizedPrefix == null || ((String)matchedNormalizedPrefix).length() < rootDirPath.length());
            if (!isLongestMatchingPrefix) continue;
            matchedRootDir = rootDir;
            matchedNormalizedPrefix = rootDirPath;
        }
        return matchedRootDir;
    }

    private final JSPathResolution resolveFromPathMappings(String moduleName) {
        Collection<JSModulePathSubstitution> collection = this.resolveContext.pathsMappings();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"pathsMappings(...)");
        Collection<JSModulePathSubstitution> mappings = collection;
        if (mappings.isEmpty()) {
            JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution, (String)"EMPTY");
            return jSPathResolution;
        }
        Collection<String> collection2 = JSPathMappingsUtil.substituteMappings(moduleName, mappings);
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"substituteMappings(...)");
        Collection<String> substituteMappings = collection2;
        Collection<VirtualFile> collection3 = this.resolveContext.getMappingRoots();
        Intrinsics.checkNotNullExpressionValue(collection3, (String)"getMappingRoots(...)");
        Collection<VirtualFile> mappingRoots = collection3;
        JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)jSPathResolution, (String)"EMPTY");
        JSPathResolution partialResolved = jSPathResolution;
        VirtualFile[] virtualFileArray = ManagingFS.getInstance().getRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getRoots(...)");
        VirtualFile[] roots = virtualFileArray;
        for (String mapping : substituteMappings) {
            String fsRoot;
            for (VirtualFile baseRoot : mappingRoots) {
                ProgressManager.checkCanceled();
                Intrinsics.checkNotNull((Object)mapping);
                Intrinsics.checkNotNull((Object)baseRoot);
                JSPathResolution remapped = this.loadAndRemap(moduleName, mapping, baseRoot);
                if (remapped.isFullChainResolved()) {
                    return remapped;
                }
                partialResolved = this.chooseBetterMatched(partialResolved, remapped);
            }
            String string = FileUtil.extractRootPath((String)mapping);
            if (string == null) {
                Intrinsics.checkNotNull((Object)mapping);
                string = StringsKt.startsWith$default((String)mapping, (String)"/", (boolean)false, (int)2, null) ? "/" : null;
            }
            if ((fsRoot = string) == null) continue;
            for (VirtualFile fsRootFile : roots) {
                String independentPath;
                if (!Intrinsics.areEqual((Object)fsRootFile.getName(), (Object)fsRoot) || fsRootFile == null) continue;
                Intrinsics.checkNotNull((Object)mapping);
                String string2 = mapping.substring(fsRoot.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)string2), (String)"toSystemIndependentName(...)");
                JSPathResolution fsRemapped = this.loadAndRemap(moduleName, independentPath, fsRootFile);
                if (fsRemapped.isFullChainResolved()) {
                    return fsRemapped;
                }
                partialResolved = this.chooseBetterMatched(partialResolved, fsRemapped);
            }
        }
        return partialResolved;
    }

    private final JSPathResolution loadAndRemap(String moduleName, String ref, VirtualFile currentRoot) {
        JSParsedPathElement[] subElements = this.parseTextElements(ref);
        JSPathResolution newCandidate = this.loader(ref, subElements, currentRoot);
        return this.reMapElements(newCandidate, subElements, moduleName, ref);
    }

    /*
     * WARNING - void declaration
     */
    private final JSPathResolution reMapElements(JSPathResolution pathResolution, JSParsedPathElement[] subElements, String moduleName, String ref) {
        Object[] originalElements = this.parseTextElements(moduleName);
        int counter2 = Math.min(originalElements.length, subElements.length);
        List fullChain = new ArrayList();
        List<VirtualFile> list2 = pathResolution.getChain();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getChain(...)");
        fullChain.addAll((Collection)list2);
        if (subElements.length > fullChain.size()) {
            int n = subElements.length - fullChain.size();
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                fullChain.add(null);
            }
        }
        List reversedResult = CollectionsKt.reversed((Iterable)fullChain);
        List reversedElements = ArraysKt.reversed((Object[])originalElements);
        List chainProcessed = new ArrayList();
        VirtualFile lastElement = null;
        boolean chainIsBroken = false;
        Iterable $this$forEachIndexed$iv = reversedElements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void currPath;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JSParsedPathElement jSParsedPathElement = (JSParsedPathElement)item$iv;
            int i = n;
            boolean bl = false;
            if (chainIsBroken || i >= counter2) {
                chainProcessed.add(lastElement);
                continue;
            }
            VirtualFile currFile = (VirtualFile)reversedResult.get(i);
            if (i == 0) {
                chainProcessed.add(currFile);
                lastElement = currFile;
                continue;
            }
            if (currFile == null) {
                chainProcessed.add(null);
                lastElement = null;
                continue;
            }
            chainProcessed.add(currFile);
            lastElement = currFile;
            if (Intrinsics.areEqual((Object)currFile.getName(), (Object)currPath.getText())) continue;
            chainIsBroken = true;
        }
        List newChain = CollectionsKt.filterNotNull((Iterable)CollectionsKt.reversed((Iterable)chainProcessed));
        if (pathResolution.isFullChainResolved() && newChain.size() != originalElements.length) {
            JSFileImportsResolverImpl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JSFileImportsResolverImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Incorrect state of mapped chain: " + moduleName + " and mapped " + ref);
        }
        return new JSPathResolution(newChain, pathResolution.isFullChainResolved(), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final VirtualFile loadNodeModuleFromDirectory(VirtualFile directory) {
        JSDirectorySearchProcessor jSDirectorySearchProcessor = this.resolveContext.getNodeModuleSearchProcessor();
        Intrinsics.checkNotNullExpressionValue((Object)jSDirectorySearchProcessor, (String)"getNodeModuleSearchProcessor(...)");
        JSDirectorySearchProcessor processor = jSDirectorySearchProcessor;
        VirtualFile moduleMainFile = processor.loadDirectory(directory);
        if (moduleMainFile == null) return null;
        String string = moduleMainFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!this.allowDirectResolve(string)) return null;
        VirtualFile virtualFile = moduleMainFile;
        return virtualFile;
    }

    private final VirtualFile toPreferredFileModule(VirtualFile file) {
        if (file == null) {
            return null;
        }
        if (this.resolveContext.preserveSymlinks()) {
            return file;
        }
        VirtualFile virtualFile = JSFileModuleReference.getCanonicalPreferredFile(this.project, file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getCanonicalPreferredFile(...)");
        VirtualFile canonicalFile = virtualFile;
        if (this.isReDirectCandidate(canonicalFile, file)) {
            return this.remapToTypeScriptSourceDirectory(canonicalFile);
        }
        return canonicalFile;
    }

    private final boolean isReDirectCandidate(VirtualFile canonicalFile, VirtualFile file) {
        if (!TypeScriptUtil.isDefinitionFile(canonicalFile)) {
            return false;
        }
        return !Intrinsics.areEqual((Object)canonicalFile, (Object)file) || !VfsUtil.isAncestor((VirtualFile)canonicalFile, (VirtualFile)this.resolveContext.contextDirectory(), (boolean)true);
    }

    private final VirtualFile remapToTypeScriptSourceDirectory(VirtualFile canonicalFile) {
        VirtualFile virtualFile = TypeScriptConfigUtil.getParentConfigWithName(canonicalFile, "tsconfig.json");
        if (virtualFile == null) {
            return canonicalFile;
        }
        VirtualFile parentConfig = virtualFile;
        if (!VfsUtil.isAncestor((VirtualFile)parentConfig.getParent(), (VirtualFile)this.resolveContext.contextDirectory(), (boolean)false)) {
            TypeScriptConfig typeScriptConfig = TypeScriptConfigService.Provider.get(this.project).parseConfigFile(parentConfig);
            if (typeScriptConfig == null) {
                return canonicalFile;
            }
            TypeScriptConfig tsConfig = typeScriptConfig;
            VirtualFile virtualFile2 = TypeScriptImportPathBuilder.detectRootDir(this.project, tsConfig);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"detectRootDir(...)");
            VirtualFile sourceRoot = virtualFile2;
            VirtualFile virtualFile3 = tsConfig.getEffectiveOutDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getEffectiveOutDirectory(...)");
            VirtualFile outRoot = virtualFile3;
            if (Intrinsics.areEqual((Object)sourceRoot, (Object)outRoot)) {
                return canonicalFile;
            }
            TypeScriptSymlinkLinkedProject linked = new TypeScriptSymlinkLinkedProject(tsConfig.getConfigDirectory(), tsConfig.getConfigDirectory(), sourceRoot, outRoot, "");
            VirtualFile fromProjectStructure = linked.getSourceFileByLinkedFile(canonicalFile);
            if (fromProjectStructure != null) {
                return fromProjectStructure;
            }
        }
        return canonicalFile;
    }
}

