/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules.resolver;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.frameworks.modules.JSDefaultFileReferenceCompletionFilter;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSDefaultFileReferenceRootsProvider;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSFileReferenceContext;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.path.JSImportModulePathStrategy;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefaultFileReferenceContext
implements JSFileReferenceContext {
    @NotNull
    protected final String myPath;
    @NotNull
    protected final PsiElement myContext;
    @Nullable
    protected final JSConfig myConfig;
    private final String @NotNull [] myImplicitExtensions;

    public static JSDefaultFileReferenceContext defaultWithExtensions(@NotNull String path2, @NotNull PsiElement context2, @Nullable JSConfig config, String @NotNull [] extensions, boolean mergeWithPlatforms) {
        if (path2 == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(1);
        }
        if (extensions == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(2);
        }
        return new JSDefaultFileReferenceContext(path2, context2, config, mergeWithPlatforms ? JSFileReferencesUtil.getExtensionsWithPlatforms(context2, extensions) : extensions);
    }

    public static String @NotNull [] getDefaultExtensions(@NotNull PsiElement context2) {
        if (context2 == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(3);
        }
        String[] stringArray = JSFileReferencesUtil.getExtensionsWithPlatforms(context2, JSDefaultFileReferenceContext.withCurrentFileExtension(JSImportModulePathStrategy.mergeWithExtensions(JSFileReferencesUtil.IMPLICIT_EXTENSIONS, context2), context2));
        if (stringArray == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    public JSDefaultFileReferenceContext(@NotNull String path2, @NotNull PsiElement context2, @Nullable JSConfig config) {
        if (path2 == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(5);
        }
        if (context2 == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(6);
        }
        this(path2, context2, config, JSDefaultFileReferenceContext.getDefaultExtensions(context2));
    }

    public JSDefaultFileReferenceContext(@NotNull String path2, @NotNull PsiElement context2, @Nullable JSConfig config, String @NotNull [] implicitExtensions) {
        if (path2 == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(8);
        }
        if (implicitExtensions == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(9);
        }
        this.myPath = path2;
        this.myContext = context2;
        this.myConfig = config;
        this.myImplicitExtensions = implicitExtensions;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getDefaultRoots(@NotNull Project project, @NotNull String moduleName, @NotNull VirtualFile contextFile) {
        if (project == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(10);
        }
        if (moduleName == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(11);
        }
        if (contextFile == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(12);
        }
        JSDefaultFileReferenceRootsProvider provider = new JSDefaultFileReferenceRootsProvider(this);
        Collection<VirtualFile> collection = provider.getDefaultRoots(project, moduleName, contextFile);
        if (collection == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Nullable
    protected PsiFile getOriginalFile() {
        return JSResolveUtil.getOriginalFile(this.myContext);
    }

    @Override
    public final String @NotNull [] getImplicitExtensions() {
        if (this.myImplicitExtensions == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(14);
        }
        return this.myImplicitExtensions;
    }

    @Override
    public boolean isNodeLikeResolution() {
        return this.myConfig == null || this.myConfig.isNodeResolution();
    }

    @NotNull
    protected Collection<PsiFileSystemItem> toFileSystemItems(VirtualFile ... files) {
        Collection<PsiFileSystemItem> collection = this.toFileSystemItems(Arrays.asList(files));
        if (collection == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @Override
    @NotNull
    public Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return new JSDefaultFileReferenceCompletionFilter(this.myContext);
    }

    @NotNull
    protected Collection<PsiFileSystemItem> toFileSystemItems(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(16);
        }
        PsiManager manager = this.myContext.getManager();
        List list2 = ContainerUtil.mapNotNull(files, file -> file != null && file.isValid() ? manager.findDirectory(file) : null);
        if (list2 == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(18);
        }
        return psiElement;
    }

    public static void fillNodeModulesDirContexts(@NotNull PsiElement element, @NotNull Collection<VirtualFile> result2, boolean withTypes) {
        VirtualFile localNodeModulesDir;
        if (element == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(19);
        }
        if (result2 == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(20);
        }
        if ((localNodeModulesDir = JSDefaultFileReferenceContext.findUpNodeModules(element)) != null) {
            VirtualFile current = localNodeModulesDir;
            while (current != null) {
                VirtualFile typesFile;
                if (withTypes && (typesFile = current.findChild("@types")) != null && typesFile.isDirectory()) {
                    result2.add(typesFile);
                }
                result2.add(current);
                VirtualFile parent = current.getParent();
                current = parent == null ? null : NodeModuleUtil.findUpClosestNodeModulesResolveRoot(parent);
            }
        }
    }

    @Nullable
    public static VirtualFile findUpNodeModules(@NotNull PsiElement element) {
        VirtualFile currentFile;
        if (element == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(21);
        }
        if ((currentFile = element.getContainingFile().getOriginalFile().getVirtualFile()) != null) {
            VirtualFile parentNodeModules = NodeModuleSearchUtil.findAncestorNodeModulesDir(currentFile);
            if (parentNodeModules != null) {
                return parentNodeModules;
            }
            return NodeModuleUtil.findUpClosestNodeModulesResolveRoot(currentFile);
        }
        return null;
    }

    @Override
    @NotNull
    public JSDirectorySearchProcessor getNodeModuleSearchProcessor() {
        NodeModuleDirectorySearchProcessor nodeModuleDirectorySearchProcessor = NodeModuleDirectorySearchProcessor.forElement(this.getContext(), this.getImplicitExtensions());
        if (nodeModuleDirectorySearchProcessor == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(22);
        }
        return nodeModuleDirectorySearchProcessor;
    }

    @Override
    @NotNull
    public VirtualFile contextDirectory() {
        if (this.myConfig == null) {
            VirtualFile file = Objects.requireNonNull(PsiUtilCore.getVirtualFile((PsiElement)this.getOriginalFile()));
            if (file instanceof VirtualFileWindow) {
                VirtualFileWindow virtualFileWindow = (VirtualFileWindow)file;
                file = virtualFileWindow.getDelegate();
            }
            VirtualFile virtualFile = file.isDirectory() ? file : file.getParent();
            if (virtualFile == null) {
                JSDefaultFileReferenceContext.$$$reportNull$$$0(23);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = this.myConfig.getConfigDirectory();
        if (virtualFile == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(24);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getRootDirs() {
        if (this.myConfig == null) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                JSDefaultFileReferenceContext.$$$reportNull$$$0(25);
            }
            return list2;
        }
        List list3 = ContainerUtil.map(this.myConfig.getRootDirs(), el -> el.getVirtualFile());
        if (list3 == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(26);
        }
        return list3;
    }

    @Override
    @NotNull
    public Collection<JSModulePathSubstitution> pathsMappings() {
        Collection<JSModulePathSubstitution> collection = this.myConfig != null ? this.myConfig.getPaths() : Collections.emptySet();
        if (collection == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(27);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getMappingRoots() {
        Set<VirtualFile> set = this.myConfig != null ? Collections.singleton(this.myConfig.getMappingRoot()) : Collections.emptySet();
        if (set == null) {
            JSDefaultFileReferenceContext.$$$reportNull$$$0(28);
        }
        return set;
    }

    @Override
    @Nullable
    public VirtualFile baseUrl() {
        return this.myConfig != null ? this.myConfig.getBaseUrl() : null;
    }

    public static String[] withCurrentFileExtension(String[] implicitExtensions, PsiElement element) {
        String extension;
        if (implicitExtensions.length == 0) {
            return implicitExtensions;
        }
        PsiFile file = element.getContainingFile();
        if (element instanceof CssElement && !(file instanceof StylesheetFile)) {
            CssStylesheet stylesheet = (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)element, CssStylesheet.class);
            LanguageFileType fileType = stylesheet != null ? stylesheet.getLanguage().getAssociatedFileType() : null;
            extension = fileType != null ? fileType.getDefaultExtension() : null;
        } else {
            extension = FileUtilRt.getExtension((String)file.getName());
        }
        return !StringUtil.isEmpty((String)extension) && !ArrayUtil.contains((String)extension, (String[])implicitExtensions) ? (String[])ArrayUtil.append((Object[])implicitExtensions, (Object)("." + extension)) : implicitExtensions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 13, 14, 15, 17, 18, 22, 23, 24, 25, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/resolver/JSDefaultFileReferenceContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitExtensions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/resolver/JSDefaultFileReferenceContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExtensions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitExtensions";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toFileSystemItems";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModuleSearchProcessor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "contextDirectory";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDirs";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "pathsMappings";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "defaultWithExtensions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultExtensions";
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRoots";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "toFileSystemItems";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fillNodeModulesDirContexts";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findUpNodeModules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 13, 14, 15, 17, 18, 22, 23, 24, 25, 26, 27, 28 -> new IllegalStateException(string);
        };
    }
}

