/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.library.JSCDNLibManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JSUrlImportsUtil {
    public static final String JS_EXT = ".js";
    public static final String MJS_EXT = ".mjs";
    public static final String[] EXTENSIONS = new String[]{".js", ".mjs"};
    private static final String[] HTTP_PREFIXES = new String[]{"http://", "https://", "//", "ftp://"};
    private static final String WSL_PREFIX = "wsl$";
    private static final Pattern SANITIZE_FILENAME = Pattern.compile("[*?|\":<>]");
    private static String ourRemoteModulesTestRoot;

    private JSUrlImportsUtil() {
    }

    public static boolean isSupportedRemoteModuleUrl(@NotNull String url) {
        if (url == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(0);
        }
        return JSUrlImportsUtil.startsWithRemoteUrlPrefix(url) && JSUrlImportsUtil.isPossibleModuleFile(url);
    }

    @Nullable
    public static Pair<String, String> trimSchema(@NotNull String url) {
        if (url == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(1);
        }
        for (String prefix : HTTP_PREFIXES) {
            if (!url.startsWith(prefix)) continue;
            return Pair.create((Object)StringUtil.trimStart((String)url, (String)prefix), (Object)StringUtil.trimEnd((String)prefix, (String)"://"));
        }
        return null;
    }

    public static boolean startsWithRemoteUrlPrefix(@NotNull String url) {
        if (url == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(2);
        }
        if (url.contains(WSL_PREFIX)) {
            return false;
        }
        for (String prefix : HTTP_PREFIXES) {
            if (!url.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getRemoteModulesDirPath() {
        if (ApplicationManager.getApplication().isUnitTestMode() && ourRemoteModulesTestRoot != null) {
            String string = ourRemoteModulesTestRoot;
            if (string == null) {
                JSUrlImportsUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = FileUtil.join((String[])new String[]{PathManager.getSystemPath(), "javascript", "remoteModules"});
        if (string == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static VirtualFile getRemoteModulesDir() {
        return JSUrlImportsUtil.findFileByPath(JSUrlImportsUtil.getRemoteModulesDirPath());
    }

    public static boolean isInRemoteModulesLibrary(@NotNull VirtualFile file) {
        VirtualFile modulesDir;
        if (file == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(5);
        }
        return (modulesDir = JSUrlImportsUtil.getRemoteModulesDir()) != null && VfsUtilCore.isAncestor((VirtualFile)modulesDir, (VirtualFile)file, (boolean)true);
    }

    @NotNull
    public static String remoteModuleUrlToEntryPath(@NotNull String url, boolean relative, boolean adjustLocation) {
        if (url == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(6);
        }
        url = JSUrlImportsUtil.getRemoteModuleUrlForDownload(url, adjustLocation);
        for (String prefix : HTTP_PREFIXES) {
            if (!url.startsWith(prefix)) continue;
            url = StringUtil.trimStart((String)url, (String)prefix);
            break;
        }
        url = SANITIZE_FILENAME.matcher(url).replaceAll("_");
        url = FileUtil.toSystemDependentName((String)url);
        String string = relative ? url : FileUtil.join((String[])new String[]{JSUrlImportsUtil.getRemoteModulesDirPath(), url});
        if (string == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getRemoteModuleUrlForDownload(@NotNull String url, boolean adjustLocation) {
        if (url == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(8);
        }
        url = JSUrlImportsUtil.normalizeUrl(url);
        if (!adjustLocation) {
            String string = url;
            if (string == null) {
                JSUrlImportsUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        JSCDNLibManager.JSCDNLibrary library = JSCDNLibManager.getLibraryForUrl(url);
        if (library != null) {
            String string = library.getNonMinifiedUrl(true);
            if (string == null) {
                JSUrlImportsUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = JSLibraryUtil.convertLocationSuffixToNonMinimized(url);
        if (string == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static boolean isPossibleModuleFile(@NotNull String urlOrFilename) {
        if (urlOrFilename == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(12);
        }
        return (urlOrFilename = JSUrlImportsUtil.normalizeUrl(urlOrFilename)).endsWith(JS_EXT) || urlOrFilename.endsWith(MJS_EXT);
    }

    @NotNull
    private static String normalizeUrl(@NotNull String urlOrFilename) {
        if (urlOrFilename == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(13);
        }
        if (JSUrlImportsUtil.startsWithRemoteUrlPrefix(urlOrFilename)) {
            urlOrFilename = JSUrlImportsUtil.trimPath(urlOrFilename);
        }
        String string = urlOrFilename;
        if (string == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String trimPath(@NotNull String url) {
        if (url == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(15);
        }
        for (int i = 0; i < url.length(); ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '?': {
                    String string = url.substring(0, i);
                    if (string == null) {
                        JSUrlImportsUtil.$$$reportNull$$$0(16);
                    }
                    return string;
                }
            }
        }
        String string = url;
        if (string == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @TestOnly
    public static void setRemoteModulesTestRoot(@Nullable String remoteModulesTestRoot) {
        ourRemoteModulesTestRoot = remoteModulesTestRoot;
    }

    @Nullable
    public static VirtualFile findFileByPath(@Nullable String path2) {
        if (StringUtil.isEmpty((String)path2)) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path2);
        if (file == null && ApplicationManager.getApplication().isUnitTestMode()) {
            return TempFileSystem.getInstance().findFileByPath(path2);
        }
        return file;
    }

    @NotNull
    public static Set<String> collectAllImportReferences(@NotNull JSFile file) {
        if (file == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(18);
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            final HashSet references = new HashSet();
            JSRecursiveWalkingElementVisitor visitor = new JSRecursiveWalkingElementVisitor(){

                @Override
                public void visitES6ImportDeclaration(@NotNull ES6ImportDeclaration importDeclaration) {
                    if (importDeclaration == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitES6ImportDeclaration(importDeclaration);
                    if (!StringUtil.isEmpty((String)importDeclaration.getImportModuleText())) {
                        this.addReferenceText((PsiElement)importDeclaration);
                    } else {
                        this.addReferenceText((PsiElement)importDeclaration.getFromClause());
                    }
                }

                @Override
                public void visitES6ExportDeclaration(@NotNull ES6ExportDeclaration exportDeclaration) {
                    if (exportDeclaration == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.visitES6ExportDeclaration(exportDeclaration);
                    this.addReferenceText((PsiElement)exportDeclaration.getFromClause());
                }

                @Override
                public void visitES6ImportCall(@NotNull ES6ImportCall importCall) {
                    if (importCall == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    super.visitES6ImportCall(importCall);
                    this.addReferenceText((PsiElement)importCall.getStringArgument());
                }

                private void addReferenceText(@Nullable PsiElement element) {
                    if (element == null) {
                        return;
                    }
                    Pair<String, PsiElement> literalWithText = JSPsiImplUtils.getChildStringLiteralWithText(element);
                    if (literalWithText == null) {
                        return;
                    }
                    String url = JSStringUtil.unquoteStringLiteralValue((String)literalWithText.first);
                    if (StringUtil.isEmptyOrSpaces((String)url)) {
                        return;
                    }
                    references.add(url);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "importDeclaration";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "exportDeclaration";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "importCall";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSUrlImportsUtil$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitES6ImportDeclaration";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitES6ExportDeclaration";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitES6ImportCall";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            file.accept(visitor);
            return CachedValueProvider.Result.createSingleDependency(Collections.unmodifiableSet(references), (Object)file);
        });
        if (set == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(19);
        }
        return set;
    }

    public static boolean isRemoteModuleReferenceAttribute(@NotNull XmlAttribute attribute, @NotNull XmlAttributeValue attributeValue) {
        if (attribute == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(20);
        }
        if (attributeValue == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(21);
        }
        if (!"src".equals(attribute.getName())) {
            return false;
        }
        XmlTag tag = attribute.getParent();
        return HtmlUtil.isScriptTag((XmlTag)tag) && JSUrlImportsUtil.isModuleContext(tag, attributeValue);
    }

    public static boolean isModuleContext(@NotNull XmlTag scriptTag, @Nullable XmlAttributeValue attributeValue) {
        if (scriptTag == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(22);
        }
        return Objects.equals(scriptTag.getAttributeValue("type"), "module") || attributeValue != null && attributeValue.getValue().endsWith(MJS_EXT);
    }

    @NotNull
    public static Icon getIcon() {
        Icon icon2 = AllIcons.General.Web;
        if (icon2 == null) {
            JSUrlImportsUtil.$$$reportNull$$$0(23);
        }
        return icon2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 9, 10, 11, 14, 16, 17, 19, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSUrlImportsUtil";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlOrFilename";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSUrlImportsUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteModulesDirPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "remoteModuleUrlToEntryPath";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteModuleUrlForDownload";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeUrl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "trimPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllImportReferences";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedRemoteModuleUrl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "trimSchema";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startsWithRemoteUrlPrefix";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInRemoteModulesLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remoteModuleUrlToEntryPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteModuleUrlForDownload";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleModuleFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "normalizeUrl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "trimPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectAllImportReferences";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isRemoteModuleReferenceAttribute";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isModuleContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 9, 10, 11, 14, 16, 17, 19, 23 -> new IllegalStateException(string);
        };
    }
}

