/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPathResolution {
    public static final JSPathResolution EMPTY = new JSPathResolution(Collections.emptyList(), false, false);
    @NotNull
    private final List<VirtualFile> myFiles;
    private final boolean myFullChainResolved;
    private final boolean myRemapped;

    public JSPathResolution(@NotNull List<VirtualFile> files, boolean fullChainResolved, boolean remapped) {
        if (files == null) {
            JSPathResolution.$$$reportNull$$$0(0);
        }
        this.myFiles = files;
        this.myFullChainResolved = fullChainResolved;
        this.myRemapped = remapped;
    }

    @NotNull
    public List<VirtualFile> getChain() {
        List<VirtualFile> list2 = this.myFiles;
        if (list2 == null) {
            JSPathResolution.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public int size() {
        return this.myFiles.size();
    }

    @Nullable
    public VirtualFile resolvedTarget() {
        return this.myFullChainResolved ? this.myFiles.get(this.myFiles.size() - 1) : null;
    }

    public boolean isFullChainResolved() {
        return this.myFullChainResolved;
    }

    public boolean isRemapped() {
        return this.myRemapped;
    }

    public ResolveResult @NotNull [] getResolveResults(@NotNull PsiElement context2, int index) {
        PsiDirectory element;
        if (context2 == null) {
            JSPathResolution.$$$reportNull$$$0(2);
        }
        if (this.myFiles.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSPathResolution.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (!this.myFullChainResolved && index >= this.myFiles.size()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSPathResolution.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (this.myFiles.size() <= index) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSPathResolution.$$$reportNull$$$0(5);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        VirtualFile file = this.myFiles.get(index);
        PsiManager manager = context2.getManager();
        Object object = element = file.isDirectory() ? manager.findDirectory(file) : manager.findFile(file);
        if (element == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSPathResolution.$$$reportNull$$$0(6);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] results = new ResolveResult[]{new PsiElementResolveResult((PsiElement)element)};
        if (results == null) {
            JSPathResolution.$$$reportNull$$$0(7);
        }
        return results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSPathResolution that = (JSPathResolution)o;
        return this.myFullChainResolved == that.myFullChainResolved && this.myRemapped == that.myRemapped && this.myFiles.equals(that.myFiles);
    }

    public int hashCode() {
        return Objects.hash(this.myFiles, this.myFullChainResolved, this.myRemapped);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSPathResolution";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSPathResolution";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChain";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResults";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

