/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.codeInsight.completion.FileReferenceWithExtendedCompletion;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.packages.NodePackageLinkResolver;
import com.intellij.javascript.nodejs.reference.NodeFileModulePsiReferenceBase;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferenceCache;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.modules.JSMappingReferenceSet;
import com.intellij.lang.javascript.frameworks.modules.JSPathResolution;
import com.intellij.lang.javascript.frameworks.modules.JSReferencePathUpdater;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSFileReferenceAltResolver;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSFileReferenceContext;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.lang.typescript.modules.TypeScriptNodeSearchProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.URLUtil;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class JSFileModuleReference
extends JSFileReference
implements FileReferenceWithExtendedCompletion,
HighlightSeverityHolder {
    @NotNull
    private final JSFileReferenceContext myContext;
    @NotNull
    private final JSFileReferenceAltResolver myResolver;

    public JSFileModuleReference(String text2, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet, @NotNull JSFileReferenceContext context2, @NotNull JSFileReferenceAltResolver resolver) {
        if (fileReferenceSet == null) {
            JSFileModuleReference.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSFileModuleReference.$$$reportNull$$$0(1);
        }
        if (resolver == null) {
            JSFileModuleReference.$$$reportNull$$$0(2);
        }
        super(text2, offset, textRange, fileReferenceSet);
        this.myContext = context2;
        this.myResolver = resolver;
    }

    @Override
    @NotNull
    public @NotNull String @NotNull [] getImplicitExtensions() {
        String[] stringArray = this.myContext.getImplicitExtensions();
        if (stringArray == null) {
            JSFileModuleReference.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    protected ResolveResult @NotNull [] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile2) {
        if (containingFile2 == null) {
            JSFileModuleReference.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)this.getFileReferenceSet().getPathString())) {
            PsiFile file = this.getElement().getContainingFile();
            if (file == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    JSFileModuleReference.$$$reportNull$$$0(5);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            PsiDirectory directory = file.getContainingDirectory();
            if (directory == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    JSFileModuleReference.$$$reportNull$$$0(6);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)directory)};
            if (resolveResultArray == null) {
                JSFileModuleReference.$$$reportNull$$$0(7);
            }
            return resolveResultArray;
        }
        JSPathResolution resolve = this.myResolver.altResolveWithCache();
        if (resolve != null) {
            ResolveResult[] resolveResultArray = this.replaceNonModuleFiles(resolve.getResolveResults(this.getElement(), this.getIndex()));
            if (resolveResultArray == null) {
                JSFileModuleReference.$$$reportNull$$$0(8);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            JSFileModuleReference.$$$reportNull$$$0(9);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public void bindToExtendedElement(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiFile contextFile;
        String path2;
        PsiElement context2;
        if (element == null) {
            JSFileModuleReference.$$$reportNull$$$0(10);
        }
        if (JSCodeStyleSettings.isUseAbsolutePath(context2 = this.getElement())) {
            String path3 = JSFileModuleReference.getPathFromDefaultContext(this.getFileReferenceSet(), element, false);
            if (path3 != null) {
                this.trimPathExtension(path3);
            }
        } else if (element instanceof PsiFile && (path2 = PsiFileSystemItemUtil.findRelativePath((PsiFileSystemItem)(contextFile = context2.getContainingFile()), (PsiFileSystemItem)((PsiFile)element))) != null) {
            this.trimPathExtension((String)(path2.startsWith(".") ? path2 : "./" + path2));
        }
    }

    @Nullable
    protected LookupElement createLookupItem(@NotNull PsiElement candidate) {
        PsiDirectory directory;
        PsiDirectory directParent;
        PsiDirectory nodeModulesCandidate;
        if (candidate == null) {
            JSFileModuleReference.$$$reportNull$$$0(11);
        }
        if (candidate instanceof PsiDirectory && (nodeModulesCandidate = (directParent = (directory = (PsiDirectory)candidate).getParent())) != null) {
            if ("@types".equals(directParent.getName())) {
                nodeModulesCandidate = nodeModulesCandidate.getParent();
            }
            if (nodeModulesCandidate != null && "node_modules".equals(nodeModulesCandidate.getName())) {
                VirtualFile context2 = PsiUtilCore.getVirtualFile((PsiElement)this.getElement());
                CompletionModuleInfo module = this.createCompletionModuleInfo(directory.getName(), directory);
                return NodeFileModulePsiReferenceBase.createLookupElement(context2, module, directory.getProject());
            }
        }
        return JSCompletionUtil.createLookupElementForJSModule(candidate, this.getElement(), this.getImplicitExtensions(), this.fixLookupItemWithRelativePath(candidate));
    }

    @NotNull
    protected CompletionModuleInfo createCompletionModuleInfo(@NotNull String name, @NotNull PsiDirectory directory) {
        if (name == null) {
            JSFileModuleReference.$$$reportNull$$$0(12);
        }
        if (directory == null) {
            JSFileModuleReference.$$$reportNull$$$0(13);
        }
        CompletionModuleInfo completionModuleInfo = (CompletionModuleInfo)TypeScriptNodeSearchProcessor.MAP_COMPLETION_MODULE.fun((Object)new CompletionModuleInfo(name, directory.getVirtualFile(), ModuleType.NODE_MODULES_DIR));
        if (completionModuleInfo == null) {
            JSFileModuleReference.$$$reportNull$$$0(14);
        }
        return completionModuleInfo;
    }

    private boolean fixLookupItemWithRelativePath(@Nullable PsiElement candidate) {
        Collection<PsiPolyVariantReference> parentReferences;
        if (!(candidate instanceof PsiFileSystemItem)) {
            return false;
        }
        PsiElement element = this.getElement();
        if (!(element instanceof ES6ImportExportDeclaration) && !(element.getParent() instanceof ES6ImportExportDeclaration)) {
            return false;
        }
        String name = ((PsiFileSystemItem)candidate).getName();
        FileReferenceSet set = this.getFileReferenceSet();
        if (set.getAllReferences().length != 1) {
            return false;
        }
        if (set instanceof JSMappingReferenceSet.MappingFileReferenceSet && !(parentReferences = ((JSMappingReferenceSet.MappingFileReferenceSet)set).getParentReferences()).isEmpty()) {
            return false;
        }
        String text2 = set.getPathString();
        if (text2.startsWith(".")) {
            return false;
        }
        int index = text2.indexOf("IntellijIdeaRulezzz");
        String string = text2 = index > 0 ? text2.substring(0, index) : text2;
        if (!name.startsWith(text2) && !text2.equals("IntellijIdeaRulezzz")) {
            return false;
        }
        PsiElement currentElement = this.getElement();
        PsiDirectory directory = currentElement.getContainingFile().getOriginalFile().getParent();
        return candidate.getParent() == directory && !JSCodeStyleSettings.isUseAbsolutePath(currentElement);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement psiElement;
        if (element == null) {
            JSFileModuleReference.$$$reportNull$$$0(15);
        }
        if ((psiElement = this.getElementIfReferenceIsBroken()) != null) {
            return psiElement;
        }
        return super.bindToElement(element);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSFileModuleReference.$$$reportNull$$$0(16);
        }
        String newName = newElementName;
        if (this.isLast()) {
            newName = this.fixLastNameForRename(newName);
        }
        return super.handleElementRename(this.fixRelativePath(newName));
    }

    @Nullable
    public String getNewFileTemplateName() {
        return DialectDetector.isTypeScript(this.getElement()) ? "TypeScript_module.ts" : super.getNewFileTemplateName();
    }

    @NotNull
    protected @NotNull ResolveResult @NotNull [] replaceNonModuleFiles(@NotNull @NotNull ResolveResult @NotNull [] results) {
        if (results == null) {
            JSFileModuleReference.$$$reportNull$$$0(17);
        }
        if (results.length == 0) {
            if (results == null) {
                JSFileModuleReference.$$$reportNull$$$0(18);
            }
            return results;
        }
        JSModuleStatusOwner.ModuleStatus status = ES6PsiUtil.getModuleStatus(this.getElement());
        if (status == JSModuleStatusOwner.ModuleStatus.NONE) {
            if (results == null) {
                JSFileModuleReference.$$$reportNull$$$0(19);
            }
            return results;
        }
        JSFileReferenceCache cache2 = JSFileReferenceCache.getInstance(this.getElement().getProject());
        for (int i = 0; i < results.length; ++i) {
            ResolveResult result2 = results[i];
            PsiElement element = result2.getElement();
            if (!(element instanceof JSFile) || !cache2.isUnindexedJSFile((PsiFile)element) && ((JSFile)element).isCommonJSModule()) continue;
            results[i] = new PsiElementResolveResult(element, false);
        }
        if (results == null) {
            JSFileModuleReference.$$$reportNull$$$0(20);
        }
        return results;
    }

    @Nullable
    private PsiElement getElementIfReferenceIsBroken() {
        PsiElement context2 = this.getElement();
        if (!context2.isValid()) {
            return null;
        }
        String text2 = context2.getText();
        if (text2 != null) {
            TextRange range = this.getRangeInElement();
            String rowValue = text2.length() > range.getEndOffset() ? range.substring(text2) : null;
            String curText = this.getText();
            if (rowValue == null || !curText.equals(rowValue) && !curText.equals(JSStringUtil.unescapeStringLiteralValue(rowValue))) {
                return this.getElement();
            }
        }
        return null;
    }

    private void trimPathExtension(String path2) {
        String[] extensions = this.getSortedByLengthImplicitExtensions();
        String extension = JSFileReferencesUtil.findExtension(path2, extensions);
        this.rename(extension == null ? path2 : path2.substring(0, path2.length() - extension.length()));
    }

    @Override
    public int getWeight() {
        return this.myContext.getReferencesWeight();
    }

    @Override
    @NotNull
    protected String fixLastNameForRename(@NotNull String beforeProcessing) {
        if (beforeProcessing == null) {
            JSFileModuleReference.$$$reportNull$$$0(21);
        }
        String newName = super.fixLastNameForRename(beforeProcessing);
        String indexSuffix = "/index";
        if (this.getText().endsWith(indexSuffix) || !newName.endsWith(indexSuffix)) {
            String string = newName;
            if (string == null) {
                JSFileModuleReference.$$$reportNull$$$0(22);
            }
            return string;
        }
        PsiElement element = this.getElement();
        if (!element.isValid() || !JSCodeStyleSettings.isUseNodeResolution(element)) {
            String string = newName;
            if (string == null) {
                JSFileModuleReference.$$$reportNull$$$0(23);
            }
            return string;
        }
        String withoutIndex = newName.substring(0, newName.length() - indexSuffix.length());
        String string = withoutIndex.isEmpty() ? newName : withoutIndex;
        if (string == null) {
            JSFileModuleReference.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static VirtualFile getCanonicalPreferredFile(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile canonicalFile;
        if (project == null) {
            JSFileModuleReference.$$$reportNull$$$0(25);
        }
        if (file == null) {
            JSFileModuleReference.$$$reportNull$$$0(26);
        }
        if ((canonicalFile = NodePackageLinkResolver.INSTANCE.resolve(file)).equals(file)) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                JSFileModuleReference.$$$reportNull$$$0(27);
            }
            return virtualFile;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        if (fileIndex.isInContent(canonicalFile)) {
            VirtualFile virtualFile = canonicalFile;
            if (virtualFile == null) {
                JSFileModuleReference.$$$reportNull$$$0(28);
            }
            return virtualFile;
        }
        if (fileIndex.isInContent(file)) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                JSFileModuleReference.$$$reportNull$$$0(29);
            }
            return virtualFile;
        }
        if (fileIndex.isInLibrary(canonicalFile)) {
            VirtualFile virtualFile = canonicalFile;
            if (virtualFile == null) {
                JSFileModuleReference.$$$reportNull$$$0(30);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = fileIndex.isInLibrary(file) ? file : canonicalFile;
        if (virtualFile == null) {
            JSFileModuleReference.$$$reportNull$$$0(31);
        }
        return virtualFile;
    }

    protected Collection<PsiFileSystemItem> getContextsForBindToElement(VirtualFile curVFile, Project project, FileReferenceHelper helper) {
        return this.getFileReferenceSet().getDefaultContexts();
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        JSReferencePathUpdater updater;
        PsiElement result2;
        if (element == null) {
            JSFileModuleReference.$$$reportNull$$$0(32);
        }
        return (result2 = (updater = new JSReferencePathUpdater(this, this.myContext, element, absolute)).bind()) != null ? result2 : super.bindToElement(element, absolute);
    }

    @NotNull
    public String decode(@NotNull String text2) {
        if (text2 == null) {
            JSFileModuleReference.$$$reportNull$$$0(33);
        }
        String string = this.myContext.isUrlEncoded() ? JSFileReferencesUtil.decodePathChars(text2) : super.decode(text2);
        if (string == null) {
            JSFileModuleReference.$$$reportNull$$$0(34);
        }
        return string;
    }

    @Nullable
    protected String encode(String name, PsiElement psiElement) {
        return this.myContext.isUrlEncoded() ? JSFileModuleReference.encodePathChars(name) : super.encode(name, psiElement);
    }

    @Override
    @NotNull
    protected String fixExtension(@NotNull String newName, @NotNull String oldRefText) {
        String oldExtension;
        String newExtension;
        if (newName == null) {
            JSFileModuleReference.$$$reportNull$$$0(35);
        }
        if (oldRefText == null) {
            JSFileModuleReference.$$$reportNull$$$0(36);
        }
        if ((newExtension = JSFileReferencesUtil.findExtension(newName, TypeScriptUtil.TYPESCRIPT_EXTENSIONS)) != null && (oldExtension = JSFileReferencesUtil.findExtension(oldRefText, TypeScriptUtil.JAVASCRIPT_EXTENSIONS)) != null) {
            String string = this.fixExtension(newName.substring(0, newName.length() - newExtension.length()) + oldExtension, oldRefText);
            if (string == null) {
                JSFileModuleReference.$$$reportNull$$$0(37);
            }
            return string;
        }
        String string = super.fixExtension(newName, oldRefText);
        if (string == null) {
            JSFileModuleReference.$$$reportNull$$$0(38);
        }
        return string;
    }

    @Nullable
    private static String encodePathChars(@Nullable String name) {
        if (name == null) {
            return null;
        }
        try {
            String url = URLUtil.encodeURIComponent((String)name);
            return url.replace("%20", " ");
        }
        catch (Exception ignored) {
            return name;
        }
    }

    @Override
    @NotNull
    public HighlightSeverity getUnresolvedReferenceSeverity() {
        HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
        if (highlightSeverity == null) {
            JSFileModuleReference.$$$reportNull$$$0(39);
        }
        return highlightSeverity;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7, 8, 9, 14, 18, 19, 20, 22, 23, 24, 27, 28, 29, 30, 31, 34, 37, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSFileModuleReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 10: 
            case 15: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeProcessing";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRefText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSFileModuleReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitExtensions";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionModuleInfo";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceNonModuleFiles";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "fixLastNameForRename";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalPreferredFile";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "fixExtension";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedReferenceSeverity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 37: 
            case 38: 
            case 39: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindToExtendedElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createLookupItem";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionModuleInfo";
                break;
            }
            case 15: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceNonModuleFiles";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fixLastNameForRename";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalPreferredFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fixExtension";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 7, 8, 9, 14, 18, 19, 20, 22, 23, 24, 27, 28, 29, 30, 31, 34, 37, 38, 39 -> new IllegalStateException(string);
        };
    }
}

