/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.ecmascript6.resolve.JSProcessedPath;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.frameworks.amd.JSAmdBaseUrlIndex;
import com.intellij.lang.javascript.frameworks.modules.JSModuleFileReferenceSet;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSDefaultFileReferenceAltResolver;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSDefaultFileReferenceContext;
import com.intellij.lang.javascript.index.JSCustomSingleEntriesIndex;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class JSDefaultModuleReferenceContributor
implements JSModuleReferenceContributor {
    @Override
    public PsiReference @NotNull [] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(0);
        }
        if (host == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(1);
        }
        if (JSUrlImportsUtil.startsWithRemoteUrlPrefix(unquotedRefText)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JSDefaultModuleReferenceContributor.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        JSProcessedPath actualPath = JSProcessedPath.getActualPath(unquotedRefText, offset);
        String modulePath = actualPath.fixedPath;
        int actualOffset = actualPath.fixedOffset;
        String scheme = JSFileReferencesUtil.findFileUrlPrefix(modulePath);
        if (scheme != null) {
            actualOffset += scheme.length();
            modulePath = modulePath.substring(scheme.length());
        }
        PsiReference[] psiReferenceArray = this.getReferences(host, modulePath, actualOffset, scheme);
        if (psiReferenceArray == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    @Override
    @NotNull
    public Collection<PsiElement> resolveReferences(@NotNull PsiElement context2, @NotNull String unquotedRefText) {
        if (context2 == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(4);
        }
        if (unquotedRefText == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(5);
        }
        if (JSUrlImportsUtil.startsWithRemoteUrlPrefix(unquotedRefText)) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                JSDefaultModuleReferenceContributor.$$$reportNull$$$0(6);
            }
            return set;
        }
        String modulePath = JSProcessedPath.getActualPathString(unquotedRefText);
        String scheme = JSFileReferencesUtil.findFileUrlPrefix(modulePath);
        if (scheme != null) {
            modulePath = modulePath.substring(scheme.length());
        }
        JSDefaultFileReferenceContext referenceContext = JSDefaultModuleReferenceContributor.createReferenceContext(context2, modulePath, scheme);
        Collection<PsiElement> collection = JSDefaultFileReferenceAltResolver.resolvePsiElements(context2, referenceContext, modulePath);
        if (collection == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(7);
        }
        return collection;
    }

    protected PsiReference @NotNull [] getReferences(@NotNull PsiElement host, String modulePath, int index, @Nullable String scheme) {
        if (host == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(8);
        }
        FileReference[] fileReferenceArray = new JSModuleFileReferenceSet(modulePath, JSDefaultModuleReferenceContributor.createReferenceContext(host, modulePath, scheme), host, index).getAllReferences();
        if (fileReferenceArray == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(9);
        }
        return fileReferenceArray;
    }

    @NotNull
    private static JSDefaultFileReferenceContext createReferenceContext(@NotNull PsiElement host, @NotNull String modulePath, final @Nullable String scheme) {
        if (host == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(10);
        }
        if (modulePath == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(11);
        }
        return new JSDefaultFileReferenceContext(modulePath, host, (JSConfig)TypeScriptConfigUtil.getConfigForPsiFile(host.getContainingFile(), true)){

            @Override
            public boolean isUrlEncoded() {
                return scheme != null;
            }
        };
    }

    @Override
    @NotNull
    public Collection<?> getDependencies(@NotNull String unquoted, @NotNull PsiElement host) {
        if (unquoted == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(12);
        }
        if (host == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(13);
        }
        ArrayList<Object> deps = new ArrayList<Object>();
        TypeScriptConfig file = TypeScriptConfigUtil.getConfigForPsiFile(host.getContainingFile(), true);
        if (file != null) {
            deps.addAll(file.getDependencies());
        }
        deps.add(TypeScriptConfigService.Provider.get(host.getProject()).getTracker());
        Project project = host.getProject();
        JSDefaultModuleReferenceContributor.addNodeModulesDependencies(project, deps, unquoted);
        deps.add(JSModuleReferenceContributor.getIndexModificationTracker(host, JSAmdBaseUrlIndex.KEY));
        deps.add(JSModuleReferenceContributor.getFileBasedIndexModificationTracker(host, JSCustomSingleEntriesIndex.INDEX_ID));
        ArrayList<Object> arrayList = deps;
        if (arrayList == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public static void addNodeModulesDependencies(@NotNull Project project, @NotNull List<Object> deps, @NotNull String unquoted) {
        String modulePath;
        if (project == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(15);
        }
        if (deps == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(16);
        }
        if (unquoted == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(17);
        }
        if (!JSFileReferencesUtil.isRelative(modulePath = JSProcessedPath.getActualPathString(unquoted))) {
            deps.add(NodeModulesDirectoryManager.getInstance(project).getNodeModulesDirChangeTracker());
            deps.add(YarnPnpManager.getInstance(project).getYarnChangeTracker());
            deps.add(PackageJsonFileManager.getInstance(project).getModificationTracker());
        }
    }

    @Override
    @NotNull
    public Collection<LookupElement> getLookupElements(@NotNull String unquotedEscapedText, @NotNull PsiElement host) {
        if (unquotedEscapedText == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(18);
        }
        if (host == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(19);
        }
        return JSDefaultModuleReferenceContributor.getMappedLookupElements(host);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(20);
        }
        return !DialectDetector.isTypeScript(host);
    }

    @NotNull
    public static Collection<LookupElement> getMappedLookupElements(@NotNull PsiElement host) {
        VirtualFile file;
        if (host == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(21);
        }
        if ((file = PsiUtilCore.getVirtualFile((PsiElement)host)) == null) {
            List<LookupElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSDefaultModuleReferenceContributor.$$$reportNull$$$0(22);
            }
            return list2;
        }
        TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile(host.getContainingFile(), true);
        if (config == null) {
            List<LookupElement> list3 = Collections.emptyList();
            if (list3 == null) {
                JSDefaultModuleReferenceContributor.$$$reportNull$$$0(23);
            }
            return list3;
        }
        Collection<JSModulePathSubstitution> paths = config.getPaths();
        if (paths.isEmpty()) {
            List<LookupElement> list4 = Collections.emptyList();
            if (list4 == null) {
                JSDefaultModuleReferenceContributor.$$$reportNull$$$0(24);
            }
            return list4;
        }
        SmartList result2 = new SmartList();
        for (JSModulePathSubstitution substitution : paths) {
            String variant;
            String pattern = substitution.getPattern();
            boolean hasStar = pattern.contains("*");
            if (hasStar && !JSPathMappingsUtil.isPatternOrMappingEndsWithStar(pattern)) continue;
            String string = variant = hasStar ? pattern.substring(0, pattern.length() - 1) : pattern;
            if (variant.isEmpty()) continue;
            LookupElementBuilder newBuilder = LookupElementBuilder.create((String)variant);
            result2.add((Object)newBuilder.withIcon(AllIcons.Nodes.Folder));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(25);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7, 9, 14, 22, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedRefText";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquoted";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deps";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedEscapedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllReferences";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappedLookupElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllReferences";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferences";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceContext";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addNodeModulesDependencies";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElements";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMappedLookupElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7, 9, 14, 22, 23, 24, 25 -> new IllegalStateException(string);
        };
    }
}

