/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.html;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.frameworks.html.JSStaticDirectoriesFileReferenceHelperKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/javascript/frameworks/html/JSStaticDirectoriesFileReferenceHelper;", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper;", "()V", "findRoot", "Lcom/intellij/psi/PsiFileSystemItem;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getContexts", "", "getRoots", "module", "Lcom/intellij/openapi/module/Module;", "hostFile", "isMine", "", "contextFile", "referencedFile", "intellij.javascript.impl"})
public final class JSStaticDirectoriesFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module, @NotNull VirtualFile hostFile) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)hostFile, (String)"hostFile");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.getRoots(project, hostFile);
    }

    @Nullable
    public PsiFileSystemItem findRoot(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiFileSystemItem psiFileSystemItem = this.getPsiFileSystemItem(project, file);
        if (psiFileSystemItem == null) {
            return null;
        }
        PsiFileSystemItem psiFile = psiFileSystemItem;
        return (PsiFileSystemItem)CollectionsKt.firstOrNull((Iterable)JSStaticDirectoriesFileReferenceHelperKt.getFixedDirectories(psiFile, JSStaticDirectoriesFileReferenceHelperKt.access$getStaticDirectories$p(), true));
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return CollectionsKt.emptyList();
    }

    private final Collection<PsiFileSystemItem> getRoots(Project project, VirtualFile file) {
        PsiFileSystemItem psiFileSystemItem = this.getPsiFileSystemItem(project, file);
        if (psiFileSystemItem == null) {
            return CollectionsKt.emptyList();
        }
        PsiFileSystemItem psiFile = psiFileSystemItem;
        return JSStaticDirectoriesFileReferenceHelperKt.getFixedDirectories$default(psiFile, JSStaticDirectoriesFileReferenceHelperKt.access$getStaticDirectories$p(), false, 4, null);
    }

    public boolean isMine(@NotNull Project project, @NotNull VirtualFile contextFile, @NotNull VirtualFile referencedFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        Intrinsics.checkNotNullParameter((Object)referencedFile, (String)"referencedFile");
        return this.isMine(project, contextFile);
    }

    public boolean isMine(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file)) {
            return false;
        }
        FileType fileType = file.getFileType();
        LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
        if (languageFileType == null) {
            return false;
        }
        LanguageFileType fileType2 = languageFileType;
        Language language = fileType2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        return language2 instanceof HTMLLanguage || language2 instanceof JSLanguageDialect;
    }
}

