/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.WrapType;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionExitPoint;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.xml.HtmlPolicy;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlPolicy;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavascriptFormattingModelBuilder
implements FormattingModelBuilder {
    public static final Key<Alignment> BLOCK_ALIGNMENT = Key.create((String)"js.block.alignment");

    public static FormattingModel createJSFormattingModel(PsiFile file, CodeStyleSettings settings2, Block rootBlock) {
        Document document2 = FormattingDocumentModelImpl.getDocumentToBeUsedFor((PsiFile)file);
        if (document2 != null && FormattingDocumentModelImpl.canUseDocumentModel((Document)document2, (PsiFile)file) && file instanceof JSFile && file.getContext() == null) {
            return new DocumentBasedFormattingModel(rootBlock, file.getProject(), settings2, file.getFileType(), file);
        }
        return FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)file, (Block)rootBlock, (CodeStyleSettings)settings2);
    }

    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        if (formattingContext == null) {
            JavascriptFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        PsiElement element = formattingContext.getPsiElement();
        CodeStyleSettings settings2 = formattingContext.getCodeStyleSettings();
        Language dialect = JSLanguageUtil.getLanguageDialect(element);
        Alignment alignment = (Alignment)element.getNode().getUserData(BLOCK_ALIGNMENT);
        JSBlockContext jsBlockContext = this.createBlockFactory(settings2, dialect, formattingContext.getFormattingMode());
        Block rootBlock = jsBlockContext.createBlock(element.getNode(), null, alignment, null, null, null);
        FormattingModel formattingModel = JavascriptFormattingModelBuilder.createJSFormattingModel(element.getContainingFile(), settings2, rootBlock);
        XmlFormattingPolicy xmlFormattingPolicy = JavascriptFormattingModelBuilder.getPolicy(element, settings2, formattingModel.getDocumentModel());
        jsBlockContext.setXmlFormattingPolicy(xmlFormattingPolicy);
        FormattingModel formattingModel2 = formattingModel;
        if (formattingModel2 == null) {
            JavascriptFormattingModelBuilder.$$$reportNull$$$0(1);
        }
        return formattingModel2;
    }

    @NotNull
    protected JSBlockContext createBlockFactory(CodeStyleSettings settings2, Language dialect, FormattingMode mode) {
        return new JSBlockContext(settings2, dialect, null, mode);
    }

    @NotNull
    private static XmlFormattingPolicy getPolicy(PsiElement element, CodeStyleSettings settings2, FormattingDocumentModel model) {
        return DialectDetector.isJSX(element) ? new HtmlPolicy(settings2, model){

            public WrapType getWrappingTypeForTagBegin(XmlTag tag) {
                PsiElement parent = tag.getParent();
                if (JavascriptFormattingModelBuilder.isRestrictedProduction(parent)) {
                    return WrapType.NONE;
                }
                if (!(parent instanceof XmlTag)) {
                    return WrapType.NORMAL;
                }
                if (JavascriptFormattingModelBuilder.newlineProhibitedBefore((PsiElement)tag)) {
                    return WrapType.NONE;
                }
                return super.getWrappingTypeForTagBegin(tag);
            }

            public boolean indentChildrenOf(XmlTag parentTag) {
                if (parentTag != null && parentTag.getName().isEmpty()) {
                    return true;
                }
                return super.indentChildrenOf(parentTag);
            }

            public boolean allowWrapBeforeText() {
                return false;
            }

            public boolean insertLineBreakBeforeTag(XmlTag xmlTag) {
                return false;
            }

            protected boolean checkName(XmlTag tag, String option) {
                return this.checkName(tag, option, false);
            }

            protected boolean isInlineTag(XmlTag tag) {
                return StringUtil.isCapitalized((String)tag.getName()) || super.isInlineTag(tag);
            }
        } : new XmlPolicy(settings2, model){

            public WrapType getWrappingTypeForTagBegin(XmlTag tag) {
                if (!(tag.getParent() instanceof XmlTag)) {
                    return WrapType.NORMAL;
                }
                return super.getWrappingTypeForTagBegin(tag);
            }
        };
    }

    private static boolean newlineProhibitedBefore(PsiElement tag) {
        PsiElement prevSibling = tag.getPrevSibling();
        return prevSibling instanceof PsiWhiteSpace && prevSibling.getPrevSibling() instanceof XmlText;
    }

    private static boolean isRestrictedProduction(@Nullable PsiElement parent) {
        return parent instanceof JSFunctionExitPoint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

