/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIndentOptionsEditor
extends SmartIndentOptionsEditor {
    private JCheckBox myIndentOptionsCheckBox;
    private JCheckBox myUseChainedCallsGroupIndent;
    private final Language myDialect;

    public JSIndentOptionsEditor(@Nullable Language dialect) {
        this.myDialect = dialect;
    }

    protected void addComponents() {
        super.addComponents();
        this.myIndentOptionsCheckBox = new JCheckBox(JavaScriptBundle.message("settings.code.style.indent.chained.methods", new Object[0]));
        this.myIndentOptionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSIndentOptionsEditor.this.myUseChainedCallsGroupIndent.setEnabled(JSIndentOptionsEditor.this.myIndentOptionsCheckBox.isSelected());
            }
        });
        this.add(this.myIndentOptionsCheckBox);
        this.myUseChainedCallsGroupIndent = new JCheckBox(JavaScriptBundle.message("settings.code.style.indent.all.chained.calls.in.a.group", new Object[0]));
        this.add(this.myUseChainedCallsGroupIndent);
    }

    public boolean isModified(CodeStyleSettings settings2, CommonCodeStyleSettings.IndentOptions options) {
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)settings2.getCustomSettings(JSCodeStyleSettings.getSettingsClass(this.myDialect));
        return super.isModified(settings2, options) || this.myIndentOptionsCheckBox.isSelected() != jsSettings.INDENT_CHAINED_CALLS || this.myUseChainedCallsGroupIndent.isSelected() != jsSettings.USE_CHAINED_CALLS_GROUP_INDENTS;
    }

    public void apply(CodeStyleSettings settings2, CommonCodeStyleSettings.IndentOptions options) {
        super.apply(settings2, options);
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)settings2.getCustomSettings(JSCodeStyleSettings.getSettingsClass(this.myDialect));
        jsSettings.INDENT_CHAINED_CALLS = this.myIndentOptionsCheckBox.isSelected();
        jsSettings.USE_CHAINED_CALLS_GROUP_INDENTS = this.myUseChainedCallsGroupIndent.isSelected();
    }

    public void reset(@NotNull CodeStyleSettings settings2, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (settings2 == null) {
            JSIndentOptionsEditor.$$$reportNull$$$0(0);
        }
        if (options == null) {
            JSIndentOptionsEditor.$$$reportNull$$$0(1);
        }
        super.reset(settings2, options);
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)settings2.getCustomSettings(JSCodeStyleSettings.getSettingsClass(this.myDialect));
        this.myIndentOptionsCheckBox.setSelected(jsSettings.INDENT_CHAINED_CALLS);
        this.myUseChainedCallsGroupIndent.setSelected(jsSettings.USE_CHAINED_CALLS_GROUP_INDENTS);
        this.myUseChainedCallsGroupIndent.setEnabled(jsSettings.INDENT_CHAINED_CALLS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "options";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/formatter/JSIndentOptionsEditor";
        objectArray[2] = "reset";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

