/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectsMappings;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsFlowSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FlowJSSettingsManager
implements PersistentStateComponent<FlowJSSettings> {
    @NotNull
    private volatile FlowJSSettings myFlowSettings = new FlowJSSettings();

    @NotNull
    public FlowJSSettings getState() {
        FlowJSSettings flowJSSettings = this.myFlowSettings;
        if (flowJSSettings == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(0);
        }
        return flowJSSettings;
    }

    public void loadState(@NotNull FlowJSSettings state) {
        if (state == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(1);
        }
        this.myFlowSettings = state;
    }

    @NotNull
    public FlowJSSettings getRawSettings() {
        FlowJSSettings flowJSSettings = this.myFlowSettings;
        if (flowJSSettings == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(2);
        }
        return flowJSSettings;
    }

    private static boolean hasFlowVersionConfigured(@NotNull Project project) {
        if (project == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(3);
        }
        return JSRootConfiguration.getInstance(project).getLanguageLevel() == JSLanguageLevel.FLOW || JSDialectsMappings.getInstance(project).getMappings().containsValue(JSLanguageLevel.FLOW.getId());
    }

    public static boolean isTypeCheckingEnabled(@Nullable PsiFile file, @NotNull Project project) {
        if (project == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(4);
        }
        return FlowJSSettingsManager.isTypeCheckingConfigured(project) && (file == null || file.getLanguage() == JavaScriptSupportLoader.FLOW_JS);
    }

    public static boolean isTypeCheckingEnabled(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(5);
        }
        if (!FlowJSSettingsManager.isTypeCheckingConfigured(project)) {
            return false;
        }
        if (file == null) {
            return true;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return psiFile == null || psiFile.getLanguage() == JavaScriptSupportLoader.FLOW_JS;
    }

    private static boolean isTypeCheckingConfigured(@NotNull Project project) {
        FlowJSSettings settings2;
        if (project == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(6);
        }
        return (settings2 = FlowJSSettingsManager.getInstance(project).getRawSettings()).getFlowExecutable() != null && settings2.isTypeCheckingEnabled() && FlowJSSettingsManager.hasFlowVersionConfigured(project);
    }

    @Nullable
    public static FlowJSSettings.FlowJSExecutable getFlowExecutable(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(7);
        }
        if (!FlowJSSettingsManager.isTypeCheckingEnabled(file, project)) {
            return null;
        }
        return FlowJSSettingsManager.getInstance(project).getRawSettings().getFlowExecutable();
    }

    public static boolean areOtherServicesEnabled(@NotNull PsiFile file) {
        Project project;
        if (file == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(8);
        }
        return FlowJSSettingsManager.isTypeCheckingEnabled(file, project = file.getProject()) && FlowJSSettingsManager.getInstance(project).getRawSettings().isOtherServicesEnabled();
    }

    public static boolean isAutoSaveEnabled(@NotNull Project project) {
        if (project == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(9);
        }
        return FlowJSSettingsManager.getInstance(project).getRawSettings().isAutoSaveEnabled();
    }

    public static FlowJSSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(10);
        }
        return (FlowJSSettingsManager)project.getService(FlowJSSettingsManager.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSSettingsManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSSettingsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasFlowVersionConfigured";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTypeCheckingEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTypeCheckingConfigured";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFlowExecutable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "areOtherServicesEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAutoSaveEnabled";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

