/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.javascript.JSParameterInfoHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.hints.JSCodeVisionLocations;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSPipeExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptInlayParameterHintsProvider
implements InlayParameterHintsProvider {
    public static final Option NAMES_FOR_ALL_ARGS = new Option("js.only.show.names.for.all.args", JavaScriptBundle.messagePointer("js.param.hints.show.names.for.all.args", new Object[0]), false);
    public static final Option NAMES_FOR_TAGGED_TEMPLATES = new Option("js.only.show.names.for.tagged", JavaScriptBundle.messagePointer("js.param.hints.show.names.for.tagged", new Object[0]), true);
    public static final Option NAMES_FOR_PIPES = new Option("js.only.show.names.for.pipes", JavaScriptBundle.messagePointer("js.param.hints.show.names.for.pipes", new Object[0]), true);
    private static final String SKIP_PARAMETER = "_";
    private static final Set<String> DEFAULT_BLACKLIST = Set.of("(begin*, end*)", "(start*, end*)", "(first*, last*)", "(first*, second*)", "(from*, to*)", "(min*, max*)", "(key, value)", "(format, arg*)", "(message)", "(message, error)", "Array.*(callbackfn, *)", "Array.*(callbackfn)", "Array.*(predicate, *)", "Array.*(predicate)", "require(*)", "Error(*)", "*.set*(*)", "*.add(*)", "*.push(*)", "*.concat(*)", "*.join(*)", "*.forEach(*)", "*.map(*)", "*.map(*, *)", "*.reduce(*, *)", "*.set(*,*)", "*.filter(*)", "*.get(*)", "*.create(*)", "*.log(*)", "*.log(*, *)", "*.error(*)", "*.error(*, *)", "*.debug(*)", "*.debug(*, *)", "*.append(*)", "*.charAt(*)", "*.charCodeAt(*)", "*.codePointAt(*)", "*.indexOf(*, *)", "*.includes(*, *)", "*.padStart(*, *)", "*.padEnd(*, *)", "*.lastIndexOf(*, *)", "*.contains(*)", "*.startsWith(*)", "*.startsWith(*, *)", "*.endsWith(*)", "*.endsWith(*, *)", "Promise.then(*, *)", "Promise.catch(*)", "getElementById(*)", "getElementsByTagName(*)", "Document.write(*)", "Document.writeln(*)");

    @Nullable
    public HintInfo getHintInfo(@NotNull PsiElement element) {
        String name;
        JSExpression expression;
        JSCallLikeExpression callExpression;
        if (element == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(0);
        }
        if ((callExpression = (JSCallLikeExpression)ObjectUtils.tryCast((Object)element, JSCallLikeExpression.class)) == null) {
            return null;
        }
        if (!JSCodeVisionLocations.INSTANCE.acceptsFileContent(callExpression.getContainingFile())) {
            return null;
        }
        JSFunctionItem psiElement = this.resolveSuitableOverload(callExpression);
        if (psiElement == null) {
            return null;
        }
        JSParameterItem[] parameters = psiElement.getParameters();
        if (parameters.length == 0) {
            return null;
        }
        List<JSParameterTypeDecorator> decorators = TypeScriptJSFunctionTypeImpl.expandRestTupleTypes(parameters, -1);
        List parameterNames = ContainerUtil.map(decorators, el -> el.getName());
        String qName = psiElement.getQualifiedName();
        if (qName != null) {
            return new HintInfo.MethodInfo(qName, parameterNames);
        }
        if ((psiElement instanceof TypeScriptCallSignature || psiElement instanceof TypeScriptFunctionType) && (expression = callExpression.getMethodExpression()) instanceof JSReferenceExpression && (name = ((JSReferenceExpression)expression).getReferenceName()) != null) {
            return new HintInfo.MethodInfo(name, parameterNames);
        }
        return null;
    }

    @NotNull
    public List<Option> getSupportedOptions() {
        List<Option> list2 = Arrays.asList(this.getShowNameForAllArgsOption(), this.getShowNameForTaggedOption(), NAMES_FOR_PIPES);
        if (list2 == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(1);
        }
        return list2;
    }

    protected Option getShowNameForAllArgsOption() {
        return NAMES_FOR_ALL_ARGS;
    }

    protected Option getShowNameForTaggedOption() {
        return NAMES_FOR_TAGGED_TEMPLATES;
    }

    @Contract(value="null -> false")
    protected boolean isSuitableCallExpression(@Nullable JSCallLikeExpression expression) {
        if (expression == null) {
            return false;
        }
        boolean showForTagged = this.getShowNameForTaggedOption().get();
        if (!showForTagged && expression instanceof ES6TaggedTemplateExpression) {
            return false;
        }
        return NAMES_FOR_PIPES.get() || !(expression instanceof JSPipeExpression);
    }

    private List<? extends JSFunctionItem> resolveFunctions(@Nullable JSCallLikeExpression callLikeExpression) {
        if (!this.isSuitableCallExpression(callLikeExpression)) {
            return ContainerUtil.emptyList();
        }
        return TypeScriptSignatureChooser.resolveFunctions(callLikeExpression);
    }

    @Nullable
    private JSFunctionItem resolveSuitableOverload(@NotNull JSCallLikeExpression callExpression) {
        JSExpression methodExpression;
        List<? extends JSFunctionItem> psiElements;
        if (callExpression == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(2);
        }
        if (!(psiElements = this.resolveFunctions(callExpression)).isEmpty()) {
            if (psiElements.size() == 1) {
                return psiElements.get(0);
            }
            JSFunctionItem functionItem = TypeScriptSignatureChooser.resolveOverloads(callExpression, psiElements);
            if (functionItem != null) {
                return functionItem;
            }
        }
        if (!this.isSuitableCallExpression(callExpression)) {
            return null;
        }
        if (callExpression.isNewExpression() && (methodExpression = callExpression.getMethodExpression()) instanceof JSReferenceExpression) {
            PsiElement resolved = ((JSReferenceExpression)methodExpression).resolve();
            if (resolved instanceof JSFunctionItem) {
                return (JSFunctionItem)resolved;
            }
            if (resolved instanceof JSClass) {
                String className = ((JSClass)resolved).getName();
                if (className == null) {
                    className = "<anonymous>";
                }
                return new JSImplicitFunctionImpl(new JSImplicitElementStructureImpl(new JSImplicitElementImpl.Builder(className, null)), JSParameterItem.EMPTY_ARRAY, null);
            }
        }
        return JSParameterInfoHandler.getImplicitFunction(callExpression.getMethodExpression());
    }

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element) {
        JSCallLikeExpression callExpression;
        if (element == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(3);
        }
        if ((callExpression = (JSCallLikeExpression)ObjectUtils.tryCast((Object)element, JSCallLikeExpression.class)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(4);
            }
            return list2;
        }
        if (!JSCodeVisionLocations.INSTANCE.acceptsFileContent(element.getContainingFile())) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(5);
            }
            return list3;
        }
        JSFunctionItem functionItem = this.resolveSuitableOverload(callExpression);
        if (functionItem == null) {
            List list4 = ContainerUtil.emptyList();
            if (list4 == null) {
                JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(6);
            }
            return list4;
        }
        if (functionItem.getParameters().length == 0) {
            List list5 = ContainerUtil.emptyList();
            if (list5 == null) {
                JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(7);
            }
            return list5;
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression == null) {
            List<InlayInfo> list6 = Collections.emptyList();
            if (list6 == null) {
                JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(8);
            }
            return list6;
        }
        JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.getInstance().getTypeSubstitutorForMember(functionItem, (PsiElement)methodExpression);
        JSFunctionType functionType2 = JSParameterInfoHandler.mapToFunction(functionItem, substitutor);
        int paramShift = callExpression.getFirstArgumentIndex();
        JSExpression[] arguments = callExpression.getArguments();
        List<JSParameterTypeDecorator> decorators = TypeScriptJSFunctionTypeImpl.expandRestTupleTypes(functionType2.getParameters(), -1);
        int toStop = Math.max(arguments.length, decorators.size() - paramShift);
        ArrayList<InlayInfo> list7 = new ArrayList<InlayInfo>(toStop);
        JSParameterItem restParameter = null;
        boolean isPipe = callExpression instanceof JSPipeExpression;
        boolean hadSpreads = false;
        for (int i = 0; i < toStop && !hadSpreads; ++i) {
            JSExpression argument;
            if (this.skipIndex(i, callExpression)) continue;
            JSExpression jSExpression = argument = i < arguments.length ? arguments[i] : null;
            if (argument == null) break;
            if (argument instanceof JSSpreadExpression) {
                hadSpreads = true;
            }
            JSParameterItem parameter = i + paramShift < decorators.size() ? (JSParameterItem)decorators.get(i + paramShift) : null;
            boolean isInRest = false;
            if (parameter != null && parameter.isRest()) {
                restParameter = parameter;
                boolean bl = isInRest = toStop + paramShift >= decorators.size();
            }
            if (parameter == null) {
                parameter = restParameter;
                isInRest = true;
            }
            if (parameter == null) break;
            if ((!isPipe || !JavaScriptInlayParameterHintsProvider.isValidParameter(parameter)) && !JavaScriptInlayParameterHintsProvider.shouldInlineParameterName((PsiElement)argument, parameter, this.getShowNameForAllArgsOption().get())) continue;
            InlayInfo info2 = this.createInlayInfo(argument, parameter, i - decorators.size() + 1, isInRest);
            if (info2 == null) break;
            list7.add(info2);
        }
        ArrayList<InlayInfo> arrayList = list7;
        if (arrayList == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    protected boolean skipIndex(int i, JSCallLikeExpression expression) {
        return false;
    }

    @Nullable
    public InlayInfo createInlayInfo(@NotNull JSExpression argument, @NotNull JSParameterItem parameter, int restIndex, boolean isInRest) {
        if (argument == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(10);
        }
        if (parameter == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(11);
        }
        if (!isInRest) {
            return new InlayInfo(JavaScriptInlayParameterHintsProvider.getParameterName(parameter), JavaScriptInlayParameterHintsProvider.getInlayOffset(argument));
        }
        InlayInfo defaultInfo = restIndex == 0 ? new InlayInfo(JavaScriptInlayParameterHintsProvider.getParameterName(parameter), JavaScriptInlayParameterHintsProvider.getInlayOffset(argument)) : null;
        JSType paramType = JavaScriptInlayParameterHintsProvider.getParameterType(parameter);
        if (paramType == null) {
            return defaultInfo;
        }
        if (parameter.isRest() && paramType instanceof JSRestTypeImpl) {
            paramType = ((JSRestTypeImpl)paramType).getIterableType();
        }
        if (!(paramType instanceof JSTupleType)) {
            return defaultInfo;
        }
        JSType byIndex = ((JSTupleType)paramType).getTypeByIndex(restIndex);
        if (byIndex == null) {
            return defaultInfo;
        }
        return new InlayInfo(TypeScriptJSFunctionTypeImpl.getNameFromParentOrDefault(parameter, restIndex), JavaScriptInlayParameterHintsProvider.getInlayOffset(argument));
    }

    private static int getInlayOffset(@NotNull JSExpression argument) {
        ASTNode node;
        PsiElement parent;
        if (argument == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(12);
        }
        if ((parent = argument.getParent()) instanceof JSPipeExpression && (node = ((JSPipeExpression)parent).getOperationNode()) != null) {
            return node.getStartOffset();
        }
        return argument.getTextOffset();
    }

    private static JSType getParameterType(@NotNull JSParameterItem parameter) {
        if (parameter == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(13);
        }
        if (parameter instanceof JSParameter) {
            return JSResolveUtil.getElementJSType((PsiElement)parameter);
        }
        return parameter.getInferredType();
    }

    @NotNull
    private static String getParameterName(JSParameterItem element) {
        String string = TypeScriptJSFunctionTypeImpl.getParameterItemPresentableName(element);
        if (string == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(14);
        }
        return string;
    }

    static boolean isLiteralOrUndefined(@Nullable PsiElement argument) {
        return argument instanceof JSLiteralExpression || argument instanceof JSPrefixExpression && ((JSPrefixExpression)argument).getExpression() instanceof JSLiteralExpression || argument instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)argument, "undefined");
    }

    private static boolean shouldInlineParameterName(@NotNull PsiElement argument, @NotNull JSParameterItem parameter, boolean showAll) {
        if (argument == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(15);
        }
        if (parameter == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(16);
        }
        if (!JavaScriptInlayParameterHintsProvider.isValidParameter(parameter)) {
            return false;
        }
        if (showAll) {
            return true;
        }
        if (argument instanceof JSBinaryExpression || argument instanceof JSConditionalExpression || argument instanceof JSObjectLiteralExpression || argument instanceof JSArrayLiteralExpression || argument instanceof JSFunctionExpression && ((JSFunctionExpression)argument).getName() == null) {
            return true;
        }
        return !(argument instanceof JSXmlLiteralExpression) && JavaScriptInlayParameterHintsProvider.isLiteralOrUndefined(argument);
    }

    private static boolean isValidParameter(@NotNull JSParameterItem parameter) {
        if (parameter == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(17);
        }
        if (parameter instanceof JSDestructuringParameter) {
            return false;
        }
        String name = parameter.getName();
        return !StringUtil.isEmpty((String)name) && !SKIP_PARAMETER.equals(name);
    }

    public String getBlacklistExplanationHTML() {
        return JavaScriptBundle.message("js.param.hints.blacklist.pattern.explanation", KeymapUtil.getFirstKeyboardShortcutText((String)"ShowIntentionActions"));
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        Set<String> set = DEFAULT_BLACKLIST;
        if (set == null) {
            JavaScriptInlayParameterHintsProvider.$$$reportNull$$$0(18);
        }
        return set;
    }

    @Nls
    public String getProperty(String key2) {
        return JavaScriptBundle.message(key2, new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 7, 8, 9, 14, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/JavaScriptInlayParameterHintsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/JavaScriptInlayParameterHintsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedOptions";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterHints";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBlackList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHintInfo";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveSuitableOverload";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParameterHints";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createInlayInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInlayOffset";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldInlineParameterName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isValidParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6, 7, 8, 9, 14, 18 -> new IllegalStateException(string);
        };
    }
}

