/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.hints.chain.AbstractDeclarativeCallChainProvider;
import com.intellij.codeInsight.hints.declarative.PresentationTreeBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.editing.JSDeclarativeMethodChainsInlayProvider;
import com.intellij.lang.javascript.editing.JSDeclarativeTypeHintsFactory;
import com.intellij.lang.javascript.hints.JSCodeVisionLocations;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u001c\u0010\u0015\u001a\u00020\u000b2\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00180\u0017H\u0014J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0012\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003H\u0014J1\u0010\"\u001a\u00020\u0004*\u00020\u00032\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)H\u0014\u00a2\u0006\u0002\u0010*J\u000e\u0010+\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0014J\u000e\u0010,\u001a\u0004\u0018\u00010$*\u00020\u0002H\u0014J\u001b\u0010-\u001a\u0004\u0018\u00010\u0003*\u00020$2\u0006\u0010'\u001a\u00020\u0004H\u0014\u00a2\u0006\u0002\u0010.J\u000e\u0010/\u001a\u0004\u0018\u00010$*\u00020$H\u0014R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u00060"}, d2={"Lcom/intellij/lang/javascript/editing/JSDeclarativeMethodChainsInlayProvider;", "Lcom/intellij/codeInsight/hints/chain/AbstractDeclarativeCallChainProvider;", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "Lcom/intellij/lang/javascript/psi/JSType;", "", "()V", "dotQualifiedClass", "Ljava/lang/Class;", "getDotQualifiedClass", "()Ljava/lang/Class;", "areEquivalentForPresentation", "", "jsType", "expressionType", "getTypeComputationContext", "topmostDotQualifiedExpression", "isAvailable", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isChainUnacceptable", "chain", "", "Lcom/intellij/codeInsight/hints/chain/AbstractDeclarativeCallChainProvider$ExpressionWithType;", "isLanguageSupported", "language", "Lcom/intellij/lang/Language;", "isSupportedDialect", "dialectOfElement", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "presentableType", "", "type", "buildTree", "expression", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "context", "treeBuilder", "Lcom/intellij/codeInsight/hints/declarative/PresentationTreeBuilder;", "(Lcom/intellij/lang/javascript/psi/JSType;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/project/Project;Lkotlin/Unit;Lcom/intellij/codeInsight/hints/declarative/PresentationTreeBuilder;)V", "getParentDotQualifiedExpression", "getReceiver", "getType", "(Lcom/intellij/psi/PsiElement;Lkotlin/Unit;)Lcom/intellij/lang/javascript/psi/JSType;", "skipParenthesesAndPostfixOperatorsDown", "intellij.javascript.impl"})
public class JSDeclarativeMethodChainsInlayProvider
extends AbstractDeclarativeCallChainProvider<JSCallExpression, JSType, Unit> {
    protected boolean isAvailable(@NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (!this.isLanguageSupported(language)) {
            return false;
        }
        if (!this.isSupportedDialect(DialectDetector.dialectOfElement((PsiElement)file))) {
            return false;
        }
        return JSCodeVisionLocations.INSTANCE.acceptsFileContent(file);
    }

    protected boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return !(language instanceof JSLanguageDialect) || !((JSLanguageDialect)language).getOptionHolder().isTypeScript;
    }

    protected boolean isSupportedDialect(@Nullable DialectOptionHolder dialectOfElement) {
        return dialectOfElement != null && dialectOfElement.isJavaScript();
    }

    protected void buildTree(@NotNull JSType $this$buildTree, @NotNull PsiElement expression, @NotNull Project project, @NotNull Unit context2, @NotNull PresentationTreeBuilder treeBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$buildTree, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)treeBuilder, (String)"treeBuilder");
        JSDeclarativeTypeHintsFactory.INSTANCE.typeHint($this$buildTree, treeBuilder);
    }

    @Nullable
    protected JSType getType(@NotNull PsiElement $this$getType, @NotNull Unit context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if ($this$getType instanceof JSNewExpression) {
            return null;
        }
        return TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getExpressionJSType((JSExpression)$this$getType));
    }

    @NotNull
    protected Class<JSCallExpression> getDotQualifiedClass() {
        return JSCallExpression.class;
    }

    @Nullable
    protected PsiElement skipParenthesesAndPostfixOperatorsDown(@NotNull PsiElement $this$skipParenthesesAndPostfixOperatorsDown) {
        Intrinsics.checkNotNullParameter((Object)$this$skipParenthesesAndPostfixOperatorsDown, (String)"<this>");
        return $this$skipParenthesesAndPostfixOperatorsDown instanceof JSExpression ? (PsiElement)JSUtils.unparenthesize((JSExpression)$this$skipParenthesesAndPostfixOperatorsDown) : $this$skipParenthesesAndPostfixOperatorsDown;
    }

    protected void getTypeComputationContext(@NotNull JSCallExpression topmostDotQualifiedExpression) {
        Intrinsics.checkNotNullParameter((Object)topmostDotQualifiedExpression, (String)"topmostDotQualifiedExpression");
    }

    @Nullable
    protected JSCallExpression getParentDotQualifiedExpression(@NotNull JSCallExpression $this$getParentDotQualifiedExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$getParentDotQualifiedExpression, (String)"<this>");
        PsiElement psiElement = $this$getParentDotQualifiedExpression.getParent();
        PsiElement psiElement2 = psiElement != null ? psiElement.getParent() : null;
        return psiElement2 instanceof JSCallExpression ? (JSCallExpression)psiElement2 : null;
    }

    @Nullable
    protected PsiElement getReceiver(@NotNull JSCallExpression $this$getReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getReceiver, (String)"<this>");
        JSExpression jSExpression = $this$getReceiver.getMethodExpression();
        JSReferenceExpression jSReferenceExpression = jSExpression instanceof JSReferenceExpression ? (JSReferenceExpression)jSExpression : null;
        if (jSReferenceExpression == null) {
            return null;
        }
        JSReferenceExpression referenceExpression = jSReferenceExpression;
        return (PsiElement)referenceExpression.getQualifier();
    }

    @NotNull
    protected String presentableType(@NotNull JSType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        String string = type2.getTypeText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeText(...)");
        return string;
    }

    protected boolean isChainUnacceptable(@NotNull List<AbstractDeclarativeCallChainProvider.ExpressionWithType<JSType>> chain) {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Map existingTypes = new LinkedHashMap();
        Map numToType = new LinkedHashMap();
        int totalTypes = 0;
        Iterator<AbstractDeclarativeCallChainProvider.ExpressionWithType<JSType>> iterator = chain.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            AbstractDeclarativeCallChainProvider.ExpressionWithType<JSType> expression = iterator.next();
            PsiElement psiElement = expression.getExpression();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSExpression");
            JSType expressionType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getExpressionJSType((JSExpression)psiElement));
            if (expressionType == null || JSTypeUtils.isAnyType(expressionType)) continue;
            boolean found = false;
            for (JSType jsType : existingTypes.keySet()) {
                if (!this.areEquivalentForPresentation(jsType, expressionType)) continue;
                Object v = existingTypes.get(jsType);
                Intrinsics.checkNotNull(v);
                existingTypes.put(jsType, ((Number)v).intValue() + 1);
                found = true;
            }
            if (!found) {
                existingTypes.put(expressionType, 1);
            }
            Integer n2 = index;
            numToType.put(n2, expressionType);
            ++totalTypes;
        }
        return totalTypes != chain.size();
    }

    private final boolean areEquivalentForPresentation(JSType jsType, JSType expressionType) {
        if (jsType.isEquivalentTo(expressionType, null)) {
            return true;
        }
        if (expressionType == null) {
            return false;
        }
        Function1 function2 = areEquivalentForPresentation.function.1.INSTANCE;
        return jsType.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)arg_0 -> JSDeclarativeMethodChainsInlayProvider.areEquivalentForPresentation$lambda$0(function2, arg_0))).isEquivalentTo(expressionType.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)arg_0 -> JSDeclarativeMethodChainsInlayProvider.areEquivalentForPresentation$lambda$1(function2, arg_0))), null);
    }

    private static final JSType areEquivalentForPresentation$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JSType)$tmp0.invoke(p0);
    }

    private static final JSType areEquivalentForPresentation$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JSType)$tmp0.invoke(p0);
    }
}

