/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.types;

import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooserKt;
import com.intellij.lang.javascript.ecmascript6.types.OverloadPriority;
import com.intellij.lang.javascript.ecmascript6.types.OverloadStrictness;
import com.intellij.lang.javascript.evaluation.JSExpressionTypeFactory;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeEvaluationFunction;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 b2\u00020\u0001:\u0003bcdB5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bB\r\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J.\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\"2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020 0&2\u0006\u0010'\u001a\u00020\"H\u0002JA\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020 2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002\u00a2\u0006\u0002\u0010.J<\u0010/\u001a\u00020\"2\f\u00100\u001a\b\u0012\u0004\u0012\u00020 0&2\f\u00101\u001a\b\u0012\u0004\u0012\u00020 0&2\u0006\u0010*\u001a\u00020+2\u0006\u00102\u001a\u00020\"2\u0006\u0010,\u001a\u00020-H\u0002J\u001c\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00052\f\u00105\u001a\b\u0012\u0004\u0012\u0002040\u0005H\u0002J\u001f\u00106\u001a\b\u0012\u0004\u0012\u0002070\t2\f\u00105\u001a\b\u0012\u0004\u0012\u0002070\t\u00a2\u0006\u0002\u00108J'\u00106\u001a\b\u0012\u0004\u0012\u0002070\t2\f\u00105\u001a\b\u0012\u0004\u0012\u0002070\t2\u0006\u00109\u001a\u00020:\u00a2\u0006\u0002\u0010;J\"\u00106\u001a\b\u0012\u0004\u0012\u00020 0\u00052\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00060=2\u0006\u00109\u001a\u00020:J\u0016\u00106\u001a\u00020 2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020 0\u0005H\u0002J\"\u00106\u001a\b\u0012\u0004\u0012\u0002040\u00052\f\u00105\u001a\b\u0012\u0004\u0012\u0002040\u00052\u0006\u00109\u001a\u00020:J\"\u00106\u001a\b\u0012\u0004\u0012\u0002040\u00052\f\u00105\u001a\b\u0012\u0004\u0012\u0002040\u00052\u0006\u0010?\u001a\u00020-J\u001e\u0010@\u001a\u0004\u0018\u00010\u001e2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001e0=2\u0006\u0010B\u001a\u00020-J\"\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00052\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001e0=2\u0006\u00109\u001a\u00020:J\u0016\u0010D\u001a\u00020-2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001a\u0010E\u001a\u00020-2\u0006\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010I\u001a\u00020-2\b\u0010J\u001a\u0004\u0018\u00010\u0006H\u0002J$\u0010K\u001a\u00020\u00062\b\u0010L\u001a\u0004\u0018\u00010\u00062\b\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010,\u001a\u00020-H\u0002J\u001c\u0010O\u001a\b\u0012\u0004\u0012\u00020N0\u00052\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001e0=H\u0002J\u0018\u0010P\u001a\u00020\u00062\u0006\u0010Q\u001a\u00020-2\u0006\u0010R\u001a\u00020 H\u0002J4\u0010S\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002040U0T2\f\u00105\u001a\b\u0012\u0004\u0012\u0002040\u0005H\u0002J\u001e\u0010V\u001a\u00020\"2\u0006\u0010W\u001a\u00020\u001c2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Y0\u0005H\u0002J \u0010Z\u001a\u00020\"2\u0006\u0010#\u001a\u00020 2\u0006\u0010W\u001a\u00020\u001c2\u0006\u0010[\u001a\u00020\u001cH\u0002J\u001c\u0010\\\u001a\b\u0012\u0004\u0012\u0002040\u00052\f\u0010]\u001a\b\u0012\u0004\u0012\u0002040\u0005H\u0002J\u0016\u0010^\u001a\u0004\u0018\u00010\u00062\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00060=J\"\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00060=2\u0006\u0010Q\u001a\u00020-J$\u0010`\u001a\b\u0012\u0004\u0012\u00020 0\u00052\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00060=2\u0006\u00109\u001a\u00020:H\u0002J\u001c\u0010a\u001a\b\u0012\u0004\u0012\u00020 0\u00052\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00060=H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006e"}, d2={"Lcom/intellij/lang/javascript/ecmascript6/types/JSTypeSignatureChooser;", "", "context", "Lcom/intellij/psi/PsiElement;", "argumentProviders", "", "Lcom/intellij/lang/javascript/psi/JSType;", "qualifierType", "callTypeArguments", "", "Lcom/intellij/lang/javascript/psi/ecma6/JSTypeDeclaration;", "(Lcom/intellij/psi/PsiElement;Ljava/util/List;Lcom/intellij/lang/javascript/psi/JSType;[Lcom/intellij/lang/javascript/psi/ecma6/JSTypeDeclaration;)V", "callItem", "Lcom/intellij/lang/javascript/psi/JSCallItem;", "(Lcom/intellij/lang/javascript/psi/JSCallItem;)V", "getArgumentProviders", "()Ljava/util/List;", "getCallTypeArguments", "()[Lcom/intellij/lang/javascript/psi/ecma6/JSTypeDeclaration;", "getContext", "()Lcom/intellij/psi/PsiElement;", "methodExpression", "Lcom/intellij/lang/javascript/psi/JSExpression;", "getMethodExpression", "()Lcom/intellij/lang/javascript/psi/JSExpression;", "getQualifierType", "()Lcom/intellij/lang/javascript/psi/JSType;", "argumentsCount", "", "asFunctionItem", "Lcom/intellij/lang/javascript/psi/JSFunctionItem;", "kind", "Lcom/intellij/lang/javascript/ecmascript6/types/JSTypeSignatureChooser$FunctionTypeWithKind;", "checkBestMatch", "Lcom/intellij/lang/javascript/ecmascript6/types/OverloadPriority;", "jsFunction", "currentPriority", "preFiltered", "", "oldBestMatch", "checkOverload", "type", "processingContext", "Lcom/intellij/util/ProcessingContext;", "skipReturnType", "", "(Lcom/intellij/lang/javascript/ecmascript6/types/JSTypeSignatureChooser$FunctionTypeWithKind;Ljava/util/List;[Lcom/intellij/lang/javascript/psi/ecma6/JSTypeDeclaration;Lcom/intellij/util/ProcessingContext;Z)Lcom/intellij/lang/javascript/ecmascript6/types/OverloadPriority;", "checkOverloads", "candidates", "result", "startBestMatch", "chooseNonFunctionalOverload", "Lcom/intellij/lang/javascript/psi/resolve/ResolveResultSink$JSResolveResultForSymbolProcessor;", "results", "chooseOverload", "Lcom/intellij/psi/ResolveResult;", "([Lcom/intellij/psi/ResolveResult;)[Lcom/intellij/psi/ResolveResult;", "strictness", "Lcom/intellij/lang/javascript/ecmascript6/types/OverloadStrictness;", "([Lcom/intellij/psi/ResolveResult;Lcom/intellij/lang/javascript/ecmascript6/types/OverloadStrictness;)[Lcom/intellij/psi/ResolveResult;", "types", "", "overloads", "alwaysCheckArguments", "chooseOverloadFunction", "functions", "assignableOnly", "chooseOverloadFunctions", "hasContextualFunctionArguments", "isFunctionWithInferredType", "arg", "Lcom/intellij/lang/javascript/psi/types/JSPsiBasedTypeOfType;", "evaluate", "isInferredReturnType", "returnType", "mapContextualType", "jsType", "jsFunctionType", "Lcom/intellij/lang/javascript/psi/JSFunctionType;", "mapFunctionToTypes", "mapToFunctionType", "applyGenerics", "functionWithKind", "mapToFunctionTypes", "Lkotlin/Pair;", "", "notAssignableWithParameterLength", "argumentsLength", "parameters", "Lcom/intellij/lang/javascript/psi/JSParameterTypeDecorator;", "preConditionCheck", "callTypeArgumentsLength", "resolveConstructors", "list", "resolveOverloadsReturnTypeWithApplying", "resolveOverloadsWithApplying", "resolveOverloadsWithParametersCheck", "toFunctionTypeWithKind", "Companion", "FunctionTypeWithKind", "JSDummyCallItem", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nJSTypeSignatureChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSTypeSignatureChooser.kt\ncom/intellij/lang/javascript/ecmascript6/types/JSTypeSignatureChooser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,555:1\n1603#2,9:556\n1855#2:565\n1856#2:567\n1612#2:568\n1549#2:569\n1620#2,3:570\n1747#2,3:573\n1549#2:580\n1620#2,3:581\n1549#2:586\n1620#2,3:587\n1549#2:590\n1620#2,3:591\n1726#2,3:594\n1549#2:597\n1620#2,3:598\n1747#2,3:601\n1#3:566\n11065#4:576\n11400#4,3:577\n37#5,2:584\n*S KotlinDebug\n*F\n+ 1 JSTypeSignatureChooser.kt\ncom/intellij/lang/javascript/ecmascript6/types/JSTypeSignatureChooser\n*L\n139#1:556,9\n139#1:565\n139#1:567\n139#1:568\n155#1:569\n155#1:570,3\n261#1:573,3\n313#1:580\n313#1:581,3\n353#1:586\n353#1:587,3\n369#1:590\n369#1:591,3\n371#1:594,3\n431#1:597\n431#1:598,3\n490#1:601,3\n139#1:566\n312#1:576\n312#1:577,3\n313#1:584,2\n*E\n"})
public final class JSTypeSignatureChooser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JSCallItem callItem;

    public JSTypeSignatureChooser(@NotNull JSCallItem callItem) {
        Intrinsics.checkNotNullParameter((Object)callItem, (String)"callItem");
        this.callItem = callItem;
    }

    private final JSExpression getMethodExpression() {
        JSCallItem jSCallItem = this.callItem;
        JSCallLikeExpression jSCallLikeExpression = jSCallItem instanceof JSCallLikeExpression ? (JSCallLikeExpression)jSCallItem : null;
        return jSCallLikeExpression != null ? jSCallLikeExpression.getMethodExpression() : null;
    }

    private final PsiElement getContext() {
        return this.callItem.getPsiContext();
    }

    private final List<JSType> getArgumentProviders() {
        List<JSType> list2 = this.callItem.getArgumentTypes(JSPsiBasedTypeOfType.getArgumentTypeFactory(true));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getArgumentTypes(...)");
        return list2;
    }

    private final JSType getQualifierType() {
        return this.callItem.getQualifierType();
    }

    private final JSTypeDeclaration[] getCallTypeArguments() {
        JSTypeDeclaration[] jSTypeDeclarationArray = this.callItem.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue((Object)jSTypeDeclarationArray, (String)"getTypeArguments(...)");
        return jSTypeDeclarationArray;
    }

    public JSTypeSignatureChooser(@NotNull PsiElement context2, @NotNull List<? extends JSType> argumentProviders, @Nullable JSType qualifierType, @NotNull JSTypeDeclaration[] callTypeArguments) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(argumentProviders, (String)"argumentProviders");
        Intrinsics.checkNotNullParameter((Object)callTypeArguments, (String)"callTypeArguments");
        this(new JSDummyCallItem(context2, argumentProviders, qualifierType, callTypeArguments));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JSFunctionItem> chooseOverloadFunctions(@NotNull Collection<? extends JSFunctionItem> functions, @NotNull OverloadStrictness strictness) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        Intrinsics.checkNotNullParameter((Object)((Object)strictness), (String)"strictness");
        List<FunctionTypeWithKind> overloads = this.resolveOverloadsWithParametersCheck((Collection<? extends JSType>)this.mapFunctionToTypes(functions), strictness);
        Iterable $this$mapNotNull$iv = overloads;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JSFunctionItem it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FunctionTypeWithKind it = (FunctionTypeWithKind)element$iv$iv;
            boolean bl2 = false;
            if (this.asFunctionItem(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final JSFunctionItem chooseOverloadFunction(@NotNull Collection<? extends JSFunctionItem> functions, boolean assignableOnly) {
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        List<FunctionTypeWithKind> overloads = this.chooseOverload((Collection<? extends JSType>)this.mapFunctionToTypes(functions), assignableOnly ? OverloadStrictness.FULL : OverloadStrictness.UNIQUE);
        FunctionTypeWithKind functionTypeWithKind = (FunctionTypeWithKind)CollectionsKt.firstOrNull(overloads);
        if (functionTypeWithKind == null) {
            return null;
        }
        FunctionTypeWithKind candidate = functionTypeWithKind;
        return !assignableOnly || candidate.getOverloadType().isAssignable() ? this.asFunctionItem(candidate) : null;
    }

    public final int argumentsCount() {
        return this.getArgumentProviders().size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JSType> resolveOverloadsWithApplying(@NotNull Collection<? extends JSType> types2, boolean applyGenerics) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(types2, (String)"types");
        List<FunctionTypeWithKind> overloads = this.chooseOverload(types2, OverloadStrictness.UNIQUE);
        Iterable $this$map$iv = overloads;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FunctionTypeWithKind functionTypeWithKind = (FunctionTypeWithKind)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mapToFunctionType(applyGenerics, (FunctionTypeWithKind)it));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final JSType resolveOverloadsReturnTypeWithApplying(@NotNull Collection<? extends JSType> types2) {
        Intrinsics.checkNotNullParameter(types2, (String)"types");
        List<FunctionTypeWithKind> overloads = this.chooseOverload(types2, OverloadStrictness.UNIQUE);
        FunctionTypeWithKind functionTypeWithKind = (FunctionTypeWithKind)CollectionsKt.firstOrNull(overloads);
        if (functionTypeWithKind == null) {
            return null;
        }
        JSFunctionType jsFunctionType = functionTypeWithKind.getJsFunction();
        JSFunctionItem functionItem = this.asFunctionItem(functionTypeWithKind);
        if (functionItem != null) {
            JSType newOrReturnType = JSTypeUtils.getNewOrReturnType(jsFunctionType);
            return JSGenericTypesEvaluator.getEvaluator(this.getContext()).evaluateGenerics(newOrReturnType, this.callItem, (PsiElement)functionItem, JSGenericTypesEvaluator.DEFAULT_CONTEXT);
        }
        return JSTypeUtils.getNewOrReturnType(this.mapToFunctionType(true, functionTypeWithKind));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<FunctionTypeWithKind> chooseOverload(@NotNull Collection<? extends JSType> types2, @NotNull OverloadStrictness strictness) {
        Intrinsics.checkNotNullParameter(types2, (String)"types");
        Intrinsics.checkNotNullParameter((Object)((Object)strictness), (String)"strictness");
        JSEvaluationLogger.getInstance().startTask(() -> JSTypeSignatureChooser.chooseOverload$lambda$2(types2, this));
        Ref.ObjectRef results = new Ref.ObjectRef();
        try {
            results.element = this.resolveOverloadsWithParametersCheck(types2, strictness);
            results.element = ((List)results.element).isEmpty() ? (List)results.element : (strictness == OverloadStrictness.NO_INFERRED_RETURN_TYPE_CHECK && ((FunctionTypeWithKind)((List)results.element).get(0)).getOverloadType() == OverloadPriority.ASSIGNABLE_WITHOUT_RETURN_TYPE_CHECK ? (List)results.element : (((FunctionTypeWithKind)((List)results.element).get(0)).getOverloadType().isAssignable() ? CollectionsKt.listOf((Object)this.chooseOverload((List)results.element)) : (List)results.element));
            List list2 = (List)results.element;
            return list2;
        }
        finally {
            JSEvaluationLogger.getInstance().finishTask(() -> JSTypeSignatureChooser.chooseOverload$lambda$3(results));
        }
    }

    private final List<FunctionTypeWithKind> resolveOverloadsWithParametersCheck(Collection<? extends JSType> types2, OverloadStrictness strictness) {
        List<FunctionTypeWithKind> candidates = this.toFunctionTypeWithKind(types2);
        if (!strictness.isFull() && candidates.size() == 1) {
            return candidates;
        }
        List checkedSimple = new ArrayList();
        OverloadPriority bestMatch = OverloadPriority.UNKNOWN;
        int argumentsLength = this.getArgumentProviders().size();
        int typeArgumentsLength = this.getCallTypeArguments().length;
        for (FunctionTypeWithKind currentFunction : candidates) {
            OverloadPriority preCheck = this.preConditionCheck(currentFunction, argumentsLength, typeArgumentsLength);
            bestMatch = this.checkBestMatch(currentFunction, preCheck, checkedSimple, bestMatch);
        }
        if (strictness == OverloadStrictness.NO_RESOLVE || !strictness.isFull() && (checkedSimple.size() <= 1 || bestMatch != OverloadPriority.ASSIGNABLE_WITHOUT_PARAMETER_CHECK)) {
            return checkedSimple;
        }
        ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCallEnvironment(this.callItem.getPsiContext());
        Intrinsics.checkNotNullExpressionValue((Object)processingContext, (String)"createProcessingContextWithCallEnvironment(...)");
        ProcessingContext processingContext2 = processingContext;
        processingContext2.put(JSTypeBaseImpl.IS_CHOOSING_FROM_OVERLOADS, (Object)true);
        List checkedWithoutReturnType = new ArrayList();
        if (checkedSimple.size() > 0 && this.hasContextualFunctionArguments(this.getArgumentProviders())) {
            if ((bestMatch = this.checkOverloads(checkedSimple, checkedWithoutReturnType, processingContext2, bestMatch, true)) != OverloadPriority.ASSIGNABLE_WITHOUT_RETURN_TYPE_CHECK || checkedWithoutReturnType.size() == 1 && !strictness.isFull() || strictness == OverloadStrictness.NO_INFERRED_RETURN_TYPE_CHECK) {
                return checkedWithoutReturnType;
            }
        } else {
            checkedWithoutReturnType.addAll(checkedSimple);
        }
        List result2 = new ArrayList();
        this.checkOverloads(checkedWithoutReturnType, result2, processingContext2, bestMatch, false);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final OverloadPriority checkOverloads(List<FunctionTypeWithKind> candidates, List<FunctionTypeWithKind> result2, ProcessingContext processingContext, OverloadPriority startBestMatch, boolean skipReturnType) {
        OverloadPriority bestMatch = startBestMatch;
        for (FunctionTypeWithKind functionTypeWithKind : candidates) {
            JSEvaluationLogger.getInstance().startTask(() -> JSTypeSignatureChooser.checkOverloads$lambda$4(functionTypeWithKind));
            Ref.ObjectRef overloadPriority = new Ref.ObjectRef();
            try {
                overloadPriority.element = this.checkOverload(functionTypeWithKind, this.getArgumentProviders(), this.getCallTypeArguments(), processingContext, skipReturnType);
                bestMatch = this.checkBestMatch(functionTypeWithKind, (OverloadPriority)((Object)overloadPriority.element), result2, bestMatch);
            }
            finally {
                JSEvaluationLogger.getInstance().finishTask(() -> JSTypeSignatureChooser.checkOverloads$lambda$5(overloadPriority));
            }
        }
        return bestMatch;
    }

    private final boolean hasContextualFunctionArguments(List<? extends JSType> argumentProviders) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = argumentProviders;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JSType evaluate;
                    JSType it = (JSType)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof JSPsiBasedTypeOfType && ((JSPsiBasedTypeOfType)it).getElement() instanceof JSFunctionExpression && this.isFunctionWithInferredType((JSPsiBasedTypeOfType)it, evaluate = ((JSPsiBasedTypeOfType)it).substituteOrNull()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final OverloadPriority preConditionCheck(FunctionTypeWithKind jsFunction, int argumentsLength, int callTypeArgumentsLength) {
        List<JSParameterTypeDecorator> list2 = jsFunction.getJsFunction().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
        List<JSParameterTypeDecorator> parameters = list2;
        int min = TypeScriptSignatureChooser.getMinArgumentCount(parameters);
        int max = TypeScriptSignatureChooser.getMaxArgumentCount(parameters);
        if (!(min <= argumentsLength ? argumentsLength <= max : false)) {
            return OverloadPriority.INCORRECT_PARAMETERS_LENGTH;
        }
        if (callTypeArgumentsLength > jsFunction.getMaxTypeParameters() || callTypeArgumentsLength > 0 && callTypeArgumentsLength < jsFunction.getMinTypeParameters()) {
            return OverloadPriority.INCORRECT_GENERICS_LENGTH;
        }
        return OverloadPriority.ASSIGNABLE_WITHOUT_PARAMETER_CHECK;
    }

    private final FunctionTypeWithKind chooseOverload(List<FunctionTypeWithKind> overloads) {
        for (FunctionTypeWithKind overload : overloads) {
            for (JSParameterTypeDecorator parameter : overload.getJsFunction().getParameters()) {
                if (!(parameter.getSimpleType() instanceof JSStringLiteralTypeImpl)) continue;
                return overload;
            }
        }
        Object e = ((List)StreamEx.of((Collection)overloads).collect(MoreCollectors.least((Comparator)JSTypeSignatureChooserKt.access$getFunctionTypeWithKindComparator$p(), (int)1))).get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        return (FunctionTypeWithKind)e;
    }

    private final JSType mapToFunctionType(boolean applyGenerics, FunctionTypeWithKind functionWithKind) {
        if (applyGenerics) {
            JSType jSType = TypeScriptGenericTypesEvaluator.applyTypeScriptGenericArguments(functionWithKind.getJsFunction(), this.callItem, (PsiElement)this.asFunctionItem(functionWithKind));
            Intrinsics.checkNotNullExpressionValue((Object)jSType, (String)"applyTypeScriptGenericArguments(...)");
            return jSType;
        }
        return functionWithKind.getJsFunction();
    }

    @NotNull
    public final ResolveResult[] chooseOverload(@NotNull ResolveResult[] results) {
        Intrinsics.checkNotNullParameter((Object)results, (String)"results");
        return this.chooseOverload(results, OverloadStrictness.FULL);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ResolveResult[] chooseOverload(@NotNull ResolveResult[] results, @NotNull OverloadStrictness strictness) {
        void $this$toTypedArray$iv;
        Collection collection;
        Object $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)((Object)strictness), (String)"strictness");
        Object $this$map$iv = results;
        boolean $i$f$map = false;
        ResolveResult[] resolveResultArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((ResolveResult[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (ResolveResultSink.JSResolveResultForSymbolProcessor item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var12_13 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ResolveResultSink.JSResolveResultForSymbolProcessor((ResolveResult)it));
        }
        List list2 = (List)destination$iv$iv;
        $this$map$iv = this.chooseOverload((List<ResolveResultSink.JSResolveResultForSymbolProcessor>)list2, strictness);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            ResolveResultSink.JSResolveResultForSymbolProcessor item$iv$iv;
            Object item$iv$iv2 = iterator.next();
            item$iv$iv = (ResolveResultSink.JSResolveResultForSymbolProcessor)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getResolveResult());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ResolveResult[0]);
    }

    @NotNull
    public final List<ResolveResultSink.JSResolveResultForSymbolProcessor> chooseOverload(@NotNull List<ResolveResultSink.JSResolveResultForSymbolProcessor> results, boolean alwaysCheckArguments) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        return this.chooseOverload(results, alwaysCheckArguments ? OverloadStrictness.FULL : OverloadStrictness.UNIQUE);
    }

    private final List<ResolveResultSink.JSResolveResultForSymbolProcessor> resolveConstructors(List<ResolveResultSink.JSResolveResultForSymbolProcessor> list2) {
        List constructors = new ArrayList();
        for (ResolveResultSink.JSResolveResultForSymbolProcessor resultForSymbolProcessor : list2) {
            ResolveResult result2;
            Intrinsics.checkNotNullExpressionValue((Object)resultForSymbolProcessor.getResolveResult(), (String)"getResolveResult(...)");
            PsiElement element = result2.getElement();
            if (element instanceof TypeScriptImplicitOverloadedAliasElement) {
                element = ((TypeScriptImplicitOverloadedAliasElement)element).getBackingElement();
            }
            if (!(element instanceof JSClass) && (!(element instanceof JSFunction) || !((JSFunction)element).isConstructor())) continue;
            constructors.add(resultForSymbolProcessor);
        }
        return constructors;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResolveResultSink.JSResolveResultForSymbolProcessor> chooseOverload(@NotNull List<ResolveResultSink.JSResolveResultForSymbolProcessor> results, @NotNull OverloadStrictness strictness) {
        List<FunctionTypeWithKind> overloads;
        List<ResolveResultSink.JSResolveResultForSymbolProcessor> constructors;
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)((Object)strictness), (String)"strictness");
        if (results.size() <= 1) {
            return results;
        }
        if (this.callItem.isNewExpression() && (constructors = this.resolveConstructors(results)).size() == 1) {
            return constructors;
        }
        Pair<List<JSType>, Map<JSType, ResolveResultSink.JSResolveResultForSymbolProcessor>> pair = this.mapToFunctionTypes(results);
        List keys = (List)pair.component1();
        Map functions = (Map)pair.component2();
        if (functions.size() == 1) {
            return CollectionsKt.toList((Iterable)functions.values());
        }
        if (functions.size() > 1 && !((Collection)(overloads = this.chooseOverload(keys, strictness))).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = overloads;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ResolveResult result2;
                void el;
                FunctionTypeWithKind functionTypeWithKind = (FunctionTypeWithKind)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ResolveResultSink.JSResolveResultForSymbolProcessor resultForSymbolProcessor = (ResolveResultSink.JSResolveResultForSymbolProcessor)MapsKt.getValue((Map)functions, (Object)el.getJsFunction());
                Intrinsics.checkNotNullExpressionValue((Object)resultForSymbolProcessor.getResolveResult(), (String)"getResolveResult(...)");
                collection.add(!(result2 instanceof JSResolveResult) || el.getOverloadType().isAssignable() ? resultForSymbolProcessor : new ResolveResultSink.JSResolveResultForSymbolProcessor(new JSResolveResult(((JSResolveResult)result2).getElement(), ((JSResolveResult)result2).getES6Import(), JSResolveResult.ProblemKind.ARGUMENT_TYPES_MISMATCH)));
            }
            return (List)destination$iv$iv;
        }
        Collections.sort(results, TypeScriptSignatureChooser.FUNCTIONS_FIRST_RESOLVE_RESULT);
        return !functions.isEmpty() ? CollectionsKt.listOf((Object)CollectionsKt.first(results)) : this.chooseNonFunctionalOverload(results);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ResolveResultSink.JSResolveResultForSymbolProcessor> chooseNonFunctionalOverload(List<ResolveResultSink.JSResolveResultForSymbolProcessor> results) {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = results;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ResolveResultSink.JSResolveResultForSymbolProcessor jSResolveResultForSymbolProcessor = (ResolveResultSink.JSResolveResultForSymbolProcessor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getResolveResult().getElement());
            }
            List elements = (List)destination$iv$iv;
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl3 = false;
                    if (it instanceof TypeScriptVariable) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            return results;
        }
        return CollectionsKt.listOf((Object)CollectionsKt.first(results));
    }

    private final Pair<List<JSType>, Map<JSType, ResolveResultSink.JSResolveResultForSymbolProcessor>> mapToFunctionTypes(List<ResolveResultSink.JSResolveResultForSymbolProcessor> results) {
        IdentityHashMap functions = new IdentityHashMap();
        List types2 = new ArrayList();
        for (ResolveResultSink.JSResolveResultForSymbolProcessor resultForSymbolProcessor : results) {
            ResolveResult result2;
            Intrinsics.checkNotNullExpressionValue((Object)resultForSymbolProcessor.getResolveResult(), (String)"getResolveResult(...)");
            PsiElement element = result2.getElement();
            if (element instanceof TypeScriptImplicitOverloadedAliasElement) {
                element = ((TypeScriptImplicitOverloadedAliasElement)element).getBackingElement();
            }
            if (!(element instanceof JSFunction)) continue;
            JSFunctionType jSFunctionType = TypeScriptTypeParser.buildFunctionType((JSFunctionItem)element);
            Intrinsics.checkNotNullExpressionValue((Object)jSFunctionType, (String)"buildFunctionType(...)");
            JSType functionType2 = jSFunctionType;
            if (result2 instanceof JSResolveResult) {
                JSTypeSubstitutor substitutor = ((JSResolveResult)result2).getTypeSubstitutor();
                JSType jSType = JSTypeUtils.applyGenericArguments(functionType2, substitutor);
                Intrinsics.checkNotNull((Object)jSType);
                functionType2 = jSType;
            }
            ((Map)functions).put(functionType2, resultForSymbolProcessor);
            types2.add(functionType2);
        }
        return new Pair((Object)types2, functions);
    }

    private final OverloadPriority checkBestMatch(FunctionTypeWithKind jsFunction, OverloadPriority currentPriority, List<FunctionTypeWithKind> preFiltered, OverloadPriority oldBestMatch) {
        if (oldBestMatch.compareTo((Enum)currentPriority) > 0) {
            preFiltered.clear();
            preFiltered.add(jsFunction.copyWithPriority(currentPriority));
            return currentPriority;
        }
        if (currentPriority == oldBestMatch) {
            preFiltered.add(jsFunction.copyWithPriority(currentPriority));
        }
        return oldBestMatch;
    }

    /*
     * WARNING - void declaration
     */
    private final OverloadPriority checkOverload(FunctionTypeWithKind type2, List<? extends JSType> argumentProviders, JSTypeDeclaration[] callTypeArguments, ProcessingContext processingContext, boolean skipReturnType) {
        JSType qualifierType;
        void $this$mapTo$iv$iv;
        boolean typeScript = type2.getJsFunction().isTypeScript();
        int argumentsLength = argumentProviders.size();
        JSFunctionType jsFunctionType = type2.getJsFunction();
        List<JSParameterTypeDecorator> list2 = jsFunctionType.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
        List<JSParameterTypeDecorator> parameters = list2;
        Iterable $this$map$iv = argumentProviders;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JSType jSType = (JSType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mapContextualType((JSType)it, type2.getJsFunction(), skipReturnType));
        }
        List actualArguments = (List)destination$iv$iv;
        List<JSParameterTypeDecorator> decorators = JSTypeUtils.getParameterTypeDecorators(actualArguments);
        if (!JSTypeUtils.areArgumentsAssignable(parameters, decorators, processingContext, false, false, typeScript)) {
            return this.notAssignableWithParameterLength(argumentsLength, parameters);
        }
        JSType thisType = jsFunctionType.getThisType();
        if (thisType != null && this.getQualifierType() != null && !thisType.isDirectlyAssignableType(qualifierType = this.getQualifierType(), processingContext)) {
            return this.notAssignableWithParameterLength(argumentsLength, parameters);
        }
        JSFunctionItem actualSource = this.asFunctionItem(type2);
        if (actualSource instanceof TypeScriptFunction) {
            List list3 = ContainerUtil.map((Collection)parameters, arg_0 -> JSTypeSignatureChooser.checkOverload$lambda$13(checkOverload.types.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"map(...)");
            List types2 = list3;
            if (TypeScriptGenericTypesEvaluator.getInstance().hasGenericsCompatibilityErrors(types2, actualArguments, (TypeScriptFunction)actualSource)) {
                return this.notAssignableWithParameterLength(argumentsLength, parameters);
            }
        }
        if (skipReturnType) {
            return OverloadPriority.ASSIGNABLE_WITHOUT_RETURN_TYPE_CHECK;
        }
        return callTypeArguments.length == 0 || type2.getMaxTypeParameters() == callTypeArguments.length ? OverloadPriority.ASSIGNABLE_EXACT : OverloadPriority.ASSIGNABLE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFunctionWithInferredType(JSPsiBasedTypeOfType arg, JSType evaluate) {
        if (!arg.isWithContextualOverloads()) return false;
        if (!(evaluate instanceof JSFunctionType)) return false;
        List<JSParameterTypeDecorator> list2 = ((JSFunctionType)evaluate).getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
        if (((Collection)list2).isEmpty()) return false;
        return true;
    }

    private final JSType mapContextualType(JSType jsType, JSFunctionType jsFunctionType, boolean skipReturnType) {
        JSType toProcess = jsType;
        if (jsType instanceof JSPsiBasedTypeOfType) {
            JSType returnType;
            JSType evaluate = ((JSPsiBasedTypeOfType)jsType).substituteOrNull();
            if (skipReturnType && evaluate instanceof JSFunctionType && this.isFunctionWithInferredType((JSPsiBasedTypeOfType)jsType, evaluate) && this.isInferredReturnType(returnType = ((JSFunctionType)evaluate).getReturnType())) {
                evaluate = ((JSFunctionType)evaluate).copyWithReturnType(JSAnyType.get(((JSFunctionType)evaluate).getSource()));
            }
            toProcess = evaluate;
        }
        JSType jSType = TypeScriptGenericTypesEvaluator.getExplicitTypeOrAnyIfTypeScript(this.getContext(), TypeScriptSignatureChooser.mapContextualTypeForOverload(toProcess, jsFunctionType, this.callItem, JSExpectedTypeKind.EXPECTED));
        Intrinsics.checkNotNullExpressionValue((Object)jSType, (String)"getExplicitTypeOrAnyIfTypeScript(...)");
        return jSType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInferredReturnType(JSType returnType) {
        JSType it;
        if (returnType instanceof JSCodeBasedType) return true;
        if (!(returnType instanceof JSUnionType)) return false;
        List<JSType> list2 = ((JSUnionType)returnType).getTypes();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypes(...)");
        Iterable $this$any$iv = list2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (JSType)element$iv;
            boolean bl = false;
        } while (!this.isInferredReturnType(it));
        return true;
    }

    private final OverloadPriority notAssignableWithParameterLength(int argumentsLength, List<? extends JSParameterTypeDecorator> parameters) {
        return argumentsLength == parameters.size() ? OverloadPriority.NOT_ASSIGNABLE_SAME_PARAMETERS_LENGTH : OverloadPriority.NOT_ASSIGNABLE_PARAMETERS;
    }

    private final List<FunctionTypeWithKind> toFunctionTypeWithKind(Collection<? extends JSType> types2) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)types2), (Function1)toFunctionTypeWithKind.1.INSTANCE), (Function1)toFunctionTypeWithKind.2.INSTANCE));
    }

    private final List<JSFunctionType> mapFunctionToTypes(Collection<? extends JSFunctionItem> functions) {
        List list2 = ContainerUtil.map(functions, arg_0 -> JSTypeSignatureChooser.mapFunctionToTypes$lambda$15(mapFunctionToTypes.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"map(...)");
        return list2;
    }

    private final JSFunctionItem asFunctionItem(FunctionTypeWithKind kind) {
        Object object = kind;
        return object != null && (object = ((FunctionTypeWithKind)object).getJsFunction()) != null ? object.getSourceFunctionItem() : null;
    }

    private static final String chooseOverload$lambda$2(Collection $types, JSTypeSignatureChooser this$0) {
        Intrinsics.checkNotNullParameter((Object)$types, (String)"$types");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "chooseOverload of " + JSEvaluationLogger.toPresentable($types) + ", callItem = " + this$0.callItem;
    }

    private static final String chooseOverload$lambda$3(Ref.ObjectRef $results) {
        Intrinsics.checkNotNullParameter((Object)$results, (String)"$results");
        return ". Results = " + JSEvaluationLogger.toPresentable($results.element);
    }

    private static final String checkOverloads$lambda$4(FunctionTypeWithKind $functionTypeWithKind) {
        Intrinsics.checkNotNullParameter((Object)$functionTypeWithKind, (String)"$functionTypeWithKind");
        return "Check overload return " + JSEvaluationLogger.toPresentable($functionTypeWithKind) + " from " + $functionTypeWithKind.getJsFunction().getSource().getScope();
    }

    private static final String checkOverloads$lambda$5(Ref.ObjectRef $overloadPriority) {
        Intrinsics.checkNotNullParameter((Object)$overloadPriority, (String)"$overloadPriority");
        return "; overloadPriority = " + $overloadPriority.element;
    }

    private static final JSType checkOverload$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JSType)$tmp0.invoke(p0);
    }

    private static final JSFunctionType mapFunctionToTypes$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JSFunctionType)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/javascript/ecmascript6/types/JSTypeSignatureChooser$Companion;", "", "()V", "maxTypeParametersLength", "", "it", "Lcom/intellij/lang/javascript/psi/JSFunctionType;", "minTypeParametersLength", "jsFunction", "intellij.javascript.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nJSTypeSignatureChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSTypeSignatureChooser.kt\ncom/intellij/lang/javascript/ecmascript6/types/JSTypeSignatureChooser$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,555:1\n1855#2,2:556\n*S KotlinDebug\n*F\n+ 1 JSTypeSignatureChooser.kt\ncom/intellij/lang/javascript/ecmascript6/types/JSTypeSignatureChooser$Companion\n*L\n528#1:556,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int maxTypeParametersLength(@NotNull JSFunctionType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof TypeScriptJSFunctionTypeImpl ? ((TypeScriptJSFunctionTypeImpl)it).getGenericDeclarations().size() : 0;
        }

        public final int minTypeParametersLength(@NotNull JSFunctionType jsFunction) {
            Intrinsics.checkNotNullParameter((Object)jsFunction, (String)"jsFunction");
            if (jsFunction instanceof TypeScriptJSFunctionTypeImpl) {
                List<TypeScriptGenericDeclarationTypeImpl> list2 = ((TypeScriptJSFunctionTypeImpl)jsFunction).getGenericDeclarations();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getGenericDeclarations(...)");
                Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)list2);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IndexedValue indexedValue = (IndexedValue)element$iv;
                    boolean bl = false;
                    int i = indexedValue.component1();
                    TypeScriptGenericDeclarationTypeImpl genericDeclaration = (TypeScriptGenericDeclarationTypeImpl)indexedValue.component2();
                    if (genericDeclaration.getDefaultType() == null) continue;
                    return i;
                }
                return ((TypeScriptJSFunctionTypeImpl)jsFunction).getGenericDeclarations().size();
            }
            return 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/ecmascript6/types/JSTypeSignatureChooser$FunctionTypeWithKind;", "", "jsFunction", "Lcom/intellij/lang/javascript/psi/JSFunctionType;", "maxTypeParameters", "", "minTypeParameters", "overloadType", "Lcom/intellij/lang/javascript/ecmascript6/types/OverloadPriority;", "genericEvaluationFunction", "Lcom/intellij/lang/javascript/psi/types/JSGenericTypeEvaluationFunction;", "(Lcom/intellij/lang/javascript/psi/JSFunctionType;IILcom/intellij/lang/javascript/ecmascript6/types/OverloadPriority;Lcom/intellij/lang/javascript/psi/types/JSGenericTypeEvaluationFunction;)V", "getJsFunction", "()Lcom/intellij/lang/javascript/psi/JSFunctionType;", "getMaxTypeParameters", "()I", "getMinTypeParameters", "getOverloadType", "()Lcom/intellij/lang/javascript/ecmascript6/types/OverloadPriority;", "copyWithPriority", "newOverloadType", "toString", "", "intellij.javascript.psi.impl"})
    public static final class FunctionTypeWithKind {
        @NotNull
        private final JSFunctionType jsFunction;
        private final int maxTypeParameters;
        private final int minTypeParameters;
        @NotNull
        private final OverloadPriority overloadType;
        @Nullable
        private final JSGenericTypeEvaluationFunction genericEvaluationFunction;

        public FunctionTypeWithKind(@NotNull JSFunctionType jsFunction, int maxTypeParameters, int minTypeParameters, @NotNull OverloadPriority overloadType, @Nullable JSGenericTypeEvaluationFunction genericEvaluationFunction) {
            Intrinsics.checkNotNullParameter((Object)jsFunction, (String)"jsFunction");
            Intrinsics.checkNotNullParameter((Object)((Object)overloadType), (String)"overloadType");
            this.jsFunction = jsFunction;
            this.maxTypeParameters = maxTypeParameters;
            this.minTypeParameters = minTypeParameters;
            this.overloadType = overloadType;
            this.genericEvaluationFunction = genericEvaluationFunction;
        }

        @NotNull
        public final JSFunctionType getJsFunction() {
            return this.jsFunction;
        }

        public final int getMaxTypeParameters() {
            return this.maxTypeParameters;
        }

        public final int getMinTypeParameters() {
            return this.minTypeParameters;
        }

        @NotNull
        public final OverloadPriority getOverloadType() {
            return this.overloadType;
        }

        @NotNull
        public final FunctionTypeWithKind copyWithPriority(@NotNull OverloadPriority newOverloadType) {
            Intrinsics.checkNotNullParameter((Object)((Object)newOverloadType), (String)"newOverloadType");
            return new FunctionTypeWithKind(this.jsFunction, this.maxTypeParameters, this.minTypeParameters, newOverloadType, this.genericEvaluationFunction);
        }

        @NotNull
        public String toString() {
            return this.jsFunction.toString();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B5\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/javascript/ecmascript6/types/JSTypeSignatureChooser$JSDummyCallItem;", "Lcom/intellij/lang/javascript/psi/JSCallItem;", "psiContext", "Lcom/intellij/psi/PsiElement;", "argumentProviders", "", "Lcom/intellij/lang/javascript/psi/JSType;", "qualifierType", "callTypeArguments", "", "Lcom/intellij/lang/javascript/psi/ecma6/JSTypeDeclaration;", "(Lcom/intellij/psi/PsiElement;Ljava/util/List;Lcom/intellij/lang/javascript/psi/JSType;[Lcom/intellij/lang/javascript/psi/ecma6/JSTypeDeclaration;)V", "[Lcom/intellij/lang/javascript/psi/ecma6/JSTypeDeclaration;", "getArgumentSize", "", "getArgumentTypes", "argumentTypeFactory", "Lcom/intellij/lang/javascript/evaluation/JSExpressionTypeFactory;", "getPsiContext", "getQualifierType", "getTypeArguments", "()[Lcom/intellij/lang/javascript/psi/ecma6/JSTypeDeclaration;", "intellij.javascript.psi.impl"})
    private static final class JSDummyCallItem
    implements JSCallItem {
        @Nullable
        private final PsiElement psiContext;
        @NotNull
        private final List<JSType> argumentProviders;
        @Nullable
        private final JSType qualifierType;
        @NotNull
        private final JSTypeDeclaration[] callTypeArguments;

        public JSDummyCallItem(@Nullable PsiElement psiContext, @NotNull List<? extends JSType> argumentProviders, @Nullable JSType qualifierType, @NotNull JSTypeDeclaration[] callTypeArguments) {
            Intrinsics.checkNotNullParameter(argumentProviders, (String)"argumentProviders");
            Intrinsics.checkNotNullParameter((Object)callTypeArguments, (String)"callTypeArguments");
            this.psiContext = psiContext;
            this.argumentProviders = argumentProviders;
            this.qualifierType = qualifierType;
            this.callTypeArguments = callTypeArguments;
        }

        @Override
        @Nullable
        public PsiElement getPsiContext() {
            return this.psiContext;
        }

        @Override
        @NotNull
        public List<JSType> getArgumentTypes(@NotNull JSExpressionTypeFactory argumentTypeFactory) {
            Intrinsics.checkNotNullParameter((Object)argumentTypeFactory, (String)"argumentTypeFactory");
            return this.argumentProviders;
        }

        @Override
        @Nullable
        public JSType getQualifierType() {
            return this.qualifierType;
        }

        @Override
        public int getArgumentSize() {
            return this.argumentProviders.size();
        }

        @Override
        @NotNull
        public JSTypeDeclaration[] getTypeArguments() {
            return this.callTypeArguments;
        }
    }
}

