/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptFunctionParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class TypeScriptExpressionParser
extends ES6ExpressionParser<TypeScriptParser> {
    protected TypeScriptExpressionParser(TypeScriptParser parser2) {
        super(parser2);
    }

    @Override
    protected boolean parseUnaryExpression() {
        return this.parseUnaryExpressionInner();
    }

    @Override
    protected IElementType getBinaryExpressionElementType(IElementType signType) {
        if (signType == JSTokenTypes.AS_KEYWORD) {
            return JSStubElementTypes.TYPE_AS_EXPRESSION;
        }
        if (signType == JSTokenTypes.SATISFIES_KEYWORD) {
            return JSElementTypes.TYPE_SATISFIES_EXPRESSION;
        }
        return super.getBinaryExpressionElementType(signType);
    }

    @Override
    protected ExpressionParser.BinaryParsingState parseBinaryRightHandSide(IElementType type2) {
        if (type2 == JSTokenTypes.AS_KEYWORD) {
            if (this.builder.getTokenType() == JSTokenTypes.CONST_KEYWORD) {
                this.advanceConstTypeInCast();
                return ExpressionParser.BinaryParsingState.STOP;
            }
            return this.parseTypeInRHS();
        }
        if (type2 == JSTokenTypes.SATISFIES_KEYWORD) {
            return this.parseTypeInRHS();
        }
        return super.parseBinaryRightHandSide(type2);
    }

    private ExpressionParser.BinaryParsingState parseTypeInRHS() {
        return ((TypeScriptPsiTypeParser)((TypeScriptParser)this.myJavaScriptParser).getTypeParser()).parseType() ? ExpressionParser.BinaryParsingState.STOP : ExpressionParser.BinaryParsingState.FAIL_AND_STOP;
    }

    private boolean parseUnaryExpressionInner() {
        if (this.builder.getTokenType() == JSTokenTypes.LT) {
            boolean canBeArrow = this.checkCanBeArrowForJSX(0);
            if (canBeArrow && ((TypeScriptFunctionParser)((TypeScriptParser)this.myJavaScriptParser).getFunctionParser()).parseArrowFunction()) {
                return true;
            }
            if (this.isRegularTypeScript()) {
                PsiBuilder.Marker expr = this.builder.mark();
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.CONST_KEYWORD) {
                    this.advanceConstTypeInCast();
                } else {
                    ((TypeScriptPsiTypeParser)((TypeScriptParser)this.myJavaScriptParser).getTypeParser()).parseType();
                }
                if (this.builder.getTokenType() != JSTokenTypes.GT) {
                    this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.gt", new Object[0]));
                } else {
                    this.builder.advanceLexer();
                }
                if (!this.parseUnaryExpression()) {
                    this.builder.error(JavaScriptBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                }
                expr.done(JSElementTypes.TYPE_ASSERTION);
                return true;
            }
        } else if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD) {
            boolean canBeArrow = true;
            if (!this.isRegularTypeScript()) {
                canBeArrow = this.checkCanBeArrowForJSX(1);
            }
            if (canBeArrow && ((TypeScriptFunctionParser)((TypeScriptParser)this.myJavaScriptParser).getFunctionParser()).parseArrowFunction()) {
                return true;
            }
        }
        return super.parseUnaryExpression();
    }

    private void advanceConstTypeInCast() {
        PsiBuilder.Marker mark = this.builder.mark();
        this.builder.advanceLexer();
        mark.done(TypeScriptStubElementTypes.CONST_TYPE);
    }

    private boolean checkCanBeArrowForJSX(int additionalLookaheadSteps) {
        boolean canBeArrow = true;
        if (!this.isRegularTypeScript() && this.isIdentifierToken(this.builder.lookAhead(additionalLookaheadSteps + 1))) {
            IElementType head2 = this.builder.lookAhead(additionalLookaheadSteps + 2);
            if (head2 == JSTokenTypes.EXTENDS_KEYWORD) {
                IElementType head3 = this.builder.lookAhead(additionalLookaheadSteps + 3);
                if (head3 == JSTokenTypes.EQ || head3 == JSTokenTypes.GT) {
                    canBeArrow = false;
                }
            } else if (head2 != JSTokenTypes.COMMA && head2 != JSTokenTypes.EQ) {
                canBeArrow = false;
            }
        }
        return canBeArrow;
    }

    public boolean isRegularTypeScript() {
        DialectOptionHolder dialect = ((TypeScriptParser)this.myJavaScriptParser).getDialect();
        if (dialect == null) {
            return true;
        }
        return !dialect.hasFeature(JSLanguageFeature.E4X);
    }

    @Override
    public boolean parsePrimaryExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
            this.parseParenthesizedExpression();
            if (this.builder.getTokenType() == JSTokenTypes.LT) {
                ((TypeScriptPsiTypeParser)((TypeScriptParser)this.myJavaScriptParser).getTypeParser()).tryParseTypeArgumentList(true, false, true);
            }
            return true;
        }
        return super.parsePrimaryExpression();
    }

    @Override
    protected boolean parseDialectSpecificMemberExpressionPart(Ref<PsiBuilder.Marker> markerRef, boolean isInExtendsOrImplementsList) {
        PsiBuilder.Marker marker = (PsiBuilder.Marker)markerRef.get();
        if (((TypeScriptPsiTypeParser)((TypeScriptParser)this.myJavaScriptParser).getTypeParser()).parseOptionalTypeArgumentListInExpression()) {
            if (!isInExtendsOrImplementsList && this.builder.getTokenType() != JSTokenTypes.LPAR && this.builder.getTokenType() != JSTokenTypes.BACKQUOTE) {
                marker.done(JSElementTypes.EXPRESSION_WITH_TYPE_ARGUMENTS);
                markerRef.set((Object)marker.precede());
            }
            return true;
        }
        if (this.builder.getTokenType() == JSTokenTypes.EXCL && !TypeScriptExpressionParser.hasLineTerminatorBefore(this.builder)) {
            this.builder.advanceLexer();
            marker.done(JSElementTypes.NOT_NULL_EXPRESSION);
            markerRef.set((Object)marker.precede());
            return true;
        }
        return false;
    }

    @Override
    protected IElementType getNewExpressionElementType() {
        return JSStubElementTypes.TYPESCRIPT_NEW_EXPRESSION;
    }

    @Override
    protected int getCurrentBinarySignPriority(boolean allowIn, boolean advance) {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.AS_KEYWORD || tokenType == JSTokenTypes.SATISFIES_KEYWORD) {
            if (TypeScriptExpressionParser.hasLineTerminatorBefore(this.builder)) {
                return -1;
            }
            if (advance) {
                this.builder.advanceLexer();
            }
            return 6;
        }
        int x = TypeScriptExpressionParser.collapseGtAndGetPriority(advance, this.builder);
        if (x > 0) {
            return x;
        }
        return super.getCurrentBinarySignPriority(allowIn, advance);
    }

    @Override
    protected boolean isFunctionPropertyStart(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            TypeScriptExpressionParser.$$$reportNull$$$0(0);
        }
        return JSKeywordSets.PROPERTY_NAMES.contains(builder2.getTokenType()) && builder2.lookAhead(1) == JSTokenTypes.LT || super.isFunctionPropertyStart(builder2);
    }

    @Override
    protected IElementType getFunctionPropertyElementType() {
        return JSStubElementTypes.TYPESCRIPT_FUNCTION_PROPERTY;
    }

    @Override
    public void parseTypeInEmbeddedTypeContext() {
        PsiBuilder.Marker root = this.builder.mark();
        ((TypeScriptPsiTypeParser)((TypeScriptParser)this.myJavaScriptParser).getTypeParser()).parseTypeInGenericArgument();
        while (!this.builder.eof()) {
            this.builder.advanceLexer();
        }
        root.done(JSStubElementTypes.EMBEDDED_EXPRESSION);
    }

    @Override
    protected boolean isParenAfterReferenceSeparator(IElementType tokenType) {
        if (super.isParenAfterReferenceSeparator(tokenType)) {
            return true;
        }
        if (tokenType == JSTokenTypes.LT) {
            return ((TypeScriptPsiTypeParser)((TypeScriptParser)this.myJavaScriptParser).getTypeParser()).tryParseTypeArgumentList(true, false, true) && this.builder.getTokenType() == JSTokenTypes.LPAR;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/ecmascript6/parsing/TypeScriptExpressionParser", "isFunctionPropertyStart"));
    }
}

