/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeWithSignature;
import com.intellij.lang.javascript.ecmascript6.types.TypeScriptOverloadContextualType;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.generic.JSTypeSubstitutorImpl;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerResolvedIdBase;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSRestType;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOfJSTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptSignatureChooser {
    private static final Comparator<PsiElement> FUNCTIONS_FIRST = Comparator.comparing(el -> el instanceof TypeScriptCompileTimeType ? 1 : -1).thenComparing(el -> el instanceof TypeScriptModule ? 1 : -1);
    public static final Comparator<ResolveResultSink.JSResolveResultForSymbolProcessor> FUNCTIONS_FIRST_RESOLVE_RESULT = (o1, o2) -> FUNCTIONS_FIRST.compare(o1.getResolveResult().getElement(), o2.getResolveResult().getElement());
    public static final int HAS_REST_ARG = Integer.MAX_VALUE;
    public static final Key<ParameterizedCachedValue<JSFunctionItem, Pair<List<? extends JSFunctionItem>, JSCallLikeExpression>>> RESOLVE_OVERLOAD_KEY = Key.create((String)"ts.resolve.overloads.signature");
    private static final ParameterizedCachedValueProvider<JSFunctionItem, Pair<List<? extends JSFunctionItem>, JSCallLikeExpression>> RESOLVE_OVERLOAD_CACHE = pair -> {
        List functions = (List)pair.getFirst();
        JSCallLikeExpression callLikeExpression = (JSCallLikeExpression)pair.getSecond();
        JSFunctionItem element = new JSTypeSignatureChooser(callLikeExpression).chooseOverloadFunction(functions, false);
        return CachedValueProvider.Result.create((Object)element, (Object[])new Object[]{callLikeExpression, PsiModificationTracker.MODIFICATION_COUNT});
    };

    @NotNull
    public static JSResolveResult getOverloadSignatureForImplementation(@NotNull PsiElement functionCandidate, @Nullable List<JSType> argumentTypes) {
        if (functionCandidate == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(0);
        }
        List<TypeScriptFunction> overloads = ((TypeScriptFunction)functionCandidate).getOverloadDeclarations();
        JSFunctionItem resolved = new JSTypeSignatureChooser(functionCandidate, ContainerUtil.notNullize(argumentTypes), null, JSTypeDeclaration.EMPTY_ARRAY).chooseOverloadFunction(overloads, true);
        if (resolved != null) {
            return new JSResolveResult((PsiElement)resolved);
        }
        PsiElement incorrectResult = overloads.size() > 0 ? (PsiElement)overloads.get(0) : functionCandidate;
        return new JSResolveResult(incorrectResult, null, JSResolveResult.ProblemKind.ARGUMENT_TYPES_MISMATCH);
    }

    public static boolean isOverloadImplementation(@Nullable PsiElement function2) {
        return function2 instanceof TypeScriptFunction && ((TypeScriptFunction)function2).isOverloadImplementation();
    }

    @NotNull
    public static List<JSFunctionWithSubstitutor> resolveConstructorOrCallSignature(@NotNull PsiElement referenceExpression) {
        JSReferenceExpression methodExpression;
        block6: {
            block5: {
                if (referenceExpression == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(1);
                }
                if (!(referenceExpression instanceof JSReferenceExpression)) break block5;
                methodExpression = (JSReferenceExpression)referenceExpression;
                if (referenceExpression.getParent() instanceof JSCallExpression) break block6;
            }
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(2);
            }
            return list2;
        }
        ResolveResult[] resolveResults = methodExpression.multiResolve(false);
        List<PsiElement> elements = JSResolveResult.toElements(resolveResults);
        return TypeScriptSignatureChooser.resolveConstructorOrCallSignature(methodExpression, (JSCallExpression)referenceExpression.getParent(), elements, true);
    }

    @NotNull
    public static List<JSFunctionWithSubstitutor> resolveConstructorOrCallSignature(@NotNull JSReferenceExpression methodExpression, @NotNull JSCallExpression callExpression, @NotNull Collection<PsiElement> resolveResults, boolean assignableOnly) {
        PsiElement functionCandidate;
        List<JSFunctionItem> resolveElements;
        boolean hasAliases;
        if (methodExpression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(3);
        }
        if (callExpression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(4);
        }
        if (resolveResults == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(5);
        }
        if (hasAliases = ContainerUtil.exists(resolveResults, r -> r instanceof TypeScriptProxyImplicitElementWithBackingItem)) {
            resolveResults = TypeScriptImplicitOverloadedAliasElement.unwrapElements(resolveResults);
        }
        if (callExpression instanceof JSNewExpression && (resolveElements = TypeScriptSignatureChooser.getConstructorsForResolveElements(methodExpression, resolveResults)).size() > 0) {
            List list2 = ContainerUtil.map(resolveElements, JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR);
            if (list2 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(6);
            }
            return list2;
        }
        if (resolveResults.size() == 1 && (functionCandidate = (PsiElement)ContainerUtil.getFirstItem(resolveResults)) != null && (!(functionCandidate instanceof JSFunction) || hasAliases) && DialectDetector.isTypeScript(functionCandidate)) {
            return TypeScriptSignatureChooser.getCallSignatures(functionCandidate, callExpression, assignableOnly);
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(7);
        }
        return list3;
    }

    @NotNull
    private static List<JSFunctionItem> getConstructorsForResolveElements(@NotNull JSReferenceExpression methodExpression, @NotNull Collection<PsiElement> elements) {
        if (methodExpression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(8);
        }
        if (elements == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(9);
        }
        if (!elements.isEmpty()) {
            SmartList result2 = new SmartList();
            for (PsiElement psiElement : elements) {
                ResolveResult[] results;
                List<PsiElement> resolvedElements;
                if (!(psiElement instanceof JSClass) || (resolvedElements = JSResolveResult.toElements(results = JSClassUtils.resolveES6Constructor((JSClass)psiElement, methodExpression))).isEmpty()) continue;
                result2.addAll(resolvedElements);
            }
            if (result2.size() > 0) {
                List list2 = ContainerUtil.mapNotNull((Collection)result2, el -> el instanceof JSFunctionItem ? (JSFunctionItem)el : null);
                if (list2 == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(10);
                }
                return list2;
            }
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(11);
        }
        return list3;
    }

    @NotNull
    private static List<JSFunctionWithSubstitutor> getCallSignatures(@NotNull PsiElement functionCandidate, @NotNull JSCallExpression callExpression, boolean assignableOnly) {
        JSExpression methodExpression;
        Collection<JSFunctionWithSubstitutor> functionWithSubstitutors;
        List functionItems;
        JSFunctionItem functionItem;
        if (functionCandidate == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(12);
        }
        if (callExpression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(13);
        }
        if ((functionItem = new JSTypeSignatureChooser(callExpression).chooseOverloadFunction(functionItems = ContainerUtil.map(functionWithSubstitutors = JSStubBasedPsiTreeUtil.calculatePossibleFunctions(functionCandidate, (PsiElement)(methodExpression = callExpression.getMethodExpression()), false), el -> el.myFunctionItem), assignableOnly)) != null) {
            for (JSFunctionWithSubstitutor withSubstitutor : functionWithSubstitutors) {
                if (withSubstitutor.myFunctionItem != functionItem) continue;
                List list2 = ContainerUtil.createMaybeSingletonList((Object)withSubstitutor);
                if (list2 == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(14);
                }
                return list2;
            }
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(15);
        }
        return list3;
    }

    public static int getMinArgumentCount(@NotNull List<? extends JSParameterTypeDecorator> parameters) {
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(16);
        }
        if (parameters.size() == 0) {
            return 0;
        }
        int minArgumentCount = 0;
        for (JSParameterTypeDecorator jSParameterTypeDecorator : parameters) {
            if (jSParameterTypeDecorator.isOptional()) break;
            if (jSParameterTypeDecorator.isRest()) {
                JSTupleType innerTuple;
                JSRestType restType;
                JSType jSType = jSParameterTypeDecorator.getSimpleType();
                if (!(jSType instanceof JSRestType) || !((jSType = (restType = (JSRestType)((Object)jSType)).getInnerType()) instanceof JSTupleType) || !ContainerUtil.exists((innerTuple = (JSTupleType)jSType).getTypes(), t -> !(t instanceof JSSpreadType))) break;
                ++minArgumentCount;
                break;
            }
            ++minArgumentCount;
        }
        return minArgumentCount;
    }

    public static int getMaxArgumentCount(@NotNull List<? extends JSParameterTypeDecorator> parameters) {
        int size;
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(17);
        }
        if ((size = parameters.size()) == 0) {
            return 0;
        }
        JSParameterTypeDecorator lastParameter = (JSParameterTypeDecorator)ContainerUtil.getLastItem(parameters);
        if (lastParameter == null) {
            return size;
        }
        if (lastParameter.isRest()) {
            return Integer.MAX_VALUE;
        }
        return TypeScriptSignatureChooser.getMaxCountWithTuple(size, lastParameter.getSimpleType());
    }

    public static int getMinArgumentCount(JSParameterItem @NotNull [] parameters) {
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(18);
        }
        if (parameters.length == 0) {
            return 0;
        }
        int minArgumentCount = 0;
        for (JSParameterItem element : parameters) {
            if (element.isOptional() || element.isRest()) break;
            ++minArgumentCount;
        }
        return minArgumentCount;
    }

    private static int getMaxCountWithTuple(int length, @Nullable JSType type2) {
        if (type2 instanceof JSTupleType) {
            int maxLength = ((JSTupleType)type2).getMaxLength();
            return maxLength == Integer.MAX_VALUE ? Integer.MAX_VALUE : length + maxLength;
        }
        return length;
    }

    @Nullable
    public static JSRecordType.CallSignature findMatchedSignature(@NotNull List<? extends JSRecordType.CallSignature> signatures, @NotNull JSRecordType.CallSignature signature, boolean partialMatch, boolean ignoreReturnType) {
        if (signatures == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(19);
        }
        if (signature == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(20);
        }
        for (JSRecordType.CallSignature callSignature : signatures) {
            if (!TypeScriptSignatureChooser.compareSignaturesIdentical(callSignature, signature, partialMatch, ignoreReturnType)) continue;
            return callSignature;
        }
        return null;
    }

    @NotNull
    public static List<JSRecordType.CallSignature> findMatchingSignatures(@NotNull List<? extends List<JSRecordType.CallSignature>> table, @NotNull JSRecordType.CallSignature signature, int workingIndex) {
        if (table == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(21);
        }
        if (signature == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(22);
        }
        SmartList result2 = new SmartList();
        for (int i = 0; i < table.size(); ++i) {
            JSRecordType.CallSignature matched;
            List<JSRecordType.CallSignature> signatures = table.get(i);
            JSRecordType.CallSignature callSignature = matched = i == workingIndex ? signature : TypeScriptSignatureChooser.findMatchedSignature(signatures, signature, true, true);
            if (matched == null) {
                List list2 = ContainerUtil.emptyList();
                if (list2 == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(23);
                }
                return list2;
            }
            result2.add(matched);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(24);
        }
        return smartList;
    }

    private static boolean compareSignaturesIdentical(@NotNull JSRecordType.CallSignature source, @NotNull JSRecordType.CallSignature target, boolean partialMatch, boolean ignoreReturnType) {
        if (source == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(25);
        }
        if (target == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(26);
        }
        if (source.isEquivalentTo(target, null, true)) {
            return true;
        }
        if (!TypeScriptSignatureChooser.isMatchingSignature(source, target, partialMatch)) {
            return false;
        }
        List<JSParameterTypeDecorator> lParameters = source.getParameterTypeDecorators();
        List<JSParameterTypeDecorator> rParameters = target.getParameterTypeDecorators();
        int rLength = rParameters.size();
        PsiElement element = source.getMemberSource().getSingleElement();
        for (int i = 0; i < lParameters.size(); ++i) {
            JSType rParameterType;
            JSParameterTypeDecorator lDecorator = lParameters.get(i);
            JSParameterTypeDecorator rDecorator = rLength > i ? rParameters.get(i) : null;
            JSType lParameterType = lDecorator.getSimpleType();
            JSType jSType = rParameterType = rDecorator == null ? TypeScriptSignatureChooser.getRestComponentType(rParameters, element) : rDecorator.getSimpleType();
            if (TypeScriptTypeRelations.isTypeRelatedTo(lParameterType, rParameterType, null)) continue;
            return false;
        }
        if (!ignoreReturnType) {
            JSType sourceReturnType = source.getReturnType();
            JSType targetReturnType = target.getReturnType();
            return TypeScriptTypeRelations.isTypeRelatedTo(sourceReturnType, targetReturnType, null);
        }
        return true;
    }

    @Nullable
    public static JSType getRestComponentType(@NotNull List<? extends JSParameterTypeDecorator> parameters, PsiElement context2) {
        int size;
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(27);
        }
        if ((size = parameters.size()) == 0) {
            return null;
        }
        JSParameterTypeDecorator last = parameters.get(size - 1);
        return last.isRest() && last.getSimpleType() != null ? JSTypeUtils.getIndexableComponentType(last.getSimpleType()) : JSAnyType.get(context2);
    }

    public static boolean isMatchingSignature(@NotNull JSRecordType.CallSignature source, @NotNull JSRecordType.CallSignature target, boolean partial) {
        if (source == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(28);
        }
        if (target == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(29);
        }
        List<JSParameterTypeDecorator> sourceParameters = source.getParameterTypeDecorators();
        int minSource = TypeScriptSignatureChooser.getMinArgumentCount(sourceParameters);
        List<JSParameterTypeDecorator> targetParameters = target.getParameterTypeDecorators();
        int minTarget = TypeScriptSignatureChooser.getMinArgumentCount(targetParameters);
        boolean sourceHasRestParameter = TypeScriptSignatureChooser.hasRestParameter(sourceParameters);
        boolean targetHasRestParameter = TypeScriptSignatureChooser.hasRestParameter(targetParameters);
        if (sourceParameters.size() == targetParameters.size() && minSource == minTarget && sourceHasRestParameter == targetHasRestParameter) {
            return true;
        }
        if (partial && minSource <= minTarget) {
            if (sourceHasRestParameter && !targetHasRestParameter) {
                return true;
            }
            if (sourceHasRestParameter == targetHasRestParameter) {
                return sourceParameters.size() >= targetParameters.size();
            }
        }
        return false;
    }

    private static boolean hasRestParameter(@NotNull List<JSParameterTypeDecorator> parameters) {
        if (parameters == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(30);
        }
        return parameters.size() != 0 && parameters.get(parameters.size() - 1).isRest();
    }

    @Nullable
    public static JSType mapContextualTypeForOverload(@Nullable JSType jsType, @Nullable JSFunctionType jsFunctionType, final @Nullable JSCallItem callItem, JSExpectedTypeKind expectedTypeKind) {
        if (jsType == null) {
            return null;
        }
        JSFunctionItem functionCandidate = jsFunctionType != null ? jsFunctionType.getSourceFunctionItem() : null;
        return jsType.transformTypeHierarchy(new JSCacheableTypeTransformerResolvedIdBase((PsiElement)functionCandidate, expectedTypeKind){
            final /* synthetic */ PsiElement val$functionCandidate;
            final /* synthetic */ JSExpectedTypeKind val$expectedTypeKind;
            {
                this.val$functionCandidate = psiElement;
                this.val$expectedTypeKind = jSExpectedTypeKind;
            }

            @Override
            @NotNull
            public JSType fun(@NotNull JSType el) {
                JSType substitute;
                if (el == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (el instanceof JSPsiBasedTypeOfType && ((JSPsiBasedTypeOfType)el).isWithContextualOverloads() && (substitute = el.substitute()) != el) {
                    JSType jSType = substitute.transformTypeHierarchy(this);
                    if (jSType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return jSType;
                }
                if (el instanceof TypeScriptOverloadContextualType) {
                    TypeScriptOverloadContextualType contextualType = (TypeScriptOverloadContextualType)el;
                    if (callItem == ((TypeScriptOverloadContextualType)el).getExpression() && this.val$functionCandidate != null) {
                        for (JSTypeWithSignature signature : contextualType.getTypes()) {
                            if (!this.val$functionCandidate.getManager().areElementsEquivalent(this.val$functionCandidate, (PsiElement)signature.getFunction())) continue;
                            JSType jSType = signature.evaluateGenerics(contextualType.getExpression(), contextualType.getIndex(), this.val$expectedTypeKind.increaseInferenceDepth());
                            if (jSType == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return jSType;
                        }
                    }
                }
                JSType jSType = el;
                if (jSType == null) {
                    1.$$$reportNull$$$0(3);
                }
                return jSType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "el";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fun";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "fun";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3 -> new IllegalStateException(string);
                };
            }
        });
    }

    @Nullable
    public static JSFunctionItem resolveOverloads(@NotNull JSCallLikeExpression callLikeExpression, @NotNull List<? extends JSFunctionItem> functions) {
        if (callLikeExpression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(31);
        }
        if (functions == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(32);
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)callLikeExpression.getProject());
        return (JSFunctionItem)manager.getParameterizedCachedValue((UserDataHolder)callLikeExpression, RESOLVE_OVERLOAD_KEY, RESOLVE_OVERLOAD_CACHE, false, (Object)new Pair(functions, (Object)callLikeExpression));
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> getFunctionsExcludeNonFunctionsInType(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(33);
            }
            return list2;
        }
        JSType jsType = JSTypeUtils.getTypeOfElement(psiElement);
        if (jsType == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(34);
            }
            return list3;
        }
        if (!TypeScriptSignatureChooser.typeCanHaveExplicitCallSignatures(jsType = jsType.substitute(), false)) {
            List<JSFunctionWithSubstitutor> list4 = Collections.emptyList();
            if (list4 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(35);
            }
            return list4;
        }
        if (!(jsType instanceof JSEvaluableOnlyType) || !jsType.isJavaScript()) {
            JSRecordType recordType = jsType.asRecordType();
            List<JSRecordType.TypeMember> members = recordType.getTypeMembers();
            List<JSRecordType.CallSignature> signatures = recordType.getCallSignatures();
            if (members.size() > 0 && signatures.size() != members.size()) {
                List list5 = ContainerUtil.emptyList();
                if (list5 == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(36);
                }
                return list5;
            }
        }
        Collection<JSFunctionWithSubstitutor> collection = JSStubBasedPsiTreeUtil.calculatePossibleFunctions(psiElement, null, true);
        if (collection == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(37);
        }
        return collection;
    }

    @NotNull
    public static List<? extends JSFunctionItem> resolveFunctions(@Nullable JSCallLikeExpression callLikeExpression) {
        if (callLikeExpression == null || callLikeExpression.getParent() instanceof ES6Decorator) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(38);
            }
            return list2;
        }
        JSExpression methodExpression = callLikeExpression.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(39);
            }
            return list3;
        }
        if (callLikeExpression instanceof JSNewExpression) {
            List<JSFunctionWithSubstitutor> functionWithSubstitutors = TypeScriptSignatureChooser.resolveConstructorOrCallSignature((PsiElement)methodExpression);
            List list4 = functionWithSubstitutors.size() != 1 ? ContainerUtil.emptyList() : ContainerUtil.map(functionWithSubstitutors, el -> el.myFunctionItem);
            if (list4 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(40);
            }
            return list4;
        }
        ResolveResult[] results = ((JSReferenceExpression)methodExpression).multiResolve(false);
        PsiElement resolve = JSResolveResult.resolve(results);
        if (resolve == null) {
            List list5 = ContainerUtil.emptyList();
            if (list5 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(41);
            }
            return list5;
        }
        List list6 = ContainerUtil.map(JSStubBasedPsiTreeUtil.calculatePossibleFunctions(resolve, (PsiElement)methodExpression, true), el -> el.myFunctionItem);
        if (list6 == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(42);
        }
        return list6;
    }

    @Nullable
    public static JSFunctionItem resolveAnyFunction(@Nullable PsiElement object, @Nullable PsiElement context2) {
        PsiElement callCandidate;
        JSCallExpression callExpression;
        if (object instanceof JSFunctionItem) {
            return (JSFunctionItem)object;
        }
        if (context2 == null) {
            return null;
        }
        if (!(context2 instanceof JSExpression)) {
            context2 = context2.getContext();
        }
        if ((callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)(callCandidate = context2 != null && !(context2 instanceof JSCallExpression) ? context2.getContext() : null), JSCallExpression.class)) == null) {
            return null;
        }
        List<? extends JSFunctionItem> relatedFunctions = TypeScriptSignatureChooser.resolveFunctions(callExpression);
        if (relatedFunctions.isEmpty()) {
            return null;
        }
        JSFunctionItem result2 = relatedFunctions.size() == 1 ? relatedFunctions.get(0) : TypeScriptSignatureChooser.resolveOverloads(callExpression, relatedFunctions);
        return object == null || result2 != null && TypeScriptSignatureChooser.isCallSignatureOf(result2, object) ? result2 : null;
    }

    public static boolean isCallSignatureOf(@NotNull JSFunctionItem function2, @NotNull PsiElement object) {
        if (function2 == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(43);
        }
        if (object == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(44);
        }
        return Stream.ofNullable(JSResolveUtil.getElementJSType(object)).flatMap(it -> it.asRecordType().getCallSignatures().stream()).flatMap(it -> it.getMemberSource().getAllSourceElements().stream()).anyMatch(it -> it == function2);
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctionForVariable(@NotNull JSFieldVariable element, @Nullable PsiElement methodExpression, @Nullable Set<PsiElement> visited, boolean includeRawSignatures) {
        boolean isNew;
        PsiElement typeElement2;
        if (element == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(45);
        }
        if ((typeElement2 = element.getTypeElement()) != null) {
            return TypeScriptSignatureChooser.calculatePossibleFunctionForTypeElement(typeElement2, methodExpression, visited, includeRawSignatures);
        }
        if (!includeRawSignatures) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(46);
            }
            return list2;
        }
        JSType expanded = JSResolveUtil.getElementJSType((PsiElement)element);
        if (!TypeScriptSignatureChooser.typeCanHaveExplicitCallSignatures(expanded, isNew = TypeScriptSignatureChooser.isNewExpression(methodExpression))) {
            List<JSFunctionWithSubstitutor> list3 = Collections.emptyList();
            if (list3 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(47);
            }
            return list3;
        }
        List<JSRecordType.CallSignature> signatures = expanded.asRecordType().getCallSignatures();
        if (signatures.isEmpty()) {
            List list4 = ContainerUtil.emptyList();
            if (list4 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(48);
            }
            return list4;
        }
        ArrayList<JSFunctionItem> results = new ArrayList<JSFunctionItem>();
        for (JSRecordType.CallSignature member : signatures) {
            PsiElement singleElement;
            if (methodExpression != null && isNew != member.hasNew() || !((singleElement = member.getMemberSource().getSingleElement()) instanceof JSFunctionItem)) continue;
            results.add((JSFunctionItem)singleElement);
        }
        List list5 = ContainerUtil.map(results, el -> new JSFunctionWithSubstitutor((JSFunctionItem)el, JSTypeSubstitutor.EMPTY));
        if (list5 == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(49);
        }
        return list5;
    }

    @NotNull
    private static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctionForTypeElement(@Nullable PsiElement typeElement2, @Nullable PsiElement methodExpression, @Nullable Set<PsiElement> visited, boolean includeRawSignatures) {
        ThreeState hasNew;
        if (typeElement2 == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(50);
            }
            return list2;
        }
        ThreeState threeState = hasNew = methodExpression == null ? ThreeState.UNSURE : ThreeState.fromBoolean((boolean)TypeScriptSignatureChooser.isNewExpression(methodExpression));
        if (typeElement2 instanceof TypeScriptSingleType) {
            return TypeScriptSignatureChooser.getSignaturesForSingleType((TypeScriptSingleType)typeElement2, hasNew, methodExpression, visited, includeRawSignatures);
        }
        if (typeElement2 instanceof JSFunction) {
            List<JSFunctionWithSubstitutor> list3 = List.of((JSFunctionWithSubstitutor)JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR.fun((Object)((JSFunctionItem)typeElement2)));
            if (list3 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(51);
            }
            return list3;
        }
        if (typeElement2 instanceof TypeScriptObjectType) {
            return TypeScriptSignatureChooser.getCallSignatures((TypeScriptObjectType)typeElement2, hasNew);
        }
        if (typeElement2 instanceof TypeScriptTypeofType) {
            String refExpression = ((TypeScriptTypeofType)typeElement2).getReferenceText();
            if (StringUtil.isEmpty((String)refExpression)) {
                List list4 = ContainerUtil.emptyList();
                if (list4 == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(52);
                }
                return list4;
            }
            Collection<? extends PsiElement> elements = TypeScriptTypeOfJSTypeImpl.getTypeOfResultElements(typeElement2, refExpression);
            if (visited == null) {
                visited = new HashSet<PsiElement>();
            }
            if (!visited.add(typeElement2)) {
                List list5 = ContainerUtil.emptyList();
                if (list5 == null) {
                    TypeScriptSignatureChooser.$$$reportNull$$$0(53);
                }
                return list5;
            }
            Set<PsiElement> finalVisited = visited;
            Collection collection = elements.stream().flatMap(el -> JSStubBasedPsiTreeUtil.calculatePossibleFunctions(el, methodExpression, finalVisited, includeRawSignatures).stream()).collect(Collectors.toList());
            if (collection == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(54);
            }
            return collection;
        }
        List list6 = ContainerUtil.emptyList();
        if (list6 == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(55);
        }
        return list6;
    }

    private static boolean isNewExpression(@Nullable PsiElement methodExpression) {
        @Nullable PsiElement callExpressionCandidate = methodExpression instanceof JSCallExpression ? methodExpression : (methodExpression == null ? null : methodExpression.getParent());
        return callExpressionCandidate instanceof JSNewExpression;
    }

    @NotNull
    private static Collection<JSFunctionWithSubstitutor> getSignaturesForSingleType(@NotNull TypeScriptSingleType singleType, @NotNull ThreeState isNewExpression, @Nullable PsiElement methodExpression, @Nullable Set<PsiElement> visited, boolean includeRawSignatures) {
        if (singleType == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(56);
        }
        if (isNewExpression == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(57);
        }
        JSTypeDeclaration[] typeArguments = singleType.getTypeArguments();
        List<JSType> genericArguments = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(typeArguments, null);
        String qualifiedTypeName = singleType.getQualifiedTypeName();
        if (qualifiedTypeName == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(58);
            }
            return list2;
        }
        JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveTypeName(qualifiedTypeName, (PsiElement)singleType);
        if (!result2.hasElements()) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                TypeScriptSignatureChooser.$$$reportNull$$$0(59);
            }
            return list3;
        }
        ArrayList<JSFunctionWithSubstitutor> allSignatures = new ArrayList<JSFunctionWithSubstitutor>();
        for (PsiElement psiElement : result2.getElements()) {
            Collection<Object> signatures = ContainerUtil.emptyList();
            if (psiElement instanceof TypeScriptTypeAlias) {
                TypeScriptType aliasedType = ((TypeScriptTypeAlias)psiElement).getTypeDeclaration();
                if (aliasedType != null) {
                    if (visited == null) {
                        visited = new HashSet<PsiElement>();
                    }
                    if (!visited.add((PsiElement)singleType)) {
                        List list4 = ContainerUtil.emptyList();
                        if (list4 == null) {
                            TypeScriptSignatureChooser.$$$reportNull$$$0(60);
                        }
                        return list4;
                    }
                    signatures = TypeScriptSignatureChooser.calculatePossibleFunctionForTypeElement((PsiElement)aliasedType, methodExpression, visited, includeRawSignatures);
                } else {
                    signatures = ContainerUtil.emptyList();
                }
            } else if (psiElement instanceof TypeScriptInterface) {
                signatures = TypeScriptSignatureChooser.getCallSignatures((TypeScriptInterface)psiElement, isNewExpression);
            }
            if (!genericArguments.isEmpty() && psiElement instanceof TypeScriptTypeParameterListOwner) {
                JSTypeSubstitutor argumentsSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)psiElement, genericArguments);
                for (JSFunctionWithSubstitutor jSFunctionWithSubstitutor : signatures) {
                    JSTypeSubstitutor substitutor = JSTypeSubstitutorImpl.combineWithApplying(argumentsSubstitutor, jSFunctionWithSubstitutor.myTypeSubstitutor, JSTypeUtils::applyGenericArguments);
                    allSignatures.add(new JSFunctionWithSubstitutor(jSFunctionWithSubstitutor.myFunctionItem, substitutor));
                }
                continue;
            }
            allSignatures.addAll((Collection<JSFunctionWithSubstitutor>)signatures);
        }
        ArrayList<JSFunctionWithSubstitutor> arrayList = allSignatures;
        if (arrayList == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(61);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> getCallSignatures(@NotNull TypeScriptInterface interfaceToProcess, @NotNull ThreeState isNew) {
        if (interfaceToProcess == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(62);
        }
        if (isNew == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(63);
        }
        ArrayList<JSFunctionWithSubstitutor> result2 = new ArrayList<JSFunctionWithSubstitutor>();
        JSClassUtils.processClassesInHierarchy((JSClass)interfaceToProcess, true, (aClass, typeSubstitutor, fromImplements) -> {
            List<JSFunctionItem> interfaceSignatures = TypeScriptSignatureChooser.getCallSignatures(aClass.getMembers(), isNew);
            result2.addAll(ContainerUtil.map(interfaceSignatures, fun -> new JSFunctionWithSubstitutor((JSFunctionItem)fun, typeSubstitutor)));
            return true;
        });
        ArrayList<JSFunctionWithSubstitutor> arrayList = result2;
        if (arrayList == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(64);
        }
        return arrayList;
    }

    @NotNull
    private static List<JSFunctionWithSubstitutor> getCallSignatures(@NotNull TypeScriptObjectType type2, @NotNull ThreeState isNew) {
        if (type2 == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(65);
        }
        if (isNew == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(66);
        }
        List list2 = ContainerUtil.map(TypeScriptSignatureChooser.getCallSignatures(Arrays.asList(type2.getTypeMembers()), isNew), JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR);
        if (list2 == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(67);
        }
        return list2;
    }

    @NotNull
    private static List<JSFunctionItem> getCallSignatures(@NotNull Iterable<? extends JSElement> members, @NotNull ThreeState isNew) {
        if (members == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(68);
        }
        if (isNew == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(69);
        }
        SmartList result2 = new SmartList();
        for (JSElement jSElement : members) {
            if (!(jSElement instanceof TypeScriptCallSignature)) continue;
            TypeScriptCallSignature callSignature = (TypeScriptCallSignature)jSElement;
            if (isNew != ThreeState.UNSURE && ThreeState.fromBoolean((boolean)callSignature.isConstructor()) != isNew) continue;
            result2.add(callSignature);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            TypeScriptSignatureChooser.$$$reportNull$$$0(70);
        }
        return smartList;
    }

    @Contract(value="null,_ -> false")
    public static boolean typeCanHaveExplicitCallSignatures(@Nullable JSType type2, boolean isNew) {
        JSResolvedTypeInfo info2;
        Collection<? extends PsiElement> declarations;
        JSType innerType;
        if (type2 == null) {
            return false;
        }
        if (type2 instanceof JSFunctionType) {
            return true;
        }
        if (type2 instanceof JSGenericTypeImpl && (innerType = ((JSGenericTypeImpl)type2).getType()) instanceof JSTypeImpl && !(declarations = (info2 = ((JSTypeImpl)innerType).resolveType()).getDeclarations()).isEmpty() && ContainerUtil.and(declarations, d -> d instanceof TypeScriptClass)) {
            return false;
        }
        if (type2 instanceof JSTypeImpl) {
            JSResolvedTypeInfo resolvedInfo = ((JSTypeImpl)type2).resolveType();
            return resolvedInfo.isInterface() && ContainerUtil.exists(resolvedInfo.getDeclarations(), el -> el instanceof TypeScriptInterface && ((TypeScriptInterface)el).hasCallSignature());
        }
        if (type2 instanceof JSSimpleRecordTypeImpl) {
            return type2.getSource().getSourceElement() instanceof TypeScriptObjectType;
        }
        if (type2 instanceof JSUnionOrIntersectionType) {
            return ContainerUtil.exists(((JSUnionOrIntersectionType)type2).getTypes(), el -> TypeScriptSignatureChooser.typeCanHaveExplicitCallSignatures(el, isNew));
        }
        return isNew || !(type2 instanceof JSUtilType);
    }

    @Nullable
    public static JSCallLikeExpression getCallLikeExpression(@Nullable PsiElement place) {
        PsiElement parent;
        if (place == null) {
            return null;
        }
        PsiElement psiElement = parent = place instanceof PsiFile ? place : place.getParent();
        while (parent instanceof JSParenthesizedExpression) {
            parent = parent.getParent();
        }
        return parent instanceof JSCallLikeExpression ? (JSCallLikeExpression)parent : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 10, 11, 14, 15, 23, 24, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 64, 67, 70 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCandidate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 23: 
            case 24: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatures";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callLikeExpression";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleType";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isNewExpression";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceToProcess";
                break;
            }
            case 63: 
            case 66: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isNew";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptSignatureChooser";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructorOrCallSignature";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorsForResolveElements";
                break;
            }
            case 14: 
            case 15: 
            case 64: 
            case 67: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallSignatures";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatchingSignatures";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionsExcludeNonFunctionsInType";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFunctions";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePossibleFunctionForVariable";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePossibleFunctionForTypeElement";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesForSingleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOverloadSignatureForImplementation";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorOrCallSignature";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 23: 
            case 24: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 67: 
            case 70: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorsForResolveElements";
                break;
            }
            case 12: 
            case 13: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getCallSignatures";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMinArgumentCount";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMaxArgumentCount";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findMatchedSignature";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingSignatures";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "compareSignaturesIdentical";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRestComponentType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingSignature";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasRestParameter";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveOverloads";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isCallSignatureOf";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleFunctionForVariable";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getSignaturesForSingleType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 10, 11, 14, 15, 23, 24, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 58, 59, 60, 61, 64, 67, 70 -> new IllegalStateException(string);
        };
    }
}

