/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.documentation.JSTooltipCachedCodeStyleSettingsService;
import com.intellij.lang.javascript.documentation.JSTooltipWithHtmlHighlighterImpl;
import com.intellij.lang.javascript.documentation.JSTooltipWithHtmlHighlighterImplKt;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.validation.JSTooltipWithHtmlHighlighter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/lang/javascript/documentation/JSTooltipWithHtmlHighlighterImpl;", "Lcom/intellij/lang/javascript/validation/JSTooltipWithHtmlHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "applyAttributes", "", "text", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "wrapWithCodeTag", "", "doHighlight", "code", "limit", "", "highlightImpl", "typePlainText", "wrapLimit", "highlightName", "name", "element", "Lcom/intellij/psi/PsiElement;", "highlightTypeOrStmt", "highlightWithLexer", "language", "Lcom/intellij/lang/Language;", "shouldWrapWithBlock", "originalCode", "htmlCode", "simpleLinesFallback", "fullErrorText", "wrapToCodeTagsForTooltip", "codeInnerHtml", "isBlock", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSTooltipWithHtmlHighlighterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSTooltipWithHtmlHighlighterImpl.kt\ncom/intellij/lang/javascript/documentation/JSTooltipWithHtmlHighlighterImpl\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,138:1\n35#2:139\n35#2:140\n35#2:141\n35#2:142\n731#3,9:143\n37#4,2:152\n*S KotlinDebug\n*F\n+ 1 JSTooltipWithHtmlHighlighterImpl.kt\ncom/intellij/lang/javascript/documentation/JSTooltipWithHtmlHighlighterImpl\n*L\n35#1:139\n39#1:140\n43#1:141\n47#1:142\n124#1:143,9\n124#1:152,2\n*E\n"})
public final class JSTooltipWithHtmlHighlighterImpl
implements JSTooltipWithHtmlHighlighter {
    @NotNull
    private final Project project;

    public JSTooltipWithHtmlHighlighterImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    @NotNull
    public String highlightTypeOrStmt(@NotNull String typePlainText, boolean wrapWithCodeTag, int wrapLimit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)typePlainText, (String)"typePlainText");
        String string2 = this.highlightImpl(typePlainText, wrapLimit);
        boolean $i$f$applyIf = false;
        if (wrapWithCodeTag) {
            void $this$highlightTypeOrStmt_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            string = this.wrapWithCodeTag((String)$this$highlightTypeOrStmt_u24lambda_u240, this.shouldWrapWithBlock(typePlainText, (String)$this$highlightTypeOrStmt_u24lambda_u240, wrapLimit));
        } else {
            string = $this$applyIf$iv;
        }
        return string;
    }

    @Override
    @NotNull
    public String highlightName(@NotNull String name, @NotNull PsiElement element, boolean wrapWithCodeTag) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string2 = JSQuickNavigateBuilder.buildHtmlForName(element, name);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buildHtmlForName(...)");
        String string3 = string2;
        boolean $i$f$applyIf = false;
        if (wrapWithCodeTag) {
            void $this$highlightName_u24lambda_u241 = $this$applyIf$iv;
            boolean bl = false;
            string = this.wrapWithCodeTag((String)$this$highlightName_u24lambda_u241, false);
        } else {
            string = $this$applyIf$iv;
        }
        return string;
    }

    @Override
    @NotNull
    public String applyAttributes(@NotNull String text2, @NotNull TextAttributesKey textAttributesKey, boolean wrapWithCodeTag) {
        String string;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)textAttributesKey, (String)"textAttributesKey");
        String string2 = QuickDocHighlightingHelper.getStyledFragment((String)text2, (TextAttributesKey)textAttributesKey);
        boolean $i$f$applyIf = false;
        if (wrapWithCodeTag) {
            void $this$applyAttributes_u24lambda_u242 = $this$applyIf$iv;
            boolean bl = false;
            string = this.wrapWithCodeTag((String)$this$applyAttributes_u24lambda_u242, JSTooltipWithHtmlHighlighterImpl.shouldWrapWithBlock$default(this, text2, (String)$this$applyAttributes_u24lambda_u242, 0, 4, null));
        } else {
            string = $this$applyIf$iv;
        }
        return string;
    }

    @Override
    @NotNull
    public String highlightWithLexer(@NotNull String text2, @NotNull Language language, boolean wrapWithCodeTag) {
        String string;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String string2 = QuickDocHighlightingHelper.getStyledCodeFragment((Project)this.project, (Language)language, (String)text2);
        boolean $i$f$applyIf = false;
        if (wrapWithCodeTag) {
            void $this$highlightWithLexer_u24lambda_u243 = $this$applyIf$iv;
            boolean bl = false;
            string = this.wrapWithCodeTag((String)$this$highlightWithLexer_u24lambda_u243, JSTooltipWithHtmlHighlighterImpl.shouldWrapWithBlock$default(this, text2, (String)$this$highlightWithLexer_u24lambda_u243, 0, 4, null));
        } else {
            string = $this$applyIf$iv;
        }
        return string;
    }

    @Override
    @NotNull
    public String wrapWithCodeTag(@NotNull String text2, boolean isBlock) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.wrapToCodeTagsForTooltip(text2, isBlock);
    }

    private final String highlightImpl(String typePlainText, int wrapLimit) {
        String string;
        if (JSTooltipWithHtmlHighlighterImplKt.access$getSKIP_HTML_HIGHLIGHT_PATTERN$p().matcher(typePlainText).matches()) {
            string = typePlainText;
        } else {
            string = this.doHighlight(this.project, typePlainText, wrapLimit);
            if (string == null) {
                string = this.simpleLinesFallback(typePlainText);
            }
        }
        return string;
    }

    private final String doHighlight(Project project, String code, int limit) {
        PsiElement typeElement2 = (PsiElement)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, (Function0)new Function0<PsiElement>(code, project){
            final /* synthetic */ String $code;
            final /* synthetic */ Project $project;
            {
                this.$code = $code;
                this.$project = $project;
                super(0);
            }

            @Nullable
            public final PsiElement invoke() {
                return JSChangeUtil.tryCreateTypeElement(this.$code, this.$project);
            }
        });
        if (typeElement2 == null || JSTooltipWithHtmlHighlighterImpl.doHighlight$hasErrors(project, typeElement2)) {
            JSElement jsElement2 = (JSElement)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, (Function0)new Function0<JSElement>(project, code){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $code;
                {
                    this.$project = $project;
                    this.$code = $code;
                    super(0);
                }

                public final JSElement invoke() {
                    return JSChangeUtil.createJSContentFromText(this.$project, this.$code, null);
                }
            });
            if (jsElement2 == null || JSTooltipWithHtmlHighlighterImpl.doHighlight$hasErrors(project, (PsiElement)jsElement2)) {
                return null;
            }
            String fakeText2 = jsElement2.getText();
            String string = (String)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, (Function0)new Function0<String>(project, fakeText2){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $fakeText;
                {
                    this.$project = $project;
                    this.$fakeText = $fakeText;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)javascriptLanguage), (String)"INSTANCE");
                    Language language = javascriptLanguage;
                    String string = this.$fakeText;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"$fakeText");
                    return QuickDocHighlightingHelper.getStyledCodeFragment((Project)this.$project, (Language)language, (String)string);
                }
            });
            return string != null ? string.toString() : null;
        }
        SmartPsiElementPointer smartPsiElementPointer = (SmartPsiElementPointer)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, (Function0)new Function0<SmartPsiElementPointer<PsiElement>>(typeElement2){
            final /* synthetic */ PsiElement $typeElement;
            {
                this.$typeElement = $typeElement;
                super(0);
            }

            @NotNull
            public final SmartPsiElementPointer<PsiElement> invoke() {
                return SmartPointerManager.createPointer((PsiElement)this.$typeElement);
            }
        });
        if (smartPsiElementPointer == null) {
            return null;
        }
        SmartPsiElementPointer pointer2 = smartPsiElementPointer;
        PsiFile psiFile = (PsiFile)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, (Function0)new Function0<PsiFile>(typeElement2){
            final /* synthetic */ PsiElement $typeElement;
            {
                this.$typeElement = $typeElement;
                super(0);
            }

            public final PsiFile invoke() {
                return this.$typeElement.getContainingFile();
            }
        });
        if (psiFile == null) {
            return null;
        }
        PsiFile containingFile2 = psiFile;
        CodeStyleSettings tooltipStyleSettings = ((JSTooltipCachedCodeStyleSettingsService)project.getService(JSTooltipCachedCodeStyleSettingsService.class)).getTooltipSettings(code.length() >= limit);
        JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, (Function0)new Function0<Unit>(containingFile2, project, tooltipStyleSettings, typeElement2){
            final /* synthetic */ PsiFile $containingFile;
            final /* synthetic */ Project $project;
            final /* synthetic */ CodeStyleSettings $tooltipStyleSettings;
            final /* synthetic */ PsiElement $typeElement;
            {
                this.$containingFile = $containingFile;
                this.$project = $project;
                this.$tooltipStyleSettings = $tooltipStyleSettings;
                this.$typeElement = $typeElement;
                super(0);
            }

            public final void invoke() {
                Document document2 = this.$containingFile.getViewProvider().getDocument();
                if (document2 != null) {
                    PsiDocumentManager.getInstance((Project)this.$project).commitDocument(document2);
                }
                CodeStyle.runWithLocalSettings((Project)this.$project, (CodeStyleSettings)this.$tooltipStyleSettings, () -> doHighlight.2.invoke$lambda$0(this.$typeElement));
            }

            private static final void invoke$lambda$0(PsiElement $typeElement) {
                FormatFixer.create($typeElement, FormatFixer.Mode.Reformat).fixFormat();
            }
        });
        PsiElement psiElement = (PsiElement)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, (Function0)new Function0<PsiElement>((SmartPsiElementPointer<PsiElement>)pointer2){
            final /* synthetic */ SmartPsiElementPointer<PsiElement> $pointer;
            {
                this.$pointer = $pointer;
                super(0);
            }

            @Nullable
            public final PsiElement invoke() {
                return this.$pointer.getElement();
            }
        });
        if (psiElement == null) {
            return null;
        }
        PsiElement afterTypeElement2 = psiElement;
        String prefix = "let foo: ";
        String string = (String)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, (Function0)new Function0<String>(typeElement2){
            final /* synthetic */ PsiElement $typeElement;
            {
                this.$typeElement = $typeElement;
                super(0);
            }

            public final String invoke() {
                return this.$typeElement.getText();
            }
        });
        if (string == null) {
            return null;
        }
        String fakeText3 = prefix + string;
        int startOffset = prefix.length();
        int endOffset = fakeText3.length();
        CharSequence charSequence = (CharSequence)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, (Function0)new Function0<CharSequence>(afterTypeElement2, fakeText3, startOffset, endOffset){
            final /* synthetic */ PsiElement $afterTypeElement;
            final /* synthetic */ String $fakeText;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            {
                this.$afterTypeElement = $afterTypeElement;
                this.$fakeText = $fakeText;
                this.$startOffset = $startOffset;
                this.$endOffset = $endOffset;
                super(0);
            }

            @Nullable
            public final CharSequence invoke() {
                return JSHtmlHighlightingUtil.tryGetHtmlHighlighting(this.$afterTypeElement, this.$fakeText, null, this.$startOffset, this.$endOffset);
            }
        });
        if (charSequence == null) {
            return null;
        }
        CharSequence html2 = charSequence;
        return ((Object)html2).toString();
    }

    private final boolean shouldWrapWithBlock(String originalCode, String htmlCode, int limit) {
        return originalCode.length() > limit || StringsKt.contains$default((CharSequence)htmlCode, (CharSequence)"<br", (boolean)false, (int)2, null);
    }

    static /* synthetic */ boolean shouldWrapWithBlock$default(JSTooltipWithHtmlHighlighterImpl jSTooltipWithHtmlHighlighterImpl, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = JSTooltipWithHtmlHighlighter.Companion.getMinCodeLengthToMultiline();
        }
        return jSTooltipWithHtmlHighlighterImpl.shouldWrapWithBlock(string, string2, n);
    }

    private final String wrapToCodeTagsForTooltip(String codeInnerHtml, boolean isBlock) {
        return isBlock ? "<div class='styled-code'><pre style=\"padding: 0px; margin: 0px\">" + codeInnerHtml + "</pre></div>" : "<code>" + codeInnerHtml + "</code>";
    }

    /*
     * WARNING - void declaration
     */
    private final String simpleLinesFallback(String fullErrorText) {
        void $this$toTypedArray$iv;
        List list2;
        Collection $this$dropLastWhile$iv;
        String text2 = XmlStringUtil.escapeString((String)fullErrorText);
        Intrinsics.checkNotNull((Object)text2);
        Object object = text2;
        Regex regex = new Regex("\n");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list2;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] rows = thisCollection$iv.toArray(new String[0]);
        object = StringUtil.join((Object[])rows, arg_0 -> JSTooltipWithHtmlHighlighterImpl.simpleLinesFallback$lambda$7(simpleLinesFallback.1.INSTANCE, arg_0), (String)"<br>");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"join(...)");
        return object;
    }

    private static final Object doHighlight$projectReadAction$lambda$4(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke();
    }

    private static final Object doHighlight$projectReadAction$lambda$5(Function0 $action) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        return $action.invoke();
    }

    private static final <T> T doHighlight$projectReadAction(Project $project, Function0<? extends T> action) {
        return (T)($project.isDisposed() ? null : (ApplicationKt.getApplication().isDispatchThread() ? ReadAction.compute(() -> JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction$lambda$4(action)) : ReadAction.computeCancellable(() -> JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction$lambda$5(action))));
    }

    private static final boolean doHighlight$hasErrors(Project $project, PsiElement element) {
        PsiFile containingFile2 = (PsiFile)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction($project, (Function0)new Function0<PsiFile>(element){
            final /* synthetic */ PsiElement $element;
            {
                this.$element = $element;
                super(0);
            }

            public final PsiFile invoke() {
                return this.$element.getContainingFile();
            }
        });
        return containingFile2 == null || PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)containingFile2));
    }

    private static final String simpleLinesFallback$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }
}

