/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSDocumentationBuilder;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.documentation.JSTypeHighlightingHelper;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSConstantValueOwner;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocSimpleInfoPrinter<T extends JSDocBuilderSimpleInfo> {
    public static final int PATH_LENGTH = 40;
    private static final int DEFINITION_DETAILS_LIMIT = 10;
    @Nullable
    protected final JSPsiNamedElementBase namedItem;
    @Nullable
    protected final PsiElement contextElement;
    @NotNull
    protected final PsiElement myElement;
    @NotNull
    protected final T myBuilder;
    @Nullable
    protected JSDocumentationBuilder myDocBuilder;

    public JSDocSimpleInfoPrinter(@NotNull T builder2, @NotNull PsiElement element, @Nullable PsiElement _contextElement, boolean canBeNamed) {
        if (builder2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(1);
        }
        this.namedItem = element instanceof JSPsiNamedElementBase && canBeNamed ? (JSPsiNamedElementBase)element : null;
        this.contextElement = _contextElement;
        this.myElement = element;
        if (this.namedItem != null) {
            PsiElement parent = element.getParent();
            ((JSDocBuilderSimpleInfo)builder2).namespace = element instanceof JSClass && parent instanceof JSPackageStatement ? ((JSPackageStatement)parent).getQualifiedName() : null;
        }
        this.myBuilder = builder2;
    }

    public void appendDoc(@NotNull StringBuilder result2, @NotNull JSDocumentationProvider provider, @Nullable Ref<String> definitionDetails) {
        boolean hasDefinition;
        if (result2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(3);
        }
        JSQuickNavigateBuilder quickNavigateBuilder = provider.createQuickNavigateBuilder();
        this.appendDefinitionDoc(result2, quickNavigateBuilder, definitionDetails);
        boolean bl = hasDefinition = result2.length() > 0;
        if (!this.appendMdnDoc(result2, hasDefinition)) {
            this.appendDescriptionsAndSections(result2, provider, quickNavigateBuilder, hasDefinition);
        }
    }

    @Nullable
    @Nls
    public String getRenderedDoc(@NotNull JSDocumentationProvider provider) {
        StringBuilder result2;
        if (provider == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(4);
        }
        if (!this.appendMdnDoc(result2 = new StringBuilder(), false)) {
            this.appendDescriptionsAndSections(result2, provider, provider.createQuickNavigateBuilder(), false);
        }
        return result2.toString();
    }

    private void appendDescriptionsAndSections(@NotNull StringBuilder result2, @NotNull JSDocumentationProvider provider, @NotNull JSQuickNavigateBuilder quickNavigateBuilder, boolean hasDefinition) {
        String documentationFromService;
        if (result2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(6);
        }
        if (quickNavigateBuilder == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(7);
        }
        JSDocSimpleInfoPrinter.appendDescriptionContent(this, result2);
        if (!((JSDocBuilderSimpleInfo)this.myBuilder).hasDescription() && this.contextElement != null && LookupManager.getInstance((Project)this.contextElement.getProject()).getActiveLookup() == null && StringUtil.isNotEmpty((String)(documentationFromService = quickNavigateBuilder.getDocumentationFromLanguageService(this.contextElement)))) {
            if (this.myDocBuilder != null) {
                JSDocComment docFromService = JSPsiElementFactory.createJSDocComment("/** " + this.sanitizeDocFromLanguageServer(documentationFromService) + " */", this.contextElement);
                docFromService.acceptChildren(this.myDocBuilder);
                JSDocSimpleInfoPrinter.appendDescriptionContent(this, result2);
            } else {
                String html2 = DocMarkdownToHtmlConverter.convert((Project)this.contextElement.getProject(), (String)documentationFromService);
                if (StringUtil.isNotEmpty((String)html2)) {
                    result2.append("<div class='content'>");
                    JSDocSimpleInfoPrinter.addDescription(html2, result2);
                    result2.append("</div>");
                }
            }
        }
        result2.append("<table class='sections'>");
        this.appendInnerSections(result2, provider, hasDefinition);
        result2.append("</table>");
    }

    @NotNull
    @NlsSafe
    private String sanitizeDocFromLanguageServer(@NotNull String doc) {
        if (doc == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(8);
        }
        String string = doc.replaceAll("\\*@([a-zA-Z-_]+)\\*[- \n]*", "@$1 ");
        if (string == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(9);
        }
        return string;
    }

    protected boolean appendMdnDoc(@NotNull StringBuilder result2, boolean hasDefinition) {
        MdnSymbolDocumentation documentation;
        if (result2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(10);
        }
        if ((documentation = JSDocumentationUtils.getJsMdnDocumentation(this.myElement, this.contextElement)) == null) {
            return false;
        }
        result2.append(documentation.getDocumentation(false, builder2 -> {
            if (hasDefinition) {
                this.appendLocation((StringBuilder)builder2);
            }
        }));
        return true;
    }

    protected void appendInnerSections(@NotNull StringBuilder result2, @NotNull JSDocumentationProvider provider, boolean hasDefinition) {
        if (result2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(11);
        }
        if (provider == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(12);
        }
        this.appendBodyDoc(result2, hasDefinition);
        JSDocSimpleInfoPrinter.addSections(((JSDocBuilderSimpleInfo)this.myBuilder).mySimpleTags, result2);
        if (hasDefinition) {
            this.appendLocation(result2);
        }
    }

    protected void appendLocation(@NotNull StringBuilder result2) {
        if (result2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(13);
        }
        if (DialectDetector.isActionScript(this.myElement) || !(this.myElement instanceof JSElement)) {
            return;
        }
        PsiFile file = this.myElement.getContainingFile();
        if (file == null) {
            return;
        }
        String rawLocation = JSItemPresentation.getFileName(file, true, true, false);
        String location = JSDocSimpleInfoPrinter.getLocationWithEllipsis(rawLocation = StringUtil.trimEnd((String)StringUtil.trimStart((String)rawLocation, (String)"("), (String)")"), 40);
        if (location.isEmpty()) {
            return;
        }
        int sections = result2.indexOf("<tr><td valign='top' class='section'><p>");
        result2.append("<tr><td valign='top'");
        if (sections > 0) {
            result2.append(" colspan='2'");
        }
        result2.append(">");
        String icon2 = JSDocSimpleInfoPrinter.getFileIconPath(file);
        result2.append("<icon src='").append(icon2).append("'/>&nbsp;").append(StringUtil.escapeXmlEntities((String)location));
        result2.append("</td>");
    }

    @NotNull
    public static String getLocationWithEllipsis(@NotNull String filePath, int maxLength) {
        int startPartSymbolCount;
        String fileName;
        if (filePath == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(14);
        }
        if ((fileName = VfsUtil.extractFileName((String)filePath)) == null) {
            String string = filePath;
            if (string == null) {
                JSDocSimpleInfoPrinter.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (fileName.length() + 4 >= maxLength) {
            String string = fileName;
            if (string == null) {
                JSDocSimpleInfoPrinter.$$$reportNull$$$0(16);
            }
            return string;
        }
        if (maxLength >= filePath.length()) {
            String string = filePath;
            if (string == null) {
                JSDocSimpleInfoPrinter.$$$reportNull$$$0(17);
            }
            return string;
        }
        int acceptableSymbolCount = maxLength - fileName.length() - 4;
        int leftPartEnd = filePath.indexOf("/");
        if (leftPartEnd == 0) {
            leftPartEnd = filePath.indexOf("/", 1);
        }
        if ((startPartSymbolCount = leftPartEnd + 1) > acceptableSymbolCount) {
            String string = fileName;
            if (string == null) {
                JSDocSimpleInfoPrinter.$$$reportNull$$$0(18);
            }
            return string;
        }
        int lastIndex = filePath.lastIndexOf("/");
        if (leftPartEnd >= lastIndex) {
            String string = fileName;
            if (string == null) {
                JSDocSimpleInfoPrinter.$$$reportNull$$$0(19);
            }
            return string;
        }
        StringBuilder result2 = new StringBuilder();
        result2.append(filePath, 0, leftPartEnd + 1).append(".../");
        JSDocSimpleInfoPrinter.appendMaxRightPath(filePath.substring(leftPartEnd + 1, lastIndex + 1), result2, acceptableSymbolCount - startPartSymbolCount);
        result2.append(fileName);
        String string = result2.toString();
        if (string == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static void appendMaxRightPath(@NotNull String subPathWithoutFilename, @NotNull StringBuilder result2, int maxLength) {
        if (subPathWithoutFilename == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(21);
        }
        if (result2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(22);
        }
        if (maxLength > 0 && subPathWithoutFilename.length() > 0) {
            String partOfPathToTrim;
            int toCropIndex;
            int startOffset = subPathWithoutFilename.length() - maxLength;
            if (startOffset > 0 && subPathWithoutFilename.charAt(startOffset - 1) == '/') {
                result2.append(subPathWithoutFilename.substring(startOffset));
            } else if (startOffset > 0 && (toCropIndex = (partOfPathToTrim = subPathWithoutFilename.substring(startOffset)).indexOf("/")) >= 0 && partOfPathToTrim.length() > toCropIndex + 1) {
                result2.append(partOfPathToTrim.substring(toCropIndex + 1));
            }
        }
    }

    @NotNull
    private static String getFileIconPath(@NotNull PsiFile file) {
        if (file == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(23);
        }
        if (DialectDetector.isTypeScript((PsiElement)file)) {
            return "JavaScriptPsiIcons.FileTypes.TypeScriptFile";
        }
        if (DialectDetector.isJavaScript((PsiElement)file)) {
            return "AllIcons.FileTypes.JavaScript";
        }
        return "AllIcons.Nodes.Folder";
    }

    protected void appendPropertiesAndDefaultValue(@NotNull StringBuilder result2) {
        if (result2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(24);
        }
    }

    protected void appendBodyDoc(@NotNull StringBuilder result2, boolean hasDefinition) {
        String text2;
        JSType expanded;
        TypeScriptTypeAlias alias;
        JSType declaration;
        PsiElement psiElement;
        String value;
        if (result2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(25);
        }
        if (!hasDefinition) {
            return;
        }
        this.appendPropertiesAndDefaultValue(result2);
        if (this.myElement instanceof JSConstantValueOwner && (value = ((JSConstantValueOwner)this.myElement).getConstantValueDescription()) != null) {
            JSDocSimpleInfoPrinter.startNamedSection("Constant value:", result2);
            result2.append("<td valign='top'>");
            JSDocSimpleInfoPrinter.appendSingleNamedDescriptionSection(value, "", result2);
            result2.append("</td>");
        }
        if ((psiElement = this.myElement) instanceof TypeScriptTypeAlias && (declaration = (alias = (TypeScriptTypeAlias)psiElement).getParsedTypeDeclaration()) != null && !(expanded = JSTypeUtils.unwrapType(declaration.substitute())).isEquivalentTo(((JSDocBuilderSimpleInfo)this.myBuilder).type, null)) {
            JSType completelyExpanded;
            String expandedCodeText = expanded.getTypeText(JSType.TypeTextFormat.CODE);
            if (!expandedCodeText.equals(declaration.getTypeText(JSType.TypeTextFormat.CODE))) {
                JSDocSimpleInfoPrinter.startNamedSection("Initial type:", result2);
                result2.append("<td valign='top'>");
                CharSequence initialType = JSHtmlHighlightingUtil.getTypeWithLinksHtmlHighlighting(expanded, this.myElement, false);
                JSDocSimpleInfoPrinter.appendSingleNamedDescriptionSection(initialType, "", result2);
                result2.append("</td>");
            }
            if (!(completelyExpanded = JSTypeWithIncompleteSubstitution.substituteCompletely(expanded)).isEquivalentTo(expanded, null)) {
                JSDocSimpleInfoPrinter.startNamedSection("Expanded:", result2);
                result2.append("<td valign='top'>");
                CharSequence recordText = JSHtmlHighlightingUtil.getTypeWithLinksHtmlHighlighting(completelyExpanded, this.myElement, false);
                JSDocSimpleInfoPrinter.appendSingleNamedDescriptionSection(recordText, "", result2);
                result2.append("</td>");
            }
        }
        if (this.contextElement != null && !(this.contextElement instanceof JSImplicitElement) && (text2 = this.contextElement.getText()).startsWith("#") && text2.length() == 7) {
            result2.append(JSDocSimpleInfoPrinter.buildCurrentOrDefaultValue(text2.substring(1), true, false, text2, true));
        }
    }

    protected final void appendDefinitionDoc(@NotNull StringBuilder result2, @NotNull JSDocumentationProvider provider, @Nullable Ref<String> definitionDetails) {
        if (result2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(26);
        }
        if (provider == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(27);
        }
        this.appendDefinitionDoc(result2, provider.createQuickNavigateBuilder(), definitionDetails);
    }

    protected void appendDefinitionDoc(@NotNull StringBuilder result2, @NotNull JSQuickNavigateBuilder quickNavigateBuilder, @Nullable Ref<String> definitionDetails) {
        String name;
        if (result2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(28);
        }
        if (quickNavigateBuilder == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(29);
        }
        if (this.namedItem == null) {
            return;
        }
        result2.append("<div class='definition'><pre>");
        PsiElement psiElement = this.myElement;
        if (psiElement instanceof JSAttributeNameValuePair) {
            JSAttributeNameValuePair nameValuePair = (JSAttributeNameValuePair)psiElement;
            v0 = nameValuePair.getSimpleValue();
        } else {
            v0 = name = JSDocumentationBuilder.getNameForDocumentation(this.namedItem);
        }
        if (!(this.namedItem instanceof JSAttributeNameValuePair || this.namedItem instanceof JSImplicitElement || this.namedItem instanceof JSDefinitionExpression || DialectDetector.isActionScript((PsiElement)this.namedItem))) {
            JSPsiNamedElementBase element = this.contextElement == null || LookupManager.getInstance((Project)this.namedItem.getProject()).getActiveLookup() != null ? this.namedItem : this.contextElement;
            String declaration = quickNavigateBuilder.getQuickNavigateInfoForNavigationElement((PsiElement)this.namedItem, (PsiElement)element, true);
            declaration = (String)ObjectUtils.coalesce((Object)declaration, (Object)name);
            if (definitionDetails != null) {
                String string;
                JSPsiNamedElementBase jSPsiNamedElementBase = this.namedItem;
                if (jSPsiNamedElementBase instanceof JSClass) {
                    JSClass jsClass = (JSClass)jSPsiNamedElementBase;
                    string = JSTypeHighlightingHelper.getTypeBody(jsClass);
                } else {
                    string = null;
                }
                String body2 = string;
                Pair<String, String> parts = JSDocSimpleInfoPrinter.getDocumentationParts(declaration + StringUtil.notNullize((String)body2));
                result2.append((String)parts.first);
                definitionDetails.set((Object)((String)parts.second));
            } else {
                result2.append(declaration);
            }
        } else {
            this.appendBasicDefinitionDoc(result2, name);
        }
        result2.append("</pre></div>");
    }

    private void appendBasicDefinitionDoc(@NotNull StringBuilder result2, @Nullable String name) {
        if (result2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(30);
        }
        JSType jsType = ((JSDocBuilderSimpleInfo)this.myBuilder).type != null ? ((JSDocBuilderSimpleInfo)this.myBuilder).type.substitute() : null;
        Object nameToUse = StringUtil.notNullize((String)name);
        if (this.myElement instanceof JSImplicitElement) {
            String text2;
            List names;
            if (this.myElement instanceof JSOptionalOwner && ((JSOptionalOwner)this.myElement).isOptional()) {
                nameToUse = (String)nameToUse + "?";
            }
            if (jsType instanceof JSTypeImpl && !ContainerUtil.and((Iterable)(names = StringUtil.split((String)(text2 = jsType.getResolvedTypeText()), (String)".")), el -> StringUtil.isJavaIdentifier((String)el))) {
                jsType = null;
            }
        }
        CharSequence highlighted = JSHtmlHighlightingUtil.getElementHtmlHighlighting(this.myElement, (String)nameToUse, jsType);
        result2.append(highlighted);
    }

    private static Pair<String, @Nullable String> getDocumentationParts(@NotNull String content) {
        List lines;
        if (content == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(31);
        }
        if ((lines = StringUtil.split((String)content, (String)"<br>")).size() > 11) {
            return Pair.create((Object)(StringUtil.join(lines.subList(0, 10), (String)"<br>") + "<br>"), (Object)StringUtil.join(lines.subList(10, lines.size()), (String)"<br>"));
        }
        return Pair.create((Object)content, null);
    }

    protected static void addJSDocVisibilityAndAccess(JSDocBuilderSimpleInfo generationInfo, StringBuilder options) {
        if (generationInfo.modifiers != null) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append(generationInfo.modifiers);
        }
        if (generationInfo.finalAccess != null) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append(generationInfo.finalAccess);
        }
    }

    public static void appendDescriptionContent(@NotNull JSDocSimpleInfoPrinter<?> info2, @NotNull StringBuilder result2) {
        if (info2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(32);
        }
        if (result2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(33);
        }
        if (((JSDocBuilderSimpleInfo)info2.myBuilder).hasDescription()) {
            result2.append("<div class='content'>");
            JSDocSimpleInfoPrinter.addDescription(((JSDocBuilderSimpleInfo)info2.myBuilder).getFinalDescription(), result2);
            result2.append("</div>");
        }
    }

    public static void addSections(@NotNull MultiMap<String, String> sections, @NotNull StringBuilder result2) {
        if (sections == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(34);
        }
        if (result2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(35);
        }
        if (sections.isEmpty()) {
            return;
        }
        for (Map.Entry entry : sections.entrySet()) {
            Object sectionName = (String)entry.getKey();
            List items = ContainerUtil.filter((Collection)((Collection)entry.getValue()), it -> !it.isBlank());
            if (!items.isEmpty() && !((String)sectionName).endsWith(":")) {
                sectionName = (String)sectionName + ":";
            }
            JSDocSimpleInfoPrinter.startNamedSection((String)sectionName, result2);
            result2.append("<td valign='top'>");
            for (String value : (Collection)entry.getValue()) {
                if (!value.startsWith("<p>")) {
                    result2.append("<p>");
                }
                result2.append(value);
            }
            result2.append("</td>");
        }
    }

    public static void startNamedSection(String sectionName, StringBuilder result2) {
        result2.append("<tr><td valign='top' class='section'><p>");
        result2.append(sectionName);
        result2.append("</td>");
    }

    public static void appendSingleNamedDescriptionSection(CharSequence name, CharSequence description, @NotNull StringBuilder builder2) {
        if (builder2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(36);
        }
        builder2.append(name);
        if (description.length() > 0) {
            builder2.append(" &ndash; ");
            builder2.append(description);
        }
    }

    public static void addDescription(@NotNull String description, @NotNull StringBuilder builder2) {
        if (description == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(37);
        }
        if (builder2 == null) {
            JSDocSimpleInfoPrinter.$$$reportNull$$$0(38);
        }
        builder2.append("<p>");
        builder2.append(description);
    }

    protected static String buildCurrentOrDefaultValue(String content, boolean color, boolean isDefaultValue, String originalText, boolean needSection) {
        content = color ? "<code style='background-color:#" + (String)content + "; color: #" + JSDocSimpleInfoPrinter.contrastColor((String)content) + "'>" + originalText + "</code>" : "<code>" + (String)content + "</code>";
        String label = (isDefaultValue ? "Default" : "Value") + ":";
        if (!needSection) {
            return "<p>" + label + (String)content;
        }
        return "<tr><td valign='top' class='section'><p>" + label + "</td><td valign='top'><p>" + (String)content;
    }

    private static String contrastColor(String remainingLineContent) {
        try {
            Color color = ColorUtil.fromHex((String)remainingLineContent);
            return ColorUtil.toHex((Color)(ColorUtil.isDark((Color)color) ? JBColor.WHITE : JBColor.BLACK));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return remainingLineContent;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 15, 16, 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 12: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickNavigateBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocSimpleInfoPrinter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subPathWithoutFilename";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sections";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocSimpleInfoPrinter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeDocFromLanguageServer";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationWithEllipsis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendDoc";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRenderedDoc";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendDescriptionsAndSections";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeDocFromLanguageServer";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendMdnDoc";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendInnerSections";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendLocation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLocationWithEllipsis";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendMaxRightPath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFileIconPath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "appendPropertiesAndDefaultValue";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "appendBodyDoc";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "appendDefinitionDoc";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "appendBasicDefinitionDoc";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationParts";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "appendDescriptionContent";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addSections";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "appendSingleNamedDescriptionSection";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 15, 16, 17, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

