/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.config;

import com.intellij.lang.ecmascript6.index.ES6FileIncludeProvider;
import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.config.JSFileImportsBase;
import com.intellij.lang.javascript.config.JSFileInclude;
import com.intellij.lang.javascript.config.JSSimpleFileInclude;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JSFileImportsImpl
extends JSFileImportsBase {
    @NotNull
    private final JSFileInclude myIncludeScope;

    public JSFileImportsImpl(@NotNull Project project, @NotNull JSConfig config) {
        if (project == null) {
            JSFileImportsImpl.$$$reportNull$$$0(0);
        }
        if (config == null) {
            JSFileImportsImpl.$$$reportNull$$$0(1);
        }
        super(project, config);
        this.myIncludeScope = config.getInclude();
    }

    public JSFileImportsImpl(@NotNull Project project, @NotNull JSSimpleFileInclude simpleFileInclude) {
        if (project == null) {
            JSFileImportsImpl.$$$reportNull$$$0(2);
        }
        if (simpleFileInclude == null) {
            JSFileImportsImpl.$$$reportNull$$$0(3);
        }
        super(project, simpleFileInclude.getResolveContext(), simpleFileInclude.getImportResolver());
        this.myIncludeScope = simpleFileInclude;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getOutFiles(@NotNull VirtualFile file) {
        if (file == null) {
            JSFileImportsImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        if (this.processReferencedFilesUsingPsi(file)) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
            if (psiFile instanceof JSFile) {
                Set<String> paths = ((JSFile)psiFile).getReferencedPaths();
                Set<Object> set = paths.isEmpty() ? Collections.emptySet() : paths.stream().map(el -> this.resolveFile(ES6FileIncludeProvider.preProcessPath(el), file)).filter(el -> el != null).collect(Collectors.toSet());
                if (set == null) {
                    JSFileImportsImpl.$$$reportNull$$$0(5);
                }
                return set;
            }
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                JSFileImportsImpl.$$$reportNull$$$0(6);
            }
            return set;
        }
        Set<VirtualFile> set = FileIncludeIndex.getIncludes((VirtualFile)file, (Project)this.myProject).stream().map(el -> this.resolveFile(el.path, file)).filter(el -> el != null).collect(Collectors.toSet());
        if (set == null) {
            JSFileImportsImpl.$$$reportNull$$$0(7);
        }
        return set;
    }

    public boolean processReferencedFilesUsingPsi(@NotNull VirtualFile file) {
        if (file == null) {
            JSFileImportsImpl.$$$reportNull$$$0(8);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return true;
        }
        return TypeScriptLibraryProvider.checkLibraryFile(this.myProject, file);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRootFiles() {
        GlobalSearchScope scope2 = this.myIncludeScope.getRootScope(this.myProject);
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.myResolver.processAllFilesInScope(scope2, (Processor<? super VirtualFile>)processor);
        Set<VirtualFile> additionalFiles = this.myIncludeScope.getAdditionalRootFiles(this.myProject);
        additionalFiles.forEach(arg_0 -> ((CommonProcessors.CollectProcessor)processor).process(arg_0));
        Set<VirtualFile> set = Set.copyOf(processor.getResults());
        if (set == null) {
            JSFileImportsImpl.$$$reportNull$$$0(9);
        }
        return set;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JSFileImportsImpl imports = (JSFileImportsImpl)o;
        return this.myIncludeScope.equals(imports.myIncludeScope);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myIncludeScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleFileInclude";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/config/JSFileImportsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/config/JSFileImportsImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOutFiles";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReferencedFilesUsingPsi";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 9 -> new IllegalStateException(string);
        };
    }
}

